/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;

public class ArApJournalUniqueDataCheck
extends AbstractDataCheck {
    protected boolean isAr() {
        return false;
    }

    @Override
    public String getEntityName() {
        return null;
    }

    @Override
    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        return selector;
    }

    @Override
    public QFilter getExtendQFilter() {
        return null;
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    @Override
    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        Set billIds = billList.stream().map(bill -> bill.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection journalCollection = QueryServiceHelper.query((String)(this.isAr() ? "ar_journal" : "ap_journal"), (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billIds), new QFilter("sourcebilltype", "=", (Object)this.getEntityName())});
        Map<Long, Integer> billIdFrequencyMap = this.getBillIdFrequencyMap(journalCollection);
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(16);
        for (DynamicObject bill2 : billList) {
            long billId = bill2.getLong("id");
            if (billIdFrequencyMap.getOrDefault(billId, 0).compareTo(0) == 0) {
                results.add(new DataCheckResult(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6d41\u6c34\u8bb0\u5f55\u3002", (String)"ArApJournalUniqueDataCheck_0", (String)"fi-arapcommon", (Object[])new Object[0])));
                continue;
            }
            if (billIdFrequencyMap.getOrDefault(billId, 0).compareTo(1) > 0) {
                results.add(new DataCheckResult(ResManager.loadKDString((String)"\u6d41\u6c34\u8bb0\u5f55\u4e0d\u552f\u4e00\u3002", (String)"ArApJournalUniqueDataCheck_1", (String)"fi-arapcommon", (Object[])new Object[0])));
                continue;
            }
            results.add(new DataCheckResult());
        }
        return results;
    }

    private Map<Long, Integer> getBillIdFrequencyMap(DynamicObjectCollection journalCollection) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(16);
        for (DynamicObject journal : journalCollection) {
            long billId = journal.getLong("sourcebillid");
            int frequency = result.getOrDefault(billId, 0);
            result.put(billId, ++frequency);
        }
        return result;
    }
}

