/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.base;

import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.check.base.AbnormalBillInfo;
import kd.fi.arapcommon.check.base.CheckResult;
import kd.fi.arapcommon.check.base.DataCheckService;
import kd.fi.arapcommon.check.base.HealthCheckFilter;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public abstract class AbstractSqlDataCheck
implements DataCheckService {
    private HealthCheckFilter healthCheckFilter = new HealthCheckFilter();
    private CheckResult result = new CheckResult();

    protected HealthCheckFilter getHealthCheckFilter() {
        return this.healthCheckFilter;
    }

    @Override
    public CheckResult getCheckResult() {
        DataSet dataSet = DB.queryDataSet((String)"dataCheck", (DBRoute)(this.isAr() ? DBRouteConst.AR : DBRouteConst.AP), (String)this.getSql());
        int totalCount = 0;
        List<AbnormalBillInfo> errorList = this.result.getBills();
        for (Row row : dataSet) {
            ++totalCount;
            if (errorList.size() >= this.getErrorLimit()) continue;
            errorList.add(new AbnormalBillInfo(row.getLong("fid"), row.getString("fbillno"), this.getEntityName(), this.getErrorMessage()));
        }
        this.result.setTotal(totalCount);
        return this.result;
    }

    public abstract String getErrorMessage();

    public abstract String getSql();

    public abstract boolean isAr();

    public abstract String getEntityName();

    @Override
    public void setQFilter(QFilter filter) {
        String property = filter.getProperty();
        if ("org".equals(property)) {
            this.healthCheckFilter.setOrgIds((List)filter.getValue());
        }
        List nests = filter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            String nestProperty = nest.getFilter().getProperty();
            String tag = nest.getFilter().getCP();
            if ("createtime".equals(nestProperty) && ">=".equals(tag)) {
                this.healthCheckFilter.setStartDate((Date)nest.getFilter().getValue());
                continue;
            }
            if (!"createtime".equals(nestProperty) || !"<=".equals(tag)) continue;
            this.healthCheckFilter.setEndDate((Date)nest.getFilter().getValue());
        }
    }

    private int getErrorLimit() {
        String errorLimit = StdConfig.get("dataCheck.errorLimit");
        if (EmptyUtils.isEmpty(errorLimit)) {
            return 1000;
        }
        return Integer.parseInt(errorLimit);
    }
}

