/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.base;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.arapcommon.check.base.CheckResult;
import kd.fi.arapcommon.check.base.DataCheckFactory;
import kd.fi.arapcommon.check.base.DataCheckService;
import kd.fi.arapcommon.enums.CheckStatusEnum;
import kd.fi.arapcommon.enums.ExecutionStatusEnum;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.InstantUtils;

public class DataCheckHandler {
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"fi-data-check", (int)10, (int)10, (String)"fi");

    public static ThreadPool getDefaultThreadPool() {
        return threadPool;
    }

    public static void execute(DynamicObject bill, QFilter filter) {
        threadPool.execute(() -> DataCheckHandler.executeDataCheck(bill, filter));
    }

    public static void executeDataCheck(DynamicObject entity, QFilter filter) {
        CheckResult result = null;
        String message = "";
        try {
            result = DataCheckHandler.getHealthCheckResult(entity, filter);
        }
        catch (Exception e) {
            message = e.toString();
        }
        DataCheckHandler.setBillInfo(entity, result, message);
    }

    private static void setBillInfo(DynamicObject entity, CheckResult result, String message) {
        if (result == null || EmptyUtils.isNotEmpty(message)) {
            entity.set("executestatus", (Object)ExecutionStatusEnum.FAIL.getValue());
            entity.set("checkstatus", (Object)CheckStatusEnum.ABNORMAL.getValue());
            entity.set("detail", (Object)(EmptyUtils.isNotEmpty(message) ? message : "no plugin found"));
            return;
        }
        entity.set("executestatus", (Object)ExecutionStatusEnum.SUCCESS.getValue());
        entity.set("checkstatus", (Object)CheckStatusEnum.NORMAL.getValue());
        if (EmptyUtils.isEmpty(result.getBills())) {
            return;
        }
        int errorCount = result.getBills().size();
        if (errorCount > 0) {
            entity.set("checkstatus", (Object)CheckStatusEnum.ABNORMAL.getValue());
            String detailMessage = String.format(ResManager.loadKDString((String)"\u622a\u6b62\u201c%1$s\u201d\uff0c\u5b58\u5728%2$s\u5f20%3$s\u3002", (String)"DataCheckHandler_0", (String)"fi-arapcommon", (Object[])new Object[0]), InstantUtils.getInstantString(entity.getDate("enddate").toInstant(), "yyyy-MM-dd HH:mm:ss"), errorCount, entity.getString("checkitem.tips"));
            entity.set("detail", (Object)detailMessage);
        }
    }

    private static CheckResult getHealthCheckResult(DynamicObject entity, QFilter filter) {
        String classPath = entity.getString("checkitem.plugin");
        DataCheckService dataCheck = DataCheckFactory.getDataCheckInstance(classPath);
        if (dataCheck == null) {
            return null;
        }
        dataCheck.setQFilter(filter);
        return dataCheck.getCheckResult();
    }
}

