/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.base;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.fi.arapcommon.check.base.AbnormalBillInfo;
import kd.fi.arapcommon.check.base.CheckResult;
import kd.fi.arapcommon.check.base.DataCheckHandler;
import kd.fi.arapcommon.check.base.HealthCheckFilter;
import kd.fi.arapcommon.enums.CheckStatusEnum;
import kd.fi.arapcommon.enums.ExecutionStatusEnum;
import kd.fi.arapcommon.helper.MutexLockHelper;
import kd.fi.arapcommon.util.DataCheckUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.InstantUtils;
import kd.fi.arapcommon.util.JsonUtils;

public class DataCheckTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(DataCheckTask.class);
    private int size;
    private AtomicInteger currentIndex = new AtomicInteger(0);

    public MessageHandler getMessageHandle() {
        return null;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u201c\u5065\u5eb7\u5de1\u67e5\u201d\u6b63\u5728\u6267\u884c\u3002", (String)"DataCheckTask_0", (String)"fi-arapcommon", (Object[])new Object[0]), null);
        List taskBills = (List)map.get("taskBillIds");
        HealthCheckFilter checkFilter = JsonUtils.jsonToObj(map.get("filter").toString(), HealthCheckFilter.class);
        List<DynamicObject> taskBillList = this.listHealthCheck(taskBills);
        long orgId = Long.parseLong(map.get("orgId").toString());
        requestContext.setOrgId(orgId);
        if (EmptyUtils.isEmpty(taskBillList)) {
            this.feedbackProgress(100);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u201c\u5065\u5eb7\u5de1\u67e5\u201d\u3002", (String)"DataCheckTask_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        this.size = taskBillList.size();
        this.initBillInfo(taskBillList, checkFilter);
        List<Future<Boolean>> result = this.executeTask(taskBillList, checkFilter, requestContext);
        for (Future<Boolean> future : result) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("thread future error :" + future);
                LOG.error("thread error :" + e);
            }
        }
    }

    private List<Future<Boolean>> executeTask(List<DynamicObject> taskBillList, HealthCheckFilter checkFilter, RequestContext requestContext) {
        QFilter filter = DataCheckUtils.getQFilter(checkFilter);
        ThreadPool threadPool = DataCheckHandler.getDefaultThreadPool();
        ArrayList<Future<Boolean>> result = new ArrayList<Future<Boolean>>(16);
        for (DynamicObject bill : taskBillList) {
            boolean lock = MutexLockHelper.requireMutex("ap_healthcheck", Long.toString(bill.getLong("id")), "dataCheck");
            if (this.isStop()) {
                this.feedbackProgress(100, ResManager.loadKDString((String)"\u5065\u5eb7\u68c0\u67e5\u7ec8\u6b62\u5b8c\u6210", (String)"DataCheckTask_2", (String)"fi-arapcommon", (Object[])new Object[0]), null);
                break;
            }
            if (!lock) {
                LOG.info("health check is running : " + bill.getString("billno"));
                this.updateProcess();
                continue;
            }
            result.add(threadPool.submit(() -> this.executeTask(bill, filter), requestContext));
        }
        return result;
    }

    private void updateProcess() {
        int process = this.currentIndex.incrementAndGet() * 100 / this.size;
        if (this.currentIndex.intValue() == this.size) {
            process = 100;
        }
        this.feedbackProgress(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeTask(DynamicObject bill, QFilter filter) {
        try {
            CheckResult checkResult = DataCheckUtils.getCheckResult(bill, filter);
            this.setBillInfo(bill, checkResult);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            int process = this.currentIndex.incrementAndGet() * 100 / this.size;
            if (this.currentIndex.intValue() == this.size) {
                process = 100;
            }
            this.feedbackProgress(process);
        }
        catch (Exception e) {
            bill.set("executestatus", (Object)ExecutionStatusEnum.FAIL.getValue());
            bill.set("checkstatus", (Object)CheckStatusEnum.ABNORMAL.getValue());
            bill.set("detail", (Object)e.getClass().getName());
        }
        finally {
            MutexLockHelper.releaseMutex("ap_healthcheck", Long.toString(bill.getLong("id")), "dataCheck");
        }
        return true;
    }

    private void initBillInfo(List<DynamicObject> billList, HealthCheckFilter checkFilter) {
        DynamicObjectType tarType = billList.get(0).getDynamicObjectCollection("mulorgs").getDynamicObjectType();
        DynamicObject[] orgCollection = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", checkFilter.getOrgIds())});
        for (DynamicObject bill : billList) {
            bill.set("checktime", (Object)new Date());
            bill.getDynamicObjectCollection("entry").clear();
            bill.set("detail", (Object)"");
            bill.set("startdate", (Object)checkFilter.getStartDate());
            bill.set("enddate", (Object)checkFilter.getEndDate());
            String moreFilerVal = checkFilter.getMoreFilterVal();
            if (EmptyUtils.isNotEmpty(moreFilerVal)) {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)moreFilerVal, CRCondition.class);
                String exprDesc = condition.getExprDesc();
                bill.set("morefilterval", (Object)(exprDesc.length() > 255 ? exprDesc.substring(0, 255) : exprDesc));
            } else {
                bill.set("morefilterval", (Object)"");
            }
            bill.set("morefilterval_tag", (Object)moreFilerVal);
            DynamicObjectCollection orgs = new DynamicObjectCollection();
            for (DynamicObject org : orgCollection) {
                DynamicObject obj = new DynamicObject(tarType);
                obj.set("fbasedataid", (Object)org);
                orgs.add((Object)obj);
            }
            bill.set("mulorgs", (Object)orgs);
        }
    }

    private void setBillInfo(DynamicObject bill, CheckResult checkResult) {
        if (EmptyUtils.isNotEmpty(checkResult.getMessage())) {
            bill.set("executestatus", (Object)ExecutionStatusEnum.FAIL.getValue());
            bill.set("checkstatus", (Object)CheckStatusEnum.ABNORMAL.getValue());
            bill.set("detail", (Object)checkResult.getMessage());
            return;
        }
        bill.set("executestatus", (Object)ExecutionStatusEnum.SUCCESS.getValue());
        bill.set("checkstatus", (Object)CheckStatusEnum.NORMAL.getValue());
        if (EmptyUtils.isEmpty(checkResult.getBills())) {
            return;
        }
        DynamicObjectCollection errorCollection = new DynamicObjectCollection();
        DynamicObjectType type = bill.getDynamicObjectCollection("entry").getDynamicObjectType();
        for (AbnormalBillInfo abnormalBillInfo : checkResult.getBills()) {
            DynamicObject rowEntry = new DynamicObject(type);
            rowEntry.set("e_billid", (Object)abnormalBillInfo.getBillId());
            rowEntry.set("e_billno", (Object)abnormalBillInfo.getBillNo());
            rowEntry.set("e_billtype", (Object)abnormalBillInfo.getBillEntity());
            rowEntry.set("e_errormessage", (Object)abnormalBillInfo.getErrorMessage());
            errorCollection.add((Object)rowEntry);
        }
        bill.set("entry", (Object)errorCollection);
        int errorCount = checkResult.getBills().size();
        bill.set("checkstatus", (Object)CheckStatusEnum.ABNORMAL.getValue());
        Instant deadLine = EmptyUtils.isEmpty(bill.getDate("enddate")) ? Instant.now() : bill.getDate("enddate").toInstant();
        String detailMessage = String.format(ResManager.loadKDString((String)"\u622a\u6b62\u201c%1$s\u201d\uff0c\u5df2\u5b58\u5728%2$s\u5f20%3$s\u3002", (String)"DataCheckTask_3", (String)"fi-arapcommon", (Object[])new Object[0]), InstantUtils.getInstantString(deadLine, "yyyy-MM-dd HH:mm:ss"), errorCount, bill.getString("checkitem.tips"));
        bill.set("detail", (Object)detailMessage);
    }

    private List<DynamicObject> listHealthCheck(List<Long> taskBills) {
        if (EmptyUtils.isEmpty(taskBills)) {
            return Collections.emptyList();
        }
        DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)"ap_healthcheck").getDynamicObjectType();
        DynamicObject[] result = BusinessDataServiceHelper.load((Object[])taskBills.toArray(), (DynamicObjectType)type);
        return Arrays.asList(result);
    }
}

