/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.check.helper.AmountCompareHelper;
import kd.fi.arapcommon.helper.ArApHelper;

public class FinArBillCheckHelper {
    public static void checkLockAndSettleField(Set<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return;
        }
        Object[] bills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"billno,org,recamount,unsettleamount,settleamount,settlestatus,e_recamount,e_lockedamt,e_unlockamt,e_settledamt,e_unsettleamt,planpricetax,planlockedamt,unplanlockamt,plansettledamt,unplansettleamt", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (ObjectUtils.isEmpty((Object[])bills)) {
            return;
        }
        HashMap<Long, Integer> arSettleParamMap = new HashMap<Long, Integer>(8);
        for (Object bill : bills) {
            Long orgId = bill.getLong("org.id");
            int arSettleParam = 0;
            if (ObjectUtils.isEmpty(arSettleParamMap.get(orgId))) {
                arSettleParam = ArApHelper.getArSettleParam(orgId);
                arSettleParamMap.put(orgId, arSettleParam);
            } else {
                arSettleParam = (Integer)arSettleParamMap.get(orgId);
            }
            FinArBillCheckHelper.checkLockAndSettleField((DynamicObject)bill, arSettleParam);
        }
    }

    public static void checkLockAndSettleField(DynamicObject bill) {
        String billno = bill.getString("billno");
        AmountCompareHelper.compare(billno, bill, "recamount", "unsettleamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        AmountCompareHelper.compare(billno, bill, "recamount", "settleamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        DynamicObjectCollection detailEntrys = bill.getDynamicObjectCollection("entry");
        BigDecimal detailEntryUnLockSum = BigDecimal.ZERO;
        BigDecimal detailEntryUnSettleSum = BigDecimal.ZERO;
        for (DynamicObject detailEntry : detailEntrys) {
            AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_unsettleamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_settledamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_unsettleamt", "e_settledamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u7684\u201c\u672a\u7ed3\u7b97\u91d1\u989d\u201d\u4e0e\u201c\u5df2\u7ed3\u7b97\u91d1\u989d\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u8868\u5934\u7684\u201c\u5e94\u6536\u91d1\u989d\u201d\u3002", (String)"FinArBillCheckHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_unlockamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_lockedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_6", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_unlockamt", "e_lockedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u7684\u201c\u672a\u9501\u5b9a\u91d1\u989d\u201d\u4e0e\u201c\u5df2\u9501\u5b9a\u91d1\u989d\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u8868\u5934\u7684\u201c\u5e94\u6536\u91d1\u989d\u201d\u3002", (String)"FinArBillCheckHelper_7", (String)"fi-arapcommon", (Object[])new Object[0]));
            detailEntryUnLockSum = detailEntryUnLockSum.add(detailEntry.getBigDecimal("e_unlockamt"));
            detailEntryUnSettleSum = detailEntryUnSettleSum.add(detailEntry.getBigDecimal("e_unsettleamt"));
        }
        DynamicObjectCollection planEntrys = bill.getDynamicObjectCollection("planentity");
        BigDecimal planEntryUnLockSum = BigDecimal.ZERO;
        BigDecimal planEntryUnSettleSum = BigDecimal.ZERO;
        for (DynamicObject planEntry : planEntrys) {
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplansettleamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_10", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_11", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplansettleamt", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u7684\u201c\u672a\u7ed3\u7b97\u91d1\u989d\u201d\u4e0e\u201c\u5df2\u7ed3\u7b97\u91d1\u989d\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u201c\u5e94\u6536\u91d1\u989d\u201d\u3002", (String)"FinArBillCheckHelper_12", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplanlockamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_13", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "planlockedamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_14", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplanlockamt", "planlockedamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55(\u672a\u9501\u5b9a\u91d1\u989d+\u5df2\u9501\u5b9a\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_15", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planlockedamt", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5df2\u9501\u5b9a\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5df2\u9501\u5b9a\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_16", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "unplansettleamt", "unplanlockamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u672a\u9501\u5b9a\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5c0f\u4e8e\u672a\u9501\u5b9a\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_17", (String)"fi-arapcommon", (Object[])new Object[0]));
            planEntryUnLockSum = planEntryUnLockSum.add(planEntry.getBigDecimal("unplanlockamt"));
            planEntryUnSettleSum = planEntryUnSettleSum.add(planEntry.getBigDecimal("unplansettleamt"));
        }
        AmountCompareHelper.compare(billno, detailEntryUnLockSum, planEntryUnLockSum, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u672a\u9501\u5b9a\u91d1\u989d\u5408\u8ba1\u4e0e\u8ba1\u5212\u884c\u672a\u9501\u5b9a\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"FinApBillCheckHelper_18", (String)"fi-arapcommon", (Object[])new Object[0]));
        AmountCompareHelper.compare(billno, detailEntryUnSettleSum, planEntryUnSettleSum, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0e\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"FinApBillCheckHelper_19", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    public static void checkLockAndSettleField(DynamicObject bill, int arSettleParam) {
        String billno = bill.getString("billno");
        String settleStatus = bill.getString("settlestatus");
        if ("unsettle".equals(settleStatus) || "settled".equals(settleStatus)) {
            AmountCompareHelper.compare(billno, bill, "recamount", "unsettleamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, bill, "recamount", "settleamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        DynamicObjectCollection detailEntrys = bill.getDynamicObjectCollection("entry");
        BigDecimal detailEntryUnLockSum = BigDecimal.ZERO;
        BigDecimal detailEntryUnSettleSum = BigDecimal.ZERO;
        for (DynamicObject detailEntry : detailEntrys) {
            if (1 == arSettleParam) {
                AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_unsettleamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_settledamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_unsettleamt", "e_settledamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u7684\u201c\u672a\u7ed3\u7b97\u91d1\u989d\u201d\u4e0e\u201c\u5df2\u7ed3\u7b97\u91d1\u989d\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u8868\u5934\u7684\u201c\u5e94\u6536\u91d1\u989d\u201d\u3002", (String)"FinArBillCheckHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_unlockamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_lockedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_6", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, detailEntry, "e_recamount", "e_unlockamt", "e_lockedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u7684\u201c\u672a\u9501\u5b9a\u91d1\u989d\u201d\u4e0e\u201c\u5df2\u9501\u5b9a\u91d1\u989d\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u8868\u5934\u7684\u201c\u5e94\u6536\u91d1\u989d\u201d\u3002", (String)"FinArBillCheckHelper_7", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            detailEntryUnLockSum = detailEntryUnLockSum.add(detailEntry.getBigDecimal("e_unlockamt"));
            detailEntryUnSettleSum = detailEntryUnSettleSum.add(detailEntry.getBigDecimal("e_unsettleamt"));
        }
        DynamicObjectCollection planEntrys = bill.getDynamicObjectCollection("planentity");
        BigDecimal planEntryUnLockSum = BigDecimal.ZERO;
        BigDecimal planEntryUnSettleSum = BigDecimal.ZERO;
        for (DynamicObject planEntry : planEntrys) {
            if (2 == arSettleParam) {
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplansettleamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_10", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_11", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplansettleamt", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u7684\u201c\u672a\u7ed3\u7b97\u91d1\u989d\u201d\u4e0e\u201c\u5df2\u7ed3\u7b97\u91d1\u989d\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u201c\u5e94\u6536\u91d1\u989d\u201d\u3002", (String)"FinArBillCheckHelper_12", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplanlockamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_13", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "planlockedamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_14", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplanlockamt", "planlockedamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55(\u672a\u9501\u5b9a\u91d1\u989d+\u5df2\u9501\u5b9a\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\u3002", (String)"FinArBillCheckHelper_15", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planlockedamt", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5df2\u9501\u5b9a\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5df2\u9501\u5b9a\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_16", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "unplansettleamt", "unplanlockamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u672a\u9501\u5b9a\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5c0f\u4e8e\u672a\u9501\u5b9a\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_17", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            planEntryUnLockSum = planEntryUnLockSum.add(planEntry.getBigDecimal("unplanlockamt"));
            planEntryUnSettleSum = planEntryUnSettleSum.add(planEntry.getBigDecimal("unplansettleamt"));
        }
        if ("unsettle".equals(settleStatus) || "settled".equals(settleStatus)) {
            AmountCompareHelper.compare(billno, detailEntryUnLockSum, planEntryUnLockSum, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u672a\u9501\u5b9a\u91d1\u989d\u5408\u8ba1\u4e0e\u8ba1\u5212\u884c\u672a\u9501\u5b9a\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"FinApBillCheckHelper_18", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntryUnSettleSum, planEntryUnSettleSum, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0e\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"FinApBillCheckHelper_19", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }
}

