/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.helper;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.check.helper.AmountCompareHelper;

public class PayApplyBillCheckHelper {
    public static void checkAmountField(Set<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return;
        }
        Object[] bills = BusinessDataServiceHelper.load((String)"ap_payapply", (String)"billno,applyamount,approvalamount,e_payamount,paycurrency,settlecurrency,e_applyamount,e_approvedamt,e_paidamt,lockedamt,e_approvedseleamt", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (ObjectUtils.isEmpty((Object[])bills)) {
            return;
        }
        for (Object bill : bills) {
            PayApplyBillCheckHelper.checkAmountField((DynamicObject)bill);
        }
    }

    public static void checkAmountField(DynamicObject bill) {
        String billno = bill.getString("billno");
        Long payCurrencyId = bill.getDynamicObject("paycurrency").getLong("id");
        Long settleCurrencyId = bill.getDynamicObject("settlecurrency").getLong("id");
        boolean isSameCurrency = payCurrencyId.equals(settleCurrencyId);
        AmountCompareHelper.compare(billno, bill, "applyamount", "approvalamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u6838\u51c6\u91d1\u989d\u987b\u540c\u7533\u8bf7\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d\u3002", (String)"PayApplyBillCheckHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
        BigDecimal entryApplyAmount = BigDecimal.ZERO;
        BigDecimal entryApprovedAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            AmountCompareHelper.compare(billno, entry, "e_applyamount", "e_approvedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u6838\u51c6\u91d1\u989d\u987b\u540c\u7533\u8bf7\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d\u3002", (String)"PayApplyBillCheckHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            String message = isSameCurrency ? ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u987b\u540c\u6838\u51c6\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u6838\u51c6\u91d1\u989d\u3002", (String)"PayApplyBillCheckHelper_7", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u987b\u540c\u6838\u51c6\u91d1\u989d\u6298\u7ed3\u7b97\u5e01\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u6838\u51c6\u91d1\u989d\u6298\u7ed3\u7b97\u5e01\u3002", (String)"PayApplyBillCheckHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]);
            AmountCompareHelper.compare(billno, entry, "e_approvedseleamt", "lockedamt", message);
            AmountCompareHelper.compare(billno, entry, "lockedamt", "e_paidamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u4ed8\u91d1\u989d\u987b\u540c\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u3002", (String)"PayApplyBillCheckHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            entryApplyAmount = entryApplyAmount.add(entry.getBigDecimal("e_applyamount"));
            entryApprovedAmt = entryApprovedAmt.add(entry.getBigDecimal("e_approvedamt"));
        }
        AmountCompareHelper.compare(billno, entryApplyAmount, bill.getBigDecimal("applyamount"), ResManager.loadKDString((String)"\u660e\u7ec6\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u4e0e\u5355\u636e\u5934\u7533\u8bf7\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"PayApplyBillCheckHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]));
        AmountCompareHelper.compare(billno, entryApprovedAmt, bill.getBigDecimal("approvalamount"), ResManager.loadKDString((String)"\u660e\u7ec6\u6838\u51c6\u91d1\u989d\u5408\u8ba1\u4e0e\u5355\u636e\u5934\u6838\u51c6\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"PayApplyBillCheckHelper_6", (String)"fi-arapcommon", (Object[])new Object[0]));
    }
}

