/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.interf;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbnormalBillInfo;
import kd.fi.arapcommon.check.helper.DataCheckHelper;
import kd.fi.arapcommon.check.interf.IDataCheckService;
import kd.fi.arapcommon.check.param.DataCheckExecStatusEnum;
import kd.fi.arapcommon.check.param.DataCheckResult;
import kd.fi.arapcommon.check.param.DataCheckTaskParam;

public abstract class AbstractDataCheckService
implements IDataCheckService {
    private static final int BATCHQUERYCOUNT = 1000;
    private static final int ERRORDATACOUNT = 1000;

    @Override
    public DataCheckResult dataCheck(DataCheckTaskParam param) {
        DataCheckHelper.updateResultExecuting(param);
        DataCheckResult result = DataCheckHelper.genCheckResultByParam(param);
        result.setExecStatus(DataCheckExecStatusEnum.EXECUTING.getValue());
        QFilter filter = this.getFilter(param);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"checkResult-query", (String)param.getEntity(), (String)"id", (QFilter[])new QFilter[]{filter}, (String)"");
        ArrayList<Long> idList = new ArrayList<Long>(100);
        boolean errorCountMax = false;
        for (Row row : dataSet) {
            List<AbnormalBillInfo> entries;
            idList.add(row.getLong("id"));
            if (idList.size() != 1000) continue;
            result.setBillCount(result.getBillCount() + idList.size());
            if (errorCountMax || ObjectUtils.isEmpty(entries = this.doCheck(param, idList))) continue;
            result.getEntries().addAll(entries);
            result.setErrorCount(result.getErrorCount() + entries.size());
            idList.clear();
            if (result.getEntries().size() < 1000) continue;
            errorCountMax = true;
            break;
        }
        if (!idList.isEmpty()) {
            List<AbnormalBillInfo> entries;
            result.setBillCount(result.getBillCount() + idList.size());
            if (!errorCountMax && !ObjectUtils.isEmpty(entries = this.doCheck(param, idList))) {
                result.getEntries().addAll(entries);
                result.setErrorCount(result.getErrorCount() + entries.size());
            }
        }
        result.setExecStatus(DataCheckExecStatusEnum.SUCCESS.getValue());
        DataCheckHelper.updateResultEntryExecuted(result);
        return result;
    }

    protected abstract List<AbnormalBillInfo> doCheck(DataCheckTaskParam var1, List<Long> var2);

    protected QFilter getFilter(DataCheckTaskParam param) {
        long orgId = param.getOrgId();
        Date beginDate = param.getBeginDate();
        Date endDate = param.getEndDate();
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("bizdate", ">=", (Object)beginDate);
        filter.and("bizdate", "<=", (Object)endDate);
        return filter;
    }
}

