/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.checkitem;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SimOriginalBillOnPassageCheck
implements IClosePeriodCheckPlugin {
    private static Log logger = LogFactory.getLog(SimOriginalBillOnPassageCheck.class);

    public CheckResult execute(CheckContext checkContext) throws Throwable {
        logger.info("\u5e94\u6536\u81ea\u5b9a\u4e49\u7ed3\u8d26\u68c0\u67e5\u9879\uff1a\u5f00\u7968\u7533\u8bf7\u5355\u5728\u9014\u68c0\u67e5\u5f00\u59cb");
        Long orgId = checkContext.getOrgId();
        Date periodStartDate = checkContext.getPeriodStartDate();
        Date periodEndDate = checkContext.getPeriodEndDate();
        QFilter filter = new QFilter("orgid", "=", (Object)orgId);
        filter.and(new QFilter("issuetime", ">=", (Object)periodStartDate));
        filter.and(new QFilter("issuetime", "<=", (Object)periodEndDate));
        filter.and(new QFilter("validstate", "=", (Object)"2"));
        filter.and(new QFilter("billsourcetype", "=", (Object)"A"));
        filter.and(new QFilter("unpushamount", "!=", (Object)BigDecimal.ZERO));
        DynamicObjectCollection simBill = QueryServiceHelper.query((String)"sim_original_bill", (String)"id", (QFilter[])new QFilter[]{filter});
        boolean isExist = simBill != null && !simBill.isEmpty();
        CheckResult checkResult = new CheckResult();
        if (isExist) {
            List simBillIds = simBill.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            logger.info("\u5e94\u6536\u81ea\u5b9a\u4e49\u7ed3\u8d26\u68c0\u67e5\u9879\uff1a\u5f00\u7968\u7533\u8bf7\u5355\u5728\u9014\u68c0\u67e5\u5931\u8d25\uff0c\u5f00\u7968\u7533\u8bf7\u5355ids:", simBillIds);
            checkResult.setIsSuccess(false);
            checkResult.setOnlineViewId("sim_original_bill");
            QFilter idFilter = new QFilter("id", "in", simBillIds);
            checkResult.setOnlineQueryParams(idFilter.toSerializedString());
        } else {
            checkResult.setIsSuccess(true);
            logger.info("\u5e94\u6536\u81ea\u5b9a\u4e49\u7ed3\u8d26\u68c0\u67e5\u9879\uff1a\u5f00\u7968\u7533\u8bf7\u5355\u5728\u9014\u68c0\u67e5\u901a\u8fc7");
        }
        return checkResult;
    }
}

