/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class ApPrePaidAsstactConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        Long srcId;
        DynamicObject finArBill;
        String targetBillName = this.getTgtMainType().getExtendName();
        String srcBillName = this.getSrcMainType().getExtendName();
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey(targetBillName);
        HashSet<Long> apIds = new HashSet<Long>(8);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject finArBill2 = entity.getDataEntity();
            DynamicObject org = finArBill2.getDynamicObject("org");
            DynamicObject recorg = finArBill2.getDynamicObject("recorg");
            if (ObjectUtils.isEmpty((Object)recorg) || !recorg.getBoolean("fisbankroll")) {
                finArBill2.set("recorg", (Object)org);
                recorg = org;
            }
            if (!ObjectUtils.isEmpty((Object)recorg) && !recorg.getBoolean("fisbankroll")) {
                finArBill2.set("recorg", null);
            }
            Long srcId2 = finArBill2.getLong("sourcebillid");
            String billTypeNum = finArBill2.getString("billtype.number");
            if (!"arfin_other_BT_S".equals(billTypeNum) && !"ar_busbill_other_BT_S".equals(billTypeNum)) continue;
            apIds.add(srcId2);
        }
        HashMap<Long, List<Long>> allSrcIdsMap = new HashMap<Long, List<Long>>(64);
        HashMap<Long, DynamicObject> assctMap = new HashMap<Long, DynamicObject>(16);
        Set<Long> existApIds = this.selAsstBySrcIds(apIds, allSrcIdsMap, assctMap, srcBillName);
        apIds.clear();
        for (ExtendedDataEntity entity : entities) {
            finArBill = entity.getDataEntity();
            srcId = finArBill.getLong("sourcebillid");
            String billTypeNum = finArBill.getString("billtype.number");
            if (existApIds.contains(srcId) || !"arfin_other_BT_S".equals(billTypeNum)) continue;
            apIds.add(srcId);
        }
        this.selAsstByBotpNodes(apIds, allSrcIdsMap, assctMap);
        for (ExtendedDataEntity entity : entities) {
            List srcIds;
            DynamicObject asst;
            finArBill = entity.getDataEntity();
            srcId = finArBill.getLong("sourcebillid");
            if (allSrcIdsMap.size() <= 0 || (asst = (DynamicObject)assctMap.get((srcIds = (List)allSrcIdsMap.get(srcId)).get(0))) == null) continue;
            finArBill.set("asstacttype", (Object)asst.getDynamicObjectType().getName());
            finArBill.set("asstact", (Object)asst);
        }
    }

    private Set<Long> selAsstBySrcIds(Set<Long> apIds, Map<Long, List<Long>> allSrcIdsMap, Map<Long, DynamicObject> assctMap, String srcBillName) {
        DynamicObjectCollection srcApBills = QueryServiceHelper.query((String)srcBillName, (String)"id,sourcebilltype,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", apIds).and("sourcebilltype", "in", this.srcTypeSet())});
        Map<String, List<DynamicObject>> srcApMap = srcApBills.stream().collect(Collectors.groupingBy(t -> t.getString("sourcebilltype")));
        HashSet<Long> existApIds = new HashSet<Long>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : srcApMap.entrySet()) {
            String key = entry.getKey();
            List<DynamicObject> apBillList = entry.getValue();
            HashSet<Long> allSrcIds = new HashSet<Long>(64);
            for (DynamicObject apBill : apBillList) {
                Long apSrcId = apBill.getLong("sourcebillid");
                allSrcIds.add(apSrcId);
                Long apId = apBill.getLong("id");
                ArrayList<Long> srcList = new ArrayList<Long>(1);
                srcList.add(apSrcId);
                allSrcIdsMap.put(apId, srcList);
                existApIds.add(apId);
            }
            this.selAsstactByIds(allSrcIds, key, assctMap);
        }
        return existApIds;
    }

    private void selAsstByBotpNodes(Set<Long> apIds, Map<Long, List<Long>> allSrcIdsMap, Map<Long, DynamicObject> assctMap) {
        Map<String, Map<Long, List<Long>>> srcMapByEntityNum = this.loadNearUpBillIds(this.getSrcMainType().getName(), this.srcTypeSet(), apIds.toArray(new Long[0]));
        for (Map.Entry<String, Map<Long, List<Long>>> entry : srcMapByEntityNum.entrySet()) {
            String key = entry.getKey();
            Map<Long, List<Long>> srcBillIdsMap = entry.getValue();
            allSrcIdsMap.putAll(srcBillIdsMap);
            HashSet<Long> allSrcIds = new HashSet<Long>(64);
            for (Map.Entry<Long, List<Long>> srcEntry : srcBillIdsMap.entrySet()) {
                allSrcIds.addAll((Collection<Long>)srcEntry.getValue());
            }
            this.selAsstactByIds(allSrcIds, key, assctMap);
        }
    }

    private void selAsstactByIds(Set<Long> allSrcIds, String key, Map<Long, DynamicObject> assctMap) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", allSrcIds)};
        switch (key) {
            case "pm_purorderbill": {
                DynamicObject[] srcBills = BusinessDataServiceHelper.load((String)key, (String)"id,invoicesupplier", (QFilter[])filters);
                assctMap.putAll(Arrays.stream(srcBills).collect(Collectors.toMap(t -> t.getLong("id"), t -> t.getDynamicObject("invoicesupplier"))));
                break;
            }
            case "im_purinbill": {
                DynamicObject[] srcBills = BusinessDataServiceHelper.load((String)key, (String)"billentry.invoicesupplier", (QFilter[])filters);
                assctMap.putAll(Arrays.stream(srcBills).collect(Collectors.toMap(t -> t.getLong("id"), t -> ((DynamicObject)t.getDynamicObjectCollection("billentry").get(0)).getDynamicObject("invoicesupplier"))));
                break;
            }
            case "sm_salorder": {
                DynamicObject[] srcBills = BusinessDataServiceHelper.load((String)key, (String)"settlecustomer", (QFilter[])filters);
                assctMap.putAll(Arrays.stream(srcBills).collect(Collectors.toMap(t -> t.getLong("id"), t -> t.getDynamicObject("settlecustomer"))));
                break;
            }
            case "sm_delivernotice": {
                DynamicObject[] srcBills = BusinessDataServiceHelper.load((String)key, (String)"settlecustomer", (QFilter[])filters);
                assctMap.putAll(Arrays.stream(srcBills).collect(Collectors.toMap(t -> t.getLong("id"), t -> t.getDynamicObject("settlecustomer"))));
                break;
            }
            case "im_saloutbill": {
                DynamicObject[] srcBills = BusinessDataServiceHelper.load((String)key, (String)"billentry.settlecustomer", (QFilter[])filters);
                assctMap.putAll(Arrays.stream(srcBills).collect(Collectors.toMap(t -> t.getLong("id"), t -> ((DynamicObject)t.getDynamicObjectCollection("billentry").get(0)).getDynamicObject("settlecustomer"))));
            }
        }
    }

    private Set<String> srcTypeSet() {
        HashSet<String> srcTypeSet = new HashSet<String>(8);
        srcTypeSet.add("pm_purorderbill");
        srcTypeSet.add("im_purinbill");
        srcTypeSet.add("sm_salorder");
        srcTypeSet.add("sm_delivernotice");
        srcTypeSet.add("im_saloutbill");
        return srcTypeSet;
    }

    public Map<String, Map<Long, List<Long>>> loadNearUpBillIds(String entityNumber, Set<String> upEntityNumbers, Long[] ids) {
        HashMap<String, Map<Long, List<Long>>> resultMap = new HashMap<String, Map<Long, List<Long>>>(ids.length);
        HashMap resultSrcMap = new HashMap(ids.length);
        HashMap<Long, String> upTableMap = new HashMap<Long, String>(8);
        for (String upEntityNumber : upEntityNumbers) {
            TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)upEntityNumber, (String)upEntityNumber);
            Long upTableId = tableDefine.getTableId();
            upTableMap.put(upTableId, upEntityNumber);
        }
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)"", (Long[])ids);
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return resultMap;
        }
        for (Long id : ids) {
            List nodes = bfRowLinkUpNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getBillId().compareTo(id) == 0).collect(Collectors.toList());
            ArrayList srcPks = new ArrayList(10);
            String upKey = "";
            for (BFRowLinkUpNode node : nodes) {
                Map<String, List<BFRowLinkUpNode>> sourceNodesMap = this.findSourceNodes(node, upTableMap, id);
                for (Map.Entry<String, List<BFRowLinkUpNode>> entry : sourceNodesMap.entrySet()) {
                    List<BFRowLinkUpNode> sourceNodes = entry.getValue();
                    upKey = entry.getKey();
                    List pkList = sourceNodes.stream().map(srcNode -> srcNode.getRowId().getBillId()).collect(Collectors.toList());
                    srcPks.addAll(pkList);
                }
            }
            if (srcPks.isEmpty()) continue;
            resultSrcMap.put(id, srcPks);
            resultMap.put(upKey, resultSrcMap);
        }
        return resultMap;
    }

    private Map<String, List<BFRowLinkUpNode>> findSourceNodes(BFRowLinkUpNode node, Map<Long, String> upTableMap, Long id) {
        Long mainTableId;
        HashMap<String, List<BFRowLinkUpNode>> bFRowLinkUpNodeMap = new HashMap<String, List<BFRowLinkUpNode>>(8);
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        Set<Long> upTableIds = upTableMap.keySet();
        if (upTableIds.contains(mainTableId = node.getRowId().getMainTableId()) && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
            String EntityNumber = upTableMap.get(mainTableId);
            bFRowLinkUpNodeMap.put(EntityNumber, nodes);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                bFRowLinkUpNodeMap.putAll(this.findSourceNodes(sNode, upTableMap, id));
            }
        }
        return bFRowLinkUpNodeMap;
    }
}

