/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;

public class CalculateQuantityAmount
extends AbstractConvertPlugIn {
    private Map<Long, Map<String, BigDecimal>> calculateResult = new HashMap<Long, Map<String, BigDecimal>>(16);
    private final Map<Long, String> noRecalculateSrcEntryIdMap = new HashMap<Long, String>(8);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        Long entryId;
        ArrayList<Long> filterEntryIds = new ArrayList<Long>(16);
        List selectedRows = e.getSelectedRows();
        ArrayList<Long> busBillIds = new ArrayList<Long>(16);
        ArrayList<Long> busEntryIds = new ArrayList<Long>(16);
        for (Object row : selectedRows) {
            busBillIds.add((Long)row.getPrimaryKeyValue());
        }
        DataSet srcBusBills = QueryServiceHelper.queryDataSet((String)"calculateamt", (String)"ar_busbill", (String)"id,payproperty.isbasedonamt,entry.id,entry.e_amount,entry.e_quantity,entry.e_recamount,entry.e_unwoffqty,entry.e_unwoffamt,entry.e_unwoffnotaxamt,entry.e_uninvoicedqty,entry.e_uninvoicedamt,entry.e_uninvnotaxamt,entry.e_unrelateinvqty,entry.e_unrelateinvamt,entry.e_taxrate,entry.e_actunitprice,entry.e_ispresent", (QFilter[])new QFilter[]{new QFilter("id", "in", busBillIds)}, null);
        for (Row row : srcBusBills.copy()) {
            busEntryIds.add(row.getLong("entry.id"));
        }
        HashMap<Long, Long> simToBusEntryIdMap = new HashMap<Long, Long>(16);
        ArrayList<Long> simBillEntryIds = new ArrayList<Long>(16);
        Map<Long, List<Long>> targetSimMap = BOTPNewHelper.loadNearTargetRowIds("ar_busbill", "entry", busBillIds.toArray(new Long[0]), busEntryIds.toArray(new Long[0]), "sim_original_bill");
        for (Map.Entry<Long, List<Long>> entrySet : targetSimMap.entrySet()) {
            Iterator<Map.Entry<Long, Map<String, BigDecimal>>> tempEntryIds = entrySet.getValue();
            simBillEntryIds.addAll((Collection<Long>)((Object)tempEntryIds));
            Iterator<Long> iterator = tempEntryIds.iterator();
            while (iterator.hasNext()) {
                Long id = iterator.next();
                simToBusEntryIdMap.put(id, entrySet.getKey());
            }
        }
        HashMap<Long, BigDecimal> busRelInvAmtMap = new HashMap<Long, BigDecimal>(16);
        DataSet simBills = QueryServiceHelper.queryDataSet((String)"calculateamt", (String)"sim_original_bill", (String)"sim_original_bill_item.id,sim_original_bill_item.amount", (QFilter[])new QFilter[]{new QFilter("sim_original_bill_item.id", "in", simBillEntryIds)}, null);
        for (Row row : simBills) {
            entryId = row.getLong("sim_original_bill_item.id");
            Long busEntryId = (Long)simToBusEntryIdMap.get(entryId);
            if (busEntryId == null) continue;
            BigDecimal amount = row.getBigDecimal("sim_original_bill_item.amount");
            busRelInvAmtMap.merge(busEntryId, amount, (a, b) -> b.add((BigDecimal)a));
        }
        for (Row row : srcBusBills) {
            BigDecimal quantity;
            HashMap<String, BigDecimal> entryMap = new HashMap<String, BigDecimal>(8);
            Long entryId2 = row.getLong("entry.id");
            BigDecimal busQty = row.getBigDecimal("entry.e_quantity");
            if (row.getBoolean("payproperty.isbasedonamt") == null || !row.getBoolean("payproperty.isbasedonamt").booleanValue()) {
                BigDecimal busUnWoffQty = row.getBigDecimal("entry.e_unwoffqty");
                BigDecimal busUnInvoicedQty = row.getBigDecimal("entry.e_uninvoicedqty");
                BigDecimal busUnRelateInvQty = row.getBigDecimal("entry.e_unrelateinvqty");
                quantity = busQty.compareTo(BigDecimal.ZERO) >= 0 ? this.findMinValue(busUnWoffQty, busUnInvoicedQty, busUnRelateInvQty) : this.findMaxValue(busUnWoffQty, busUnInvoicedQty, busUnRelateInvQty);
            } else {
                quantity = busQty;
            }
            entryMap.put("quantity", quantity);
            BigDecimal taxRate = row.getBigDecimal("entry.e_taxrate");
            BigDecimal price = row.getBigDecimal("entry.e_actunitprice");
            BigDecimal tax = quantity.multiply(price).multiply(taxRate.divide(new BigDecimal("100"))).setScale(10, RoundingMode.HALF_UP);
            entryMap.put("tax", tax);
            BigDecimal recamount = row.getBigDecimal("entry.e_recamount");
            BigDecimal unwoffamt = row.getBigDecimal("entry.e_unwoffamt");
            BigDecimal uninvoicedamt = row.getBigDecimal("entry.e_uninvoicedamt");
            BigDecimal unrelateinvamt = row.getBigDecimal("entry.e_unrelateinvamt");
            if (recamount.compareTo(BigDecimal.ZERO) >= 0) {
                entryMap.put("recamount", this.findMinValue(unwoffamt, uninvoicedamt, unrelateinvamt));
            } else {
                entryMap.put("recamount", this.findMaxValue(unwoffamt, uninvoicedamt, unrelateinvamt));
            }
            BigDecimal amount = row.getBigDecimal("entry.e_amount");
            BigDecimal unwoffnotaxamt = row.getBigDecimal("entry.e_unwoffnotaxamt");
            BigDecimal uninvnotaxamt = row.getBigDecimal("entry.e_uninvnotaxamt");
            BigDecimal unrelateinvnotaxamt = amount.subtract(busRelInvAmtMap.getOrDefault(entryId2, BigDecimal.ZERO));
            if (amount.compareTo(BigDecimal.ZERO) >= 0) {
                entryMap.put("amount", this.findMinValue(unwoffnotaxamt, uninvnotaxamt, unrelateinvnotaxamt));
            } else {
                entryMap.put("amount", this.findMaxValue(unwoffnotaxamt, uninvnotaxamt, unrelateinvnotaxamt));
            }
            this.calculateResult.put(entryId2, entryMap);
        }
        for (Map.Entry<Long, Map<String, BigDecimal>> entrySet : this.calculateResult.entrySet()) {
            entryId = entrySet.getKey();
            Map<String, BigDecimal> busEntryInfo = entrySet.getValue();
            BigDecimal quantity = busEntryInfo.get("quantity");
            if (quantity.compareTo(BigDecimal.ZERO) != 0) continue;
            filterEntryIds.add(entryId);
        }
        List custQFilters = e.getCustQFilters();
        QFilter filter = new QFilter("entry.id", "not in", filterEntryIds);
        e.setCustFilterExpression(filter.toString());
        custQFilters.add(filter);
        String desc = ResManager.loadKDString((String)"\u53ef\u80fd\u7684\u539f\u56e0\uff1a1.\u6682\u4f30\u5e94\u6536\u5355\u5df2\u5168\u90e8\u51b2\u56de\uff1b2.\u6682\u4f30\u5e94\u6536\u5355\u5df2\u5168\u989d\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\uff1b3.\u6682\u4f30\u5e94\u6536\u5355\u5df2\u5168\u989d\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u3002", (String)"CalculateQuantityAmount_0", (String)"fi-arapcommon", (Object[])new Object[0]);
        e.setCustFilterDesc(desc);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        this.buildNoRecalculateInfo();
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String targetEntityNumber = this.getTgtMainType().getName();
        Map extDataEntityMap = entitySet.getExtDataEntityMap();
        List entitys = (List)extDataEntityMap.get(targetEntityNumber);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                Long srcEntryId;
                Map<String, BigDecimal> srcEntryInfo;
                DynamicObjectCollection entrylk = row.getDynamicObjectCollection("entry_lk");
                if (ObjectUtils.isEmpty((Object)entrylk) || (srcEntryInfo = this.calculateResult.get(srcEntryId = (Long)((DynamicObject)entrylk.get(0)).get("entry_lk_sid"))) == null) continue;
                row.set("e_quantity", (Object)srcEntryInfo.get("quantity"));
                String noRecalculate = this.noRecalculateSrcEntryIdMap.getOrDefault(srcEntryId, "false");
                if ("true".equals(noRecalculate)) continue;
                row.set("e_amount", (Object)srcEntryInfo.get("amount"));
                row.set("e_recamount", (Object)srcEntryInfo.get("recamount"));
                row.set("e_tax", (Object)srcEntryInfo.get("tax"));
            }
        }
    }

    private void buildNoRecalculateInfo() {
        Map variables = this.getOption().getVariables();
        String noRecalculateSrcEntryIds = (String)variables.get("noRecalculateSrcEntryIds");
        if (!ObjectUtils.isEmpty((Object)noRecalculateSrcEntryIds)) {
            List noRecalculateSrcEntryIdList = (List)SerializationUtils.fromJsonString((String)noRecalculateSrcEntryIds, List.class);
            for (Long entryId : noRecalculateSrcEntryIdList) {
                this.noRecalculateSrcEntryIdMap.put(entryId, "true");
            }
        }
    }

    private BigDecimal findMinValue(BigDecimal first, BigDecimal second, BigDecimal third) {
        BigDecimal result = first;
        if (result.compareTo(second) > 0) {
            result = second;
        }
        if (result.compareTo(third) > 0) {
            result = third;
        }
        if (result.compareTo(BigDecimal.ZERO) <= 0) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    private BigDecimal findMaxValue(BigDecimal first, BigDecimal second, BigDecimal third) {
        BigDecimal result = first;
        if (result.compareTo(second) < 0) {
            result = second;
        }
        if (result.compareTo(third) < 0) {
            result = third;
        }
        if (result.compareTo(BigDecimal.ZERO) >= 0) {
            result = BigDecimal.ZERO;
        }
        return result;
    }
}

