/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.util.AllocationUtils;

public class ExpenseAllocationConvertPlugin
extends AbstractConvertPlugIn {
    private BillModel billModel;

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entities;
        String targetBillName = this.getTgtMainType().getExtendName();
        this.billModel = BillModelFactory.getModel(targetBillName);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entities = entitySet.FindByEntityKey(targetBillName)) {
            DynamicObject targetBill = entity.getDataEntity();
            BigDecimal billTotalAmt = this.getTargetBillHeadAmt(targetBillName, targetBill);
            BigDecimal billTotalLocAmt = this.getTargetBillHeadLocAmt(targetBillName, targetBill);
            boolean needRecalculate = AllocationUtils.isNeedRecalculate(billTotalAmt, targetBill);
            if (!needRecalculate) continue;
            AllocationUtils.executeCalculation(billTotalAmt, billTotalLocAmt, targetBill);
        }
    }

    private BigDecimal getTargetBillHeadAmt(String billName, DynamicObject targetBill) {
        String detailEntryName = AllocationUtils.getBillDetailPropertyName(billName);
        int precision = targetBill.getBigDecimal(this.billModel.HEAD_AMOUNT).scale();
        return targetBill.getDynamicObjectCollection(detailEntryName).stream().map(rowEntry -> rowEntry.getBigDecimal(this.billModel.E_AMOUNT)).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(precision, RoundingMode.HALF_UP);
    }

    private BigDecimal getTargetBillHeadLocAmt(String billName, DynamicObject targetBill) {
        String detailEntryName = AllocationUtils.getBillDetailPropertyName(billName);
        int precision = targetBill.getBigDecimal(this.billModel.HEAD_LOCALAMT).scale();
        return targetBill.getDynamicObjectCollection(detailEntryName).stream().map(rowEntry -> rowEntry.getBigDecimal(this.billModel.E_LOCALAMT)).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(precision, RoundingMode.HALF_UP);
    }
}

