/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.util.StdConfig;

public class FinApToPayTransitPrePayCtrlPlugin
extends AbstractConvertPlugIn {
    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        BigDecimal sumConmPerAmt;
        String ignorePreTransit = StdConfig.get("ignorepretransit");
        if ("true".equals(ignorePreTransit)) {
            return;
        }
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendEntites = entitySet.FindByEntityKey(this.getTgtMainType().getExtendName());
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendEntites.length);
        for (ExtendedDataEntity extendEntity : extendEntites) {
            entities.add(extendEntity.getDataEntity());
        }
        ArrayList<Long> coreBillIds = new ArrayList<Long>(16);
        ArrayList<Long> finApBillIds = new ArrayList<Long>(16);
        for (DynamicObject bill : entities) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (Object row : entry) {
                long coreBillId = row.getLong("e_corebillid");
                if (coreBillId == 0L) continue;
                coreBillIds.add(coreBillId);
                DynamicObjectCollection entrylk = row.getDynamicObjectCollection("entry_lk");
                if (ObjectUtils.isEmpty((Object)entrylk)) continue;
                Long finApBillId = (Long)((DynamicObject)entrylk.get(0)).get("entry_lk_sbillid");
                finApBillIds.add(finApBillId);
            }
        }
        if (coreBillIds.size() == 0) {
            return;
        }
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billno,org,asstact.masterid,detailentry.corebilltype,detailentry.corebillid,detailentry.e_conbillid,detailentry.e_expensebillids_tag,detailentry.e_conbillnumber,detailentry.corebillno", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds), new QFilter("detailentry.corebillid", "in", coreBillIds)});
        ArrayList<Long> purBillIds = new ArrayList<Long>(16);
        ArrayList<Long> conmBillIds = new ArrayList<Long>(16);
        ArrayList<Long> sctmBillIds = new ArrayList<Long>(16);
        for (DynamicObject bill : finApBills) {
            boolean isExpenseBill;
            String expenseBillIds = bill.getString("detailentry.e_expensebillids_tag");
            boolean bl = isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
            if (isExpenseBill) continue;
            String coreBillType = bill.getString("detailentry.corebilltype");
            Long coreBillId = bill.getLong("detailentry.corebillid");
            if ("pm_purorderbill".equals(coreBillType)) {
                purBillIds.add(coreBillId);
                Long conBillId = bill.getLong("detailentry.e_conbillid");
                if (conBillId != 0L) {
                    conmBillIds.add(conBillId);
                }
            }
            if ("conm_purcontract".equals(coreBillType)) {
                conmBillIds.add(coreBillId);
            }
            if (!"sctm_scpo".equals(coreBillType)) continue;
            sctmBillIds.add(coreBillId);
        }
        ArrayList<Long> havePreAmtPurBillIds = new ArrayList<Long>(16);
        ArrayList<Long> havePreAmtConmBillIds = new ArrayList<Long>(16);
        ArrayList<Long> havePreAmtSctmBillIds = new ArrayList<Long>(16);
        ArrayList<Long> havePreAmtCoreBillIds = new ArrayList<Long>(16);
        HashMap<Long, BigDecimal> coreBillPrePayAmt = new HashMap<Long, BigDecimal>(16);
        DynamicObjectCollection hadChangePurBills = new DynamicObjectCollection();
        DynamicObjectCollection hadChangeConmBills = new DynamicObjectCollection();
        DynamicObjectCollection hadChangeSctmBills = new DynamicObjectCollection();
        if (purBillIds.size() > 0) {
            hadChangePurBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", purBillIds), new QFilter("changestatus", "=", (Object)"C"), new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE), new QFilter("isallowoverpay", "=", (Object)Boolean.FALSE)});
        }
        if (conmBillIds.size() > 0) {
            hadChangeConmBills = QueryServiceHelper.query((String)"conm_purcontract", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", conmBillIds), new QFilter("changestatus", "=", (Object)"C"), new QFilter("payentry.isprepay", "=", (Object)Boolean.TRUE), new QFilter("isallowoverpay", "=", (Object)Boolean.FALSE)});
        }
        if (sctmBillIds.size() > 0) {
            hadChangeSctmBills = QueryServiceHelper.query((String)"sctm_scpo", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", sctmBillIds), new QFilter("changestatus", "=", (Object)"C"), new QFilter("billentry_pay.isprepay", "=", (Object)Boolean.TRUE), new QFilter("isallowoverpay", "=", (Object)Boolean.FALSE)});
        }
        if (hadChangeConmBills.size() == 0 && hadChangePurBills.size() == 0 && hadChangeSctmBills.size() == 0) {
            return;
        }
        if (purBillIds.size() > 0) {
            DynamicObjectCollection purBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billno,purbillentry_pay.payamount", (QFilter[])new QFilter[]{new QFilter("id", "in", purBillIds), new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE), new QFilter("isallowoverpay", "=", (Object)Boolean.FALSE)});
            for (DynamicObject purBill : purBills) {
                Long purBillId = purBill.getLong("id");
                havePreAmtPurBillIds.add(purBillId);
                havePreAmtCoreBillIds.add(purBillId);
                BigDecimal sumPurPerAmt = (BigDecimal)coreBillPrePayAmt.get(purBillId);
                if (sumPurPerAmt == null) {
                    coreBillPrePayAmt.put(purBillId, purBill.getBigDecimal("purbillentry_pay.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(purBillId, sumPurPerAmt.add(purBill.getBigDecimal("purbillentry_pay.payamount")));
            }
        }
        if (conmBillIds.size() > 0) {
            DynamicObjectCollection conmBills = QueryServiceHelper.query((String)"conm_purcontract", (String)"id,billno,payentry.payamount", (QFilter[])new QFilter[]{new QFilter("id", "in", conmBillIds), new QFilter("changestatus", "=", (Object)"C"), new QFilter("payentry.isprepay", "=", (Object)Boolean.TRUE), new QFilter("isallowoverpay", "=", (Object)Boolean.FALSE)});
            for (DynamicObject conmBill : conmBills) {
                Long conmBillId = conmBill.getLong("id");
                havePreAmtConmBillIds.add(conmBillId);
                havePreAmtCoreBillIds.add(conmBillId);
                sumConmPerAmt = (BigDecimal)coreBillPrePayAmt.get(conmBillId);
                if (sumConmPerAmt == null) {
                    coreBillPrePayAmt.put(conmBillId, conmBill.getBigDecimal("payentry.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(conmBillId, sumConmPerAmt.add(conmBill.getBigDecimal("payentry.payamount")));
            }
        }
        if (sctmBillIds.size() > 0) {
            DynamicObjectCollection sctmBills = QueryServiceHelper.query((String)"sctm_scpo", (String)"id,billno,billentry_pay.payamount", (QFilter[])new QFilter[]{new QFilter("id", "in", sctmBillIds), new QFilter("changestatus", "=", (Object)"C"), new QFilter("billentry_pay.isprepay", "=", (Object)Boolean.TRUE), new QFilter("isallowoverpay", "=", (Object)Boolean.FALSE)});
            for (DynamicObject sctmBill : sctmBills) {
                Long sctmBillId = sctmBill.getLong("id");
                havePreAmtSctmBillIds.add(sctmBillId);
                havePreAmtCoreBillIds.add(sctmBillId);
                sumConmPerAmt = (BigDecimal)coreBillPrePayAmt.get(sctmBillId);
                if (sumConmPerAmt == null) {
                    coreBillPrePayAmt.put(sctmBillId, sctmBill.getBigDecimal("billentry_pay.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(sctmBillId, sumConmPerAmt.add(sctmBill.getBigDecimal("billentry_pay.payamount")));
            }
        }
        if (coreBillPrePayAmt.size() == 0) {
            return;
        }
        Map<Long, String> coreBillKeys = this.getCoreBillMatchKey(havePreAmtPurBillIds, havePreAmtConmBillIds, havePreAmtSctmBillIds);
        Map<Long, BigDecimal> coreBillSumPrePayMap = this.loadPayedPreBillAmt(havePreAmtCoreBillIds);
        for (DynamicObject apBill : finApBills) {
            String coreBillName;
            String coreMatchKey;
            boolean isExpenseBill;
            String expenseBillIds = apBill.getString("detailentry.e_expensebillids_tag");
            boolean bl = isExpenseBill = !ObjectUtils.isEmpty((Object)expenseBillIds);
            if (isExpenseBill) continue;
            String coreBillType = apBill.getString("detailentry.corebilltype");
            Long coreBillId = apBill.getLong("detailentry.corebillid");
            Long conBillId = apBill.getLong("detailentry.e_conbillid");
            Long masterId = apBill.getLong("asstact.masterid");
            String billNo = apBill.getString("billno");
            String coreBillNo = apBill.getString("detailentry.corebillno");
            String conmBillNo = apBill.getString("detailentry.e_conbillnumber");
            String apMatchKey = apBill.getLong("org") + "_" + masterId;
            if (!apMatchKey.equals(coreMatchKey = coreBillKeys.get(coreBillId))) continue;
            BigDecimal corePreAmt = (BigDecimal)coreBillPrePayAmt.get(coreBillId);
            BigDecimal conmPreAmt = (BigDecimal)coreBillPrePayAmt.get(conBillId);
            if (corePreAmt == null && conmPreAmt == null) continue;
            BigDecimal coreSumPreAmt = coreBillSumPrePayMap.get(coreBillId);
            String string = coreBillName = "pm_purorderbill".equals(coreBillType) ? ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"FinApToPayTransitPrePayCtrlPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c", (String)"FinApToPayTransitPrePayCtrlPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]);
            if (coreSumPreAmt != null && coreSumPreAmt.compareTo(corePreAmt) >= 0) continue;
            if ("pm_purorderbill".equals(coreBillType)) {
                if (conBillId == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s %3$s\u53d8\u66f4\u7684\u9884\u4ed8\u6b3e\u4fe1\u606f\u672a\u80fd\u5c06\u8d22\u52a1\u5e94\u4ed8\u5355\u540c\u6b65\u81f3\u6700\u65b0\u7684\u51bb\u7ed3\u72b6\u6001\u3002\u8bf7\u524d\u5f80\u6d41\u7a0b\u670d\u52a1\u4e91>\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3>\u76d1\u63a7\u4e2d\u5fc3>\u4e8b\u4ef6\u65e5\u5fd7\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u6216\u68c0\u67e5\u6d41\u7a0b\u670d\u52a1\u4e91>\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3>\u4e8b\u4ef6\u8ba2\u9605\u201c\u91c7\u8d2d\u5355\u636e\u9884\u4ed8\u91d1\u989d\u53d8\u66f4\u4e8b\u4ef6\u201d\u662f\u5426\u5df2\u542f\u7528\u3002", (String)"FinApToPayTransitPrePayCtrlPlugin_2", (String)"fi-arapcommon", (Object[])new Object[]{billNo, coreBillName, coreBillNo}));
                }
                BigDecimal conSumPreAmt = coreBillSumPrePayMap.get(conBillId);
                if (conmPreAmt != null && conSumPreAmt != null && conSumPreAmt.compareTo(conmPreAmt) >= 0) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u91c7\u8d2d\u5408\u540c %2$s\u53d8\u66f4\u7684\u9884\u4ed8\u6b3e\u4fe1\u606f\u672a\u80fd\u5c06\u8d22\u52a1\u5e94\u4ed8\u5355\u540c\u6b65\u81f3\u6700\u65b0\u7684\u51bb\u7ed3\u72b6\u6001\u3002\u8bf7\u524d\u5f80\u6d41\u7a0b\u670d\u52a1\u4e91>\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3>\u76d1\u63a7\u4e2d\u5fc3>\u4e8b\u4ef6\u65e5\u5fd7\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u6216\u68c0\u67e5\u6d41\u7a0b\u670d\u52a1\u4e91>\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3>\u4e8b\u4ef6\u8ba2\u9605\u201c\u91c7\u8d2d\u5355\u636e\u9884\u4ed8\u91d1\u989d\u53d8\u66f4\u4e8b\u4ef6\u201d\u662f\u5426\u5df2\u542f\u7528\u3002", (String)"FinApToPayTransitPrePayCtrlPlugin_3", (String)"fi-arapcommon", (Object[])new Object[]{billNo, conmBillNo}));
            }
            if ("conm_purcontract".equals(coreBillType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s %3$s\u53d8\u66f4\u7684\u9884\u4ed8\u6b3e\u4fe1\u606f\u672a\u80fd\u5c06\u8d22\u52a1\u5e94\u4ed8\u5355\u540c\u6b65\u81f3\u6700\u65b0\u7684\u51bb\u7ed3\u72b6\u6001\u3002\u8bf7\u524d\u5f80\u6d41\u7a0b\u670d\u52a1\u4e91>\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3>\u76d1\u63a7\u4e2d\u5fc3>\u4e8b\u4ef6\u65e5\u5fd7\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u6216\u68c0\u67e5\u6d41\u7a0b\u670d\u52a1\u4e91>\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3>\u4e8b\u4ef6\u8ba2\u9605\u201c\u91c7\u8d2d\u5355\u636e\u9884\u4ed8\u91d1\u989d\u53d8\u66f4\u4e8b\u4ef6\u201d\u662f\u5426\u5df2\u542f\u7528\u3002", (String)"FinApToPayTransitPrePayCtrlPlugin_2", (String)"fi-arapcommon", (Object[])new Object[]{billNo, coreBillName, coreBillNo}));
            }
            if (!"sctm_scpo".equals(coreBillType)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355%2$s\u53d8\u66f4\u7684\u9884\u4ed8\u6b3e\u4fe1\u606f\u672a\u80fd\u5c06\u8d22\u52a1\u5e94\u4ed8\u5355\u540c\u6b65\u81f3\u6700\u65b0\u7684\u51bb\u7ed3\u72b6\u6001\u3002\u8bf7\u524d\u5f80\u6d41\u7a0b\u670d\u52a1\u4e91>\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3>\u76d1\u63a7\u4e2d\u5fc3>\u4e8b\u4ef6\u65e5\u5fd7\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u6216\u68c0\u67e5\u6d41\u7a0b\u670d\u52a1\u4e91>\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3>\u4e8b\u4ef6\u8ba2\u9605\u201c\u91c7\u8d2d\u5355\u636e\u9884\u4ed8\u91d1\u989d\u53d8\u66f4\u4e8b\u4ef6\u201d\u662f\u5426\u5df2\u542f\u7528\u3002", (String)"FinApToPayTransitPrePayCtrlPlugin_4", (String)"fi-arapcommon", (Object[])new Object[]{billNo, coreBillNo}));
        }
    }

    private Map<Long, String> getCoreBillMatchKey(List<Long> purOrderBillIds, List<Long> conBillIds, List<Long> stcmBillIds) {
        Long masterId;
        Long billId;
        DynamicObjectCollection hadPrePurBills;
        HashMap<Long, String> coreBillMapKey = new HashMap<Long, String>(16);
        if (purOrderBillIds.size() > 0) {
            hadPrePurBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,invoicesupplier.masterid,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", purOrderBillIds)}, null);
            for (DynamicObject row : hadPrePurBills) {
                billId = row.getLong("id");
                masterId = row.getLong("invoicesupplier.masterid");
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        if (conBillIds.size() > 0) {
            DynamicObjectCollection hadPreConBills = QueryServiceHelper.query((String)"conm_purcontract", (String)"id,invoicesupplier.masterid,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", conBillIds)}, null);
            for (DynamicObject row : hadPreConBills) {
                billId = row.getLong("id");
                masterId = row.getLong("invoicesupplier.masterid");
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        if (stcmBillIds.size() > 0) {
            hadPrePurBills = QueryServiceHelper.query((String)"sctm_scpo", (String)"id,invoicesupplier.masterid,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", stcmBillIds)}, null);
            for (DynamicObject row : hadPrePurBills) {
                billId = row.getLong("id");
                masterId = row.getLong("invoicesupplier.masterid");
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        return coreBillMapKey;
    }

    private Map<Long, BigDecimal> loadPayedPreBillAmt(List<Long> coreBillIds) {
        HashMap<Long, BigDecimal> coreBillSumPrePayMap = new HashMap<Long, BigDecimal>(16);
        QFilter payBillFilter = new QFilter("entry.e_corebillid", "in", coreBillIds);
        payBillFilter.and("billstatus", "in", (Object)new String[]{"D", "F", "I"});
        DynamicObjectCollection prePayBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,entry.e_corebillid,entry.e_payableamt,entry.e_refundamt", (QFilter[])new QFilter[]{payBillFilter}, null);
        for (DynamicObject row : prePayBills) {
            Long coreBillId = row.getLong("entry.e_corebillid");
            BigDecimal currentPayAmt = row.getBigDecimal("entry.e_payableamt").subtract(row.getBigDecimal("entry.e_refundamt"));
            BigDecimal coreBillSumPrePayAmt = (BigDecimal)coreBillSumPrePayMap.get(coreBillId);
            if (coreBillSumPrePayAmt != null) {
                coreBillSumPrePayMap.put(coreBillId, coreBillSumPrePayAmt.add(currentPayAmt));
                continue;
            }
            coreBillSumPrePayMap.put(coreBillId, currentPayAmt);
        }
        return coreBillSumPrePayMap;
    }
}

