/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ApPlanSplitAndBuilder;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ArPlanSplitAndBuilder;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ConditionServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanSplitSchemeServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.helper.BOTPHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class FinArApAmtCalculateConvertPlugin
extends AbstractConvertPlugIn {
    private DynamicObject[] needMatchSplitSchemes;
    private final Map<Long, List<DynamicObject>> detailEntriesCache = new HashMap<Long, List<DynamicObject>>(1);

    public void afterConvert(AfterConvertEventArgs e) {
        String targetBillName = this.getTgtMainType().getExtendName();
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey(targetBillName);
        Map asstactMap = new HashMap(8);
        this.needMatchSplitSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes((String)targetBillName);
        if (entities != null && entities.length > 0) {
            Set asstactIdSet = Arrays.stream(entities).map(t -> t.getDataEntity().getLong("asstact.id")).collect(Collectors.toSet());
            if ("ap_finapbill".equals(targetBillName)) {
                asstactMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"deliversupplierid,invoicesupplierid,receivingsupplierid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIdSet)});
            } else if ("ar_finarbill".equals(targetBillName)) {
                asstactMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"delivercustomerid,invoicecustomerid,paymentcustomerid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIdSet)});
            }
            for (ExtendedDataEntity entity : entities) {
                DynamicObjectCollection entries;
                DynamicObject targetBill = entity.getDataEntity();
                Object asstactId = targetBill.get("asstact.id");
                DynamicObject asstact = null;
                if (asstactMap != null) {
                    asstact = (DynamicObject)asstactMap.get(asstactId);
                }
                if ("ap_finapbill".equals(targetBillName)) {
                    Date termsDate;
                    if (asstact != null) {
                        DynamicObject recSupplierId = asstact.getDynamicObject("receivingsupplierid");
                        targetBill.set("receivingsupplierid", (Object)recSupplierId);
                        entries = targetBill.getDynamicObjectCollection("detailentry");
                        for (DynamicObject entry : entries) {
                            DynamicObject invSupplierid = asstact.getDynamicObject("invoicesupplierid");
                            DynamicObject delSupplierid = asstact.getDynamicObject("deliversupplierid");
                            entry.set("e_invoicesupplierid", (Object)invSupplierid);
                            entry.set("e_deliversupplierid", (Object)delSupplierid);
                        }
                    }
                    if ((termsDate = targetBill.getDate("termsdate")) == null) {
                        Date basicDate = ConditionServiceHelper.getBasicDate((DynamicObject)targetBill);
                        targetBill.set("termsdate", (Object)basicDate);
                    }
                    this.cacheDetailEntry(targetBill, false);
                    this.setHeadAmtValueForAp(targetBill);
                    this.setPlanEntryValue(targetBill, false);
                    continue;
                }
                if (!"ar_finarbill".equals(targetBillName)) continue;
                if (asstact != null) {
                    DynamicObject payCusId = asstact.getDynamicObject("paymentcustomerid");
                    targetBill.set("paymentcustomerid", (Object)payCusId);
                    entries = targetBill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entries) {
                        DynamicObject invCusId = asstact.getDynamicObject("invoicecustomerid");
                        DynamicObject delCusId = asstact.getDynamicObject("delivercustomerid");
                        entry.set("e_invoicecustomerid", (Object)invCusId);
                        entry.set("e_delivercustomerid", (Object)delCusId);
                    }
                }
                this.cacheDetailEntry(targetBill, true);
                this.setHeadAmtValueForAr(targetBill);
                this.setPlanEntryValue(targetBill, true);
            }
        }
    }

    private void cacheDetailEntry(DynamicObject finBill, boolean isAr) {
        if (this.isPushAndSave(finBill)) {
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finBill.getLong("id"));
            if (detailEntries == null) {
                ArrayList finDetailEntries = new ArrayList(8);
                finDetailEntries.addAll(finBill.getDynamicObjectCollection(isAr ? "entry" : "detailentry"));
                this.detailEntriesCache.put(finBill.getLong("id"), finDetailEntries);
            } else {
                detailEntries.addAll((Collection<DynamicObject>)finBill.getDynamicObjectCollection(isAr ? "entry" : "detailentry"));
            }
        }
    }

    private void setPlanEntryValue(DynamicObject finBill, boolean isAr) {
        DynamicObject matchSplitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme((DynamicObject)finBill, (DynamicObject[])this.needMatchSplitSchemes);
        finBill.set("splitscheme", (Object)matchSplitScheme);
        if (this.isPushAndSave(finBill)) {
            this.calculatePlanEntryByPushAndSave(finBill, matchSplitScheme, isAr);
        } else if (isAr) {
            ArPlanSplitAndBuilder.splitAndBuild((DynamicObject)finBill, (DynamicObject)matchSplitScheme);
        } else {
            ApPlanSplitAndBuilder.splitAndBuild((DynamicObject)finBill, (DynamicObject)matchSplitScheme);
        }
        this.setHeadDueDate(finBill);
    }

    private void setHeadDueDate(DynamicObject finBill) {
        Date planMaxDuedate = finBill.getDate("duedate");
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finBill.set("duedate", (Object)planMaxDuedate);
    }

    private void calculatePlanEntryByPushAndSave(DynamicObject finBill, DynamicObject matchSplitScheme, boolean isAr) {
        DynamicObject[] dbFinBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"e_splitdimensionid,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finBill.getLong("id"))});
        if (dbFinBills == null || dbFinBills.length == 0) {
            if (isAr) {
                ArPlanSplitAndBuilder.splitAndBuild((DynamicObject)finBill, (DynamicObject)matchSplitScheme);
            } else {
                ApPlanSplitAndBuilder.splitAndBuild((DynamicObject)finBill, (DynamicObject)matchSplitScheme);
            }
        } else {
            DynamicObject dbFiBill = dbFinBills[0];
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finBill.getLong("id"));
            Map detailEntryIndexToSplitDimensionId = isAr ? ArPlanSplitAndBuilder.splitAndBuildByPushAndSave((DynamicObject)finBill, detailEntries, (DynamicObject)matchSplitScheme) : ApPlanSplitAndBuilder.splitAndBuildByPushAndSave((DynamicObject)finBill, detailEntries, (DynamicObject)matchSplitScheme);
            DynamicObjectCollection dbDetailEntries = dbFiBill.getDynamicObjectCollection(isAr ? "entry" : "detailentry");
            DynamicObjectCollection curDetailEntries = finBill.getDynamicObjectCollection(isAr ? "entry" : "detailentry");
            int dbDetailEntrySize = dbDetailEntries.size();
            for (int i = 0; i < dbDetailEntrySize; ++i) {
                DynamicObject dbDetailEntry = (DynamicObject)dbDetailEntries.get(i);
                dbDetailEntry.set("e_splitdimensionid", detailEntryIndexToSplitDimensionId.get(i));
            }
            int curDetailEntrySize = curDetailEntries.size();
            for (int i = 0; i < curDetailEntrySize; ++i) {
                DynamicObject curDetailEntry = (DynamicObject)curDetailEntries.get(i);
                curDetailEntry.set("e_splitdimensionid", detailEntryIndexToSplitDimensionId.get(i + dbDetailEntrySize));
            }
            DynamicObjectCollection dbPlanEntries = dbFiBill.getDynamicObjectCollection("planentity");
            dbPlanEntries.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbFiBill});
        }
    }

    private void setHeadAmtValueForAp(DynamicObject finApBill) {
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        Object detailEntries = this.isPushAndSave(finApBill) ? this.detailEntriesCache.get(finApBill.getLong("id")) : finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotal = priceTaxTotal.add(detailEntry.getBigDecimal("e_pricetaxtotal"));
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_pricetaxtotalbase"));
            amount = amount.add(detailEntry.getBigDecimal("e_amount"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_amountbase"));
            tax = tax.add(detailEntry.getBigDecimal("e_tax"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamt = adjustamt.add(detailEntry.getBigDecimal("e_adjustamount"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
        }
        finApBill.set("pricetaxtotal", (Object)priceTaxTotal);
        finApBill.set("pricetaxtotalbase", (Object)priceTaxTotalBase);
        finApBill.set("amount", (Object)amount);
        finApBill.set("amountbase", (Object)amountBase);
        finApBill.set("tax", (Object)tax);
        finApBill.set("taxlocamt", (Object)taxLocAmt);
        finApBill.set("uninvoicedamt", (Object)priceTaxTotal);
        finApBill.set("unverifyamount", (Object)amount);
        finApBill.set("unsettleamount", (Object)priceTaxTotal);
        finApBill.set("unsettleamountbase", (Object)priceTaxTotalBase);
        finApBill.set("adjustamount", (Object)adjustamt);
        finApBill.set("adjustlocalamt", (Object)adjustamtlocal);
    }

    private void setHeadAmtValueForAr(DynamicObject finArBill) {
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        Object detailEntries = this.isPushAndSave(finArBill) ? this.detailEntriesCache.get(finArBill.getLong("id")) : finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotal = priceTaxTotal.add(detailEntry.getBigDecimal("e_recamount"));
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_reclocalamt"));
            amount = amount.add(detailEntry.getBigDecimal("e_amount"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_localamt"));
            tax = tax.add(detailEntry.getBigDecimal("e_tax"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamt = adjustamt.add(detailEntry.getBigDecimal("e_adjustamount"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
        }
        finArBill.set("recamount", (Object)priceTaxTotal);
        finArBill.set("reclocalamt", (Object)priceTaxTotalBase);
        finArBill.set("amount", (Object)amount);
        finArBill.set("localamt", (Object)amountBase);
        finArBill.set("tax", (Object)tax);
        finArBill.set("taxlocamt", (Object)taxLocAmt);
        finArBill.set("unverifyamount", (Object)amount);
        finArBill.set("unsettleamount", (Object)priceTaxTotal);
        finArBill.set("unsettlelocalamt", (Object)priceTaxTotalBase);
        finArBill.set("adjustamount", (Object)adjustamt);
        finArBill.set("adjustlocalamt", (Object)adjustamtlocal);
        finArBill.set("uninvoicedamt", (Object)priceTaxTotal);
        finArBill.set("uninvoicedlocalamt", (Object)priceTaxTotalBase);
    }

    private boolean isPushAndSave(DynamicObject finBill) {
        return BOTPHelper.isPushAndSave((ConvertRuleElement)this.getRule(), (DynamicObject)finBill);
    }
}

