/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.plugin.ArApConvert.InitServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.business.price.FXPriceLocalCalculator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.util.StringUtils;

public class FinArLocAmtConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(FinArLocAmtConvertPlugin.class);
    private Map<Long, DynamicObject> orgInitMap;
    private final QueryUtil queryUtil = new QueryUtil();
    private final Map<Long, DynamicObject> srcFinArContainsPremiumMap = new HashMap<Long, DynamicObject>(1);

    public void initVariable(InitVariableEventArgs e) {
        boolean autoSave = this.getRule().isAutoSave();
        String ruleId = this.getRule().getId();
        if (autoSave && "516550166468103168".equals(ruleId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\u7684\u8f6c\u6362\u89c4\u5219\u4e0d\u5141\u8bb8\u6253\u5f00\u201c\u4e0b\u63a8\u81ea\u52a8\u4fdd\u5b58\u201d\u6309\u94ae\u3002\u5982\u679c\u6e90\u5355\u7269\u6599\u884c\u5206\u5f55\u7684\u5927\u5c0f\u8d85\u8fc7\u5e73\u53f0\u9650\u5236\u768420000\u884c\u5206\u5f55,\u8bf7\u53c2\u8003\u793e\u533a\u6587\u6863\u91c7\u7528\u540e\u53f0\u51b2\u9500\u7684\u65b9\u5f0f\u5904\u7406:https://vip.kingdee.com/knowledge/specialDetail/223800781941044992?category=433217318319929600&id=464213782940848384&productLineId=2", (String)"FinArSaveOp_5", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        logger.info("FinArLocAmtConvertPlugin.afterConvert start");
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendEntites = entitySet.FindByEntityKey(this.getTgtMainType().getExtendName());
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendEntites.length);
        for (ExtendedDataEntity extendEntity : extendEntites) {
            entities.add(extendEntity.getDataEntity());
        }
        this.prepareData(entities);
        for (DynamicObject finArBill : entities) {
            DynamicObject org = finArBill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            InitServiceHelper.checkOrgInit((DynamicObject)org, this.orgInitMap, (boolean)true);
            this.setHeadValue(finArBill);
            this.setDetailEntryValue(finArBill);
            this.setProjectAndContactForPremium(finArBill);
        }
        for (DynamicObject finArBill : entities) {
            this.setHeadAmtValue(finArBill);
            this.setPlanEntryValue(finArBill);
        }
        BookDateHelper.setBookDate(entities.toArray(new DynamicObject[0]), true);
        logger.info("FinArLocAmtConvertPlugin.afterConvert end");
    }

    private void prepareData(List<DynamicObject> entities) {
        logger.info("FinArLocAmtConvertPlugin.prepareData start");
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashSet<Long> srcFinArContainPremiumBillIds = new HashSet<Long>(1);
        for (DynamicObject entity : entities) {
            long orgId = entity.getLong("org.id");
            if (orgId != 0L) {
                orgIds.add(orgId);
            }
            if (!entity.getBoolean("ispremium")) continue;
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                srcFinArContainPremiumBillIds.add(entry.getLong("e_srcid"));
            }
        }
        this.orgInitMap = InitServiceHelper.loadInitInfos(orgIds, (boolean)true);
        if (srcFinArContainPremiumBillIds.size() > 0) {
            DynamicObject[] srcFinArBills;
            for (DynamicObject finArBill : srcFinArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,entry.e_conbillentity,entry.e_conbillnumber,entry.e_conbillrownum,entry.e_conbillid,entry.e_conbillentryid,entry.e_contract,entry.project", (QFilter[])new QFilter[]{new QFilter("id", "in", srcFinArContainPremiumBillIds), new QFilter("entry.seq", "in", Arrays.asList(0, 1))})) {
                this.srcFinArContainsPremiumMap.putIfAbsent(finArBill.getLong("id"), (DynamicObject)finArBill.getDynamicObjectCollection("entry").get(0));
            }
        }
        logger.info("FinArLocAmtConvertPlugin.prepareData end");
    }

    private void setHeadValue(DynamicObject finArBill) {
        DynamicObject org = finArBill.getDynamicObject("org");
        InitServiceHelper.setBizDate((DynamicObject)finArBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (ConvertRuleElement)this.getRule());
        boolean isSettingForExchange = BOTPHelper.ruleIsSetting(this.getRule(), true, "exchangerate");
        InitServiceHelper.setInitValue((DynamicObject)finArBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (boolean)isSettingForExchange);
        String imageno = finArBill.getString("imageno");
        if (StringUtils.isNotEmpty(imageno) && imageno.length() > 50) {
            finArBill.set("imageno", (Object)imageno.substring(0, 50));
        }
    }

    private void setDetailEntryValue(DynamicObject finArBill) {
        int basePrecision = finArBill.getInt("basecurrency.amtprecision");
        boolean includeTax = finArBill.getBoolean("isincludetax");
        String sourceBillType = finArBill.getString("sourcebilltype");
        String quotation = finArBill.getString("quotation");
        BigDecimal exchangeRate = finArBill.getBigDecimal("exchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0 && "1".equals(quotation)) {
            quotation = "0";
        }
        boolean isWrittenOff = finArBill.getBoolean("iswrittenoff");
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal quantity;
            BigDecimal e_tax = detailEntry.getBigDecimal("e_tax");
            BigDecimal e_amount = detailEntry.getBigDecimal("e_amount");
            BigDecimal discountamount = detailEntry.getBigDecimal("e_discountamount");
            BigDecimal eAdjustamount = detailEntry.getBigDecimal("e_adjustamount");
            FXPriceLocalCalculator calculator = new FXPriceLocalCalculator(includeTax, e_tax, e_amount, discountamount, exchangeRate, basePrecision, eAdjustamount, quotation);
            calculator.calculate();
            BigDecimal e_amountbase = calculator.getAmountLocal();
            BigDecimal e_taxlocamt = calculator.getTaxLocal();
            BigDecimal e_pricetaxtotalbase = calculator.getPriceTaxTotalLocal();
            BigDecimal discountamountLocal = calculator.getDiscountamountLocal();
            BigDecimal e_adjustlocalamt = calculator.getAdjustamtlocal();
            if (!isWrittenOff) {
                detailEntry.set("e_discountlocalamt", (Object)discountamountLocal);
                detailEntry.set("e_localamt", (Object)e_amountbase);
                detailEntry.set("e_taxlocalamt", (Object)e_taxlocamt);
                detailEntry.set("e_reclocalamt", (Object)e_pricetaxtotalbase);
                detailEntry.set("e_unsettlelocalamt", (Object)e_pricetaxtotalbase);
                detailEntry.set("e_adjustlocalamt", (Object)e_adjustlocalamt);
                if ("ar_invoice".equals(sourceBillType)) {
                    detailEntry.set("e_uninvoicedlocalamt", (Object)BigDecimal.ZERO);
                } else {
                    detailEntry.set("e_uninvoicedlocalamt", (Object)e_pricetaxtotalbase);
                }
            }
            if ((quantity = detailEntry.getBigDecimal("e_quantity")) == null) {
                quantity = BigDecimal.ZERO;
            }
            BigDecimal covertRate = detailEntry.getBigDecimal("e_unitcoefficient");
            DynamicObject material = detailEntry.getDynamicObject("e_material");
            DynamicObject measureUnit = detailEntry.getDynamicObject("e_measureunit");
            DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    detailEntry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                    covertRate = this.queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                }
            } else if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                covertRate = BigDecimal.ONE;
            }
            if (EmptyUtils.isEmpty(detailEntry.getBigDecimal("e_unitcoefficient"))) {
                detailEntry.set("e_unitcoefficient", (Object)covertRate);
            }
            if (EmptyUtils.isEmpty(detailEntry.getBigDecimal("e_baseunitqty"))) {
                detailEntry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
            }
            if (!EmptyUtils.isEmpty(detailEntry.getBigDecimal("e_unverifybaseqty"))) continue;
            detailEntry.set("e_unverifybaseqty", (Object)UnitConvertHelper.getBaseunitqty(detailEntry.getBigDecimal("e_unverifyqty"), covertRate, baseUnit));
        }
    }

    private void setHeadAmtValue(DynamicObject finArBill) {
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        BigDecimal unInvoicedLocalAmt = BigDecimal.ZERO;
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_reclocalamt"));
            unInvoicedLocalAmt = unInvoicedLocalAmt.add(detailEntry.getBigDecimal("e_uninvoicedlocalamt"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_localamt"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
        }
        finArBill.set("reclocalamt", (Object)priceTaxTotalBase);
        finArBill.set("localamt", (Object)amountBase);
        finArBill.set("taxlocamt", (Object)taxLocAmt);
        finArBill.set("unsettlelocalamt", (Object)priceTaxTotalBase);
        finArBill.set("adjustlocalamt", (Object)adjustamtlocal);
        finArBill.set("uninvoicedlocalamt", (Object)unInvoicedLocalAmt);
    }

    private void setPlanEntryValue(DynamicObject finArBill) {
        boolean isWrittenOff = finArBill.getBoolean("iswrittenoff");
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        if (planEntries.size() < 1) {
            return;
        }
        BigDecimal exchangeRate = finArBill.getBigDecimal("exchangerate");
        String quotation = finArBill.getString("quotation");
        DynamicObject bascur = finArBill.getDynamicObject("basecurrency");
        int baseprecision = bascur.getInt("amtprecision");
        BigDecimal reclocalamt = finArBill.getBigDecimal("reclocalamt");
        int count = 0;
        BigDecimal planSumAmtLoc = BigDecimal.ZERO;
        for (DynamicObject plan : planEntries) {
            BigDecimal planAmt = plan.getBigDecimal("planpricetax");
            BigDecimal planAmtLoc = quotation.equals("0") ? planAmt.multiply(exchangeRate).setScale(baseprecision, RoundingMode.HALF_UP) : planAmt.divide(exchangeRate, baseprecision, RoundingMode.HALF_UP);
            if (++count == planEntries.size()) {
                planAmtLoc = reclocalamt.subtract(planSumAmtLoc);
            } else {
                planSumAmtLoc = planSumAmtLoc.add(planAmtLoc);
            }
            if (isWrittenOff) continue;
            plan.set("planpricetax", (Object)planAmt);
            plan.set("planpricetaxloc", (Object)planAmtLoc);
            plan.set("unplansettleamt", (Object)planAmt);
            plan.set("unplansettlelocamt", (Object)planAmtLoc);
            plan.set("unplanlockamt", (Object)planAmt);
        }
        this.setHeadDueDate(finArBill);
    }

    private void setHeadDueDate(DynamicObject finArBill) {
        Date planMaxDuedate = finArBill.getDate("duedate");
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finArBill.set("duedate", (Object)planMaxDuedate);
    }

    private void setProjectAndContactForPremium(DynamicObject finArBill) {
        if (!finArBill.getBoolean("ispremium")) {
            return;
        }
        DynamicObjectCollection entries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            DynamicObject srcFinArRow;
            long sourcebillid = entry.getLong("e_srcid");
            if (sourcebillid == 0L || (srcFinArRow = this.srcFinArContainsPremiumMap.get(sourcebillid)) == null) continue;
            if (ObjectUtils.isEmpty((Object)entry.get("project"))) {
                entry.set("project", srcFinArRow.get("project"));
            }
            if (ObjectUtils.isEmpty((Object)entry.get("e_contract"))) {
                entry.set("e_contract", srcFinArRow.get("e_contract"));
            }
            if (ObjectUtils.isEmpty((Object)entry.get("e_conbillentity"))) {
                entry.set("e_conbillentity", srcFinArRow.get("e_conbillentity"));
            }
            if (ObjectUtils.isEmpty((Object)entry.get("e_conbillnumber"))) {
                entry.set("e_conbillnumber", srcFinArRow.get("e_conbillnumber"));
            }
            if (!EmptyUtils.isEmpty(entry.get("e_conbillid"))) continue;
            entry.set("e_conbillid", srcFinArRow.get("e_conbillid"));
        }
    }
}

