/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.util.StringUtils;

public class FinBillToCasPayBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey("cas_paybill");
        HashSet<Long> finApBillIds = new HashSet<Long>(16);
        HashSet<Long> coreBillIds = new HashSet<Long>(16);
        HashMap<Long, String> coreBillTypes = new HashMap<Long, String>(16);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                long sourceBillId;
                long coreBillId = row.getLong("e_corebillid");
                if (coreBillId == 0L || (sourceBillId = row.getLong("e_sourcebillid")) == 0L) continue;
                coreBillIds.add(coreBillId);
                finApBillIds.add(sourceBillId);
            }
        }
        DataSet apBills = QueryServiceHelper.queryDataSet((String)"FinBillToCasPay", (String)"ap_finapbill", (String)"id,detailentry.corebilltype,detailentry.corebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds), new QFilter("detailentry.corebillid", "in", coreBillIds)}, null);
        for (Row row : apBills) {
            String coreBillType = row.getString("detailentry.corebilltype");
            if (StringUtils.isEmpty(coreBillType)) continue;
            coreBillTypes.put(row.getLong("detailentry.corebillid"), coreBillType);
        }
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String coreBillType;
                long coreBillId = row.getLong("e_corebillid");
                if (coreBillId == 0L || (coreBillType = (String)coreBillTypes.get(coreBillId)) == null) continue;
                row.set("e_corebilltype", (Object)coreBillType);
            }
        }
    }
}

