/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldMapPolicy;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.QuotationHelper;

public class InitConvertHelper {
    private DynamicObject init = null;
    private final QuotationHelper quotationHelper = new QuotationHelper();

    public InitConvertHelper(String initEntity, ConvertRuleElement rule, Map<Long, List<DynamicObject>> targetBillByOrgId) {
        DynamicObject[] inits;
        if (targetBillByOrgId.isEmpty()) {
            return;
        }
        HashMap<Long, DynamicObject> initmap = new HashMap<Long, DynamicObject>(2);
        QFilter qFilter = new QFilter("org", "in", targetBillByOrgId.keySet());
        if ("ar_init".equals(initEntity)) {
            inits = BusinessDataServiceHelper.load((String)initEntity, (String)(this.getSelectors() + ", policytype.type"), (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject initInfo : inits) {
                Long orgId = initInfo.getLong("org.id");
                String policytype = initInfo.getString("policytype.type");
                if ("master".equals(policytype)) {
                    initmap.put(orgId, initInfo);
                    continue;
                }
                initmap.putIfAbsent(orgId, initInfo);
            }
        } else {
            inits = BusinessDataServiceHelper.load((String)initEntity, (String)this.getSelectors(), (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject initInfo : inits) {
                initmap.put(initInfo.getLong("org.id"), initInfo);
            }
        }
        boolean ruleIsSettingRate = BOTPHelper.ruleIsSetting(rule, true, "exchangerate");
        for (Map.Entry entry : targetBillByOrgId.entrySet()) {
            Long orgId = (Long)entry.getKey();
            this.init = (DynamicObject)initmap.get(orgId);
            if (ObjectUtils.isEmpty((Object)this.getStartDate())) {
                ErrorCode ConvertOrgNotInit = new ErrorCode("ConvertOrgNotInit", ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\u3002", (String)"InitConvertHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                String orgName = "";
                List targetBillList = (List)entry.getValue();
                if (!ObjectUtils.isEmpty((Object)targetBillList)) {
                    DynamicObject org = ((DynamicObject)targetBillList.get(0)).getDynamicObject("org");
                    orgName = org.getLocaleString("name").getLocaleValue();
                }
                throw new KDBizException(ConvertOrgNotInit, new Object[]{orgName});
            }
            for (DynamicObject targetBill : (List)entry.getValue()) {
                this.setExchangeRateInfo(targetBill, ruleIsSettingRate);
            }
        }
    }

    private void setExchangeRateInfo(DynamicObject targetBill, boolean botpSetRate) {
        long srcCurrencyId = targetBill.getLong("currency.id");
        DynamicObject basecurrency = this.getStandardCurrency();
        if (ObjectUtils.isEmpty((Object)srcCurrencyId) || basecurrency == null) {
            ErrorCode ConvertCurrencyIsNull = new ErrorCode("ConvertCurrencyIsNull", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u6216\u672c\u4f4d\u5e01\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InitConvertHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            throw new KDBizException(ConvertCurrencyIsNull, new Object[0]);
        }
        targetBill.set("basecurrency", (Object)basecurrency);
        if (ObjectUtils.isEmpty((Object)targetBill.get("exratetable"))) {
            targetBill.set("exratetable", (Object)this.getExrateTable());
        }
        if (ObjectUtils.isEmpty((Object)targetBill.get("exratedate"))) {
            targetBill.set("exratedate", (Object)new Date());
        }
        String quotation = targetBill.getString("quotation");
        BigDecimal exchangerate = targetBill.getBigDecimal("exchangerate");
        if (!botpSetRate || ObjectUtils.isEmpty((Object)exchangerate) || BigDecimal.ZERO.compareTo(exchangerate) == 0 || ObjectUtils.isEmpty((Object)quotation) || quotation.equals("0")) {
            long destCurrencyId = basecurrency.getLong("id");
            if (srcCurrencyId == destCurrencyId) {
                targetBill.set("quotation", (Object)"0");
                targetBill.set("exchangerate", (Object)BigDecimal.valueOf(1L));
            } else {
                Tuple<String, BigDecimal> tuple = this.quotationHelper.getExchangeRateMap(targetBill.getLong("exratetable.id"), srcCurrencyId, destCurrencyId, targetBill.getDate("exratedate"));
                if (ObjectUtils.isEmpty((Object)quotation) || quotation.equals("0")) {
                    targetBill.set("quotation", tuple.item1);
                }
                if (!botpSetRate || ObjectUtils.isEmpty((Object)exchangerate) || BigDecimal.ZERO.compareTo(exchangerate) == 0) {
                    targetBill.set("exchangerate", tuple.item2);
                }
            }
        }
    }

    public InitConvertHelper(DynamicObject org, String entity, DynamicObject tarabebtObject, String srcMainTypeName) {
        QFilter qFilter = new QFilter("org", "=", org.getPkValue());
        if ("ar_init".equals(entity)) {
            Object[] inits = BusinessDataServiceHelper.load((String)entity, (String)(this.getSelectors() + ", policytype.type"), (QFilter[])new QFilter[]{qFilter});
            if (!ObjectUtils.isEmpty((Object[])inits)) {
                if (inits.length == 1) {
                    this.init = inits[0];
                } else {
                    for (Object obj : inits) {
                        DynamicObject policytype = obj.getDynamicObject("policytype");
                        if (policytype == null || !"master".equals(policytype.getString("type"))) continue;
                        this.init = obj;
                    }
                    if (this.init == null) {
                        this.init = inits[0];
                    }
                }
            }
        } else {
            this.init = BusinessDataServiceHelper.loadSingle((String)entity, (String)this.getSelectors(), (QFilter[])new QFilter[]{qFilter});
        }
        if (ObjectUtils.isEmpty((Object)this.getStartDate())) {
            ErrorCode ConvertOrgNotInit = new ErrorCode("ConvertOrgNotInit", ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\u3002", (String)"InitConvertHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            throw new KDBizException(ConvertOrgNotInit, new Object[]{org.getLocaleString("name").getLocaleValue()});
        }
        this.setExchangeRateInfo(tarabebtObject, true);
    }

    @Deprecated
    public static BigDecimal getExchangeRate(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        return InitConvertHelper.getConvertExchangeRate(exratetableId, srcCurrencyId, destCurrencyId, exrateDate);
    }

    public static BigDecimal getConvertExchangeRate(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        Object rate;
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (exrateDate == null) {
            exrateDate = new Date();
        }
        if (srcCurrencyId == null || srcCurrencyId == 0L || destCurrencyId == null || destCurrencyId == 0L || srcCurrencyId.compareTo(destCurrencyId) == 0) {
            return exchangeRate;
        }
        Map<String, Object> exrateMap = BaseDataHelper.getExchangeRateMap(exratetableId, srcCurrencyId, destCurrencyId, exrateDate);
        if (exrateMap != null && (rate = exrateMap.get("exchangeRate")) != null) {
            exchangeRate = (BigDecimal)rate;
        }
        return exchangeRate;
    }

    private String getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("org");
        selectors.add("standardcurrency");
        selectors.add("exratetable");
        selectors.add("isfinishinit");
        selectors.add("startdate");
        return String.join((CharSequence)",", selectors);
    }

    public final Date getStartDate() {
        if (this.init == null) {
            return null;
        }
        Date startDate = this.init.getDate("startdate");
        return startDate == null ? null : InitConvertHelper.getDataFormat(startDate, true);
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public final DynamicObject getStandardCurrency() {
        if (this.init == null) {
            return null;
        }
        return this.init.getDynamicObject("standardcurrency");
    }

    public final DynamicObject getExrateTable() {
        if (this.init == null) {
            return null;
        }
        return this.init.getDynamicObject("exratetable");
    }

    public final boolean isFinishInit() {
        if (this.init == null) {
            return false;
        }
        return this.init.getBoolean("isfinishinit");
    }

    public final boolean isFinishSetting() {
        return this.init.getDate("startdate") != null;
    }

    public static void checkExRate(ConvertRuleElement cre, DynamicObject targetObj) {
        BigDecimal targetExRate = (BigDecimal)targetObj.get("exchangerate");
        if (!ObjectUtils.isEmpty((Object)targetExRate) && BigDecimal.ONE.compareTo(targetExRate) == 0) {
            FieldMapPolicy fmp = cre.getFieldMapPolicy();
            List fmis = fmp.getFieldMaps();
            for (FieldMapItem fmi : fmis) {
                String sourceFieldKey;
                if (!"exchangerate".equals(fmi.getTargetFieldKey()) || !StringUtils.isEmpty((CharSequence)(sourceFieldKey = fmi.getSourceFieldKey()))) continue;
                targetObj.set("exchangerate", (Object)BigDecimal.ZERO);
            }
        }
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = BigDecimal.ONE;
        if (srcUnitId.equals(desUnitId)) {
            return unitRate;
        }
        DynamicObject muConv1 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        if (!ObjectUtils.isEmpty((Object)muConv1) && muConv1.getInt("numerator") != 0) {
            unitRate = muConv1.getBigDecimal("numerator").divide(muConv1.getBigDecimal("denominator"), 10, RoundingMode.HALF_UP);
        } else {
            DynamicObject muConv2 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)desUnitId, (Long)srcUnitId);
            if (!ObjectUtils.isEmpty((Object)muConv2) && muConv2.getInt("numerator") != 0) {
                unitRate = muConv2.getBigDecimal("denominator").divide(muConv2.getBigDecimal("numerator"), 10, RoundingMode.HALF_UP);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ONE;
        }
        return unitRate;
    }

    public static BigDecimal getBaseunitqty(BigDecimal quantity, BigDecimal covertRate, DynamicObject baseUnit) {
        if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
            covertRate = BigDecimal.ONE;
        }
        int precisionaccount = 4;
        int precision = 10;
        if (baseUnit == null) {
            BigDecimal baseunitqty = quantity.multiply(covertRate).setScale(precision, precisionaccount);
            return baseunitqty;
        }
        precisionaccount = baseUnit.getInt("precisionaccount");
        precision = baseUnit.getInt("precision");
        BigDecimal baseunitqty = precisionaccount == 2 ? quantity.multiply(covertRate).setScale(precision, 1) : (precisionaccount == 3 ? quantity.multiply(covertRate).setScale(precision, 0) : quantity.multiply(covertRate).setScale(precision, 4));
        return baseunitqty;
    }
}

