/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class RevCfmBillChargeAgainstConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log LOGGER = LogFactory.getLog(RevCfmBillChargeAgainstConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey("ar_revcfmbill");
        Set<Long> sourceRevCfmBillIds = this.listSourceRevCfmBillIds(extendedDataEntities);
        Map<Long, String> sourceRevCfmBillIdToBillNoMap = this.getSourceRevCfmBillIdToBillNoMap(sourceRevCfmBillIds);
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            long sourceBillId;
            String billNo;
            entities.add(extendedDataEntity.getDataEntity());
            DynamicObject entity = extendedDataEntity.getDataEntity();
            String sourceBillType = entity.getString("sourcebilltype");
            if (!"ar_revcfmbill".equals(sourceBillType) || EmptyUtils.isEmpty(billNo = sourceRevCfmBillIdToBillNoMap.getOrDefault(sourceBillId = entity.getLong("sourcebillid"), ""))) continue;
            entity.set("billno", (Object)billNo);
        }
        BookDateHelper.setBookDate(entities.toArray(new DynamicObject[0]), true);
        this.setBillSrcType(entities);
    }

    private Map<Long, String> getSourceRevCfmBillIdToBillNoMap(Set<Long> sourceRevCfmBillIds) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        if (EmptyUtils.isEmpty(sourceRevCfmBillIds)) {
            return result;
        }
        Map<Long, Set<Long>> revCfmBillToSourceFinBillIdMap = BOTPHelper.findDirectSourceBillMap("ar_revcfmbill", "ar_finarbill", sourceRevCfmBillIds);
        LOGGER.info("revCfmBillToSourceFinBillIdMap :" + revCfmBillToSourceFinBillIdMap);
        HashSet allFinBillIds = new HashSet(16);
        for (Set<Long> value : revCfmBillToSourceFinBillIdMap.values()) {
            Set valueStr = value.stream().map(String::valueOf).collect(Collectors.toSet());
            allFinBillIds.addAll(valueStr);
        }
        if (EmptyUtils.isEmpty(allFinBillIds)) {
            return result;
        }
        DynamicObjectCollection chargeAgainstFinBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id, billno, sourcebillid", (QFilter[])new QFilter[]{new QFilter("iswrittenoff", "=", (Object)Boolean.TRUE), new QFilter("sourcebillid", "in", allFinBillIds)});
        for (DynamicObject chargeAgainstFinBill : chargeAgainstFinBills) {
            long sourceBillId = chargeAgainstFinBill.getLong("sourcebillid");
            String billNo = chargeAgainstFinBill.getString("billno");
            long revCfmBillId = this.finRevCfmBillId(revCfmBillToSourceFinBillIdMap, sourceBillId);
            if (revCfmBillId == 0L) continue;
            result.put(revCfmBillId, billNo);
        }
        LOGGER.info("sourceRevCfmBillIdToBillNoMap :" + result);
        return result;
    }

    private long finRevCfmBillId(Map<Long, Set<Long>> revCfmBillToSourceFinBillIdMap, long sourceBillId) {
        for (Map.Entry<Long, Set<Long>> entry : revCfmBillToSourceFinBillIdMap.entrySet()) {
            if (!entry.getValue().contains(sourceBillId)) continue;
            return entry.getKey();
        }
        return 0L;
    }

    private Set<Long> listSourceRevCfmBillIds(ExtendedDataEntity[] extendedDataEntities) {
        HashSet<Long> result = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            long sourceBillId;
            DynamicObject entity = extendedDataEntity.getDataEntity();
            String sourceBillType = entity.getString("sourcebilltype");
            if (!"ar_revcfmbill".equals(sourceBillType) || (sourceBillId = entity.getLong("sourcebillid")) == 0L) continue;
            result.add(sourceBillId);
        }
        return result;
    }

    private void setBillSrcType(List<DynamicObject> billList) {
        Map paramMap = this.getOption().getVariables();
        String billsrctype = (String)paramMap.get("billsrctype");
        for (DynamicObject bill : billList) {
            if (ObjectUtils.isEmpty((Object)billsrctype)) {
                bill.set("billsrctype", (Object)BillSrcTypeEnum.MANUALWRITTENOFF.getValue());
                continue;
            }
            bill.set("billsrctype", (Object)BillSrcTypeEnum.AUTOWRITTENOFF.getValue());
        }
    }
}

