/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.writeback.BusBillUpgradeService;

public class WoffBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(WoffBillConvertPlugin.class);
    private String busEntityKey;
    private Boolean isAmt;
    private boolean isAr = false;

    public void initVariable(InitVariableEventArgs e) {
        super.initVariable(e);
        this.busEntityKey = this.getTgtMainType().getName();
        if ("ar_busbill".equals(this.busEntityKey)) {
            this.isAr = true;
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey(this.busEntityKey);
        List<DynamicObject> trgBills = Stream.of(entities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        HashSet<DynamicObject> woffBills = new HashSet<DynamicObject>(entities.length);
        boolean isselfwoff = this.getOption().getVariables().containsKey("isselfwoff");
        this.repairBill(trgBills, isselfwoff);
        if (isselfwoff) {
            QueryUtil queryUtil = new QueryUtil();
            for (DynamicObject trgBill : trgBills) {
                woffBills.add(trgBill);
                this.buildWoffBill(trgBill, queryUtil);
            }
            this.setBizDate4SelfWoff(trgBills);
        }
        this.processMostBusBill(entities);
        this.setBookDate(woffBills);
    }

    private void repairBill(List<DynamicObject> trgBills, boolean isselfwoff) {
        List srcBillIds = trgBills.stream().map(v -> Long.valueOf(v.getString("sourcebillid"))).collect(Collectors.toList());
        HashSet<Long> repairSrcIds = new HashSet<Long>(2);
        String upgradeDateStr = StdConfig.get("businvupgradeDate");
        if (upgradeDateStr == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date upgradeDate = sdf.parse(upgradeDateStr);
            if (upgradeDate == null) {
                return;
            }
            Date repairDate = DateUtils.getNextDay(upgradeDate, -180);
            QFilter filter = new QFilter("id", "in", srcBillIds);
            filter.and(new QFilter("bizdate", "<", (Object)repairDate)).and("unwoffamt", "!=", (Object)BigDecimal.ZERO).and("unwoffnotaxamt", "=", (Object)BigDecimal.ZERO);
            DynamicObjectCollection srcBills = QueryServiceHelper.query((String)this.busEntityKey, (String)"id,bizdate,unwoffamt,unwoffnotaxamt", (QFilter[])new QFilter[]{filter});
            for (DynamicObject srcBill : srcBills) {
                repairSrcIds.add(srcBill.getLong("id"));
            }
            if (!repairSrcIds.isEmpty()) {
                BusBillUpgradeService.upgrade(repairSrcIds, this.isAr);
                if (isselfwoff) {
                    this.repairTrgBill(trgBills, repairSrcIds);
                }
            }
        }
        catch (ParseException p) {
            logger.info("message", (Object)p.getMessage());
        }
    }

    private void repairTrgBill(List<DynamicObject> trgBills, Set<Long> repairSrcIds) {
        DynamicObject[] srcBills;
        for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((String)this.busEntityKey, (String)"unwoffnotaxamt,unwoffnotaxlocamt,unwofftax,unwofftaxlocal,entry.id,entry.e_unwoffnotaxamt,entry.e_unwoffnotaxlocamt,entry.e_unwofftax,entry.e_unwofftaxlocal", (QFilter[])new QFilter[]{new QFilter("id", "in", repairSrcIds)})) {
            String srcBillId = String.valueOf(srcBill.getLong("id"));
            DynamicObjectCollection srcEntrys = srcBill.getDynamicObjectCollection("entry");
            for (DynamicObject trgBill : trgBills) {
                if (!srcBillId.equals(trgBill.getString("sourcebillid"))) continue;
                trgBill.set("amount", (Object)srcBill.getBigDecimal("unwoffnotaxamt").negate());
                trgBill.set("localamt", (Object)srcBill.getBigDecimal("unwoffnotaxlocamt").negate());
                trgBill.set("tax", (Object)srcBill.getBigDecimal("unwofftax").negate());
                trgBill.set("taxlocamt", (Object)srcBill.getBigDecimal("unwofftaxlocal").negate());
                trgBill.set("unwoffnotaxamt", (Object)srcBill.getBigDecimal("unwoffnotaxamt").negate());
                trgBill.set("unwoffnotaxlocamt", (Object)srcBill.getBigDecimal("unwoffnotaxlocamt").negate());
                trgBill.set("unwofftax", (Object)srcBill.getBigDecimal("unwofftax").negate());
                trgBill.set("unwofftaxlocal", (Object)srcBill.getBigDecimal("unwofftaxlocal").negate());
                DynamicObjectCollection trgEntrys = trgBill.getDynamicObjectCollection("entry");
                for (DynamicObject srcRow : srcEntrys) {
                    Long entryId = srcRow.getLong("id");
                    for (DynamicObject trgRow : trgEntrys) {
                        Long srcEntryId = trgRow.getLong("e_srcentryid");
                        if (entryId.compareTo(srcEntryId) != 0) continue;
                        trgRow.set("e_amount", (Object)srcRow.getBigDecimal("e_unwoffnotaxamt").negate());
                        trgRow.set("e_localamt", (Object)srcRow.getBigDecimal("e_unwoffnotaxlocamt").negate());
                        trgRow.set("e_tax", (Object)srcRow.getBigDecimal("e_unwofftax").negate());
                        trgRow.set("e_taxlocalamt", (Object)srcRow.getBigDecimal("e_unwofftaxlocal").negate());
                        trgRow.set("e_unwoffnotaxamt", (Object)srcRow.getBigDecimal("e_unwoffnotaxamt").negate());
                        trgRow.set("e_unwoffnotaxlocamt", (Object)srcRow.getBigDecimal("e_unwoffnotaxlocamt").negate());
                        trgRow.set("e_unwofftax", (Object)srcRow.getBigDecimal("e_unwofftax").negate());
                        trgRow.set("e_unwofftaxlocal", (Object)srcRow.getBigDecimal("e_unwofftaxlocal").negate());
                    }
                }
            }
        }
    }

    private void setBookDate(Set<DynamicObject> woffBills) {
        Map paramMap = this.getOption().getVariables();
        String woffMode = (String)paramMap.get("woffmode");
        if (!"reval".equals(woffMode)) {
            BookDateHelper.setBookDate(woffBills.toArray(new DynamicObject[0]), "ar_busbill".equals(this.busEntityKey));
        }
    }

    private void setBizDate4SelfWoff(List<DynamicObject> trgBills) {
        DynamicObject trgBill;
        long orgId;
        DynamicObject init;
        Map paramMap = this.getOption().getVariables();
        String woffMode = (String)paramMap.get("woffmode");
        if ("batch".equals(woffMode)) {
            String bizDateStr = (String)paramMap.get("bizdate");
            if (bizDateStr == null) {
                this.autoMatchVerifyBillSetBizDate(trgBills);
            } else {
                List bizDates = (List)SerializationUtils.fromJsonString((String)bizDateStr, List.class);
                for (Map bizDate : bizDates) {
                    Long id = (Long)bizDate.get("id");
                    try {
                        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String)bizDate.get("bizdate"));
                        for (DynamicObject trgBill2 : trgBills) {
                            Long srcBusId = Long.valueOf(trgBill2.getString("sourcebillid"));
                            if (srcBusId.compareTo(id) != 0) continue;
                            trgBill2.set("bizdate", (Object)date);
                        }
                    }
                    catch (ParseException e) {
                        logger.error("context", (Object)e.getMessage());
                    }
                }
            }
        } else if ("part".equals(woffMode) && !ObjectUtils.isEmpty((Object)(init = BusinessDataServiceHelper.loadSingleFromCache((String)(this.isAr ? "ar_init" : "ap_init"), (String)"isfinishinit,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)(orgId = (trgBill = trgBills.get(0)).getLong("org.id")))})))) {
            Date currentdate = init.getDate("currentdate");
            Date bizdate = trgBill.getDate("bizdate");
            if (currentdate != null && init.getBoolean("isfinishinit") && currentdate.after(bizdate)) {
                trgBill.set("bizdate", (Object)currentdate);
            }
        }
    }

    private void autoMatchVerifyBillSetBizDate(List<DynamicObject> trgBills) {
        DynamicObject[] srcBusBills;
        ArrayList<Long> sourceBillIds = new ArrayList<Long>(16);
        for (DynamicObject trgBill : trgBills) {
            sourceBillIds.add(Long.valueOf(trgBill.getString("sourcebillid")));
        }
        Date currentDate = new Date();
        ArrayList<Long> orgidList = new ArrayList<Long>(8);
        HashMap<Long, Date> orgCurDateMap = new HashMap<Long, Date>(2);
        HashMap<Long, DynamicObject> srcBusBillMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject bill : srcBusBills = BusinessDataServiceHelper.load((String)this.busEntityKey, (String)"id,org.id,bookdate", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds)})) {
            Long orgId = bill.getLong("org.id");
            orgidList.add(orgId);
            srcBusBillMap.put(bill.getLong("id"), bill);
        }
        Map orgInit = this.isAr ? BusinessDataServiceHelper.loadFromCache((String)"ar_closeaccount", (String)"org.id,currentdate", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgidList)}) : BusinessDataServiceHelper.loadFromCache((String)"ap_closeaccount", (String)"org.id,currentdate", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgidList)});
        for (Map.Entry entrySet : orgInit.entrySet()) {
            Date date = ((DynamicObject)entrySet.getValue()).getDate("currentdate");
            if (date == null) continue;
            orgCurDateMap.put(((DynamicObject)entrySet.getValue()).getLong("org.id"), date);
        }
        for (DynamicObject trgBill : trgBills) {
            Long srcBillId = Long.valueOf(trgBill.getString("sourcebillid"));
            DynamicObject srcBill = (DynamicObject)srcBusBillMap.get(srcBillId);
            Long orgId = srcBill.getLong("org.id");
            Date bookDate = srcBill.getDate("bookdate");
            Date curDate = (Date)orgCurDateMap.get(orgId);
            if (curDate == null) {
                if (bookDate.before(currentDate)) {
                    trgBill.set("bizdate", (Object)currentDate);
                    trgBill.set("bookdate", (Object)currentDate);
                    continue;
                }
                trgBill.set("bizdate", (Object)bookDate);
                trgBill.set("bookdate", (Object)bookDate);
                continue;
            }
            if (!bookDate.before(currentDate) && !bookDate.before(curDate)) {
                trgBill.set("bizdate", (Object)bookDate);
                trgBill.set("bookdate", (Object)bookDate);
                continue;
            }
            if (!curDate.before(bookDate) && !curDate.before(currentDate)) {
                trgBill.set("bizdate", (Object)curDate);
                trgBill.set("bookdate", (Object)curDate);
                continue;
            }
            if (currentDate.before(curDate) || currentDate.before(bookDate)) continue;
            if (!curDate.before(bookDate)) {
                if (DateUtils.isSameMonth(currentDate, curDate)) {
                    trgBill.set("bizdate", (Object)currentDate);
                    trgBill.set("bookdate", (Object)currentDate);
                    continue;
                }
                trgBill.set("bizdate", (Object)curDate);
                trgBill.set("bookdate", (Object)curDate);
                continue;
            }
            if (DateUtils.isSameMonth(currentDate, curDate)) {
                trgBill.set("bizdate", (Object)currentDate);
                trgBill.set("bookdate", (Object)currentDate);
                continue;
            }
            if (DateUtils.isSameMonth(currentDate, bookDate)) {
                trgBill.set("bizdate", (Object)currentDate);
                trgBill.set("bookdate", (Object)currentDate);
                continue;
            }
            trgBill.set("bizdate", (Object)bookDate);
            trgBill.set("bookdate", (Object)bookDate);
        }
    }

    private void buildWoffBill(DynamicObject trgBill, QueryUtil queryUtil) {
        trgBill.set("isadjust", (Object)Boolean.TRUE);
        trgBill.set("isselfwoff", (Object)Boolean.TRUE);
        BigDecimal rate = trgBill.getBigDecimal("exchangerate");
        String quotation = trgBill.getString("quotation");
        DynamicObjectCollection trgEntries = trgBill.getDynamicObjectCollection("entry");
        DynamicObject currency = trgBill.getDynamicObject("currency");
        int precision = currency.getInt("amtprecision");
        DynamicObject basecurrency = trgBill.getDynamicObject("basecurrency");
        int localprecision = basecurrency.getInt("amtprecision");
        boolean includeTax = trgBill.getBoolean("isincludetax");
        boolean ispricetotal = trgBill.getBoolean("ispricetotal");
        this.isAmt = trgBill.getBoolean("payproperty.isbasedonamt");
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxlocamt = BigDecimal.ZERO;
        BigDecimal unwoffamt = BigDecimal.ZERO;
        BigDecimal unwofflocamt = BigDecimal.ZERO;
        BigDecimal unwoffnotaxamt = BigDecimal.ZERO;
        BigDecimal unwoffnotaxlocamt = BigDecimal.ZERO;
        BigDecimal unwofftax = BigDecimal.ZERO;
        BigDecimal unwofftaxlocal = BigDecimal.ZERO;
        BigDecimal uninvoicedamt = BigDecimal.ZERO;
        BigDecimal uninvoicedlocamt = BigDecimal.ZERO;
        for (DynamicObject entry : trgEntries) {
            this.setTrgEntry(queryUtil, entry, rate, includeTax, ispricetotal, precision, localprecision, quotation);
            pricetaxtotal = pricetaxtotal.add(entry.getBigDecimal(this.isAr ? "e_recamount" : "e_pricetaxtotal"));
            pricetaxtotalbase = pricetaxtotalbase.add(entry.getBigDecimal(this.isAr ? "e_reclocalamt" : "e_pricetaxtotalbase"));
            amount = amount.add(entry.getBigDecimal("e_amount"));
            localamt = localamt.add(entry.getBigDecimal("e_localamt"));
            tax = tax.add(entry.getBigDecimal("e_tax"));
            taxlocamt = taxlocamt.add(entry.getBigDecimal("e_taxlocalamt"));
            unwoffamt = unwoffamt.add(entry.getBigDecimal("e_unwoffamt"));
            unwofflocamt = unwofflocamt.add(entry.getBigDecimal("e_unwofflocamt"));
            unwoffnotaxamt = unwoffnotaxamt.add(entry.getBigDecimal("e_unwoffnotaxamt"));
            unwoffnotaxlocamt = unwoffnotaxlocamt.add(entry.getBigDecimal("e_unwoffnotaxlocamt"));
            unwofftax = unwofftax.add(entry.getBigDecimal("e_unwofftax"));
            unwofftaxlocal = unwofftaxlocal.add(entry.getBigDecimal("e_unwofftaxlocal"));
            uninvoicedamt = uninvoicedamt.add(entry.getBigDecimal("e_uninvoicedamt"));
            uninvoicedlocamt = uninvoicedlocamt.add(entry.getBigDecimal("e_uninvoicedlocamt"));
        }
        trgBill.set(this.isAr ? "recamount" : "pricetaxtotal", (Object)pricetaxtotal);
        trgBill.set(this.isAr ? "reclocalamt" : "pricetaxtotalbase", (Object)pricetaxtotalbase);
        trgBill.set("amount", (Object)amount);
        trgBill.set("localamt", (Object)localamt);
        trgBill.set("tax", (Object)tax);
        trgBill.set("taxlocamt", (Object)taxlocamt);
        trgBill.set("unwoffamt", (Object)unwoffamt);
        trgBill.set("unwofflocamt", (Object)unwofflocamt);
        trgBill.set("unwoffnotaxamt", (Object)unwoffnotaxamt);
        trgBill.set("unwoffnotaxlocamt", (Object)unwoffnotaxlocamt);
        trgBill.set("unwofftax", (Object)unwofftax);
        trgBill.set("unwofftaxlocal", (Object)unwofftaxlocal);
        trgBill.set("uninvoicedamt", (Object)uninvoicedamt);
        trgBill.set("uninvoicedlocamt", (Object)uninvoicedlocamt);
    }

    private void setTrgEntry(QueryUtil queryUtil, DynamicObject trgEntry, BigDecimal rate, boolean includeTax, boolean ispricetotal, int precision, int localprecision, String quotation) {
        AbstractPriceCalculator calculator;
        boolean isPresent = trgEntry.getBoolean("e_ispresent");
        BigDecimal price = trgEntry.getBigDecimal("e_unitprice");
        BigDecimal priceTax = trgEntry.getBigDecimal("e_taxunitprice");
        BigDecimal quantity = trgEntry.getBigDecimal("e_unwoffqty");
        if (ispricetotal && isPresent && (BigDecimal.ZERO.compareTo(price) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
            BigDecimal covertRate = trgEntry.getBigDecimal("e_unitcoefficient");
            DynamicObject material = trgEntry.getDynamicObject("e_material");
            DynamicObject measureUnit = trgEntry.getDynamicObject("e_measureunit");
            DynamicObject baseUnit = trgEntry.getDynamicObject("e_baseunit");
            if (EmptyUtils.isEmpty(covertRate)) {
                if (!ObjectUtils.isEmpty((Object)material)) {
                    if (ObjectUtils.isEmpty((Object)baseUnit)) {
                        baseUnit = material.getDynamicObject("baseunit");
                        trgEntry.set("e_baseunit", (Object)baseUnit);
                    }
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    covertRate = queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                } else {
                    covertRate = BigDecimal.ONE;
                }
                trgEntry.set("e_unitcoefficient", (Object)covertRate);
            }
            if (EmptyUtils.isEmpty(trgEntry.getBigDecimal("e_baseunitqty"))) {
                trgEntry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
            }
            trgEntry.set("e_quantity", (Object)quantity);
            return;
        }
        BigDecimal unwoffnotaxamt = trgEntry.getBigDecimal("e_unwoffnotaxamt");
        BigDecimal taxRate = trgEntry.getBigDecimal("e_taxrate");
        String discountMode = trgEntry.getString("e_discountmode");
        BigDecimal discountRate = trgEntry.getBigDecimal("e_discountrate");
        BigDecimal discountAmt = trgEntry.getBigDecimal("e_discountamount");
        BigDecimal amount = trgEntry.getBigDecimal("e_amount");
        if (this.isAmt != null && this.isAmt.booleanValue()) {
            if (!trgEntry.getBoolean("e_ispresent") && amount.compareTo(BigDecimal.ZERO) != 0) {
                quantity = new BigDecimal(unwoffnotaxamt.compareTo(BigDecimal.ZERO));
            }
            trgEntry.set("e_quantity", (Object)quantity);
            trgEntry.set("e_unwoffqty", (Object)quantity);
            discountMode = "NULL";
            trgEntry.set("e_discountmode", (Object)discountMode);
            discountRate = BigDecimal.ZERO;
            trgEntry.set("e_discountrate", (Object)discountRate);
            calculator = new PriceTotalCalculator(quantity, amount, taxRate, discountMode, discountRate, precision);
        } else {
            BigDecimal disCountRate = trgEntry.getBigDecimal("e_discountrate");
            if (includeTax) {
                if ("TOTAL".equals(discountMode) && disCountRate.compareTo(BigDecimal.ZERO) != 0) {
                    trgEntry.set("e_discountamount", (Object)disCountRate.multiply(quantity).setScale(precision, RoundingMode.HALF_UP));
                }
                calculator = new TaxUnitPriceCalculator(quantity, trgEntry.getBigDecimal("e_taxunitprice"), taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
            } else {
                if ("TOTAL".equals(discountMode) && disCountRate.compareTo(BigDecimal.ZERO) != 0) {
                    trgEntry.set("e_discountamount", (Object)disCountRate.multiply(quantity).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                }
                calculator = new UnitPriceCalculator(quantity, trgEntry.getBigDecimal("e_unitprice"), taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
            }
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision, quotation);
        localCalculator.calculate();
        BigDecimal covertRate = trgEntry.getBigDecimal("e_unitcoefficient");
        DynamicObject material = trgEntry.getDynamicObject("e_material");
        DynamicObject measureUnit = trgEntry.getDynamicObject("e_measureunit");
        DynamicObject baseUnit = trgEntry.getDynamicObject("e_baseunit");
        if (EmptyUtils.isEmpty(covertRate)) {
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    trgEntry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                covertRate = queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
            } else {
                covertRate = BigDecimal.ONE;
            }
            trgEntry.set("e_unitcoefficient", (Object)covertRate);
        }
        if (EmptyUtils.isEmpty(trgEntry.getBigDecimal("e_baseunitqty"))) {
            trgEntry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
        }
        if (this.isAmt != null && this.isAmt.booleanValue()) {
            trgEntry.set("e_unitprice", (Object)localCalculator.getUnitprice());
            trgEntry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
            trgEntry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
            trgEntry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
        }
    }

    private void processMostBusBill(ExtendedDataEntity[] entities) {
        Set allAdjustBillId = Arrays.stream(entities).map(entity -> entity.getDataEntity().getLong("sourcebillid")).collect(Collectors.toSet());
        String selector = "id,sourcebillid,entry.id,entry.e_srcentryid,entry.e_srcbillid,mostsrcbusbillid,entry.e_mostsrcbusentryid, entry.e_mostsrcbusbillid";
        DynamicObject[] allAdjustBill = BusinessDataServiceHelper.load((String)this.busEntityKey, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", allAdjustBillId), new QFilter("isadjust", "=", (Object)Boolean.TRUE)});
        if (EmptyUtils.isEmpty(allAdjustBill)) {
            return;
        }
        HashMap<Long, DynamicObject> allAdjustBillMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> busBillRowMap = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject dynamicObject : allAdjustBill) {
            allAdjustBillMap.put(dynamicObject.getLong("id"), dynamicObject);
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                busBillRowMap.put(row.getLong("id"), row);
            }
        }
        for (DynamicObject dynamicObject : entities) {
            DynamicObject writeOffBill = dynamicObject.getDataEntity();
            DynamicObject srcAdjustBill = (DynamicObject)allAdjustBillMap.get(writeOffBill.getLong("sourcebillid"));
            if (EmptyUtils.isEmpty(srcAdjustBill)) continue;
            writeOffBill.set("mostsrcbusbillid", (Object)srcAdjustBill.getLong("sourcebillid"));
            DynamicObjectCollection entry = writeOffBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                DynamicObject srcAdjustRow = (DynamicObject)busBillRowMap.get(row.getLong("e_srcentryid"));
                if (srcAdjustRow == null) continue;
                row.set("e_mostsrcbusentryid", srcAdjustRow.get("e_srcentryid"));
                row.set("e_mostsrcbusbillid", srcAdjustRow.get("e_srcbillid"));
            }
        }
    }
}

