/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.dev.beanfactory;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.fi.arapcommon.dev.beanfactory.BeanDefinition;
import kd.fi.arapcommon.dev.beanfactory.DBBeanDefinitionLoader;
import kd.fi.arapcommon.dev.beanfactory.DefaultInstanceSupplier;
import kd.fi.arapcommon.dev.beanfactory.InstanceSupplier;
import kd.fi.arapcommon.dev.beanfactory.Scope;
import kd.fi.arapcommon.dev.beanfactory.Service;

public class BeanRepository {
    private static Map<String, Object> singletonHolder = new ConcurrentHashMap<String, Object>();
    private static Map<String, BeanDefinition> beanDefinitionHolder = new ConcurrentHashMap<String, BeanDefinition>();

    public static void init() {
        DBBeanDefinitionLoader dbBeanDefinitionLoader = new DBBeanDefinitionLoader();
        List<BeanDefinition> beanDefinitions = dbBeanDefinitionLoader.loadAll();
        for (BeanDefinition beanDefinition : beanDefinitions) {
            beanDefinitionHolder.put(beanDefinition.getBeanName(), beanDefinition);
        }
    }

    public static <T> T getBean(Class<T> beanClass) {
        BeanDefinition beanDefinition = BeanRepository.getBeanDefinition(beanClass);
        return BeanRepository.innerGetBean(beanDefinition, new Object[0]);
    }

    private static <T> BeanDefinition genericBeanDefinition(Class<T> beanClass, String beanName, Scope scope) {
        BeanDefinition beanDefinition = new BeanDefinition();
        beanDefinition.setBeanClassName(beanClass.getName());
        beanDefinition.setBeanName(beanName);
        DefaultInstanceSupplier defaultInstanceSupplier = new DefaultInstanceSupplier(beanClass);
        beanDefinition.setInstanceSupplier(defaultInstanceSupplier);
        beanDefinition.setScope(scope);
        return beanDefinition;
    }

    public static <T> T getBean(Class<T> beanClass, Object ... constructorArgs) {
        BeanDefinition beanDefinition = BeanRepository.getBeanDefinition(beanClass);
        return BeanRepository.innerGetBean(beanDefinition, constructorArgs);
    }

    public static String getBeanNameByType(Class<?> beanClass) {
        Service service = beanClass.getAnnotation(Service.class);
        if (service == null || "".equals(service.value())) {
            return beanClass.getSimpleName();
        }
        return service.value();
    }

    private static <T> T innerGetBean(BeanDefinition beanDefinition, Object ... constructorArgs) {
        String beanName = beanDefinition.getBeanName();
        Scope scope = beanDefinition.getScope();
        if (Scope.Singleton == scope) {
            Object beanInstance = singletonHolder.get(beanName);
            if (beanInstance == null) {
                InstanceSupplier instanceSupplier = beanDefinition.getInstanceSupplier();
                beanInstance = instanceSupplier.get(constructorArgs);
                singletonHolder.put(beanName, beanInstance);
            }
            return (T)beanInstance;
        }
        if (Scope.Prototype == scope) {
            InstanceSupplier instanceSupplier = beanDefinition.getInstanceSupplier();
            return instanceSupplier.get(constructorArgs);
        }
        throw new RuntimeException("Unknown bean scope:" + (Object)((Object)scope));
    }

    public static <T> T getBean(String beanName) {
        BeanDefinition beanDefinition = beanDefinitionHolder.get(beanName);
        if (beanDefinition == null) {
            return null;
        }
        return BeanRepository.innerGetBean(beanDefinition, new Object[0]);
    }

    public static <T> T getBean(String beanName, Object ... constructorArgs) {
        BeanDefinition beanDefinition = beanDefinitionHolder.get(beanName);
        if (beanDefinition == null) {
            return null;
        }
        return BeanRepository.innerGetBean(beanDefinition, constructorArgs);
    }

    public static void registerBean(Class<?> beanClass, Object instance) {
        BeanDefinition beanDefinition = BeanRepository.getBeanDefinition(beanClass);
        Scope scope = beanDefinition.getScope();
        if (Scope.Singleton == scope) {
            singletonHolder.put(beanDefinition.getBeanName(), instance);
        }
    }

    public static void registerBean(String beanName, Object instance) {
        BeanDefinition beanDefinition = beanDefinitionHolder.get(beanName);
        if (beanDefinition == null) {
            return;
        }
        Scope scope = beanDefinition.getScope();
        if (Scope.Singleton == scope) {
            singletonHolder.put(beanName, instance);
        }
    }

    public static BeanDefinition getBeanDefinition(String beanName) {
        return beanDefinitionHolder.get(beanName);
    }

    private static BeanDefinition getBeanDefinition(Class<?> beanClass) {
        String beanName = BeanRepository.getBeanNameByType(beanClass);
        BeanDefinition beanDefinition = beanDefinitionHolder.get(beanName);
        if (beanDefinition == null) {
            Service service = beanClass.getAnnotation(Service.class);
            Scope scope = service != null ? service.scope() : Scope.Prototype;
            beanDefinition = BeanRepository.genericBeanDefinition(beanClass, beanName, scope);
            beanDefinitionHolder.put(beanName, beanDefinition);
        }
        return beanDefinition;
    }

    public static void registerBeanDefinition(BeanDefinition beanDefinition) {
        String beanName = beanDefinition.getBeanName();
        beanDefinitionHolder.put(beanName, beanDefinition);
        singletonHolder.remove(beanName);
    }

    public static void removeBean(Class<?> beanClass) {
        String beanName = BeanRepository.getBeanNameByType(beanClass);
        singletonHolder.remove(beanName);
    }

    public static void removeBeanDefinition(String beanName) {
        beanDefinitionHolder.remove(beanName);
        singletonHolder.remove(beanName);
    }

    static {
        try {
            BeanRepository.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

