/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.dev.beanfactory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import kd.fi.arapcommon.dev.beanfactory.InstanceSupplier;

public class DefaultInstanceSupplier
implements InstanceSupplier {
    private Class<?> beanClass;
    private String beanClassName;

    public DefaultInstanceSupplier(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public DefaultInstanceSupplier(String beanClassName) {
        this.beanClassName = beanClassName;
    }

    @Override
    public <T> T get(Object ... constructArgs) {
        Constructor<?>[] constructors;
        if (this.beanClass == null) {
            try {
                this.beanClass = Class.forName(this.beanClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (constructArgs.length == 0) {
            try {
                return (T)this.beanClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        Class[] constructArgsType = new Class[constructArgs.length];
        boolean matchByConstructorArgType = true;
        for (int i = 0; i < constructArgs.length; ++i) {
            if (constructArgs[i] == null) {
                matchByConstructorArgType = false;
                break;
            }
            constructArgsType[i] = constructArgs[i].getClass();
        }
        if (matchByConstructorArgType) {
            try {
                Constructor<?> constructor = this.beanClass.getConstructor(constructArgsType);
                return (T)constructor.newInstance(constructArgs);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        for (Constructor<?> c : constructors = this.beanClass.getConstructors()) {
            if (c.getParameterCount() != constructArgs.length) continue;
            try {
                return (T)c.newInstance(constructArgs);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("InstantiationException:Not found a matched constructor");
    }
}

