/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.eas.helper.MoveEasCommonHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

public class FinAfterProcess4EasOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinAfterProcess4EasOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("FinAfterProcess4EasOp endOperationTransaction begin.");
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> orgIds = new HashSet<Long>(8);
        ArrayList<Long> billIds = new ArrayList<Long>(64);
        String entityName = this.billEntityType.getName();
        BillModel billModel = BillModelFactory.getModel(entityName);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong(billModel.HEAD_ORG + ".id"));
            billIds.add(dataEntity.getLong("id"));
        }
        dataEntities = this.getFinBills(entityName, billIds);
        Map<Long, DynamicObject> initObjMap = this.getInitObjMap(orgIds);
        List<Tuple<String, String>> sumAmtFieldList = this.getSumAmtFieldList(entityName);
        for (DynamicObject dataEntity : dataEntities) {
            long orgId = dataEntity.getLong("org.id");
            DynamicObject initObj = initObjMap.get(orgId);
            if (initObj != null) {
                if (dataEntity.getDynamicObject(billModel.HEAD_EXRATETABLE) == null) {
                    dataEntity.set(billModel.HEAD_EXRATETABLE, (Object)initObj.getDynamicObject("exratetable"));
                }
                if (dataEntity.getDynamicObject(billModel.HEAD_BASECURRENCY) == null) {
                    dataEntity.set(billModel.HEAD_BASECURRENCY, (Object)initObj.getDynamicObject("standardcurrency"));
                }
            }
            if ("ap_finapbill".equals(entityName)) {
                this.processFinApBill(dataEntity);
            }
            if ("ar_finarbill".equals(entityName)) {
                this.processFinArBill(dataEntity);
            }
            MoveEasCommonHelper.entryAmtSumToHead(dataEntity, billModel.ENTRY, sumAmtFieldList);
            if (ObjectUtils.isEmpty((Object)dataEntity.getString(billModel.HEAD_SETTLESTATUS))) {
                dataEntity.set(billModel.HEAD_SETTLESTATUS, (Object)"unsettle");
            }
            if (dataEntity.getBigDecimal(billModel.HEAD_UNVERIFYAMOUNT).compareTo(dataEntity.getBigDecimal(billModel.HEAD_AMOUNT)) == 0) {
                dataEntity.set(billModel.HEAD_VERIFYSTATUS, (Object)("ap_finapbill".equals(entityName) ? "10" : "unverify"));
            } else if (dataEntity.getBigDecimal(billModel.HEAD_UNVERIFYAMOUNT).compareTo(BigDecimal.ZERO) == 0) {
                dataEntity.set(billModel.HEAD_VERIFYSTATUS, (Object)("ap_finapbill".equals(entityName) ? "30" : "verified"));
            } else {
                dataEntity.set(billModel.HEAD_VERIFYSTATUS, (Object)("ap_finapbill".equals(entityName) ? "20" : "partverify"));
            }
            DynamicObjectCollection planEntry = dataEntity.getDynamicObjectCollection(billModel.P_ENTRY);
            ((DynamicObject)planEntry.get(0)).set(billModel.P_UNPLANSETTLEAMT, (Object)dataEntity.getBigDecimal(billModel.HEAD_UNSETTLEAMOUNT));
            ((DynamicObject)planEntry.get(0)).set(billModel.P_UNPLANSETTLELOCAMT, (Object)dataEntity.getBigDecimal(billModel.HEAD_UNSETTLELOCALAMT));
            ((DynamicObject)planEntry.get(0)).set(billModel.P_PLANSETTLEDAMT, (Object)dataEntity.getBigDecimal(billModel.HEAD_SETTLEAMOUNT));
            ((DynamicObject)planEntry.get(0)).set(billModel.P_PLANSETTLEDLOCAMT, (Object)dataEntity.getBigDecimal(billModel.HEAD_SETTLELOCALAMT));
        }
        JournalService journalService = new JournalService();
        journalService.pushAndSaveJournals(dataEntities);
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        logger.info("FinAfterProcess4EasOp endOperationTransaction end.");
    }

    private void processFinApBill(DynamicObject dataEntity) {
        DynamicObject invRow;
        DynamicObjectCollection invEntry;
        int amtPrecision = dataEntity.getInt("currency.amtprecision");
        BigDecimal exchangeRate = dataEntity.getBigDecimal("exchangerate");
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("detailentry");
        for (DynamicObject detail : entry) {
            BigDecimal unverifyAmount = detail.getBigDecimal("e_unverifyamount").divide(exchangeRate, amtPrecision, RoundingMode.HALF_UP);
            detail.set("e_unverifyamount", (Object)unverifyAmount);
            detail.set("verifyamount", (Object)detail.getBigDecimal("e_amount").subtract(unverifyAmount));
        }
        if (ObjectUtils.isEmpty((Object)dataEntity.getString("freezestate"))) {
            dataEntity.set("freezestate", (Object)"unfreeze");
        }
        if (!(invEntry = dataEntity.getDynamicObjectCollection("inventry")).isEmpty() && ObjectUtils.isEmpty((Object)(invRow = (DynamicObject)invEntry.get(0)).getString("i_invoicecode")) && ObjectUtils.isEmpty((Object)invRow.getString("i_invoiceno"))) {
            invEntry.clear();
        }
    }

    private void processFinArBill(DynamicObject dataEntity) {
        int amtPrecision = dataEntity.getInt("currency.amtprecision");
        BigDecimal exchangeRate = dataEntity.getBigDecimal("exchangerate");
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
        for (DynamicObject detail : entry) {
            BigDecimal unverifyAmount = detail.getBigDecimal("e_unverifyamt").divide(exchangeRate, amtPrecision, RoundingMode.HALF_UP);
            detail.set("e_unverifyamt", (Object)unverifyAmount);
            detail.set("e_verifiedamt", (Object)detail.getBigDecimal("e_amount").subtract(unverifyAmount));
        }
    }

    private List<Tuple<String, String>> getSumAmtFieldList(String entityName) {
        ArrayList<Tuple<String, String>> sumAmtFieldList = new ArrayList<Tuple<String, String>>(16);
        if ("ap_finapbill".equals(entityName)) {
            sumAmtFieldList.add(Tuple.create((Object)"e_amount", (Object)"amount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_amountbase", (Object)"amountbase"));
            sumAmtFieldList.add(Tuple.create((Object)"e_tax", (Object)"tax"));
            sumAmtFieldList.add(Tuple.create((Object)"e_taxlocalamt", (Object)"taxlocamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_pricetaxtotal", (Object)"pricetaxtotal"));
            sumAmtFieldList.add(Tuple.create((Object)"e_pricetaxtotalbase", (Object)"pricetaxtotalbase"));
            sumAmtFieldList.add(Tuple.create((Object)"unsettleamt", (Object)"unsettleamount"));
            sumAmtFieldList.add(Tuple.create((Object)"unsettleamtbase", (Object)"unsettleamountbase"));
            sumAmtFieldList.add(Tuple.create((Object)"settledamt", (Object)"settleamount"));
            sumAmtFieldList.add(Tuple.create((Object)"settledamtbase", (Object)"settleamountbase"));
            sumAmtFieldList.add(Tuple.create((Object)"e_unverifyamount", (Object)"unverifyamount"));
            sumAmtFieldList.add((Tuple<String, String>)Tuple.create((Object)"e_uninvoicedamt", (Object)"uninvoicedamt"));
            sumAmtFieldList.add((Tuple<String, String>)Tuple.create((Object)"e_adjustamount", (Object)"adjustamount"));
            sumAmtFieldList.add((Tuple<String, String>)Tuple.create((Object)"e_adjustlocalamt", (Object)"adjustlocalamt"));
        } else {
            sumAmtFieldList.add(Tuple.create((Object)"e_amount", (Object)"amount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_localamt", (Object)"localamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_tax", (Object)"tax"));
            sumAmtFieldList.add(Tuple.create((Object)"e_taxlocalamt", (Object)"taxlocamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_recamount", (Object)"recamount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_reclocalamt", (Object)"reclocalamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_unsettleamt", (Object)"unsettleamount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_unsettlelocalamt", (Object)"unsettlelocalamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_settledamt", (Object)"settleamount"));
            sumAmtFieldList.add(Tuple.create((Object)"e_settledlocalamt", (Object)"settlelocalamt"));
            sumAmtFieldList.add(Tuple.create((Object)"e_unverifyamt", (Object)"unverifyamount"));
        }
        return sumAmtFieldList;
    }

    private DynamicObject[] getFinBills(String entityName, List<Long> billIds) {
        String selectors = "ap_finapbill".equals(entityName) ? "org,basecurrency,exratetable,e_amount,amount,e_amountbase,amountbase,e_tax,tax,e_taxlocalamt,taxlocamt,e_pricetaxtotal,pricetaxtotal,e_pricetaxtotalbase,pricetaxtotalbase,unsettleamt,unsettleamount,unsettleamtbase,unsettleamountbase,settledamt,settleamount,settledamtbase,settleamountbase,e_unverifyamount,unverifyamount,e_uninvoicedamt,uninvoicedamt,e_adjustamount,adjustamount,e_adjustlocalamt,adjustlocalamt,settlestatus,verifystatus,iswrittenoff,hadwrittenoff,e_sourcebillid,sourcebillid,billsrctype,istanspay,e_sourcebillentryid,currency,exchangerate,i_invoicecode,i_invoiceno,taxrateid,taxrate,verifyamount,freezestate,plansettledamt,plansettledlocamt,unplansettleamt,unplansettlelocamt" : "e_amount,amount,e_localamt,localamt,e_tax,tax,e_taxlocalamt,taxlocamt,e_recamount,recamount,e_reclocalamt,reclocalamt,e_unsettleamt,unsettleamount,e_unsettlelocalamt,unsettlelocalamt,e_settledamt,settleamount,e_settledlocalamt,settlelocalamt,e_verifiedamt,e_unverifyamt,unverifyamount,exratetable,basecurrency,org,settlestatus,verifystatus,istransfer,hadwrittenoff,iswrittenoff,sourcebillid,e_srcid,e_srcentryid,currency,exchangerate,taxrateid,taxrate,plansettledamt,plansettledlocamt,unplansettleamt,unplansettlelocamt";
        return BusinessDataServiceHelper.load((String)entityName, (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    private Map<Long, DynamicObject> getInitObjMap(Set<Long> orgIds) {
        String entityName = this.billEntityType.getName();
        DynamicObject[] initObjs = BusinessDataServiceHelper.load((String)(entityName.contains("ap_") ? "ap_init" : "ar_init"), (String)"exratetable,standardcurrency,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, DynamicObject> initObjMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject initObj : initObjs) {
            initObjMap.put(initObj.getLong("org.id"), initObj);
        }
        return initObjMap;
    }
}

