/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PayApplyAfterProcess4EasOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PayApplyAfterProcess4EasOp.class);
    private static final Long AP_PAYAPPLY_BT_S = 668013607723766784L;
    private static final Long AP_PAYAPPLY_OTH_BT_S = 668016814621498368L;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("PayApplyAfterProcess4EasOp endOperationTransaction begin.");
        DynamicObject[] dataEntities = this.getPayApplyBills(e);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong("settleorg.id"));
        }
        Map<Long, DynamicObject> initObjMap = this.getInitObjMap(orgIds);
        for (DynamicObject applypay : dataEntities) {
            long orgId = applypay.getLong("settleorg.id");
            DynamicObject initObj = initObjMap.get(orgId);
            if (initObj != null && applypay.getDynamicObject("exratetable") == null) {
                applypay.set("exratetable", (Object)initObj.getDynamicObject("exratetable"));
            }
            applypay.set("billtype", (Object)AP_PAYAPPLY_BT_S);
            String billstatus = applypay.getString("billstatus");
            BigDecimal payAmt = BigDecimal.ZERO;
            DynamicObjectCollection entrys = applypay.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                String payType = entry.getString("e_paymenttype.biztype");
                if ("999".equals(payType)) {
                    applypay.set("billtype", (Object)AP_PAYAPPLY_OTH_BT_S);
                }
                if ("D".equals(billstatus)) {
                    entry.set("e_closestatus", (Object)"B");
                }
                payAmt = payAmt.add(entry.getBigDecimal("e_paidamt"));
            }
            if (payAmt.compareTo(BigDecimal.ZERO) == 0) {
                applypay.set("paystatus", (Object)"Unpaid");
                continue;
            }
            if (payAmt.compareTo(applypay.getBigDecimal("aprseleamount")) >= 0) {
                applypay.set("paystatus", (Object)"Alreadypay");
                continue;
            }
            applypay.set("paystatus", (Object)"Inpayment");
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        logger.info("PayApplyAfterProcess4EasOp endOperationTransaction end.");
    }

    private DynamicObject[] getPayApplyBills(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List billIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        return BusinessDataServiceHelper.load((String)"ap_payapply", (String)String.join((CharSequence)",", this.getSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    private Map<Long, DynamicObject> getInitObjMap(Set<Long> orgIds) {
        DynamicObject[] initObjs = BusinessDataServiceHelper.load((String)"ap_init", (String)"exratetable,standardcurrency,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, DynamicObject> initObjMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject initObj : initObjs) {
            initObjMap.put(initObj.getLong("org.id"), initObj);
        }
        return initObjMap;
    }

    private List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("settleorg");
        selector.add("exratetable");
        selector.add("billstatus");
        selector.add("e_closestatus");
        selector.add("paystatus");
        selector.add("aprseleamount");
        selector.add("e_paidamt");
        selector.add("billtype");
        selector.add("e_paymenttype");
        return selector;
    }
}

