/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;

public class CasJournalGeneratorService {
    public static final Log logger = LogFactory.getLog(CasJournalGeneratorService.class);

    public void generateJournal(Map<String, List<Object>> paramMap) {
        List<Object> payPks;
        logger.info("CasJournalGeneratorService paramMap:" + JSON.toJSONString(paramMap));
        JournalService journalService = new JournalService();
        List<Object> recPks = paramMap.get("cas_recbill");
        if (recPks != null && !recPks.isEmpty()) {
            String recSelectors = String.join((CharSequence)",", this.getRecSelector());
            DynamicObject[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)recSelectors, (QFilter[])new QFilter[]{new QFilter("id", "in", recPks), new QFilter("receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE)});
            logger.info("CasJournalGeneratorService recBills:" + recBills.length);
            journalService.pushAndSaveJournals(recBills);
        }
        if ((payPks = paramMap.get("cas_paybill")) != null && !payPks.isEmpty()) {
            String paySelectors = String.join((CharSequence)",", this.getPaySelector());
            DynamicObject[] paymentBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)paySelectors, (QFilter[])new QFilter[]{new QFilter("id", "in", payPks), new QFilter("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE)});
            logger.info("CasJournalGeneratorService paymentBills:" + paymentBills.length);
            journalService.pushAndSaveJournals(paymentBills);
        }
    }

    public List<String> getPaySelector() {
        ArrayList<String> lst = new ArrayList<String>(64);
        lst.add("billno");
        lst.add("billstatus");
        lst.add("bizdate");
        lst.add("billtype");
        lst.add("paymenttype");
        lst.add("payeetype");
        lst.add("description");
        lst.add("issingle");
        lst.add("org");
        lst.add("payeracctcash");
        lst.add("payeracctbank");
        lst.add("payerbank");
        lst.add("payee");
        lst.add("payeeformid");
        lst.add("payeename");
        lst.add("payeeaccformid");
        lst.add("payeeacctbank");
        lst.add("payeebanknum");
        lst.add("payeebank");
        lst.add("payeebankname");
        lst.add("iscommitbe");
        lst.add("bankpaystatus");
        lst.add("actpayamt");
        lst.add("currency");
        lst.add("payquotation");
        lst.add("exchangerate");
        lst.add("localamt");
        lst.add("settletype");
        lst.add("settletnumber");
        lst.add("fundflowitem");
        lst.add("usage");
        lst.add("expectdealtime");
        lst.add("reccountry");
        lst.add("recprovince");
        lst.add("reccity");
        lst.add("recaccbankname");
        lst.add("recbanknumber");
        lst.add("sourcetype");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
        lst.add("cashier");
        lst.add("paydate");
        lst.add("bankcheckflag");
        lst.add("entrance");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("e_fundflowitem");
        lst.add("e_remark");
        lst.add("e_payableAmt");
        lst.add("e_sourcebillentryid");
        lst.add("e_unsettledamt");
        lst.add("e_settledamt");
        lst.add("e_material");
        lst.add("e_expenseitem");
        lst.add("e_corebillno");
        lst.add("e_corebillentryseq");
        lst.add("e_sourcebillid");
        lst.add("settleorg");
        lst.add("e_paymenttype");
        lst.add("basecurrency");
        List<SettleRecordExtDataListKeyVO> keys = SettleExtDataLoader.loadSettleRecordExtListKeys("cas_paybill");
        keys.forEach(v -> lst.add(v.getBillKey()));
        return lst;
    }

    public List<String> getRecSelector() {
        ArrayList<String> lst = new ArrayList<String>(64);
        lst.add("billno");
        lst.add("biztype");
        lst.add("bizdate");
        lst.add("billstatus");
        lst.add("txt_description");
        lst.add("receivingtype");
        lst.add("payertype");
        lst.add("org");
        lst.add("accountbank");
        lst.add("accountcash");
        lst.add("payeebank");
        lst.add("payer");
        lst.add("payerformid");
        lst.add("payeracctbank");
        lst.add("payeraccformid");
        lst.add("payername");
        lst.add("payeracctbanknum");
        lst.add("payerbankname");
        lst.add("f7_payerbank");
        lst.add("cashier");
        lst.add("payeedate");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("isagent");
        lst.add("accountcash");
        lst.add("actrecamt");
        lst.add("currency");
        lst.add("quotation");
        lst.add("exchangerate");
        lst.add("localamt");
        lst.add("settletype");
        lst.add("settletnumber");
        lst.add("bankcheckflag");
        lst.add("entry");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("e_fundflowitem");
        lst.add("e_remark");
        lst.add("realreccompany");
        lst.add("e_receivableamt");
        lst.add("e_sourcebillentryid");
        lst.add("e_unsettledamt");
        lst.add("e_settledamt");
        lst.add("e_material");
        lst.add("e_expenseitem");
        lst.add("e_corebilltype");
        lst.add("e_corebillno");
        lst.add("e_corebillentryseq");
        lst.add("e_settleorg");
        lst.add("basecurrency");
        lst.add("e_receivingtype");
        List<SettleRecordExtDataListKeyVO> keys = SettleExtDataLoader.loadSettleRecordExtListKeys("cas_recbill");
        keys.forEach(v -> lst.add(v.getBillKey()));
        return lst;
    }
}

