/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.enums;

import java.util.Calendar;
import java.util.Date;
import kd.fi.arapcommon.enums.MultiLangEnumBridge;
import kd.fi.arapcommon.util.DateUtils;

public enum UpgradeDataRangeEnum {
    MONTH(new MultiLangEnumBridge("\u6700\u8fd1\u4e00\u4e2a\u6708\u6570\u636e", "UpgradeDataRangeEnum_0", "fi-arapcommon"), 30),
    QUARTER(new MultiLangEnumBridge("\u6700\u8fd1\u4e09\u4e2a\u6708\u6570\u636e", "UpgradeDataRangeEnum_1", "fi-arapcommon"), 90),
    HALFYEAR(new MultiLangEnumBridge("\u6700\u8fd1\u534a\u5e74\u6570\u636e", "UpgradeDataRangeEnum_2", "fi-arapcommon"), 180),
    YEAR(new MultiLangEnumBridge("\u6700\u8fd1\u4e00\u5e74\u6570\u636e", "UpgradeDataRangeEnum_3", "fi-arapcommon"), 365),
    ALL(new MultiLangEnumBridge("\u4e0a\u5e741\u67081\u65e5\u81f3\u4eca\u7684\u6240\u6709\u6570\u636e", "UpgradeDataRangeEnum_4", "fi-arapcommon"), -1);

    private MultiLangEnumBridge bridge;
    private int value;

    private UpgradeDataRangeEnum(MultiLangEnumBridge bridge, int value) {
        this.bridge = bridge;
        this.value = value;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public int getValue() {
        if (ALL == this) {
            int lastYear = Calendar.getInstance().get(1) - 1;
            Date farthestDate = DateUtils.getDate(lastYear, 1, 1);
            return DateUtils.getDiffDays(farthestDate, new Date());
        }
        return this.value;
    }
}

