/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.check.helper.AmountCompareHelper;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.exception.AmountCheckExecption;

public class ArRevUnVerifyCheckBillCtrlService
implements IExecCtrlService<Object> {
    @Override
    public Object execute(Object ... param) {
        if (param == null || param.length != 1) {
            return null;
        }
        Object[] redRecords = (DynamicObject[])param[0];
        if (ObjectUtils.isEmpty((Object[])redRecords)) {
            return null;
        }
        HashSet<Long> mainBillIds = new HashSet<Long>(redRecords.length);
        HashSet<Long> asstBillIds = new HashSet<Long>(redRecords.length);
        for (Object redRecord : redRecords) {
            DynamicObjectCollection entrys = redRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                mainBillIds.add(entry.getLong("billid"));
                asstBillIds.add(entry.getLong("assbillid"));
            }
        }
        try {
            this.checkMainBill(mainBillIds);
            this.checkAsstBill(asstBillIds);
        }
        catch (AmountCheckExecption e) {
            String message = e.getMessage();
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5e94\u6536\u6536\u5165\u201d\u53cd\u6838\u9500\u5931\u8d25\u3002\u53cd\u6838\u9500\u540e\u5355\u636e\u5b57\u6bb5\u53cd\u5199\u5f02\u5e38\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"ArRevUnVerifyCheckBillCtrlService_0", (String)"fi-arapcommon", (Object[])new Object[]{message}));
        }
        return null;
    }

    private void checkAsstBill(Set<Long> asstBillIds) {
        DynamicObject[] revBills;
        for (DynamicObject bill : revBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"billno,entry.e_confirmbaseqty,entry.e_recbaseqty,entry.e_unrecbaseqty,entry.e_confirmamt,entry.e_recamt,entry.e_unrecamt", (QFilter[])new QFilter[]{new QFilter("id", "in", asstBillIds)})) {
            String billno = bill.getString("billno");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                AmountCompareHelper.compare(billno, entry, "e_confirmbaseqty", "e_recbaseqty", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u5e94\u6536\u57fa\u672c\u6570\u91cf\u987b\u540c\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, entry, "e_confirmbaseqty", "e_unrecbaseqty", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u5e94\u6536\u57fa\u672c\u6570\u91cf\u987b\u540c\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, entry, "e_confirmbaseqty", "e_recbaseqty", "e_unrecbaseqty", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u7684\u201c\u5df2\u5e94\u6536\u57fa\u672c\u6570\u91cf\u201d\u4e0e\u201c\u672a\u5e94\u6536\u57fa\u672c\u6570\u91cf\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u201c\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, entry, "e_confirmamt", "e_recamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u5e94\u6536\u91d1\u989d\u987b\u540c\u786e\u8ba4\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u786e\u8ba4\u91d1\u989d\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, entry, "e_confirmamt", "e_unrecamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u5e94\u6536\u91d1\u989d\u987b\u540c\u786e\u8ba4\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u786e\u8ba4\u91d1\u989d\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, entry, "e_confirmamt", "e_recamt", "e_unrecamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u7684\u201c\u5df2\u5e94\u6536\u91d1\u989d\u201d\u4e0e\u201c\u672a\u5e94\u6536\u91d1\u989d\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u201c\u786e\u8ba4\u91d1\u989d\u201d\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_6", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }

    private void checkMainBill(Set<Long> mainBillIds) {
        DynamicObject[] finArBills;
        for (DynamicObject bill : finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"billno,entry.e_baseunitqty,entry.e_confirmedbaseqty,entry.e_unconfirmbaseqty,entry.e_amount,entry.e_confirmedamt,entry.e_unconfirmamt", (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)})) {
            String billno = bill.getString("billno");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                AmountCompareHelper.compare(billno, entry, "e_baseunitqty", "e_confirmedbaseqty", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u987b\u540c\u57fa\u672c\u6570\u91cf\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u57fa\u672c\u6570\u91cf\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_7", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, entry, "e_baseunitqty", "e_unconfirmbaseqty", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u987b\u540c\u57fa\u672c\u6570\u91cf\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u57fa\u672c\u6570\u91cf\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_8", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, entry, "e_baseunitqty", "e_confirmedbaseqty", "e_unconfirmbaseqty", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u7684\u201c\u5df2\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u201d\u4e0e\u201c\u672a\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u201c\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_9", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, entry, "e_amount", "e_confirmedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u786e\u8ba4\u91d1\u989d\u987b\u540c\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u91d1\u989d\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_10", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, entry, "e_amount", "e_unconfirmamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u786e\u8ba4\u91d1\u989d\u987b\u540c\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u91d1\u989d\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_11", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, entry, "e_amount", "e_confirmedamt", "e_unconfirmamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u7684\u201c\u5df2\u786e\u8ba4\u91d1\u989d\u201d\u4e0e\u201c\u672a\u786e\u8ba4\u91d1\u989d\u201d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u201c\u91d1\u989d\u201d\u3002", (String)"ArRevUnVerifyCheckBillCtrlService_12", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }
}

