/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.check.helper.FinApBillCheckHelper;
import kd.fi.arapcommon.check.helper.FinArBillCheckHelper;
import kd.fi.arapcommon.check.helper.PayBillCheckHelper;
import kd.fi.arapcommon.check.helper.RecBillCheckHelper;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.excecontrol.ExecCtrlServiceFactory;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ExecCtrlHelper {
    private static final Log logger = LogFactory.getLog(ExecCtrlHelper.class);

    public static List<AbstractExecControlValidator> getExecControlValidator(DynamicObject[] execControls) {
        ArrayList<AbstractExecControlValidator> execControlValidators = new ArrayList<AbstractExecControlValidator>(2);
        if (EmptyUtils.isNotEmpty(execControls)) {
            for (DynamicObject execControl : execControls) {
                try {
                    AbstractExecControlValidator execControlValidator = (AbstractExecControlValidator)((Object)BeanFactory.getBean(Class.forName(execControl.getString("plugin")), new Object[0]));
                    execControlValidators.add(execControlValidator);
                }
                catch (ClassNotFoundException ignored) {
                    logger.info("ExecCtrlHelper getExecControlValidator ClassNotFoundException is : " + execControl.getString("bizobj.number"));
                }
            }
        }
        return execControlValidators;
    }

    public static <T> T execCustomizeCtrlService(String number, T defaultValue, Object ... param) {
        if (StringUtils.isEmpty(number)) {
            return defaultValue;
        }
        IExecCtrlService ctrlService = ExecCtrlServiceFactory.getCtrlService(number);
        if (ctrlService == null) {
            return defaultValue;
        }
        return ctrlService.execute(param);
    }

    public static DynamicObject[] getNormalExecControl(String entityName, String opName) {
        return ExecCtrlHelper.getExecControl(entityName, opName, "error");
    }

    public static DynamicObject[] getExecControl(String entityName, String opName, String ctrlType) {
        QFilter filter = new QFilter("bizobj.number", "=", (Object)entityName);
        filter.and("enable", "=", (Object)Boolean.TRUE);
        filter.and("status", "=", (Object)Character.valueOf('C'));
        filter.and("ctrlmode", "=", (Object)"plugin");
        filter.and("ctrlpoint", "like", (Object)("%," + opName + ",%"));
        filter.and("plugin", "not in", Arrays.asList("", " "));
        filter.and("ctrltype", "=", (Object)ctrlType);
        Map arApExecControl = BusinessDataServiceHelper.loadFromCache((String)"arap_execcontrol", (QFilter[])new QFilter[]{filter});
        return EmptyUtils.isEmpty(arApExecControl) ? new DynamicObject[]{} : arApExecControl.values().toArray(new DynamicObject[0]);
    }

    public static void checkBillAmount(String entity, Set<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return;
        }
        if ("ap_finapbill".equals(entity)) {
            FinApBillCheckHelper.checkLockAndSettleField(ids);
        } else if ("ar_finarbill".equals(entity)) {
            FinArBillCheckHelper.checkLockAndSettleField(ids);
        } else if ("cas_paybill".equals(entity)) {
            PayBillCheckHelper.checkLockAndSettleField(ids);
        } else if ("cas_recbill".equals(entity)) {
            RecBillCheckHelper.checkLockAndSettleField(ids);
        }
    }

    public static String getSameBillMessage(List<String> billNos, boolean isApply) {
        if (billNos == null || billNos.isEmpty()) {
            return null;
        }
        String finApName = ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"ExecCtrlHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        String applyName = ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355", (String)"ExecCtrlHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]);
        String billName = isApply ? applyName : finApName;
        return ExecCtrlHelper.getSameBillMessage(billNos, billName);
    }

    public static String getSameBillMessage(List<String> billNos, String billName) {
        String message = String.format(ResManager.loadKDString((String)"\u5df2\u4e3a\u60a8\u7b5b\u9009\u51fa\u76f8\u540c\u5355\u636e\u4fe1\u606f\u7684%2$s%1$s\u6761\uff0c\u5355\u636e\u7f16\u53f7\u4e3a", (String)"ExecCtrlHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]), billNos.size(), billName);
        if (billNos.size() > 3) {
            message = message.concat(String.format(ResManager.loadKDString((String)"%1$s\uff0c%2$s\uff0c%3$s ...", (String)"ExecCtrlHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]), billNos.get(0), billNos.get(1), billNos.get(2)));
        } else {
            for (int i = 0; i < billNos.size(); ++i) {
                message = i == billNos.size() - 1 ? message.concat(String.format(ResManager.loadKDString((String)"%1$s\u3002", (String)"ExecCtrlHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]), billNos.get(i))) : message.concat(String.format(ResManager.loadKDString((String)"%1$s\u3001", (String)"ExecCtrlHelper_6", (String)"fi-arapcommon", (Object[])new Object[0]), billNos.get(i)));
            }
        }
        return message;
    }
}

