/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.util.StringUtils;

public class ExecCtrlServiceFactory {
    public static IExecCtrlService getCtrlService(final String number) {
        if (StringUtils.isEmpty(number)) {
            return null;
        }
        ExecCtrlServiceParam param = (ExecCtrlServiceParam)ThreadCache.get((Object)("getCtrlService" + number), (CacheLoader)new CacheLoader<ExecCtrlServiceParam>(){

            public ExecCtrlServiceParam load() {
                DynamicObject ctrlServiceObj = BusinessDataServiceHelper.loadSingle((String)"arap_execcontrol", (String)"number,plugin,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
                if (ctrlServiceObj == null) {
                    return ExecCtrlServiceFactory.genNoExistParam();
                }
                String plugin = ctrlServiceObj.getString("plugin");
                if (StringUtils.isEmpty(plugin)) {
                    return ExecCtrlServiceFactory.genNoExistParam();
                }
                boolean enable = ctrlServiceObj.getBoolean("enable");
                try {
                    Class<?> serviceClass = Class.forName(plugin);
                    Object service = serviceClass.newInstance();
                    if (service instanceof IExecCtrlService) {
                        ExecCtrlServiceParam param = new ExecCtrlServiceParam();
                        param.setService((IExecCtrlService)service);
                        param.setEnable(enable);
                        return param;
                    }
                    return ExecCtrlServiceFactory.genNoExistParam();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }, (boolean)true);
        if (param == null || !param.isExist() || !param.isEnable()) {
            return null;
        }
        return param.getService();
    }

    private static ExecCtrlServiceParam genNoExistParam() {
        ExecCtrlServiceParam param = new ExecCtrlServiceParam();
        param.setExist(false);
        return param;
    }

    static class ExecCtrlServiceParam {
        private IExecCtrlService service;
        private boolean enable;
        private boolean exist = true;

        ExecCtrlServiceParam() {
        }

        public IExecCtrlService getService() {
            return this.service;
        }

        public void setService(IExecCtrlService service) {
            this.service = service;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public boolean isExist() {
            return this.exist;
        }

        public void setExist(boolean exist) {
            this.exist = exist;
        }
    }
}

