/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

public class ReAccountConfirmCtrlService
implements IExecCtrlService<Object> {
    @Override
    public <T> T execute(Object ... param) {
        if (param == null || param.length == 0) {
            return null;
        }
        String entityName = (String)param[0];
        DynamicObject[] bills = (DynamicObject[])param[1];
        return (T)this.doValidator(entityName, bills);
    }

    private Map<String, Set<String>> doValidator(String entityName, DynamicObject[] finBills) {
        HashMap<String, Set<String>> reAccountConfirmMap = new HashMap<String, Set<String>>(2);
        BillModel billModel = BillModelFactory.getModel(entityName);
        HashMap<String, Set> srcTypeToSrcBillIdMap = new HashMap<String, Set>(8);
        for (DynamicObject finBill : finBills) {
            String sourcebilltype = finBill.getString(billModel.HEAD_SOURCEBILLTYPE);
            DynamicObjectCollection entrys = finBill.getDynamicObjectCollection(billModel.ENTRY);
            Set e_srcbillids = entrys.stream().filter(e -> e.getLong(billModel.E_SOURCEBILLID) != 0L).map(e -> e.getLong(billModel.E_SOURCEBILLID)).collect(Collectors.toSet());
            if (ObjectUtils.isEmpty((Object)sourcebilltype) || e_srcbillids.size() <= 0) continue;
            Set srcbillids = srcTypeToSrcBillIdMap.getOrDefault(sourcebilltype, new HashSet(8));
            srcbillids.addAll(e_srcbillids);
            srcTypeToSrcBillIdMap.put(sourcebilltype, srcbillids);
        }
        if (srcTypeToSrcBillIdMap.size() == 0) {
            return reAccountConfirmMap;
        }
        HashSet<Long> linkDownFinbillIds = new HashSet<Long>(8);
        for (Map.Entry entrySet : srcTypeToSrcBillIdMap.entrySet()) {
            String sourcebilltype = (String)entrySet.getKey();
            Set srcbillids = (Set)entrySet.getValue();
            Set<Long> billids = BOTPHelper.loadDirtTargetBillIds(sourcebilltype, srcbillids.toArray(new Long[0]), entityName);
            linkDownFinbillIds.addAll(billids);
        }
        if (linkDownFinbillIds.size() == 0) {
            return reAccountConfirmMap;
        }
        String e_sourcebillidKey = billModel.ENTRY + '.' + billModel.E_SOURCEBILLID;
        DynamicObjectCollection hadWrittenOffBills = QueryServiceHelper.query((String)entityName, (String)("id,billno," + e_sourcebillidKey), (QFilter[])new QFilter[]{new QFilter("id", "in", linkDownFinbillIds), new QFilter("hadwrittenoff", "=", (Object)Boolean.TRUE)});
        if (hadWrittenOffBills.size() == 0) {
            return reAccountConfirmMap;
        }
        HashSet<Long> allHadWrittenOffIds = new HashSet<Long>(8);
        HashMap<Long, Set> srcIdToHadWrittenOffIdsMap = new HashMap<Long, Set>(8);
        for (DynamicObject hadWrittenOffBill : hadWrittenOffBills) {
            long sourcebillid = hadWrittenOffBill.getLong(e_sourcebillidKey);
            long hadWrittenOffBillId = hadWrittenOffBill.getLong("id");
            allHadWrittenOffIds.add(hadWrittenOffBillId);
            Set hadWrittenOffIdsSet = srcIdToHadWrittenOffIdsMap.getOrDefault(sourcebillid, new HashSet(8));
            hadWrittenOffIdsSet.add(hadWrittenOffBillId);
            srcIdToHadWrittenOffIdsMap.put(sourcebillid, hadWrittenOffIdsSet);
        }
        HashSet<Long> orgIds = new HashSet<Long>(8);
        HashMap<Long, String> hadWrittenOffIdToFinBillNoMap = new HashMap<Long, String>(8);
        for (DynamicObject finBill : finBills) {
            long orgId = finBill.getLong("org.id");
            orgIds.add(orgId);
            String string = finBill.getString("billno");
            DynamicObjectCollection detailentrys = finBill.getDynamicObjectCollection(billModel.ENTRY);
            for (DynamicObject entry : detailentrys) {
                long e_sourcebillid = entry.getLong(billModel.E_SOURCEBILLID);
                Set hadWrittenOffIds = (Set)srcIdToHadWrittenOffIdsMap.get(e_sourcebillid);
                if (hadWrittenOffIds == null) continue;
                for (Long hadWrittenOffId : hadWrittenOffIds) {
                    hadWrittenOffIdToFinBillNoMap.put(hadWrittenOffId, string);
                }
            }
        }
        DynamicObjectCollection records = QueryServiceHelper.query((String)"ap_settlerecord", (String)"mainbillid,settlerelation,entry.billdate,entry.billid,entry.e_billentity", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("mainbillid", "in", allHadWrittenOffIds), new QFilter("settlerelation", "in", (Object)new String[]{"appaysettle", "recsettle", "arpaysettle"}), new QFilter("hadwrittenoff", "=", (Object)Boolean.TRUE), new QFilter("settletype", "=", (Object)"auto"), new QFilter("autosettletype", "=", (Object)"1")});
        if (records.size() == 0) {
            return reAccountConfirmMap;
        }
        HashMap<String, Set> asstBillMap = new HashMap<String, Set>(2);
        HashMap<Long, Long> asstIdToMainIdMap = new HashMap<Long, Long>(records.size());
        for (DynamicObject record : records) {
            long mainBillId = record.getLong("mainbillid");
            Long asstBillId = record.getLong("entry.billid");
            String billentity = record.getString("entry.e_billentity");
            Set asstBillIds = asstBillMap.getOrDefault(billentity, new HashSet(8));
            asstBillIds.add(asstBillId);
            asstBillMap.put(billentity, asstBillIds);
            asstIdToMainIdMap.put(asstBillId, mainBillId);
        }
        HashSet<Long> needConfirmPayOrRecBillIds = new HashSet<Long>(8);
        HashSet<String> needConfirmPayOrRecBillNos = new HashSet<String>(8);
        for (Map.Entry entry : asstBillMap.entrySet()) {
            String billentity = (String)entry.getKey();
            Set billids = (Set)entry.getValue();
            DynamicObjectCollection bills = QueryServiceHelper.query((String)billentity, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billids), new QFilter("entry.e_unsettledamt", "!=", (Object)BigDecimal.ZERO)});
            for (DynamicObject bill : bills) {
                needConfirmPayOrRecBillIds.add(bill.getLong("id"));
                needConfirmPayOrRecBillNos.add(bill.getString("billno"));
            }
        }
        if (needConfirmPayOrRecBillIds.size() == 0) {
            return reAccountConfirmMap;
        }
        HashSet<Long> needConfirmHadWrittenOffIds = new HashSet<Long>(8);
        for (Long PayOrRecBillId : needConfirmPayOrRecBillIds) {
            long hadWrittenOffId = (Long)asstIdToMainIdMap.get(PayOrRecBillId);
            if (ObjectUtils.isEmpty((Object)hadWrittenOffId)) continue;
            needConfirmHadWrittenOffIds.add(hadWrittenOffId);
        }
        HashSet<String> hashSet = new HashSet<String>(8);
        for (Long needReAccountCfmHadWrittenOffId : needConfirmHadWrittenOffIds) {
            String needConfirmFinBillNo = (String)hadWrittenOffIdToFinBillNoMap.get(needReAccountCfmHadWrittenOffId);
            if (ObjectUtils.isEmpty((Object)needConfirmFinBillNo)) continue;
            hashSet.add(needConfirmFinBillNo);
        }
        reAccountConfirmMap.put("needConfirmFinBillNos", hashSet);
        reAccountConfirmMap.put("needConfirmPayOrRecBillNos", needConfirmPayOrRecBillNos);
        return reAccountConfirmMap;
    }
}

