/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.BusApQtyExcessService;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;

public class RevalBusQtyExcessService
implements IExecCtrlService<Object> {
    private static final Log logger = LogFactory.getLog(BusApQtyExcessService.class);

    @Override
    public List<String> execute(Object ... param) {
        if (param == null || param.length != 1) {
            return null;
        }
        List billIds = (List)param[0];
        if (ObjectUtils.isEmpty((Object)billIds)) {
            return null;
        }
        QFilter filter = new QFilter("id", "in", (Object)billIds);
        filter.and(new QFilter("isrevaluation", "=", (Object)Boolean.TRUE));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"id,billno,revaluasrcbusbillid,entry.id,entry.e_srcentryid,entry.seq,entry.e_quantity", (QFilter[])new QFilter[]{filter});
        return this.validate(bills);
    }

    public List<String> validate(DynamicObject[] bills) {
        logger.info("RevalBusQtyExcessService start");
        ArrayList<String> results = new ArrayList<String>(16);
        ArrayList<Long> revalSrcBusBillIds = new ArrayList<Long>(16);
        ArrayList<Long> srcPurEntryIds = new ArrayList<Long>(16);
        HashMap<String, BigDecimal> revalSrcEntryUnWoffQtys = new HashMap<String, BigDecimal>(16);
        for (DynamicObject bill : bills) {
            Long revalSrcBusBillId = bill.getLong("revaluasrcbusbillid");
            if (revalSrcBusBillId == 0L) continue;
            revalSrcBusBillIds.add(revalSrcBusBillId);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long srcBillEntryId = entry.getLong("e_srcentryid");
                if (srcBillEntryId == 0L) continue;
                srcPurEntryIds.add(srcBillEntryId);
            }
        }
        DataSet revalSrcBusBills = QueryServiceHelper.queryDataSet((String)"RevalBusQtyExcessService", (String)"ap_busbill", (String)"id,billno,entry.id,entry.e_unwoffqty,entry.e_srcentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", revalSrcBusBillIds), new QFilter("entry.e_srcentryid", "in", srcPurEntryIds)}, null);
        HashMap<Long, String> revalSrcBillNos = new HashMap<Long, String>(16);
        for (Row row : revalSrcBusBills) {
            Long id = row.getLong("id");
            Long srcEntryId = row.getLong("entry.e_srcentryid");
            String matchKey = id + "_" + srcEntryId;
            BigDecimal unWoffQty = row.getBigDecimal("entry.e_unwoffqty");
            revalSrcEntryUnWoffQtys.put(matchKey, unWoffQty);
            revalSrcBillNos.put(id, row.getString("billno"));
        }
        for (DynamicObject bill : bills) {
            Long revalSrcBusBillId = bill.getLong("revaluasrcbusbillid");
            if (revalSrcBusBillId == 0L) continue;
            String billNo = bill.getString("billno");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                String matchKey;
                BigDecimal revalSrcUnWoffQty;
                Long srcBillEntryId = entry.getLong("e_srcentryid");
                if (srcBillEntryId == 0L || (revalSrcUnWoffQty = (BigDecimal)revalSrcEntryUnWoffQtys.get(matchKey = revalSrcBusBillId + "_" + srcBillEntryId)) == null) continue;
                BigDecimal currentBillQty = entry.getBigDecimal("e_quantity");
                String revalSrcBillNo = (String)revalSrcBillNos.get(revalSrcBusBillId);
                if (revalSrcBillNo == null || currentBillQty.abs().compareTo(revalSrcUnWoffQty.abs()) <= 0) continue;
                int seq = entry.getInt("seq");
                String message = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4e0b\u63a8\u98ce\u9669\uff0c\u5355\u636e\u7f16\u53f7%1$s\u5206\u5f55\u7b2c%2$s\u884c\u7684\u6570\u91cf%3$s\u8d85\u8fc7\u88ab\u91cd\u4f30\u6682\u4f30\u5e94\u4ed8\u5355%4$s\u7684\u672a\u51b2\u56de\u6570\u91cf%5$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RevalBusQtyExcessService_0", (String)"fi-arapcommon", (Object[])new Object[0]), billNo, seq, currentBillQty, revalSrcBillNo, revalSrcUnWoffQty);
                results.add(message);
            }
        }
        return results;
    }
}

