/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.filterscheme;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.fi.arapcommon.filterscheme.FilterSchemeHelper;
import kd.fi.arapcommon.filterscheme.FilterSchemeService;
import kd.fi.arapcommon.filterscheme.IFilterSchemeCallBack;

public class FilterSchemeHandler {
    private String opKey;
    private IFilterSchemeCallBack callBack;
    private IFormView view;

    public FilterSchemeHandler(String opKey, IFilterSchemeCallBack callBack, IFormView view) {
        this.opKey = opKey;
        this.callBack = callBack;
        this.view = view;
    }

    public FilterSchemeHandler(IFormView view) {
        this.view = view;
    }

    public FilterSchemeHandler() {
    }

    public void afterDoOperation() {
        if ("addscheme".equals(this.opKey)) {
            new FilterSchemeService(this.callBack, this.view).add();
        } else if ("savescheme".equals(this.opKey)) {
            new FilterSchemeService(this.callBack, this.view).save();
        } else if ("deletescheme".equals(this.opKey)) {
            new FilterSchemeService(this.callBack, this.view).delete();
        } else if ("setdefault".equals(this.opKey)) {
            new FilterSchemeService(this.callBack, this.view).setDefault();
        } else if ("canceldefault".equals(this.opKey)) {
            new FilterSchemeService(this.callBack, this.view).cancelDefault();
        }
    }

    public void beforeBindData() {
        FilterSchemeHelper helper;
        DynamicObject defaultSchemeStr;
        String isCreateNewData = this.view.getPageCache().get("createnewdata");
        FormShowParameter formShowParameter = this.view.getFormShowParameter();
        Object apCustomParam = formShowParameter.getCustomParam("finapbills");
        Object arCustomParam = formShowParameter.getCustomParam("finarbills");
        if (!ObjectUtils.isEmpty((Object)isCreateNewData) && "true".equals(isCreateNewData) && ObjectUtils.isEmpty((Object)apCustomParam) && ObjectUtils.isEmpty((Object)arCustomParam) && (defaultSchemeStr = (helper = new FilterSchemeHelper(this.view.getEntityId())).getDefaultSchemeStr()) != null) {
            String schemeStr = defaultSchemeStr.getString("schemestr_tag");
            Map schemeMap = (Map)SerializationUtils.fromJsonString((String)schemeStr, Map.class);
            IDataModel model = this.view.getModel();
            model.setValue("settlerelation", schemeMap.get("settlerelation"));
        }
    }

    public void afterBindData() {
        FilterSchemeHelper helper = new FilterSchemeHelper(this.view.getEntityId());
        DynamicObjectCollection schemes = helper.getAllSchemes();
        if (!ObjectUtils.isEmpty((Object)schemes)) {
            helper.setComboItems(schemes, this.view);
            for (DynamicObject scheme : schemes) {
                boolean isDefault = scheme.getBoolean("isdefault");
                if (!isDefault) continue;
                helper.parseFilterScheme(scheme, this.view);
                helper.setButtonVisible(isDefault, this.view);
                return;
            }
        }
        helper.setButtonVisible(false, this.view);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (!"schemes".equals(name)) {
            return;
        }
        if (ObjectUtils.isEmpty((Object)newValue)) {
            this.view.getModel().setValue("schemename", (Object)"");
            return;
        }
        FilterSchemeHelper helper = new FilterSchemeHelper(this.view.getEntityId());
        DynamicObject scheme = helper.queryScheme(Long.parseLong((String)newValue));
        helper.parseFilterScheme(scheme, this.view);
    }
}

