/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.CloseAccountHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.ViewUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCloseAccountList
extends AbstractListPlugin {
    private static final String IS_FIRST_OPEN = "isFirstOpen";
    private static final String SELECT_ALL_ORG = "select_all_org";
    protected static final String OP_CLOSE_ACCOUNT = "closeaccount";
    protected static final String OP_ANTI_CLOSE_ACCOUNT = "anticloseaccount";
    private static final String OP_OPEN_OTHER_LIST = "openotherlist";

    protected abstract List<DynamicObject> getFinishedSettingOrgs();

    protected abstract String getCloseAccountEntity();

    protected abstract String getViewPermissionItemId();

    private List<ComboItem> getOrgFilterItems(List<DynamicObject> orgs) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>(64);
        if (orgs != null && orgs.size() > 0) {
            for (DynamicObject org : orgs) {
                orgItems.add(new ComboItem(new LocaleString(org.getString("name")), org.getString("id")));
            }
        } else {
            orgItems.add(new ComboItem(new LocaleString(""), "0"));
        }
        return orgItems;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        boolean isOpenByHyperLink = "PeriodCloseDetail".equals(customParams.get("source"));
        if (isOpenByHyperLink) {
            String orgPk = customParams.get("org").toString();
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgPk, (String)"bos_org", (String)"name");
            ArrayList<CommonFilterColumn> custFilterColumns = new ArrayList<CommonFilterColumn>();
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilterColumns) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilter.getFieldName();
                if (StringUtils.indexOf((String)fieldName, (String)".") != -1) {
                    fieldName = StringUtils.substringBefore((String)commonFilter.getFieldName(), (String)".");
                }
                if (!"org".equals(fieldName)) continue;
                commonFilter.getComboItems().clear();
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
                comboItems.add(new ComboItem(new LocaleString(org.getLocaleString("name").getLocaleValue()), orgPk));
                commonFilter.setMustInput(true);
                commonFilter.setComboItems(comboItems);
                commonFilter.setDefaultValue(orgPk);
                custFilterColumns.add(commonFilter);
                break;
            }
            args.getCommonFilterColumns().clear();
            args.getCommonFilterColumns().addAll(custFilterColumns);
        } else {
            List<ComboItem> orgFilterItems = this.getOrgFilterItems(this.getFinishedSettingOrgs());
            List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilterColumns) {
                if (!filterColumn.getFieldName().startsWith("org")) continue;
                ((CommonFilterColumn)filterColumn).setComboItems(orgFilterItems);
                if (this.getPageCache().get(IS_FIRST_OPEN) != null) break;
                this.getPageCache().put(IS_FIRST_OPEN, "false");
                filterColumn.setDefaultValue("");
                this.getPageCache().put(SELECT_ALL_ORG, "true");
                break;
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getSearchClickEvent().getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            Object fieldName = ((List)currentCommonFilter.get("FieldName")).get(0);
            List value = (List)currentCommonFilter.get("Value");
            if (fieldName.toString().startsWith("org")) {
                if (!value.isEmpty() && "".equals(value.get(0))) {
                    this.getPageCache().put(SELECT_ALL_ORG, "true");
                } else {
                    this.getPageCache().remove(SELECT_ALL_ORG);
                }
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("org.id".equals(args.getFieldName())) {
            List<DynamicObject> finishedSettingOrgs = this.getFinishedSettingOrgs();
            args.getQfilters().add(new QFilter("id", "in", finishedSettingOrgs.stream().map(org -> org.getLong("id")).collect(Collectors.toSet())));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        boolean isOpenByHyperLink = "PeriodCloseDetail".equals(customParams.get("source"));
        if (isOpenByHyperLink) {
            e.getQFilters().add(QFilter.fromSerializedString((String)customParams.get("filter").toString()));
        } else {
            e.getMainOrgQFilter();
            List qFilters = e.getQFilters();
            if (this.getPageCache().get(SELECT_ALL_ORG) != null) {
                List<DynamicObject> finishedSettingOrgs = this.getFinishedSettingOrgs();
                ArrayList<Long> finishedSettingOrgIds = new ArrayList<Long>(64);
                for (DynamicObject dy : finishedSettingOrgs) {
                    finishedSettingOrgIds.add(dy.getLong("id"));
                }
                qFilters.add(new QFilter("org", "in", finishedSettingOrgIds));
            }
        }
    }

    protected void showCloseAccountsSettingView(String operationKey, String closeAccountEntity, String settingEntity) {
        DynamicObject[] infos;
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractCloseAccountList_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        String caption = null;
        caption = OP_CLOSE_ACCOUNT.equals(operationKey) ? ResManager.loadKDString((String)"\u5173\u8d26", (String)"AbstractCloseAccountList_1", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53cd\u5173\u8d26", (String)"AbstractCloseAccountList_2", (String)"fi-arapcommon", (Object[])new Object[0]);
        for (DynamicObject info : infos = BusinessDataServiceHelper.load((String)closeAccountEntity, (String)"isfinishinit,org", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())})) {
            if (info.getBoolean("isfinishinit")) continue;
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u6ca1\u6709\u542f\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c%2$s\u64cd\u4f5c\u3002", (String)"AbstractCloseAccountList_3", (String)"fi-arapcommon", (Object[])new Object[0]), info.getDynamicObject("org").getString("name"), caption));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(settingEntity);
        fsp.setCaption(caption);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("pks", (Object)selectedRows.getPrimaryKeyValues());
        fsp.setCustomParam("operation", (Object)operationKey);
        CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, operationKey);
        fsp.setCloseCallBack(ccb);
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ((OP_CLOSE_ACCOUNT.equals(actionId) || OP_ANTI_CLOSE_ACCOUNT.equals(actionId)) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            String aimDateStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(returnData);
            OperateOption param = OperateOption.create();
            if (OP_CLOSE_ACCOUNT.equals(actionId)) {
                param.setVariableValue("closedate", aimDateStr);
            } else {
                param.setVariableValue("anticlosedate", aimDateStr);
            }
            this.getView().invokeOperation(actionId, param);
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.setCancel(true);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        int rowIndex = args.getHyperLinkClickEvent().getRowIndex();
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        long entryKey = 0L;
        for (ListSelectedRow row : selectedRows) {
            int rowKey = row.getRowKey();
            if (rowIndex != rowKey) continue;
            entryKey = (Long)row.getEntryPrimaryKeyValue();
            break;
        }
        DynamicObject entry = QueryServiceHelper.queryOne((String)this.getCloseAccountEntity(), (String)"id,org.id,org.number,entryentity.id,entryentity.billtype,entryentity.status,entryentity.duedate,currentdate", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", (Object)entryKey)});
        long orgId = entry.getLong("org.id");
        String billType = entry.getString("entryentity.billtype");
        if (!BaseDataHelper.checkCurrentUserPermission(orgId, this.isAr() ? "ar" : "ap", billType.split("[-]")[0], this.getViewPermissionItemId())) {
            String entityName = MetadataServiceHelper.getDataEntityType((String)billType).getDisplayName().getLocaleValue();
            String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s%2$s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"AbstractCloseAccountList_4", (String)"fi-arapcommon", (Object[])new Object[0]), entry.getString("org.number"), entityName);
            this.getView().showErrorNotification(message);
            return;
        }
        boolean isSimBill = "sim_original_bill".equals(billType);
        if (isSimBill) {
            List<Object> simBillIds = this.querySImBill(orgId, entry.getDate("entryentity.duedate"), entry.getDate("currentdate"));
            ViewUtils.openListPageWithPks(this.getView(), billType, simBillIds, "");
            return;
        }
        if (billType.contains("invoice")) {
            List<Object> billIds = this.queryInvoiceIds(this.isAr(), orgId, entry.getDate("entryentity.duedate"), entry.getDate("currentdate"), entry.getString("entryentity.status"));
            String entityName = this.isAr() ? "ar_invoice" : "ap_invoice";
            ViewUtils.openListPageWithPks(this.getView(), entityName, billIds, "");
            return;
        }
        ListShowParameter lsp = CloseAccountHelper.getListShowParameter(this.isAr(), billType, orgId, entry.getString("entryentity.status"), entry.getDate("entryentity.duedate"), entry.getDate("currentdate"));
        ShowType showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
        lsp.getOpenStyle().setTargetKey(this.getView().getFormShowParameter().getOpenStyle().getTargetKey());
        lsp.getOpenStyle().setShowType(showType);
        lsp.setAppId(this.getView().getFormShowParameter().getAppId());
        CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, OP_OPEN_OTHER_LIST);
        lsp.setCloseCallBack(ccb);
        lsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<Object> queryInvoiceIds(boolean isAr, long orgId, Date duedate, Date currentdate, String billStatus) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("billstatus", "=", (Object)billStatus));
        String dateFieldName = isAr ? "bizdate" : "issuedate";
        filters.add(new QFilter(dateFieldName, "<=", (Object)DateUtils.getDataFormat(duedate, false)));
        filters.add(new QFilter(dateFieldName, ">=", (Object)currentdate));
        String entityName = isAr ? "ar_invoice" : "ap_invoice";
        return QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filters.toArray(new QFilter[0]), (String)"", (int)-1);
    }

    private List<Object> querySImBill(long orgId, Date duedate, Date currentdate) {
        List<Object> ids = new ArrayList<Object>(8);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(new QFilter("orgid", "=", (Object)orgId));
        filters.add(new QFilter("issuetime", ">=", (Object)currentdate));
        filters.add(new QFilter("issuetime", "<=", (Object)duedate));
        filters.add(new QFilter("validstate", "=", (Object)"2"));
        filters.add(new QFilter("billsourcetype", "=", (Object)"A"));
        filters.add(new QFilter("unpushamount", "!=", (Object)BigDecimal.ZERO));
        List simBill = QueryServiceHelper.queryPrimaryKeys((String)"sim_original_bill", (QFilter[])filters.toArray(new QFilter[0]), (String)"", (int)-1);
        if (!simBill.isEmpty()) {
            ids = simBill;
        }
        return ids;
    }

    protected boolean isAr() {
        return "ar_closeaccount".equals(this.getCloseAccountEntity());
    }
}

