/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public abstract class AbstractSettleSchemeEdit
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(AbstractSettleSchemeEdit.class);
    private static final Long groupId_v2 = 4L;

    protected abstract List<Long> getOrgIdList();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"addcard", "addimg", "modifycard", "addlabel", "deleterule"});
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("org");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "in", this.getOrgIdList());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    protected void initUserInfo() {
        DynamicObject user;
        long id = (Long)this.getModel().getValue("id");
        if (id != 0L) {
            user = (DynamicObject)this.getModel().getValue("modifier");
            this.getView().setVisible(Boolean.FALSE, new String[]{"creatoravatar"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"modifieravatar"});
        } else {
            user = (DynamicObject)this.getModel().getValue("creator");
            this.getView().setVisible(Boolean.TRUE, new String[]{"creatoravatar"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"modifieravatar"});
        }
        if (user != null) {
            ((Label)this.getControl("personname")).setText(user.getString("name"));
            DynamicObjectCollection entrys = user.getDynamicObjectCollection("entryentity");
            if (entrys != null && entrys.size() > 0) {
                ((Label)this.getControl("persondpt")).setText(((DynamicObject)entrys.get(0)).getString("dpt.name"));
            }
            ((Label)this.getControl("personphone")).setText(user.getString("phone"));
        }
    }

    private void initOrgEntry() {
        long orgId = RequestContext.get().getOrgId();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"fisaccounting");
        if (!ObjectUtils.isEmpty((Object)org) && org.getBoolean("fisaccounting")) {
            this.getModel().setValue("org", (Object)orgId, 0);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initUserInfo();
        this.initOrgEntry();
        String productVersion = LicenseServiceHelper.getProductVersion();
        logger.info("\u5f53\u524d\u8bb8\u53ef\u8bc1\u53f7:\t" + productVersion);
        if ("3.0".equals(productVersion) || "2.0".equals(productVersion)) {
            LicenseCheckResult resultv2 = LicenseServiceHelper.checkUserInGroup((Long)RequestContext.get().getCurrUserId(), (Long)groupId_v2);
            logger.info("resultv2\u8fd4\u56de\u7ed3\u679c:\t" + resultv2.getHasLicense());
            if (!resultv2.getHasLicense().booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel", "titleapanel"});
                this.getView().showMessage(resultv2.getMsg());
            }
        } else {
            String entityName = this.getView().getFormShowParameter().getFormId();
            LicenseCheckResult result = "ap_settlescheme".equals(entityName) ? LicenseServiceHelper.checkByAppAndBizObj((String)"+HKZHSKFXOX", (String)"ap_settlescheme", (Long)RequestContext.get().getCurrUserId()) : LicenseServiceHelper.checkByAppAndBizObj((String)"/BBRH+122=39", (String)"ar_settlescheme", (Long)RequestContext.get().getCurrUserId());
            logger.info("result\u8fd4\u56de\u7ed3\u679c: \t" + result.getHasLicense());
            if (!result.getHasLicense().booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel", "titleapanel"});
                this.getView().showMessage(result.getMsg());
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String productVersion = LicenseServiceHelper.getProductVersion();
        logger.info("\u5f53\u524d\u8bb8\u53ef\u8bc1\u53f7:\t" + productVersion);
        if ("3.0".equals(productVersion) || "2.0".equals(productVersion)) {
            LicenseCheckResult resultv2 = LicenseServiceHelper.checkUserInGroup((Long)RequestContext.get().getCurrUserId(), (Long)groupId_v2);
            logger.info("resultv2\u8fd4\u56de\u7ed3\u679c:\t" + resultv2.getHasLicense());
            if (!resultv2.getHasLicense().booleanValue()) {
                e.setCancel(true);
                e.setCancelMessage(resultv2.getMsg());
            }
        } else {
            String entityName = e.getFormShowParameter().getFormId();
            LicenseCheckResult result = "ap_settlescheme".equals(entityName) ? LicenseServiceHelper.checkByAppAndBizObj((String)"+HKZHSKFXOX", (String)"ap_settlescheme", (Long)RequestContext.get().getCurrUserId()) : LicenseServiceHelper.checkByAppAndBizObj((String)"/BBRH+122=39", (String)"ar_settlescheme", (Long)RequestContext.get().getCurrUserId());
            logger.info("result\u8fd4\u56de\u7ed3\u679c: \t" + result.getHasLicense());
            if (!result.getHasLicense().booleanValue()) {
                e.setCancel(true);
                e.setCancelMessage(result.getMsg());
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initUserInfo();
        int entryRowCount = this.getModel().getEntryRowCount("ruleentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.showValueByCombo(i, "settlerelation", "settlerelationvalue");
            this.showValueByCombo(i, "timeorder", "timeordervalue");
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("addimg".equals(key) || "addcard".equals(key) || "addlabel".equals(key)) {
            this.addRule();
        } else if ("deleterule".equals(key)) {
            CardEntry operEntry = (CardEntry)this.getControl("ruleentry");
            int focusRow = operEntry.getEntryState().getFocusRow();
            this.getModel().deleteEntryRow("ruleentry", focusRow);
        } else if ("modifycard".equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex("ruleentry");
            this.modifyOperation(index);
        }
    }

    private void modifyOperation(int index) {
        HashMap<String, Object> curRuleData = new HashMap<String, Object>();
        curRuleData.put("settlerelation", this.getModel().getValue("settlerelation", index));
        curRuleData.put("timeorder", this.getModel().getValue("timeorder", index));
        curRuleData.put("description", this.getModel().getValue("description", index));
        curRuleData.put("matchfieldinfo", this.getModel().getValue("matchfieldinfo", index));
        curRuleData.put("asstbill", this.getModel().getValue("asstbill", index));
        curRuleData.put("mainfilter_tag", this.getModel().getValue("mainfilter_tag", index));
        curRuleData.put("asstfilter_tag", this.getModel().getValue("asstfilter_tag", index));
        curRuleData.put("maindatesrc", this.getModel().getValue("maindatesrc", index));
        curRuleData.put("asstdatesrc", this.getModel().getValue("asstdatesrc", index));
        curRuleData.put("oper", "modify");
        this.openRulePage("modifyrule", curRuleData);
    }

    private void addRule() {
        HashMap<String, Object> curRuleData = new HashMap<String, Object>();
        curRuleData.put("oper", "new");
        this.openRulePage("newrule", curRuleData);
    }

    protected abstract String getSettleSchemeRuleEntity();

    private void openRulePage(String closeActionID, Map<String, Object> customParam) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(this.getSettleSchemeRuleEntity());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeActionID));
        parameter.setCustomParams(customParam);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            if ("newrule".equals(e.getActionId())) {
                int rowIndex = this.getModel().createNewEntryRow("ruleentry");
                Map data = (Map)e.getReturnData();
                this.putRuleRowData(rowIndex, data);
            } else if ("modifyrule".equals(e.getActionId())) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("ruleentry");
                Map data = (Map)e.getReturnData();
                this.putRuleRowData(rowIndex, data);
            }
        }
    }

    private void putRuleRowData(int rowIndex, Map<String, Object> data) {
        IDataModel dataModel = this.getModel();
        dataModel.setValue("asstbill", (Object)"", rowIndex);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            dataModel.setValue(entry.getKey(), entry.getValue(), rowIndex);
        }
        this.showValueByCombo(rowIndex, "settlerelation", "settlerelationvalue");
        this.showValueByCombo(rowIndex, "timeorder", "timeordervalue");
    }

    private void showValueByCombo(int rowIndex, String combo, String text) {
        String comboValue = (String)this.getModel().getValue(combo, rowIndex);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(combo);
        ComboProp property = (ComboProp)comboEdit.getProperty();
        List comboItems = property.getComboItems();
        for (ValueMapItem item : comboItems) {
            if (!item.getValue().equals(comboValue)) continue;
            this.getModel().setValue(text, (Object)item.getName(), rowIndex);
            break;
        }
    }
}

