/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.arapcommon.helper.MutexLockHelper;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.service.adjustexch.AdjustExchangeService;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.adjexch.AdjustExchangeResult;

public class AdjustExchangeList
extends AbstractListPlugin {
    private static final String bizSystem = "bizSystem";
    protected static final Log logger = LogFactory.getLog(AdjustExchangeList.class);
    public final String info = ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u6b63\u5728\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AdjustExchangeList_0", (String)"fi-arapcommon", (Object[])new Object[0]);

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "genadjexch": {
                if (!e.getOperationResult().isSuccess()) break;
                this.adjustexch();
            }
        }
    }

    private void adjustexch() {
        String param = this.getParam();
        if (param != null) {
            switch (param.toUpperCase(Locale.ENGLISH)) {
                case "AP": {
                    this.apAdjustexch();
                    break;
                }
                case "AR": {
                    this.arAdjustexch();
                    break;
                }
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustExchangeList_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void arAdjustexch() {
        HashSet<Long> keySet = new HashSet<Long>(1);
        keySet.add(Long.valueOf("arAdjustexch".hashCode()));
        MutexLockHelper.requireMutex("ap_adjexchbill", keySet, "tbladjustexch", this.info);
        try {
            IListView listView = (IListView)this.getView();
            List selectedMainOrgIds = listView.getSelectedMainOrgIds();
            if (selectedMainOrgIds.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6\u672a\u9009\u4e2d\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u751f\u6210\u8c03\u6c47\u5355\u3002", (String)"AdjustExchangeList_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            ArrayList<AdjustExchangeResult> adjustExchangeResults = new ArrayList<AdjustExchangeResult>(selectedMainOrgIds.size());
            for (Long orgId : selectedMainOrgIds) {
                AdjustExchangeService adjustExchangeService = new AdjustExchangeService();
                adjustExchangeResults.add(adjustExchangeService.adjustExchange("AR", orgId, false, null, null, null));
            }
            boolean isSuccess = true;
            for (AdjustExchangeResult result : adjustExchangeResults) {
                if (result.isSuccess()) continue;
                isSuccess = false;
            }
            if (isSuccess) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u6c47\u5355\u751f\u6210\u6210\u529f\u3002", (String)"AdjustExchangeList_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6c47\u5355\u5931\u8d25", (String)"AdjustExchangeList_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        finally {
            logger.info("--------\u5b9e\u4f53\u540d\uff1aar_adjexchbill\uff0c\u91ca\u653e\u4e92\u65a5\u9501--------");
            MutexLockHelper.batchRelease("ap_adjexchbill", keySet, "tbladjustexch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apAdjustexch() {
        HashSet<Long> keySet = new HashSet<Long>(1);
        keySet.add(Long.valueOf("apAdjustexch".hashCode()));
        MutexLockHelper.requireMutex("ap_adjexchbill", keySet, "tbladjustexch", this.info);
        try {
            IListView listView = (IListView)this.getView();
            List selectedMainOrgIds = listView.getSelectedMainOrgIds();
            if (selectedMainOrgIds.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6\u672a\u9009\u4e2d\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u751f\u6210\u8c03\u6c47\u5355\u3002", (String)"AdjustExchangeList_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            ArrayList<AdjustExchangeResult> adjustExchangeResults = new ArrayList<AdjustExchangeResult>(selectedMainOrgIds.size());
            for (Long orgId : selectedMainOrgIds) {
                AdjustExchangeService adjustExchangeService = new AdjustExchangeService();
                adjustExchangeResults.add(adjustExchangeService.adjustExchange("AP", orgId, false, null, null, null));
            }
            boolean isSuccess = true;
            for (AdjustExchangeResult result : adjustExchangeResults) {
                if (result.isSuccess()) continue;
                isSuccess = false;
            }
            if (isSuccess) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u6c47\u5355\u751f\u6210\u6210\u529f\u3002", (String)"AdjustExchangeList_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6c47\u5355\u5931\u8d25", (String)"AdjustExchangeList_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        finally {
            logger.info("--------\u5b9e\u4f53\u540d\uff1aap_adjexchbill\uff0c\u91ca\u653e\u4e92\u65a5\u9501--------");
            MutexLockHelper.batchRelease("ap_adjexchbill", keySet, "tbladjustexch");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List<ComboItem> orgFilterItems = this.getOrgFilterItems(this.getFinishedSettingOrgs());
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Object initOrg = this.getView().getFormShowParameter().getCustomParam("initOrg");
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if ("gl_periodclosedetails".equals(parentFormId)) {
            for (CommonFilterColumn filterColumn : commonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!fieldName.startsWith("org")) continue;
                filterColumn.setComboItems(orgFilterItems);
                filterColumn.setDefaultValue("");
                break;
            }
        } else {
            for (CommonFilterColumn filterColumn : commonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!fieldName.startsWith("org")) continue;
                filterColumn.setComboItems(orgFilterItems);
                if (!ObjectUtils.isEmpty((Object)initOrg)) {
                    filterColumn.setDefaultValue(initOrg.toString());
                } else {
                    Long orgId = RequestContext.get().getOrgId();
                    ComboItem curOrgId = new ComboItem(new LocaleString("curOrg"), orgId.toString());
                    if (EmptyUtils.isNotEmpty(orgId) && orgFilterItems.contains(curOrgId)) {
                        filterColumn.setDefaultValues(new Object[]{orgId.toString()});
                    } else {
                        filterColumn.setDefaultValue(orgFilterItems.get(0).getValue());
                    }
                }
                break;
            }
        }
    }

    private List<ComboItem> getOrgFilterItems(List<DynamicObject> orgs) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        if (orgs != null && orgs.size() > 0) {
            for (DynamicObject org : orgs) {
                orgItems.add(new ComboItem(new LocaleString(org.getString("name")), org.getString("id")));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u5b58\u5728\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\u7684\u7ec4\u7ec7", (String)"AdjustExchangeList_5", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return orgItems;
    }

    private List<DynamicObject> getFinishedSettingOrgs() {
        DynamicObject[] finishSettingInitInfos;
        LinkedList<DynamicObject> finishedSettingOrgs = new LinkedList<DynamicObject>();
        Long userId = RequestContext.get().getCurrUserId();
        String param = ObjectUtils.isEmpty((Object)this.getParam()) ? "AP" : this.getParam();
        DynamicObjectCollection orgs = AdjustExchangeList.getAuthorizedBankOrg(userId, AdjustExchHelper.getAdjExchBillEntityName("AR".equalsIgnoreCase(this.getParam())), "47150e89000000ac", "fisaccounting", param);
        String entityInit = "AP".equalsIgnoreCase(param) ? "ap_init" : "ar_init";
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", AdjustExchangeList.getIdList((List<DynamicObject>)orgs))};
        for (DynamicObject info : finishSettingInitInfos = BusinessDataServiceHelper.load((String)entityInit, (String)"org", (QFilter[])filters)) {
            finishedSettingOrgs.add(info.getDynamicObject("org"));
        }
        return finishedSettingOrgs;
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String entityID, String permissionItem, String attributes, String appID) {
        Map orgMap;
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appID.toLowerCase(), (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(attributes, "=", (Object)Boolean.TRUE);
        if (result.hasAllOrgPerm()) {
            orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = result.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgMap.values()) {
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    public static List<Long> getIdList(List<DynamicObject> orgList) {
        ArrayList<Long> idList = new ArrayList<Long>(orgList.size());
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List orgIds = (List)listShowParameter.getCustomParam("orgFilter");
        List periodIds = (List)listShowParameter.getCustomParam("periodFilter");
        Boolean isAdjExchRecordJump = (Boolean)listShowParameter.getCustomParam("isadjexchrecordjump");
        List qFilters = e.getQFilters();
        if (EmptyUtils.isNotEmpty(isAdjExchRecordJump) && isAdjExchRecordJump.equals(Boolean.TRUE)) {
            qFilters.add(new QFilter("bizsystem", "=", (Object)this.getParam()));
            qFilters.add(new QFilter("org", "in", (Object)orgIds));
            qFilters.add(new QFilter("period", "in", (Object)periodIds));
        } else if (!"botp_trackerlist".equals(this.getView().getFormShowParameter().getFormId())) {
            qFilters.add(new QFilter("bizsystem", "=", (Object)this.getParam()));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = billList.getFocusRowPkId();
        args.setCancel(true);
        BillShowParameter param = new BillShowParameter();
        param.setPkId(pkId);
        param.setStatus(OperationStatus.EDIT);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setFormId(AdjustExchHelper.getAdjExchBillEntityName("AR".equalsIgnoreCase(this.getParam())));
        this.getView().showForm((FormShowParameter)param);
    }

    private String getParam() {
        String param = (String)this.getView().getFormShowParameter().getCustomParam(bizSystem);
        if (EmptyUtils.isEmpty(param)) {
            String serviceAppID = this.getView().getFormShowParameter().getServiceAppId();
            if (EmptyUtils.isEmpty(serviceAppID)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u5f02\u5e38", (String)"AdjustExchangeList_6", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
            param = serviceAppID.toUpperCase();
        }
        return param;
    }
}

