/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;

public class ArApExecControlEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.filterBizObj();
        this.addClickListeners(new String[]{"datafilter"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("datafilter".equals(key)) {
            DynamicObject bizobj = (DynamicObject)this.getModel().getValue("bizobj");
            if (bizobj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"ArApExecControlEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
            String entityName = bizobj.getString("id");
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("datafilterjson");
            String conditionJson = (String)this.getModel().getValue(largeTextEdit.getTagFieldKey());
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
            HashSet<String> selectedEntity = new HashSet<String>();
            selectedEntity.add(mainType.getName());
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
            parameter.getSelectedEntity().addAll(selectedEntity);
            TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, null);
            String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
            this.showConditionForm(conditionJson, entityName, fldNodes, key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("datafilter".equals(actionId) && StringUtils.isNotBlank((CharSequence)(returnData = (String)e.getReturnData()))) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
            this.getModel().setValue("datafilterjson_tag", (Object)returnData);
            if (condition.getExprDesc().length() > 255) {
                this.getModel().setValue("datafilter", (Object)condition.getExprDesc().substring(0, 255));
            } else {
                this.getModel().setValue("datafilter", (Object)condition.getExprDesc());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeDatas = e.getChangeSet();
        Object newValue = changeDatas[0].getNewValue();
        Object oldValue = changeDatas[0].getOldValue();
        switch (key) {
            case "apptype": {
                if (newValue == oldValue) break;
                this.getModel().setValue("bizobj", null);
                break;
            }
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(true));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void filterBizObj() {
        BasedataEdit bizObjF7 = (BasedataEdit)this.getControl("bizobj");
        bizObjF7.addBeforeF7SelectListener(evt -> {
            String appType = this.getModel().getValue("apptype").toString();
            List<String> bizTypeNumberList = this.getBizTypeNumber(appType);
            QFilter filter = new QFilter("number", "in", bizTypeNumberList);
            ListFilterParameter lfp = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            lfp.getQFilters().add(filter);
        });
    }

    private List<String> getBizTypeNumber(String appType) {
        ArrayList<String> list = new ArrayList<String>();
        if ("ar".equals(appType)) {
            list.add("ar_busbill");
            list.add("ar_finarbill");
            list.add("ar_revcfmbill");
            list.add("ar_invoice");
            list.add("cas_recbill");
            list.add("ar_liquidation");
            list.add("ar_baddebtlossbill");
            list.add("ar_receivedbill");
        } else if ("ap".equals(appType)) {
            list.add("ap_busbill");
            list.add("ap_finapbill");
            list.add("ap_payapply");
            list.add("cas_paybill");
            list.add("ap_invoice");
            list.add("ap_liquidation");
            list.add("ap_paidbill");
        }
        return list;
    }
}

