/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.SubmitAndNew;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.service.plan.FinPlanRowService;
import kd.fi.arapcommon.service.plan.PlanRow;
import kd.fi.arapcommon.util.DateUtils;

@Deprecated
public class ArApPlanEdit
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntry(0);
    }

    private void initEntry(int i) {
        DynamicObject settlementType;
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        Date duedate = (Date)this.getModel().getValue("duedate");
        if (this.getModel().getValue("planduedate", i) == null) {
            this.getModel().setValue("planduedate", (Object)duedate, i);
        }
        if (!ObjectUtils.isEmpty((Object)(settlementType = (DynamicObject)this.getModel().getValue("settlementtype")))) {
            this.getModel().setValue("plansettletype", settlementType.getPkValue(), i);
        }
        DateEdit plandutedate = (DateEdit)this.getView().getControl("planduedate");
        if (duedate != null && bizdate != null) {
            plandutedate.setMaxDate(DateUtils.getDataFormat(duedate, false));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isBotpNew()) {
            String entityId = this.getView().getEntityId();
            if ("ar_busbill".equals(entityId)) {
                this.getModel().setValue("paycond", null);
            } else {
                DynamicObject payCondition = (DynamicObject)this.getModel().getValue("paycond");
                if (payCondition != null && !payCondition.getBoolean("paybill")) {
                    this.getModel().setValue("paycond", null);
                }
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"paycond"});
            int count = this.getModel().getEntryRowCount("planentity");
            if (count > 1) {
                return;
            }
            if (count == 0) {
                this.getModel().insertEntryRow("planentity", 0);
                this.initEntry(0);
                this.setOneRowAmount();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        int index = changeData[0].getRowIndex();
        switch (key) {
            case "planpricetax": {
                BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate");
                this.entryAmtChanged(exchangeRate, index);
            }
        }
    }

    private void setOneRowAmount() {
        int rowcount = this.getModel().getEntryRowCount("planentity");
        if (rowcount == 1) {
            BigDecimal sumpricetax = (BigDecimal)this.getModel().getValue(this.getAmountKey());
            this.getModel().setValue("planpricetax", (Object)sumpricetax, 0);
        }
    }

    private boolean isBusBill() {
        boolean isBusBill = false;
        switch (this.getView().getEntityId()) {
            case "ar_busbill": 
            case "ap_busbill": {
                isBusBill = true;
            }
        }
        return isBusBill;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save || source instanceof Submit || source instanceof SubmitAndNew) {
            this.checkAmount(args);
        }
        if (source instanceof DeleteEntry && Objects.equals("deleteplanentry", ((DeleteEntry)source).getOperateKey())) {
            int planRowCount = this.getModel().getEntryRowCount("planentity");
            args.setCancel(planRowCount == 1);
        }
    }

    private void checkAmount(BeforeDoOperationEventArgs args) {
        String Entityname = this.getModel().getDataEntity().getDataEntityType().toString();
        BigDecimal sumpricetax = (BigDecimal)this.getModel().getValue(this.getAmountKey());
        Object source = args.getSource();
        String operte = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ArApPlanEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]);
        if (source instanceof Save) {
            operte = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ArApPlanEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        BigDecimal pricetax = BigDecimal.ZERO;
        int count = this.getModel().getEntryRowCount("planentity");
        for (int i = 0; i < count; ++i) {
            pricetax = pricetax.add((BigDecimal)this.getModel().getValue("planpricetax", i));
        }
        if (sumpricetax.compareTo(pricetax) != 0) {
            if (Entityname.contains("ar_")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u201c\u5e94\u6536\u91d1\u989d\u201d\u5408\u8ba1\u4e0e\u6574\u5355\u201c\u5e94\u6536\u91d1\u989d\u201d\u4e00\u81f4\u624d\u80fd%s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ArApPlanEdit_2", (String)"fi-arapcommon", (Object[])new Object[0]), operte));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u4e2d\u201c\u5e94\u4ed8\u91d1\u989d\u201d\u5408\u8ba1\u4e0e\u6574\u5355\u201c\u5e94\u4ed8\u91d1\u989d\u201d\u4e00\u81f4\u624d\u80fd%s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ArApPlanEdit_3", (String)"fi-arapcommon", (Object[])new Object[0]), operte));
            }
            args.setCancel(true);
            return;
        }
        this.reCalcPlanAmt();
    }

    public void reCalcPlanAmt() {
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (!"A".equals(billstatus)) {
            return;
        }
        int planentityRowCount = this.getModel().getEntryRowCount("planentity");
        if (planentityRowCount > 1) {
            BigDecimal headPricetax = (BigDecimal)this.getModel().getValue(this.getAmountKey());
            BigDecimal headPricetaxloc = (BigDecimal)this.getModel().getValue(this.getAmountLocKey());
            BigDecimal planPricetax = BigDecimal.ZERO;
            BigDecimal planPricetaxloc = BigDecimal.ZERO;
            int endRowNumber = planentityRowCount - 1;
            for (int i = 0; i < endRowNumber; ++i) {
                planPricetax = planPricetax.add((BigDecimal)this.getModel().getValue("planpricetax", i));
                planPricetaxloc = planPricetaxloc.add((BigDecimal)this.getModel().getValue("planpricetaxloc", i));
            }
            BigDecimal endRowPlanPricetax = headPricetax.subtract(planPricetax);
            BigDecimal endRowPlanPricetaxloc = headPricetaxloc.subtract(planPricetaxloc);
            this.getModel().setValue("planpricetax", (Object)endRowPlanPricetax, endRowNumber);
            this.getModel().setValue("planpricetaxloc", (Object)endRowPlanPricetaxloc, endRowNumber);
            this.getModel().setValue("p_uninvoicedamt", (Object)endRowPlanPricetax, endRowNumber);
            this.getModel().setValue("p_uninvoicedlocamt", (Object)endRowPlanPricetaxloc, endRowNumber);
        }
    }

    private String getAmountLocKey() {
        String Entityname = this.getModel().getDataEntity().getDataEntityType().toString();
        if (Entityname.contains("ar_")) {
            return "reclocalamt";
        }
        return "pricetaxtotalbase";
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if ("planentity".equals(e.getEntryProp().getName())) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                this.initEntry(row.getRowIndex());
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.setOneRowAmount();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "newplanentry": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("planentity");
                this.getModel().setValue("planduedate", this.getModel().getValue("duedate"), rowIndex);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        int rowcount = this.getModel().getEntryRowCount("planentity");
        if (rowcount < 1) {
            this.getModel().batchCreateNewEntryRow("planentity", 1);
        }
        this.initEntry(0);
        this.initPlanDisposeAmount();
    }

    private void initPlanDisposeAmount() {
        BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate");
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ZERO;
        }
        int count = this.getModel().getEntryRowCount("planentity");
        for (int index = 0; index < count; ++index) {
            this.entryAmtChanged(exchangeRate, index);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObjectCollection planEntry = this.getModel().getEntryEntity("planentity");
        if (this.isPlanEntryEmpty(planEntry)) {
            this.rebuildPlanEntry();
        }
    }

    private boolean isPlanEntryEmpty(DynamicObjectCollection planEntry) {
        if (planEntry == null || planEntry.isEmpty()) {
            return true;
        }
        for (DynamicObject planRow : planEntry) {
            BigDecimal planAmt = planRow.getBigDecimal("planpricetax");
            if (planAmt == null || planAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private void rebuildPlanEntry() {
        FinPlanRowService planRowService = BeanFactory.getBean(FinPlanRowService.class, new Object[0]);
        List<PlanRow> planRows = planRowService.calculatePlanRows(this.getModel().getDataEntity());
        Object settlementType = this.getModel().getValue("settlementtype");
        if (settlementType instanceof DynamicObject) {
            DynamicObject obj = (DynamicObject)settlementType;
            settlementType = obj.getPkValue();
        }
        int currentRowCount = this.getModel().getEntryRowCount("planentity");
        int diffRowCount = planRows.size() - currentRowCount;
        if (diffRowCount > 0) {
            this.getModel().batchCreateNewEntryRow("planentity", diffRowCount);
        } else if (diffRowCount < 0) {
            int[] deleteRowIndexs = new int[Math.abs(diffRowCount)];
            for (int i = 0; i < Math.abs(diffRowCount); ++i) {
                deleteRowIndexs[i] = currentRowCount - i - 1;
            }
            this.getModel().deleteEntryRows("planentity", deleteRowIndexs);
        }
        IDataModel model = this.getModel();
        Date planMaxDuedate = null;
        for (int i = 0; i < planRows.size(); ++i) {
            PlanRow planRow = planRows.get(i);
            Date palnDuedate = planRow.getDueDate();
            BigDecimal planAmt = planRow.getPlanAmt();
            this.getModel().setValue("planpricetax", (Object)planAmt, i);
            this.getModel().setValue("p_uninvoicedamt", (Object)planAmt, i);
            this.getModel().setValue("planduedate", (Object)palnDuedate, i);
            this.getModel().setValue("plansettletype", settlementType, i);
            if (planMaxDuedate == null) {
                planMaxDuedate = palnDuedate;
                continue;
            }
            if (palnDuedate == null) continue;
            planMaxDuedate = palnDuedate.after(planMaxDuedate) ? palnDuedate : planMaxDuedate;
        }
        this.calculateLocalAmount();
        if (planMaxDuedate != null) {
            model.setValue("duedate", planMaxDuedate);
        }
    }

    private void calculateLocalAmount() {
        BigDecimal exchanegRate = (BigDecimal)this.getModel().getValue("exchangerate");
        int count = this.getModel().getEntryRowCount("planentity");
        for (int rowIndex = count - 1; rowIndex >= 0; --rowIndex) {
            this.setEntryBase("planpricetax", "planpricetaxloc", rowIndex, exchanegRate);
            this.setEntryBase("p_uninvoicedamt", "p_uninvoicedlocamt", rowIndex, exchanegRate);
        }
    }

    private void setEntryBase(String fieldName, String localFieldName, int rowIndex, BigDecimal exchangeRate) {
        IDataModel model = this.getModel();
        BigDecimal amount = (BigDecimal)model.getValue(fieldName, rowIndex);
        amount = amount == null ? BigDecimal.ZERO : amount;
        BigDecimal localAmount = amount.multiply(exchangeRate);
        model.setValue(localFieldName, (Object)localAmount, rowIndex);
    }

    private void entryAmtChanged(BigDecimal exchangeRate, int index) {
        BigDecimal planpricetax = (BigDecimal)this.getModel().getValue("planpricetax", index);
        BigDecimal localamount = null;
        localamount = planpricetax.multiply(exchangeRate);
        this.getModel().setValue("planpricetaxloc", (Object)localamount, index);
        if (this.isBusBill()) {
            this.getModel().setValue("p_uninvoicedamt", (Object)planpricetax, index);
            this.getModel().setValue("p_uninvoicedlocamt", (Object)localamount, index);
        } else {
            this.getModel().setValue("unplanlockamt", (Object)planpricetax, index);
            this.getModel().setValue("unplansettleamt", (Object)planpricetax, index);
            this.getModel().setValue("unplansettlelocamt", (Object)localamount, index);
        }
    }

    private String getAmountKey() {
        String Entityname = this.getModel().getDataEntity().getDataEntityType().toString();
        if (Entityname.contains("ar_")) {
            return "recamount";
        }
        return "pricetaxtotal";
    }

    protected boolean isBotpNew() {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        return this.isBotpCreate() && ObjectUtils.isEmpty((Object)billShowParameter.getPkId());
    }

    protected boolean isBotpCreate() {
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        return !ObjectUtils.isEmpty((Object)sourceBillType);
    }
}

