/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

public class BillCheckEdit
extends AbstractBasePlugIn {
    private static final String F_checkCondition_expr = "checkconditionexpr";
    private static final String F_checkCondition_json = "checkconditionjson";
    private MainEntityType mainType;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.VIEW.equals((Object)status)) {
            this.addClickListeners(new String[]{F_checkCondition_expr});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("checkmode".equals(name)) {
            this.checkModeChanged(newValue.toString(), Boolean.TRUE);
        }
    }

    private void checkModeChanged(String checkMode, Boolean changed) {
        if ("plugin".equals(checkMode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"plugin"});
            this.getView().setVisible(Boolean.FALSE, new String[]{F_checkCondition_expr});
            if (changed.booleanValue()) {
                this.getModel().setValue("plugin", null);
            }
            this.getModel().setValue(F_checkCondition_expr, null);
            this.getModel().setValue(F_checkCondition_json, null);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"plugin"});
            this.getView().setVisible(Boolean.TRUE, new String[]{F_checkCondition_expr});
            this.getModel().setValue("plugin", (Object)"kd.fi.arapcommon.service.check.impl.CustomDefaultCheck");
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String checkmode = (String)this.getModel().getValue("checkmode");
        this.checkModeChanged(checkmode, Boolean.FALSE);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "checkconditionexpr": {
                DynamicObject bizobj = (DynamicObject)this.getModel().getValue("bizobj");
                if (bizobj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"BillCheckEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    return;
                }
                this.showCondition(key);
            }
        }
    }

    private void showCondition(String sourceFldKey) {
        LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl(F_checkCondition_json);
        String conditionJson = (String)this.getModel().getValue(largeTextEdit.getTagFieldKey());
        MainEntityType mainType = this.getMainType();
        HashSet<String> selectedEntity = new HashSet<String>();
        selectedEntity.add(mainType.getName());
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainType);
        parameter.getSelectedEntity().addAll(selectedEntity);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, null);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(conditionJson, mainType.getName(), true, fldNodes, sourceFldKey);
    }

    private MainEntityType getMainType() {
        DynamicObject entityObject;
        if (this.mainType == null && (entityObject = (DynamicObject)this.getModel().getValue("bizobj")) != null) {
            String entityKey = entityObject.getString("number");
            this.mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        }
        return this.mainType;
    }

    private void showConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (F_checkCondition_expr.equals(actionId) && StringUtils.isNotBlank((CharSequence)(returnData = (String)e.getReturnData()))) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
            this.getModel().setValue("checkconditionjson_tag", (Object)returnData);
            if (condition.getExprDesc().length() > 255) {
                this.getModel().setValue(F_checkCondition_expr, (Object)condition.getExprDesc().substring(0, 255));
            } else {
                this.getModel().setValue(F_checkCondition_expr, (Object)condition.getExprDesc());
            }
        }
    }
}

