/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;

public class BillTypePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String BIZTYPE = "biztype";
    private static final String LINETYPE = "linetype";
    private Map<Long, Boolean> paramCache = new HashMap<Long, Boolean>(8);
    private boolean isCopyEntryRow = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit lineTypeControl = (BasedataEdit)this.getView().getControl(LINETYPE);
        lineTypeControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizTypeControl = (BasedataEdit)this.getView().getControl(BIZTYPE);
        bizTypeControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialControl = (BasedataEdit)this.getView().getControl(this.getMaterialKey());
        materialControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        materialControl.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit asstactControl = (BasedataEdit)this.getView().getControl("asstact");
        asstactControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject billType = (DynamicObject)this.getModel().getValue(this.getBillTypeFieldKey());
        DynamicObject bizType = (DynamicObject)this.getModel().getValue(BIZTYPE);
        switch (key) {
            case "linetype": {
                if (bizType == null) {
                    QFilter filter = new QFilter("id", "=", (Object)0L);
                    showParameter.getListFilterParameter().setFilter(filter);
                    return;
                }
                Set<Long> lineTypeIds = LineTypeHelper.getAllLineTypeIds(bizType.getLong("id"));
                QFilter lineTypeFilter = new QFilter("id", "in", lineTypeIds);
                showParameter.getListFilterParameter().setFilter(lineTypeFilter);
                break;
            }
            case "biztype": {
                long billTypeId = 0L;
                if (!ObjectUtils.isEmpty((Object)billType)) {
                    billTypeId = billType.getLong("id");
                }
                List<Long> bizTypes = LineTypeHelper.getAllBizTypeIds(billTypeId);
                QFilter qFilter = new QFilter("id", "in", bizTypes);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "material": 
            case "e_material": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (ObjectUtils.isEmpty((Object)org)) {
                    return;
                }
                Boolean param = this.getParam(org.getLong("id"));
                if (!param.booleanValue()) {
                    return;
                }
                int index = this.getModel().getEntryCurrentRowIndex(this.getDetailEntryKey());
                DynamicObject lineType = (DynamicObject)this.getModel().getValue(LINETYPE, index);
                if (billType == null || bizType == null || lineType == null) {
                    QFilter filter = new QFilter("id", "=", (Object)0L);
                    showParameter.getListFilterParameter().setFilter(filter);
                    return;
                }
                LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
                QFilter[] materialFilters = LineTypeHelper.getMaterialFilterByLineType(billType.getLong("id"), bizType.getLong("id"), lineType.getLong("id"));
                if (materialFilters != null) {
                    Object value = materialFilters[0].getValue();
                    QFilter materialIdFilter = QFilter.sqlExpress((String)"id", (String)"in", (String)("(select fid from t_bd_mtsserviceattribute where fbasedataid = " + value + ")"));
                    qFilters.add(materialIdFilter);
                }
                if ("6".equals(bizType.getString("domain"))) {
                    qFilters.add(new QFilter("enablevmi", "=", (Object)Boolean.TRUE));
                }
                if ("604".equals(bizType.getString("number")) || "6041".equals(bizType.getString("number"))) {
                    qFilters.add(new QFilter("enableproduct", "=", (Object)Boolean.TRUE));
                }
                if ("115".equals(bizType.getString("number")) || "1151".equals(bizType.getString("number"))) {
                    qFilters.add(new QFilter("enableoutsource", "=", (Object)Boolean.TRUE));
                }
                showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
                break;
            }
            case "asstact": {
                DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
                if (ObjectUtils.isEmpty((Object)orgObj)) {
                    return;
                }
                Boolean lineTypeParam = this.getParam(orgObj.getLong("id"));
                if (!lineTypeParam.booleanValue()) {
                    return;
                }
                String asstactType = (String)this.getModel().getValue("asstacttype");
                if (bizType == null || !"bd_supplier".equals(asstactType)) {
                    return;
                }
                String domain = bizType.getString("domain");
                if (!"6".equals(domain)) {
                    return;
                }
                QFilter supplierFilter = new QFilter("enablevmi", "=", (Object)Boolean.TRUE);
                showParameter.getListFilterParameter().setFilter(supplierFilter);
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        Control source = (Control)afterF7SelectEvent.getSource();
        String key = source.getKey();
        if ("e_material".equals(key) || "material".equals(key)) {
            int currentRowIndex = afterF7SelectEvent.getCurrentRowIndex();
            ListSelectedRowCollection listSelectedRowCollection = afterF7SelectEvent.getListSelectedRowCollection();
            if (listSelectedRowCollection.size() > 1) {
                DynamicObject lineType = (DynamicObject)this.getModel().getValue(LINETYPE, currentRowIndex);
                long lineTypeId = lineType == null ? 0L : lineType.getLong("id");
                for (int i = 1; i < listSelectedRowCollection.size(); ++i) {
                    this.getModel().setValue(LINETYPE, (Object)lineTypeId, currentRowIndex + i);
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if ("true".equals(this.getPageCache().get("isWebApi"))) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        long orgId = org.getLong("id");
        Boolean param = this.getParam(orgId);
        if (!param.booleanValue()) {
            return;
        }
        DynamicObject billType = (DynamicObject)this.getModel().getValue(this.getBillTypeFieldKey());
        if (ObjectUtils.isEmpty((Object)billType)) {
            return;
        }
        long defaultBizTypeId = LineTypeHelper.getDefaultBizTypeId(billType.getLong("id"));
        this.getModel().setValue(BIZTYPE, (Object)defaultBizTypeId);
        long defaultLineTypeId = LineTypeHelper.getDefaultLineTypeId(defaultBizTypeId);
        this.getModel().setValue(LINETYPE, (Object)defaultLineTypeId, 0);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        long orgId = org.getLong("id");
        Boolean param = this.getParam(orgId);
        if (!param.booleanValue()) {
            this.getModel().setValue(BIZTYPE, null);
            int entryRowCount = this.getModel().getEntryRowCount(this.getDetailEntryKey());
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue(LINETYPE, null, i);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        long orgId = org.getLong("id");
        Boolean param = this.getParam(orgId);
        if (!param.booleanValue()) {
            DynamicObject billType = (DynamicObject)this.getModel().getValue(this.getBillTypeFieldKey());
            if (!ObjectUtils.isEmpty((Object)billType) && ("arfin_borrowar_BT_S".equals(billType.getString("number")) || "ApFin_borr_BT_S".equals(billType.getString("number")))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{BIZTYPE});
                BasedataEdit bizTypeControl = (BasedataEdit)this.getView().getControl(BIZTYPE);
                bizTypeControl.setMustInput(false);
                BasedataEdit lineTypeControl = (BasedataEdit)this.getView().getControl(LINETYPE);
                lineTypeControl.setMustInput(false);
                return;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{BIZTYPE});
            return;
        }
        BasedataEdit lineTypeControl = (BasedataEdit)this.getView().getControl(LINETYPE);
        lineTypeControl.setMustInput(true);
        this.getView().setVisible(Boolean.TRUE, new String[]{BIZTYPE});
        BasedataEdit bizTypeControl = (BasedataEdit)this.getView().getControl(BIZTYPE);
        bizTypeControl.setMustInput(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeValues = e.getChangeSet();
        Object newValue = changeValues[0].getNewValue();
        int currentIndex = changeValues[0].getRowIndex();
        if (!BIZTYPE.equals(key) && LINETYPE.equals(key)) {
            if (newValue == null) {
                return;
            }
            Long lineTypeServiceAttributeId = ((DynamicObject)newValue).getLong("serviceattribute.id");
            DynamicObject relatedEntity = QueryServiceHelper.queryOne((String)"bd_serviceattribute", (String)"entity.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)lineTypeServiceAttributeId)});
            String entityNumber = relatedEntity.getString("entity.number");
            if ("bd_material".equals(entityNumber)) {
                DynamicObject material = (DynamicObject)this.getModel().getValue(this.getMaterialKey(), currentIndex);
                if (material == null) {
                    return;
                }
                DynamicObjectCollection materialServiceAttrributes = material.getDynamicObjectCollection("serviceattribute");
                List<Object> materialServiceAttrributeIds = DynamicObjectHelper.getIdList4MultiBase(materialServiceAttrributes);
                if (!materialServiceAttrributeIds.contains(lineTypeServiceAttributeId)) {
                    this.getModel().setValue(this.getMaterialKey(), null, currentIndex);
                }
            } else if ("er_expenseitemedit".equals(entityNumber)) {
                this.getModel().setValue(this.getExpenseItemKey(), null, currentIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (Objects.equals("copyentryrow", key)) {
            this.isCopyEntryRow = true;
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        if (this.isCopyEntryRow || !this.getDetailEntryKey().equals(entryProp.getName())) {
            return;
        }
        DynamicObject bizType = (DynamicObject)this.getModel().getValue(BIZTYPE);
        if (bizType == null) {
            return;
        }
        long lineTypeId = LineTypeHelper.getDefaultLineTypeId(bizType.getLong("id"));
        for (RowDataEntity row : e.getRowDataEntities()) {
            this.getModel().beginInit();
            this.getModel().setValue(LINETYPE, (Object)lineTypeId, row.getRowIndex());
            this.getModel().endInit();
            this.getView().updateView(LINETYPE, row.getRowIndex());
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        long orgId = org.getLong("id");
        Boolean param = this.getParam(orgId);
        if (!param.booleanValue()) {
            return;
        }
        this.getModel().setValue(BIZTYPE, (Object)this.getBizTypeIdafterImport());
        int count = this.getModel().getEntryRowCount(this.getDetailEntryKey());
        for (int i = 0; i < count; ++i) {
            this.getModel().setValue(LINETYPE, (Object)this.getLineTypeafterImport(i), i);
            this.getModel().setValue("materialname", (Object)this.getMaterialNameafterImport(i), i);
        }
    }

    private long getBizTypeIdafterImport() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue(this.getBillTypeFieldKey());
        if (ObjectUtils.isEmpty((Object)billType)) {
            return 0L;
        }
        DynamicObject bizType = (DynamicObject)this.getModel().getValue(BIZTYPE);
        if (bizType != null && LineTypeHelper.checkBizTypeinBillType(bizType.getLong("id"), billType.getLong("id"))) {
            return bizType.getLong("id");
        }
        return LineTypeHelper.getDefaultBizTypeId(billType.getLong("id"));
    }

    private long getLineTypeafterImport(int index) {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue(BIZTYPE);
        if (ObjectUtils.isEmpty((Object)bizType)) {
            return 0L;
        }
        DynamicObject lineType = (DynamicObject)this.getModel().getValue(LINETYPE, index);
        if (lineType != null && LineTypeHelper.checkLineTypeinBizType(lineType.getLong("id"), bizType.getLong("id"))) {
            return lineType.getLong("id");
        }
        return LineTypeHelper.getDefaultLineTypeId(bizType.getLong("id"));
    }

    private String getMaterialNameafterImport(int index) {
        String materialName = "";
        DynamicObject material = (DynamicObject)this.getModel().getValue(this.getMaterialKey(), index);
        if (ObjectUtils.isEmpty((Object)material)) {
            return materialName;
        }
        boolean isDisposable = material.getBoolean("isdisposable");
        if (!isDisposable) {
            materialName = material.getLocaleString("name").toString();
        }
        return materialName;
    }

    private Boolean getParam(long orgId) {
        Boolean param = null;
        if (!ObjectUtils.isEmpty(this.paramCache)) {
            param = this.paramCache.get(orgId);
        }
        if (param == null) {
            param = LineTypeHelper.getParam(orgId, this.isAr());
            this.paramCache.put(orgId, param);
        }
        return param;
    }

    private boolean isAr() {
        boolean isAr = true;
        String entityKey = this.getModel().getDataEntityType().getName();
        if (entityKey.contains("ap_")) {
            isAr = false;
        }
        return isAr;
    }

    private String getBillTypeFieldKey() {
        String billEntitykey = this.getModel().getDataEntityType().getName();
        return "ap_finapbill".equals(billEntitykey) ? "billtypeid" : "billtype";
    }

    private String getDetailEntryKey() {
        String billEntitykey = this.getModel().getDataEntityType().getName();
        return "ap_finapbill".equals(billEntitykey) ? "detailentry" : "entry";
    }

    private String getMaterialKey() {
        String billEntitykey = this.getModel().getDataEntityType().getName();
        return "ap_finapbill".equals(billEntitykey) ? "material" : "e_material";
    }

    private String getExpenseItemKey() {
        String billEntitykey = this.getModel().getDataEntityType().getName();
        return "ap_finapbill".equals(billEntitykey) ? "expenseitem" : "e_expenseitem";
    }
}

