/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

public class ConditionEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergrid");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition condition = filterGridState.getFilterCondition();
            CRCondition conditionObj = new CRCondition();
            conditionObj.setFilterCondition(condition);
            CRCondition formulaObj = conditionObj;
            String tranExpr = this.tranFormula((CRFormula)formulaObj);
            formulaObj.setExprTran(tranExpr);
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            CRCondition conditionObj;
            FilterCondition filterCondition;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            FilterFieldBuildOption option = new FilterFieldBuildOption();
            List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)entityType, (FilterFieldBuildOption)option);
            this.clearFilterGrid();
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergrid");
            filterGrid.setEntityNumber(entityNumber);
            filterGrid.setFilterColumns(cols);
            this.getView().updateView("filtergrid");
            String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
            if (StringUtils.isNotBlank((CharSequence)conditonJson) && (filterCondition = (conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditonJson, CRCondition.class)).getFilterCondition()) != null) {
                filterGrid.SetValue(filterCondition);
            }
        }
    }

    private void clearFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        condition.getFilterRow().clear();
        filterGrid.SetValue(condition);
        filterGrid.getFieldColumns().clear();
        filterGrid.getFilterFieldKeys().clear();
    }

    private String tranFormula(CRFormula formulaObj) {
        String tranExpr = "";
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return tranExpr;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && !ObjectUtils.isEmpty((Object)filterCondition.getFilterRow())) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>(2);
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)"\u4e14", (String)"ConditionEditPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return tranExpr;
    }
}

