/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class DataCheckEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        final IDataModel model = this.getModel();
        entryGrid.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                String fieldName = e.getFieldName();
                if ("e_errorcount".equals(fieldName)) {
                    DynamicObjectCollection subEntries = model.getEntryEntity("subentry");
                    if (subEntries == null || subEntries.size() == 0) {
                        return;
                    }
                    HashSet<Long> errorIds = new HashSet<Long>(subEntries.size());
                    for (DynamicObject subEntry : subEntries) {
                        errorIds.add(subEntry.getLong("s_billid"));
                    }
                    if (!errorIds.isEmpty()) {
                        DynamicObject bizobj = (DynamicObject)model.getValue("bizobj");
                        String billEntity = bizobj.getString("id");
                        ListShowParameter listShowParameter = new ListShowParameter();
                        listShowParameter.setBillFormId(billEntity);
                        ListFilterParameter lfp = new ListFilterParameter();
                        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
                        filters.add(new QFilter("id", "in", errorIds));
                        lfp.setQFilters(filters);
                        listShowParameter.setListFilterParameter(lfp);
                        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        listShowParameter.setLookUp(true);
                        DataCheckEdit.this.getView().showForm((FormShowParameter)listShowParameter);
                    }
                }
            }
        });
        EntryGrid subEntryGrid = (EntryGrid)this.getControl("subentry");
        subEntryGrid.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                String fieldName = e.getFieldName();
                if ("s_billno".equals(fieldName)) {
                    int rowIndex = e.getRowIndex();
                    Object billid = model.getValue("s_billid", rowIndex);
                    BillShowParameter param = new BillShowParameter();
                    param.setPkId(billid);
                    param.setStatus(OperationStatus.VIEW);
                    param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    DynamicObject bizobj = (DynamicObject)model.getValue("bizobj");
                    String billEntity = bizobj.getString("id");
                    param.setFormId(billEntity);
                    DataCheckEdit.this.getView().showForm((FormShowParameter)param);
                }
            }
        });
    }
}

