/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.fi.arapcommon.form.ArApBaseAllocationPlugin;
import kd.fi.arapcommon.service.BillStatusCtrlService;
import kd.fi.arapcommon.util.AllocationUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ExpenseAllocationPlugin
extends ArApBaseAllocationPlugin {
    private boolean isAutoBalance = false;
    private BillStatusCtrlService billStatusCtrlService = new BillStatusCtrlService();

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!this.billStatusCtrlService.isCanChange(billStatus)) {
            return;
        }
        switch (propertyName) {
            case "isexpensealloc": {
                boolean allocSwitch = Boolean.parseBoolean(String.valueOf(newValue));
                if (allocSwitch) {
                    this.calculateDefaultRow();
                    break;
                }
                this.clearExpenseAlloc();
                break;
            }
            case "iswholealloc": {
                boolean wholeAllocSwitch = Boolean.parseBoolean(String.valueOf(newValue));
                this.calculateDefaultRow();
                if (wholeAllocSwitch) {
                    this.clearExpenseAllocDetail();
                    break;
                }
                this.clearExpenseAlloc();
                break;
            }
            case "a_allocationamt": 
            case "a_allocationper": {
                this.calculateWholeRowEntry();
                break;
            }
            case "amount": 
            case "pricetaxtotal": 
            case "exchangerate": 
            case "isintax": {
                this.calculateAllocationDetail();
                break;
            }
        }
        this.calculateAllocationLocDetail();
        super.propertyChanged(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap3"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("autobalance".equals(key)) {
            this.isAutoBalance = true;
            IDataModel model = this.getModel();
            this.checkAutoBalance(model);
            AllocationUtils.calculateAndSetAllocDifference(model);
        } else if ("deleteallocentry".equals(key)) {
            this.calculateAllocationLocDetail();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("allocationentry".equals(entryName)) {
            this.checkAndSetAddRow(entryName, e.getRowDataEntities().length);
            this.getModel().updateCache();
        }
    }

    private void checkAutoBalance(IDataModel model) {
        boolean isInTax = this.isInTax();
        boolean allocByPer = (Boolean)model.getValue("allocatebyper");
        int entryRowCount = this.getModel().getEntryRowCount("allocationentry");
        if (allocByPer) {
            BigDecimal alloCationPer = BigDecimal.ZERO;
            for (int i = 0; i < entryRowCount; ++i) {
                Object alloCationPerVal = this.getModel().getValue("a_allocationper", i);
                if (EmptyUtils.isEmpty(alloCationPerVal)) continue;
                alloCationPer = alloCationPer.add((BigDecimal)alloCationPerVal);
            }
            if (alloCationPer.compareTo(BigDecimal.valueOf(100L)) != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u6bd4\u4f8b\u4e4b\u548c\u9700\u7b49\u4e8e100\uff0c\u624d\u53ef\u81ea\u52a8\u8c03\u5e73\u5206\u914d\u91d1\u989d\u3002", (String)"ExpenseAllocationPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
        } else {
            BigDecimal headAmt = isInTax ? (BigDecimal)model.getValue("pricetaxtotal") : (BigDecimal)model.getValue("amount");
            BigDecimal allocationamt = BigDecimal.ZERO;
            for (int i = 0; i < entryRowCount; ++i) {
                Object alloCationAmtVal = this.getModel().getValue("a_allocationamt", i);
                if (EmptyUtils.isEmpty(alloCationAmtVal)) continue;
                allocationamt = allocationamt.add((BigDecimal)alloCationAmtVal);
            }
            if (allocationamt.compareTo(headAmt) != 0) {
                if (isInTax) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u91d1\u989d\u4e4b\u548c\u9700\u7b49\u4e8e\u8868\u5934\u5e94\u4ed8\u91d1\u989d\uff0c\u624d\u53ef\u81ea\u52a8\u8c03\u5e73\u5206\u914d\u6bd4\u4f8b\u3002", (String)"ExpenseAllocationPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u914d\u91d1\u989d\u4e4b\u548c\u9700\u7b49\u4e8e\u8868\u5934\u91d1\u989d\uff0c\u624d\u53ef\u81ea\u52a8\u8c03\u5e73\u5206\u914d\u6bd4\u4f8b\u3002", (String)"ExpenseAllocationPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void calculateWholeRowEntry() {
        BigDecimal headAmount;
        boolean allocationByPercent = this.isAllocationByPercent();
        boolean isInTax = this.isInTax();
        BigDecimal bigDecimal = headAmount = isInTax ? (BigDecimal)this.getModel().getValue("pricetaxtotal") : (BigDecimal)this.getModel().getValue("amount");
        if (this.isAutoBalance) {
            this.isAutoBalance = false;
        } else if (allocationByPercent) {
            this.calculateByAllocationPercent(headAmount, true);
        } else {
            this.calculateByAllocationAmt(headAmount, true);
        }
    }

    private void checkAndSetAddRow(String entryName, int newRowCount) {
        if (!Arrays.asList("allocationentry", "detailallocentry").contains(entryName)) {
            return;
        }
        boolean wholeAlloc = (Boolean)this.getModel().getValue("iswholealloc");
        if (!wholeAlloc) {
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("allocationentry");
        if (rowCount == 0) {
            return;
        }
        for (int i = 1; i <= newRowCount; ++i) {
            BigDecimal headAmount;
            this.getModel().setEntryCurrentRowIndex("allocationentry", rowCount - i);
            boolean allocByPer = this.isAllocationByPercent();
            boolean isInTax = this.isInTax();
            BigDecimal bigDecimal = headAmount = isInTax ? (BigDecimal)this.getModel().getValue("pricetaxtotal") : (BigDecimal)this.getModel().getValue("amount");
            if (allocByPer) {
                this.calculateByAllocationPercent(headAmount, true);
                continue;
            }
            BigDecimal rowAmt = (BigDecimal)this.getModel().getValue("a_allocationamt", rowCount - i);
            if (rowAmt.compareTo(BigDecimal.ZERO) > 0) continue;
            this.getModel().setValue("a_allocationamt", (Object)headAmount, rowCount - i);
        }
    }

    private void clearExpenseAlloc() {
        int[] rowArray = this.getRowByte("allocationentry");
        this.getModel().deleteEntryRows("allocationentry", rowArray);
        this.getModel().setValue("allocatebyper", (Object)Boolean.TRUE);
    }

    private void clearExpenseAllocDetail() {
        String entityName = this.getModel().getDataEntityType().getName();
        String detailEntryName = AllocationUtils.getBillDetailPropertyName(entityName);
        int detailRowCount = this.getModel().getEntryRowCount(detailEntryName);
        for (int i = 0; i < detailRowCount; ++i) {
            this.getModel().setEntryCurrentRowIndex(detailEntryName, i);
            int[] rowArray = this.getRowByte("detailallocentry");
            this.getModel().deleteEntryRows("detailallocentry", rowArray);
        }
    }

    private int[] getRowByte(String propertyName) {
        int rowCount = this.getModel().getEntryRowCount(propertyName);
        int[] rowArray = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rowArray[i] = i;
        }
        return rowArray;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
    }
}

