/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.util.EmptyUtils;

public class FormServiceHelper {
    public static void addMeasureUnitFilter(IDataModel model, String materialFieldName, String entryName, BasedataEdit measureUnitEdit) {
        measureUnitEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int rowIndex = model.getEntryCurrentRowIndex(entryName);
            DynamicObject material = (DynamicObject)model.getValue(materialFieldName, rowIndex);
            if (material != null) {
                ArrayList<Long> measureUnitIds = new ArrayList<Long>();
                measureUnitIds.add(material.getLong("baseunit.id"));
                QFilter[] filters = new QFilter[]{new QFilter("materialid", "=", material.getPkValue())};
                DynamicObjectCollection measureUnits = QueryServiceHelper.query((String)"bd_multimeasureunit", (String)"measureunitid", (QFilter[])filters);
                for (DynamicObject measureUnit : measureUnits) {
                    measureUnitIds.add(measureUnit.getLong("measureunitid"));
                }
                QFilter measureUnitFilter = new QFilter("id", "in", measureUnitIds);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(measureUnitFilter);
            }
        });
    }

    public static void checkMeasureUnitRange(IDataModel model, String entryName, String materialFieldName, String measureUnitFieldName) {
        Long materialId;
        Object material;
        DynamicObjectCollection entry = model.getEntryEntity(entryName);
        HashMap measureUnitIds = new HashMap();
        HashSet<Long> materialPks = new HashSet<Long>();
        for (DynamicObject row : entry) {
            material = row.getDynamicObject(materialFieldName);
            if (material == null) continue;
            Long materialId2 = material.getLong("id");
            materialPks.add(materialId2);
            if (measureUnitIds.get(materialId2) != null) continue;
            HashSet<Long> defaultUnitIds = new HashSet<Long>();
            defaultUnitIds.add(material.getLong("baseunit.id"));
            measureUnitIds.put(materialId2, defaultUnitIds);
        }
        if (!materialPks.isEmpty()) {
            QFilter[] filters = new QFilter[]{new QFilter("materialid", "in", materialPks)};
            DynamicObjectCollection measureUnits = QueryServiceHelper.query((String)"bd_multimeasureunit", (String)"materialid,measureunitid", (QFilter[])filters);
            for (DynamicObject measureUnit : measureUnits) {
                Set<Long> set;
                materialId = measureUnit.getLong("materialid");
                Long measureId = measureUnit.getLong("measureunitid");
                if (measureUnitIds.get(materialId) != null) {
                    set = (Set)measureUnitIds.get(materialId);
                    set.add(measureId);
                    continue;
                }
                set = new HashSet();
                set.add(measureId);
                measureUnitIds.put(materialId, set);
            }
        }
        for (int i = 0; i < entry.size(); ++i) {
            Set usableUnitIds;
            DynamicObject measureUnit;
            DynamicObject row;
            row = (DynamicObject)entry.get(i);
            material = row.getDynamicObject(materialFieldName);
            measureUnit = row.getDynamicObject(measureUnitFieldName);
            if (material == null || measureUnit == null || (usableUnitIds = (Set)measureUnitIds.get(materialId = Long.valueOf(material.getLong("id")))).contains(measureUnit.getLong("id"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8ba1\u4ef7\u5355\u4f4d\u4e0d\u5728\u7269\u6599\u53ef\u7528\u7684\u8ba1\u91cf\u5355\u4f4d\u8303\u56f4\u5185\u3002", (String)"FormServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
        }
    }

    public static void checkMeasureUnitRange(DynamicObjectCollection entries, String materialFieldName, Map<Long, Set<Long>> measureUnitIds) {
        HashSet<Long> materialPks = new HashSet<Long>();
        for (DynamicObject row : entries) {
            Long materialId;
            DynamicObject material = row.getDynamicObject(materialFieldName);
            if (material == null || measureUnitIds.get(materialId = Long.valueOf(material.getLong("id"))) != null) continue;
            materialPks.add(materialId);
            HashSet<Long> defaultUnitIds = new HashSet<Long>();
            defaultUnitIds.add(material.getLong("baseunit.id"));
            measureUnitIds.put(materialId, defaultUnitIds);
        }
        if (!materialPks.isEmpty()) {
            QFilter[] filters = new QFilter[]{new QFilter("materialid", "in", materialPks)};
            DynamicObjectCollection measureUnits = QueryServiceHelper.query((String)"bd_multimeasureunit", (String)"materialid,measureunitid", (QFilter[])filters);
            for (DynamicObject measureUnit : measureUnits) {
                Set<Object> set;
                Long materialId = measureUnit.getLong("materialid");
                Long measureId = measureUnit.getLong("measureunitid");
                if (measureUnitIds.get(materialId) != null) {
                    set = measureUnitIds.get(materialId);
                    set.add(measureId);
                    continue;
                }
                set = new HashSet();
                set.add(measureId);
                measureUnitIds.put(materialId, set);
            }
        }
    }

    public static void paypropertyChanged(IDataModel model, String entryName, String qty) {
        BillModel billModel = BillModelFactory.getModel(model.getDataEntityType().getExtendName());
        DynamicObject property = (DynamicObject)model.getValue(billModel.HEAD_PAYPROPERTY);
        if (property != null && property.getBoolean("isbasedonamt")) {
            DynamicObjectCollection entry = model.getEntryEntity(billModel.ENTRY);
            int quantity = 1;
            for (DynamicObject row : entry) {
                BigDecimal price = row.getBigDecimal(billModel.E_UNITPRICE);
                BigDecimal amount = row.getBigDecimal(billModel.E_AMOUNT);
                if (BigDecimal.ZERO.compareTo(price) == 0 || BigDecimal.ZERO.compareTo(amount) == 0) continue;
                if (price.signum() == amount.signum()) break;
                quantity = -1;
                break;
            }
            int entryCount = model.getEntryRowCount(entryName);
            for (int j = 0; j < entryCount; ++j) {
                model.setValue(qty, (Object)quantity, j);
            }
        }
    }

    public static void recoverOldValue(IFormView view, String property, Object oldValue, int rowIndex) {
        IDataModel model = view.getModel();
        model.beginInit();
        model.setValue(property, oldValue, rowIndex);
        model.endInit();
        view.updateView(property, rowIndex);
    }

    public static void recoverOldValue(IFormView view, String property, Object oldValue) {
        IDataModel model = view.getModel();
        model.beginInit();
        model.setValue(property, oldValue);
        model.endInit();
        view.updateView(property);
    }

    public static BigDecimal getExchangeRate(IBillModel m) {
        DynamicObject srcCurrency = (DynamicObject)m.getValue("currency");
        DynamicObject destCurrency = (DynamicObject)m.getValue("basecurrency");
        DynamicObject exrateTable = (DynamicObject)m.getValue("exratetable");
        Date exrateDate = (Date)m.getValue("exratedate");
        if (destCurrency == null || srcCurrency == null || exrateTable == null) {
            return null;
        }
        if (srcCurrency.getPkValue().equals(destCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        long srcCurrencyId = srcCurrency.getLong("id");
        long destCurrencyId = destCurrency.getLong("id");
        long exrateTableId = exrateTable.getLong("id");
        String quotation = (String)m.getValue("quotation");
        BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)exrateTableId, srcCurrencyId, (Long)destCurrencyId, quotation, exrateDate);
        if (EmptyUtils.isEmpty(exchangeRate)) {
            String reverseQuotaiton = "1".equals(quotation) ? "0" : "1";
            exchangeRate = BaseDataHelper.getExchangeRate((Long)exrateTableId, destCurrencyId, (Long)srcCurrencyId, reverseQuotaiton, exrateDate);
        }
        return exchangeRate;
    }
}

