/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.helper.MaterialFilterHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.GLUtils;

public class GlImportSchemeEdit
extends AbstractBasePlugIn {
    private static final String BOTP_SELECTFIELD = "botp_selectfield";
    private static final String ENTRY = "entry";
    private static final String E_MAPPINGFIELDNAME = "e_mappingfieldname";
    private static final String E_MAPPINGFIELD = "e_mappingfield";
    private static final String E_ENTITYOBJECT = "e_entityobject";
    private static final String E_BIZTYPE = "e_biztype";
    private static final String E_LINETYPE = "e_linetype";
    private static final String E_BILLTYPE = "e_billtype";
    private static final String E_MATERIAL = "e_material";
    private static final String E_ASSTACTITEM = "e_asstactitem";
    private static final String E_ASSTACTTYPE = "e_asstacttype";
    private static final String E_ACCOUNT = "e_account";
    private static final String E_EXPENSEITEM = "e_expenseitem";
    private static final String E_APPAYPROPERTY = "e_appayproperty";
    private static final String E_ARPAYPROPERTY = "e_arpayproperty";
    private static final String E_BALANCEDC = "e_balancedc";
    private static final String E_PAYMENTTYPE = "e_paymenttype";
    private static final String E_RECTYPE = "e_rectype";
    private static final String APPID = "appid";
    private static final String E_BALANCETYPE = "e_balancetype";
    private static final String E_BALANCEMAPPINGFIELD = "e_balancemappingfield";
    private static final String E_BALANCEMAPPINGFIELDNAME = "e_balancemappingfieldname";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(APPID, (Object)this.getView().getFormShowParameter().getAppId());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String[] mappingFields = new String[6];
        for (int i = 0; i < 6; ++i) {
            mappingFields[i] = E_MAPPINGFIELDNAME + (i + 1);
        }
        this.addClickListeners(mappingFields);
        this.addClickListeners(new String[]{E_BALANCEMAPPINGFIELDNAME});
        this.accountViewFilter();
        this.asstacttTypeFilter();
        this.billTypeFilter();
        this.expenseitemFilter();
        this.lineTypeFilter();
        this.bizTypeFilter();
        this.materialFilter();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.entityObjectComboEdit();
        boolean isLineType = this.isLineType();
        DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRY);
        for (int i = 0; i < entries.size(); ++i) {
            Object entityObject = ((DynamicObject)entries.get(i)).get(E_ENTITYOBJECT);
            this.controlEnable(entityObject, i, isLineType);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData[] changeDatas = e.getChangeSet();
        Object newValue = changeDatas[0].getNewValue();
        Object oldValue = changeDatas[0].getOldValue();
        int iRow = changeDatas[0].getRowIndex();
        if (newValue == oldValue) {
            return;
        }
        if (key.startsWith(E_MAPPINGFIELDNAME) && EmptyUtils.isEmpty(newValue)) {
            String seq = StringUtils.removeStart((String)key, (String)E_MAPPINGFIELDNAME);
            model.setValue(E_MAPPINGFIELD + seq, null, iRow);
        }
        switch (key) {
            case "e_account": {
                this.accountViewChanged(newValue, iRow);
                break;
            }
            case "e_asstactitem": {
                this.asstactitemChanged(newValue, iRow);
                break;
            }
            case "e_entityobject": {
                this.entityobjectChanged(newValue, iRow);
                break;
            }
            case "e_balancemappingfieldname": {
                if (!EmptyUtils.isEmpty(newValue)) break;
                this.getModel().setValue(E_BALANCEMAPPINGFIELDNAME, oldValue);
                break;
            }
            case "e_billtype": {
                model.setValue(E_BIZTYPE, null, iRow);
                model.setValue(E_LINETYPE, null, iRow);
                model.setValue(E_MATERIAL, null, iRow);
                model.setValue(E_EXPENSEITEM, null, iRow);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "viewlog": {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId("ar_glimportlog");
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                long pk = (Long)this.getModel().getValue("id");
                listShowParameter.setCustomParam("schemeid", (Object)pk);
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "bar_execute": {
                boolean isDataChanged = this.getModel().getDataChanged();
                if (isDataChanged) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\uff0c\u518d\u6267\u884c\u5bfc\u5165\u3002", (String)"GlImportSchemeEdit_8", (String)"fi-arapcommon", (Object[])new Object[0]));
                    return;
                }
                DynamicObject org = (DynamicObject)this.getModel().getValue("useorg");
                long orgPk = org.getLong("id");
                DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRY);
                Set accountPks = entry.stream().map(i -> i.getLong("e_account.id")).collect(Collectors.toSet());
                QFilter qFilter = new QFilter("org", "=", (Object)orgPk);
                QFilter acFilter = new QFilter("account", "in", accountPks);
                DynamicObjectCollection glimports = QueryServiceHelper.query((String)"ar_glimportbill", (String)"account.fullname,entitykey,billid", (QFilter[])new QFilter[]{qFilter, acFilter});
                if (glimports.size() > 0) {
                    Set accounts = glimports.stream().map(e -> e.getString("account.fullname")).collect(Collectors.toSet());
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%1$s \u5df2\u5b58\u5728\u4ece\u79d1\u76ee%2$s\u5bfc\u5165\u7684\u671f\u521d\u5355\u636e\uff0c\u518d\u6b21\u5bfc\u5165\u5c06\u5220\u9664\u8fd9\u4e9b\u5355\u636e\u91cd\u65b0\u751f\u6210\u3002\u662f\u5426\u7ee7\u7eed\u5bfc\u5165\uff1f", (String)"GlImportSchemeEdit_13", (String)"fi-arapcommon", (Object[])new Object[0]), org.getString("name"), String.join((CharSequence)",", accounts)), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("execute"));
                    break;
                }
                this.getView().invokeOperation("execute");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        IFormView view = this.getView();
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "execute") && isOK) {
            view.invokeOperation("execute");
        }
    }

    private void accountViewFilter() {
        BasedataEdit accountF7 = (BasedataEdit)this.getControl(E_ACCOUNT);
        accountF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Map asstacttypes;
            QFilter asstactitemFilter;
            DynamicObject org = (DynamicObject)this.getModel().getValue("useorg");
            DynamicObject accountBook = GLUtils.getAccountBook4Master(org.getLong("id"));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (EmptyUtils.isEmpty(accountBook)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%s \u7684\u4f1a\u8ba1\u4e3b\u8d26\u7c3f\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"GlImportSchemeEdit_12", (String)"fi-arapcommon", (Object[])new Object[]{org.getString("name")}));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            long accounttablePK = accountBook.getLong("accounttable.id");
            QFilter accountFilter = new QFilter("accounttable.id", "in", (Object)accounttablePK);
            Map account = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{accountFilter, asstactitemFilter = new QFilter("checkitementry.asstactitem.id", "in", (asstacttypes = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"id", (QFilter[])new QFilter[]{new QFilter("valuesource.number", "in", this.getMatchAsstactitemSet()), new QFilter("enable", "=", (Object)Boolean.TRUE)})).keySet())});
            if (account == null || account.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u4e3b\u8d26\u7c3f\u4e0b\u627e\u4e0d\u5230\u6838\u7b97\u7ef4\u5ea6\u7684\u503c\u6765\u6e90\u5305\u542b\u5ba2\u6237\u3001\u4f9b\u5e94\u5546\u3001\u5458\u5de5\u3001\u4e1a\u52a1\u5355\u5143\u7684\u79d1\u76ee\u3002", (String)"GlImportSchemeEdit_11", (String)"fi-arapcommon", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            showParameter.getListFilterParameter().setFilter(accountFilter.and(asstactitemFilter));
        });
    }

    private void materialFilter() {
        BasedataEdit materialF7 = (BasedataEdit)this.getControl(E_MATERIAL);
        materialF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
            DynamicObject org = (DynamicObject)this.getModel().getValue("useorg");
            String appid = (String)this.getModel().getValue(APPID);
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            String entityobject = (String)this.getModel().getValue(E_ENTITYOBJECT);
            if (this.getBillEntitySet().contains(entityobject)) {
                DynamicObject billType = (DynamicObject)this.getModel().getValue(E_BILLTYPE, currentRow);
                DynamicObject bizType = (DynamicObject)this.getModel().getValue(E_BIZTYPE, currentRow);
                DynamicObject lineType = (DynamicObject)this.getModel().getValue(E_LINETYPE, currentRow);
                boolean param = LineTypeHelper.getParam(org.getLong("id"), "ar".equals(appid));
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                if (!param) {
                    this.filterMaterialByBillType(showParameter, billType, currentRow);
                } else {
                    if (billType == null || bizType == null || lineType == null) {
                        QFilter filter = new QFilter("id", "=", (Object)0L);
                        showParameter.getListFilterParameter().setFilter(filter);
                        return;
                    }
                    QFilter[] materialFilters = LineTypeHelper.getMaterialFilterByLineType(billType.getLong("id"), bizType.getLong("id"), lineType.getLong("id"));
                    showParameter.getListFilterParameter().getQFilters().addAll(Arrays.asList(materialFilters));
                }
            }
        });
    }

    private void bizTypeFilter() {
        BasedataEdit bizTypeF7 = (BasedataEdit)this.getControl(E_BIZTYPE);
        bizTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
            DynamicObject billType = (DynamicObject)this.getModel().getValue(E_BILLTYPE, currentRow);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (EmptyUtils.isEmpty(billType)) {
                QFilter filter = new QFilter("id", "=", (Object)0L);
                showParameter.getListFilterParameter().setFilter(filter);
                return;
            }
            long billTypeId = billType.getLong("id");
            List<Long> bizTypes = LineTypeHelper.getAllBizTypeIds(billTypeId);
            QFilter qFilter = new QFilter("id", "in", bizTypes);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void lineTypeFilter() {
        BasedataEdit lineTypeF7 = (BasedataEdit)this.getControl(E_LINETYPE);
        lineTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
            DynamicObject bizType = (DynamicObject)this.getModel().getValue(E_BIZTYPE, currentRow);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (bizType == null) {
                QFilter filter = new QFilter("id", "=", (Object)0L);
                showParameter.getListFilterParameter().setFilter(filter);
                return;
            }
            Set<Long> lineTypeIds = LineTypeHelper.getAllLineTypeIds(bizType.getLong("id"));
            QFilter lineTypeFilter = new QFilter("id", "in", lineTypeIds);
            showParameter.getListFilterParameter().setFilter(lineTypeFilter);
        });
    }

    private void expenseitemFilter() {
        BasedataEdit expenseitemF7 = (BasedataEdit)this.getControl(E_EXPENSEITEM);
        expenseitemF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter;
            int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
            String entityKey = (String)this.getModel().getValue(E_ENTITYOBJECT, currentRow);
            if (EmptyUtils.isEmpty(entityKey)) {
                filter = new QFilter("id", "=", (Object)0L);
            } else {
                String entityName = EntityMetadataCache.getDataEntityType((String)entityKey).getDisplayName().getLocaleValue();
                filter = new QFilter("relbilltype", "ftlike", (Object)entityName);
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(filter);
        });
    }

    private void billTypeFilter() {
        BasedataEdit billTypeF7 = (BasedataEdit)this.getControl(E_BILLTYPE);
        billTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter;
            int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
            String entityKey = (String)this.getModel().getValue(E_ENTITYOBJECT, currentRow);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (EmptyUtils.isEmpty(entityKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bfc\u5165\u5bf9\u8c61\u3002", (String)"GlImportSchemeEdit_7", (String)"fi-arapcommon", (Object[])new Object[0]));
                filter = new QFilter("id", "=", (Object)0L);
            } else {
                filter = new QFilter("billformid", "=", (Object)entityKey);
            }
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(filter);
        });
    }

    private void entityobjectChanged(Object newValue, int iRow) {
        IDataModel model = this.getModel();
        model.setValue(E_BIZTYPE, null, iRow);
        model.setValue(E_LINETYPE, null, iRow);
        model.setValue(E_BILLTYPE, null, iRow);
        model.setValue(E_MATERIAL, null, iRow);
        model.setValue(E_EXPENSEITEM, null, iRow);
        model.setValue(E_BALANCEDC, (Object)0, iRow);
        model.setValue(E_APPAYPROPERTY, null, iRow);
        model.setValue(E_ARPAYPROPERTY, null, iRow);
        model.setValue(E_PAYMENTTYPE, null, iRow);
        model.setValue(E_RECTYPE, null, iRow);
        for (int i = 1; i <= 6; ++i) {
            model.setValue(E_MAPPINGFIELD + i, null, iRow);
            model.setValue(E_MAPPINGFIELDNAME + i, null, iRow);
        }
        if (newValue != null) {
            String billEntityKey = newValue.toString();
            if (this.getBillEntitySet().contains(billEntityKey)) {
                QFilter qFilter1 = new QFilter("billformid", "=", (Object)billEntityKey);
                QFilter qFilter2 = new QFilter("isdefault", "=", (Object)"1");
                DynamicObject billtype = BusinessDataServiceHelper.loadSingle((String)"bos_billtype", (String)"masterid", (QFilter[])new QFilter[]{qFilter1, qFilter2});
                if (!ObjectUtils.isEmpty((Object)billtype)) {
                    model.setValue(E_BILLTYPE, (Object)billtype.getLong("masterid"), iRow);
                }
            }
            QFilter q1 = new QFilter("enable", "=", (Object)"1");
            QFilter q2 = new QFilter("status", "=", (Object)"C");
            if ("ap_paidbill".equals(billEntityKey)) {
                DynamicObject paymenttype = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_paymentbilltype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"202"), q1, q2});
                model.setValue(E_PAYMENTTYPE, (Object)paymenttype, iRow);
                model.setValue(E_BALANCEMAPPINGFIELD, (Object)"e_actamt", iRow);
                model.setValue(E_BALANCEMAPPINGFIELDNAME, (Object)ResManager.loadKDString((String)"\u660e\u7ec6.\u4ed8\u6b3e\u91d1\u989d", (String)"GlImportSchemeEdit_15", (String)"fi-arapcommon", (Object[])new Object[0]), iRow);
            }
            if ("ar_receivedbill".equals(billEntityKey)) {
                DynamicObject rectype = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_receivingbilltype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"101"), q1, q2});
                model.setValue(E_RECTYPE, (Object)rectype, iRow);
                model.setValue(E_BALANCEMAPPINGFIELD, (Object)"e_amount", iRow);
                model.setValue(E_BALANCEMAPPINGFIELDNAME, (Object)ResManager.loadKDString((String)"\u660e\u7ec6.\u6536\u6b3e\u91d1\u989d", (String)"GlImportSchemeEdit_16", (String)"fi-arapcommon", (Object[])new Object[0]), iRow);
            }
            if ("ap_finapbill".equals(billEntityKey)) {
                model.setValue(E_BALANCEMAPPINGFIELD, (Object)"e_pricetaxtotal", iRow);
                model.setValue(E_BALANCEMAPPINGFIELDNAME, (Object)ResManager.loadKDString((String)"\u660e\u7ec6.\u5e94\u4ed8\u91d1\u989d", (String)"GlImportSchemeEdit_17", (String)"fi-arapcommon", (Object[])new Object[0]), iRow);
            }
            if ("ar_finarbill".equals(billEntityKey)) {
                model.setValue(E_BALANCEMAPPINGFIELD, (Object)"e_recamount", iRow);
                model.setValue(E_BALANCEMAPPINGFIELDNAME, (Object)ResManager.loadKDString((String)"\u660e\u7ec6.\u5e94\u6536\u91d1\u989d", (String)"GlImportSchemeEdit_18", (String)"fi-arapcommon", (Object[])new Object[0]), iRow);
            }
            if ("ap_busbill".equals(billEntityKey)) {
                model.setValue(E_BALANCEMAPPINGFIELD, (Object)"e_amount", iRow);
                model.setValue(E_BALANCEMAPPINGFIELDNAME, (Object)ResManager.loadKDString((String)"\u660e\u7ec6.\u91d1\u989d", (String)"GlImportSchemeEdit_19", (String)"fi-arapcommon", (Object[])new Object[0]), iRow);
            }
            if ("ar_busbill".equals(billEntityKey)) {
                model.setValue(E_BALANCEMAPPINGFIELD, (Object)"e_amount", iRow);
                model.setValue(E_BALANCEMAPPINGFIELDNAME, (Object)ResManager.loadKDString((String)"\u660e\u7ec6.\u91d1\u989d", (String)"GlImportSchemeEdit_19", (String)"fi-arapcommon", (Object[])new Object[0]), iRow);
            }
            this.controlEnable(newValue, iRow, this.isLineType());
        }
    }

    private void controlEnable(Object newValue, int iRow, boolean isLineType) {
        Set<String> billEntitySet = this.getBillEntitySet();
        if (billEntitySet.contains(newValue)) {
            if (isLineType) {
                this.getView().setEnable(Boolean.TRUE, iRow, new String[]{E_BIZTYPE});
                this.getView().setEnable(Boolean.TRUE, iRow, new String[]{E_LINETYPE});
            } else {
                this.getView().setEnable(Boolean.FALSE, iRow, new String[]{E_BIZTYPE});
                this.getView().setEnable(Boolean.FALSE, iRow, new String[]{E_LINETYPE});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, iRow, new String[]{E_BIZTYPE});
            this.getView().setEnable(Boolean.FALSE, iRow, new String[]{E_LINETYPE});
        }
    }

    private void asstactitemChanged(Object newValue, int iRow) {
        IDataModel model = this.getModel();
        model.setValue(E_ASSTACTTYPE, null, iRow);
        for (int i = 1; i <= 6; ++i) {
            model.setValue(E_ASSTACTITEM + i, null, iRow);
            model.setValue(E_MAPPINGFIELD + i, null, iRow);
            model.setValue(E_MAPPINGFIELDNAME + i, null, iRow);
        }
        if (newValue != null) {
            DynamicObject asstactitem = (DynamicObject)newValue;
            String asstacttype = asstactitem.getString("valuesource.number");
            if ("bos_org".equals(asstacttype)) {
                String appid = (String)this.getModel().getValue(APPID);
                model.setValue(E_ASSTACTTYPE, (Object)("ap".equals(appid) ? "bd_supplier" : "bd_customer"), iRow);
            } else {
                model.setValue(E_ASSTACTTYPE, (Object)asstacttype, iRow);
            }
            DynamicObject account = (DynamicObject)this.getModel().getValue(E_ACCOUNT, iRow);
            DynamicObjectCollection checkitementrys = account.getDynamicObjectCollection("checkitementry");
            List asstactitems = checkitementrys.stream().map(ai -> ai.getDynamicObject("asstactitem")).collect(Collectors.toList());
            asstactitems = asstactitems.stream().filter(list -> !list.getString("name").equals(asstactitem.getString("name"))).collect(Collectors.toList());
            for (int i = 0; i < 6 && i < asstactitems.size(); ++i) {
                model.setValue(E_ASSTACTITEM + (i + 1), asstactitems.get(i), iRow);
            }
        }
    }

    private void asstacttTypeFilter() {
        BasedataEdit asstactitemF7 = (BasedataEdit)this.getControl(E_ASSTACTITEM);
        asstactitemF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
            DynamicObject account = (DynamicObject)this.getModel().getValue(E_ACCOUNT, currentRow);
            if (EmptyUtils.isNotEmpty(account)) {
                DynamicObjectCollection checkitementrys = account.getDynamicObjectCollection("checkitementry");
                List asstactitemNumbers = checkitementrys.stream().map(ai -> ai.getString("asstactitem.number")).collect(Collectors.toList());
                QFilter filter = new QFilter("number", "in", asstactitemNumbers);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u79d1\u76ee\u3002", (String)"GlImportSchemeEdit_9", (String)"fi-arapcommon", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        });
    }

    private void accountViewChanged(Object newValue, int iRow) {
        IDataModel model = this.getModel();
        model.setValue(E_ASSTACTITEM, null, iRow);
        model.setValue(E_BALANCETYPE, (Object)1, iRow);
        model.setValue(E_BALANCEDC, (Object)0, iRow);
        if (newValue != null) {
            DynamicObject account = (DynamicObject)newValue;
            DynamicObjectCollection checkitementrys = account.getDynamicObjectCollection("checkitementry");
            List asstactitemPks = checkitementrys.stream().map(ai -> ai.getLong("asstactitem.id")).collect(Collectors.toList());
            Map asstacttypes = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"valuesource", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactitemPks), new QFilter("enable", "=", (Object)"1")});
            for (DynamicObject checkitementry : checkitementrys) {
                long asstacttypeId = checkitementry.getLong("asstactitem.id");
                DynamicObject asstacttype = (DynamicObject)asstacttypes.get(asstacttypeId);
                String entityName = asstacttype.getString("valuesource.number");
                if (!this.getMatchAsstactitemSet().contains(entityName)) continue;
                model.setValue(E_ASSTACTITEM, (Object)asstacttype, iRow);
                break;
            }
        }
    }

    private void entityObjectComboEdit() {
        Map<String, String> arEntityMap = this.getArEntityMap();
        Map<String, String> apEntityMap = this.getApEntityMap();
        String appid = (String)this.getModel().getValue(APPID);
        ComboEdit billtypeCbo = (ComboEdit)this.getView().getControl(E_ENTITYOBJECT);
        ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>(3);
        if ("ap".equals(appid)) {
            for (Map.Entry<String, String> entry : apEntityMap.entrySet()) {
                comboItem.add(new ComboItem(new LocaleString(entry.getValue()), entry.getKey()));
            }
        } else {
            for (Map.Entry<String, String> entry : arEntityMap.entrySet()) {
                comboItem.add(new ComboItem(new LocaleString(entry.getValue()), entry.getKey()));
            }
        }
        billtypeCbo.setComboItems(comboItem);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String seq = StringUtils.removeStart((String)key, (String)E_MAPPINGFIELDNAME);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
        String entityobject = (String)this.getModel().getValue(E_ENTITYOBJECT, rowIndex);
        if (EmptyUtils.isEmpty(entityobject)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bfc\u5165\u5bf9\u8c61\u3002", (String)"GlImportSchemeEdit_7", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        if (key.startsWith(E_BALANCEMAPPINGFIELDNAME)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityobject);
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setCurrentEntity("ap_finapbill".equals(entityobject) ? "detailentry" : ENTRY);
            option.setIncludeChildEntity(false);
            option.setIncludeParentEntity(false);
            option.addMatchedClassTypes(AmountProp.class);
            TreeNode billNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
            for (TreeNode treeNode : billNode.getChildren()) {
                this.treeNodeFilter(entityobject, treeNode);
            }
            this.showSelectFieldForm(key, billNode, seq);
        }
        if (key.startsWith(E_MAPPINGFIELDNAME)) {
            DynamicObject asstactitem = (DynamicObject)this.getModel().getValue(E_ASSTACTITEM + seq, rowIndex);
            TreeNode billNode = null;
            if (EmptyUtils.isNotEmpty(entityobject) && EmptyUtils.isNotEmpty(asstactitem)) {
                String valueSource = asstactitem.getString("valuesource.number");
                if (EmptyUtils.isEmpty(valueSource)) {
                    this.showSelectFieldForm(key, billNode, seq);
                    return;
                }
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityobject);
                List<IDataEntityProperty> properties = EntityMetadataUtils.getProperties(entityobject);
                HashSet<String> selectedEntity = new HashSet<String>();
                selectedEntity.add(entityobject);
                selectedEntity.add("detailentry");
                selectedEntity.add(ENTRY);
                PropTreeBuildOption option = null;
                for (IDataEntityProperty prop : properties) {
                    String baseEntityId;
                    if (!EmptyUtils.isNotEmpty(prop.getPropertyType()) || !(prop instanceof BasedataProp) || !valueSource.equals(baseEntityId = ((BasedataProp)prop).getBaseEntityId())) continue;
                    option = new PropTreeBuildOption(selectedEntity, prop);
                    option.setCurrentEntity(mainType.getName());
                    option.setIncludeChildEntity(false);
                    break;
                }
                if (EmptyUtils.isNotEmpty(option)) {
                    billNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, option);
                }
            }
            this.showSelectFieldForm(key, billNode, seq);
        }
    }

    private void treeNodeFilter(String entityobject, TreeNode treeNode) {
        for (int i = treeNode.getChildren().size() - 1; i >= 0; --i) {
            if ("ap_paidbill".equals(entityobject) && !"e_actamt".equals(((TreeNode)treeNode.getChildren().get(i)).getId())) {
                treeNode.deleteChildNode(((TreeNode)treeNode.getChildren().get(i)).getId());
            }
            if ("ar_receivedbill".equals(entityobject) && !"e_amount".equals(((TreeNode)treeNode.getChildren().get(i)).getId())) {
                treeNode.deleteChildNode(((TreeNode)treeNode.getChildren().get(i)).getId());
            }
            if ("ap_finapbill".equals(entityobject) && !"e_pricetaxtotal".equals(((TreeNode)treeNode.getChildren().get(i)).getId())) {
                treeNode.deleteChildNode(((TreeNode)treeNode.getChildren().get(i)).getId());
            }
            if ("ar_finarbill".equals(entityobject) && !"e_recamount".equals(((TreeNode)treeNode.getChildren().get(i)).getId())) {
                treeNode.deleteChildNode(((TreeNode)treeNode.getChildren().get(i)).getId());
            }
            if ("ap_busbill".equals(entityobject) && !"e_pricetaxtotal".equals(((TreeNode)treeNode.getChildren().get(i)).getId()) && !"e_amount".equals(((TreeNode)treeNode.getChildren().get(i)).getId())) {
                treeNode.deleteChildNode(((TreeNode)treeNode.getChildren().get(i)).getId());
            }
            if (!"ar_busbill".equals(entityobject) || "e_recamount".equals(((TreeNode)treeNode.getChildren().get(i)).getId()) || "e_amount".equals(((TreeNode)treeNode.getChildren().get(i)).getId())) continue;
            treeNode.deleteChildNode(((TreeNode)treeNode.getChildren().get(i)).getId());
        }
    }

    private MainEntityType getEntityObject() {
        IDataModel m = this.getModel();
        int row = m.getEntryCurrentRowIndex(ENTRY);
        return EntityMetadataCache.getDataEntityType((String)((String)m.getValue(E_ENTITYOBJECT, row)));
    }

    private void showSelectFieldForm(String key, TreeNode billNode, String seq) {
        if (null == billNode) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6%s\u4e3a\u7a7a\u6216\u5355\u636e\u4e0a\u6ca1\u6709\u5bf9\u5e94\u7684\u5b57\u6bb5\u7c7b\u578b\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u6620\u5c04\u5b57\u6bb5\u3002", (String)"GlImportSchemeEdit_10", (String)"fi-arapcommon", (Object[])new Object[]{seq}));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(BOTP_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (EmptyUtils.isNotEmpty(returnData)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
            String entityobject = (String)this.getModel().getValue(E_ENTITYOBJECT, rowIndex);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityobject);
            String actionId = closedCallBackEvent.getActionId();
            IDataEntityProperty prop = mainType.findProperty(returnData);
            if (ObjectUtils.isEmpty((Object)prop) || ObjectUtils.isEmpty((Object)prop.getPropertyType())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u53f6\u5b50\u8282\u70b9\u5b57\u6bb5\u3002", (String)"GlImportSchemeEdit_14", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
            this.receiveSelectField(this.getEntityObject(), returnData, org.apache.commons.lang3.StringUtils.remove((String)actionId, (String)"name"), actionId);
        }
    }

    private void receiveSelectField(MainEntityType mainType, String returnPropName, String sourceCtrlKey, String descFldKey) {
        if (StringUtils.isBlank((CharSequence)returnPropName)) {
            return;
        }
        IDataModel m = this.getModel();
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
        int row = this.getModel().getEntryCurrentRowIndex(ENTRY);
        m.setValue(sourceCtrlKey, (Object)returnPropName, row);
        m.setValue(descFldKey, (Object)fieldCaption, row);
    }

    private void filterMaterialByBillType(ListShowParameter showParameter, DynamicObject billType, int currentRow) {
        if (ObjectUtils.isEmpty((Object)billType)) {
            return;
        }
        String entityKey = (String)this.getModel().getValue(E_ENTITYOBJECT, currentRow);
        String number = billType.getString("number");
        QFilter filter = null;
        switch (entityKey) {
            case "ap_finapbill": {
                if ("ApFin_pur_BT_S".equals(number) || "ApFin_product_BT_S".equals(number)) {
                    filter = new QFilter("materialtype", "in", MaterialFilterHelper.getMaterialTypes());
                    break;
                }
                if ("ApFin_service_BT_S".equals(number)) {
                    filter = new QFilter("materialtype", "=", (Object)"9");
                    break;
                }
                if ("ApFin_purfee_BT_S".equals(number)) {
                    filter = new QFilter("materialtype", "=", (Object)"7");
                    break;
                }
                if (!"ap_finapbill_asset_BT_S".equals(number)) break;
                filter = new QFilter("materialtype", "=", (Object)"8");
                break;
            }
            case "ap_busbill": {
                if ("ap_busbill_stadpur_BT_S".equals(number)) {
                    filter = new QFilter("materialtype", "=", (Object)"1");
                    break;
                }
                if ("ap_busbill_feepur_BT_S".equals(number)) {
                    filter = new QFilter("materialtype", "=", (Object)"7");
                    break;
                }
                if ("ap_busbill_serpur_BT_S".equals(number)) {
                    filter = new QFilter("materialtype", "=", (Object)"9");
                    break;
                }
                if ("ap_busbill_asset_BT_S".equals(number)) {
                    filter = new QFilter("materialtype", "=", (Object)"8");
                    break;
                }
                if (!"ap_busbill_om_BT_S".equals(number)) break;
                filter = new QFilter("materialtype", "in", MaterialFilterHelper.getMaterialTypes());
                break;
            }
            case "ar_finarbill": {
                if ("arfin_standard_BT_S".equals(number)) {
                    List<String> materialTypes = MaterialFilterHelper.getMaterialTypes();
                    filter = new QFilter("materialtype", "in", materialTypes);
                    break;
                }
                if ("arfin_sersal_BT_S".equals(number)) {
                    filter = new QFilter("materialtype", "=", (Object)"9");
                    break;
                }
                if (!"arfin_salefee_BT_S".equals(number)) break;
                filter = new QFilter("materialtype", "=", (Object)"7");
                break;
            }
            case "ar_busbill": {
                filter = "ar_busbill_sersal_BT_S".equals(number) ? new QFilter("materialtype", "=", (Object)"9") : new QFilter("materialtype", "in", (Object)new String[]{"1", "2", "3", "4", "5", "6"});
            }
        }
        if (filter != null) {
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        for (RowDataEntity row : rowDataEntities = e.getRowDataEntities()) {
            Object entityObject = this.getModel().getValue(E_ENTITYOBJECT);
            this.controlEnable(entityObject, row.getRowIndex(), this.isLineType());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        OperationResult opResult = args.getOperationResult();
        String operateKey = op.getOperateKey().toLowerCase(Locale.ENGLISH);
        if ("execute".equals(operateKey) && !opResult.isShowMessage()) {
            if (opResult.isSuccess()) {
                this.getView().showSuccessNotification(opResult.getMessage());
            } else {
                HashMap<String, Object> customParam = new HashMap<String, Object>(2);
                customParam.put("title", opResult.getMessage());
                customParam.put("errorMsg", opResult.getAllErrorInfo().stream().map(OperateInfo::getMessage).collect(Collectors.toList()));
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("bos_operationresult");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.getCustomParams().putAll(customParam);
                parameter.setShowTitle(false);
                this.getView().showForm(parameter);
            }
        }
    }

    private boolean isLineType() {
        String appid = (String)this.getModel().getValue(APPID);
        DynamicObject org = (DynamicObject)this.getModel().getValue("useorg");
        long orgId = org.getLong("id");
        return LineTypeHelper.getParam(orgId, "ar".equals(appid));
    }

    private Map<String, String> getArEntityMap() {
        HashMap<String, String> arEntityMap = new HashMap<String, String>(3);
        arEntityMap.put("ar_busbill", ResManager.loadKDString((String)"\u671f\u521d\u6682\u4f30\u5e94\u6536\u5355", (String)"GlImportSchemeEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        arEntityMap.put("ar_finarbill", ResManager.loadKDString((String)"\u671f\u521d\u8d22\u52a1\u5e94\u6536\u5355", (String)"GlImportSchemeEdit_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        arEntityMap.put("ar_receivedbill", ResManager.loadKDString((String)"\u671f\u521d\u9884\u6536\u5355", (String)"GlImportSchemeEdit_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        return arEntityMap;
    }

    private Map<String, String> getApEntityMap() {
        HashMap<String, String> apEntityMap = new HashMap<String, String>(3);
        apEntityMap.put("ap_busbill", ResManager.loadKDString((String)"\u671f\u521d\u6682\u4f30\u5e94\u4ed8\u5355", (String)"GlImportSchemeEdit_4", (String)"fi-arapcommon", (Object[])new Object[0]));
        apEntityMap.put("ap_finapbill", ResManager.loadKDString((String)"\u671f\u521d\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"GlImportSchemeEdit_5", (String)"fi-arapcommon", (Object[])new Object[0]));
        apEntityMap.put("ap_paidbill", ResManager.loadKDString((String)"\u671f\u521d\u9884\u4ed8\u5355", (String)"GlImportSchemeEdit_6", (String)"fi-arapcommon", (Object[])new Object[0]));
        return apEntityMap;
    }

    private Set<String> getMatchAsstactitemSet() {
        HashSet<String> matchAsstactitemSet = new HashSet<String>();
        matchAsstactitemSet.add("bd_supplier");
        matchAsstactitemSet.add("bd_customer");
        matchAsstactitemSet.add("bos_user");
        matchAsstactitemSet.add("bos_org");
        return matchAsstactitemSet;
    }

    private Set<String> getBillEntitySet() {
        HashSet<String> billEntitySet = new HashSet<String>();
        billEntitySet.add("ap_finapbill");
        billEntitySet.add("ap_busbill");
        billEntitySet.add("ar_finarbill");
        billEntitySet.add("ar_busbill");
        return billEntitySet;
    }
}

