/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.check.base.HealthCheckFilter;
import kd.fi.arapcommon.helper.FilterColumnHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.FilterColumnSetting;

public class HealthCheckListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isNotEmpty(appId)) {
            e.getQFilters().add(new QFilter("bizapp.number", "=", (Object)appId));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if ("detail".equals(fieldName)) {
            args.setCancel(true);
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            int rowIndex = args.getHyperLinkClickEvent().getRowIndex();
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            long KeyValue = 0L;
            for (ListSelectedRow row : selectedRows) {
                int rowKey = row.getRowKey();
                if (rowIndex != rowKey) continue;
                KeyValue = (Long)row.getPrimaryKeyValue();
                break;
            }
            DynamicObject healthCheck = BusinessDataServiceHelper.loadSingle((Object)KeyValue, (String)"ap_healthcheck");
            this.openLinkBills(healthCheck);
        }
    }

    public void openLinkBills(DynamicObject healthCheck) {
        if (EmptyUtils.isEmpty(healthCheck.getDynamicObjectCollection("entry"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u5173\u8054\u7684\u5355\u636e\u3002", (String)"HealthCheckListPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection checkEntry = healthCheck.getDynamicObjectCollection("entry");
        String billType = ((DynamicObject)checkEntry.get(0)).getString("e_billtype");
        if (billType.equals("ccm_analyse_sum_rpt")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5de1\u67e5\u9879\u4e0d\u652f\u6301\u5217\u8868\u70b9\u63d0\u793a\u4fe1\u606f\u3002", (String)"HealthCheckListPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        List billIds = checkEntry.stream().map(entity -> entity.getLong("e_billid")).collect(Collectors.toList());
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(((DynamicObject)healthCheck.getDynamicObjectCollection("entry").get(0)).getString("e_billtype"));
        ListFilterParameter lfp = new ListFilterParameter();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("id", "in", billIds));
        lfp.setQFilters(filters);
        listShowParameter.setListFilterParameter(lfp);
        ShowType showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
        listShowParameter.getOpenStyle().setTargetKey(this.getView().getFormShowParameter().getOpenStyle().getTargetKey());
        listShowParameter.getOpenStyle().setShowType(showType);
        CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, "checkresinfo");
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        FilterColumnSetting setting = new FilterColumnSetting(FilterColumnSetting.FilterType.CommonFilterColumn, "org", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"HealthCheckListPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        setting.setDefaultValue("");
        customParams.put("commonfiltercolumns", Collections.singleton(FilterColumnHelper.toMap(setting)));
        customParams.put("isopenbyhyperlink", Boolean.TRUE);
        listShowParameter.setCustomParams(customParams);
        listShowParameter.setCloseCallBack(ccb);
        listShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("run".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
        if ("task".equals(key)) {
            boolean success = e.getOperationResult().isSuccess();
            if (success) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("ap_helathcondition");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("pkValue", this.getSelectedRows().get(0).getPrimaryKeyValue());
                showParameter.setCustomParam("isSingle", (Object)(this.getSelectedRows().size() == 1 ? 1 : 0));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ap_helathcondition");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            } else {
                e.getOperationResult().getSuccessPkIds().clear();
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"taskbtn"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        HashMap returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("taskcloseback".equals(actionId)) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
            this.getView().invokeOperation("refresh");
        }
        if ("ap_helathcondition".equals(actionId) && (returnData = (HashMap)closedCallBackEvent.getReturnData()) != null) {
            HealthCheckFilter checkFilter = this.getHealthCheckFilter(returnData);
            this.dispose(checkFilter);
        }
    }

    private HealthCheckFilter getHealthCheckFilter(HashMap returnData) {
        HealthCheckFilter filter = new HealthCheckFilter();
        DynamicObjectCollection orgList = (DynamicObjectCollection)returnData.get("orgs");
        Date startDate = (Date)returnData.get("startdate");
        Date endDate = (Date)returnData.get("enddate");
        List<Long> orgIds = orgList.stream().map(entity -> entity.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        filter.setOrgIds(orgIds);
        filter.setStartDate(startDate);
        filter.setEndDate(DateUtils.getDataFormat(endDate, false));
        Object moreFilerValTag = returnData.get("morefilterval_tag");
        if (EmptyUtils.isNotEmpty(moreFilerValTag)) {
            filter.setMoreFilterVal(moreFilerValTag.toString());
            filter.setEntityNumber(returnData.get("entitynumber").toString());
        }
        return filter;
    }

    private void dispose(HealthCheckFilter checkFilter) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getView().getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName("data check job");
        jobInfo.setTaskClassname("kd.fi.arapcommon.check.base.DataCheckTask");
        jobInfo.setId(UUID.randomUUID().toString());
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(16);
        parameterMap.put("taskBillIds", this.getSelectedRows().getPrimaryKeyValues());
        parameterMap.put("filter", JsonUtils.objToJson(checkFilter));
        parameterMap.put("orgId", RequestContext.get().getOrgId());
        jobInfo.setParams(parameterMap);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo formInfo = new JobFormInfo(jobInfo);
        formInfo.setCloseCallBack(closeCallBack);
        formInfo.setCanBackground(true);
        formInfo.setCanStop(true);
        formInfo.setTimeout(3600000);
        JobForm.dispatch((JobFormInfo)formInfo, (IFormView)this.getView());
    }

    private void taskCallBack(Object returnData) {
        if (returnData == null) {
            return;
        }
        if (!(returnData instanceof Map)) {
            return;
        }
        Map result = (Map)returnData;
        if (!result.containsKey("taskinfo")) {
            return;
        }
        String taskInfoStr = (String)result.get("taskinfo");
        if (EmptyUtils.isEmpty(taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (taskInfo.isTaskEnd()) {
            this.getView().invokeOperation("refresh");
        }
    }
}

