/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.exception.ManaulSettleQueryException;
import kd.fi.arapcommon.filterscheme.FilterSchemeHandler;
import kd.fi.arapcommon.filterscheme.IFilterSchemeCallBack;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApLicenseServiceHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationConfirmHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.service.ext.ManualSettleExtColumnHelper;
import kd.fi.arapcommon.service.ext.SettleExtDataListKeyVO;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.SettleHelper;
import kd.fi.arapcommon.service.helper.TxSettleServiceHelper;
import kd.fi.arapcommon.service.manualsettle.IManualSettleBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualProviderParam;
import kd.fi.arapcommon.service.manualsettle.ManualSettleBillProviderFactory;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.ManualSettleParam;

public abstract class ManualSettleBasePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(ManualSettleBasePlugin.class);
    private static final String PERMISSION_SETTLE = "/SJ=C433GRR6";
    protected static final String[] GRIDS = new String[]{"mainbill", "asstbill", "ar_finarbill", "cas_recbill"};
    protected static final String[] AMOUNT_SUMMARYS = new String[]{"summary_main", "summary_asst"};
    protected boolean isSingleSettle;
    protected List<String> mainListFields;
    protected List<String> asstListFields;
    protected IManualSettleBillProvider mainProvider;
    protected IManualSettleBillProvider asstProvider;
    private static String[] schemeOpKeys = new String[]{"addscheme", "savescheme", "deletescheme", "setdefault", "canceldefault"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId;
        String entityName;
        String mainAppId;
        LicenseCheckResult checkResult;
        super.preOpenForm(e);
        String appId = e.getFormShowParameter().getAppId();
        if ("dhc".equalsIgnoreCase(appId) && !(checkResult = ArApLicenseServiceHelper.check(mainAppId = "ar_handsettle".equals(entityName = FormMetadataCache.getFormConfig((String)(formId = e.getFormShowParameter().getFormId())).getEntityTypeId()) ? "/BBRH+122=39" : "+HKZHSKFXOX", entityName)).getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(checkResult.getMsg());
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnquery", "btnsave", "schemepanel"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid apGrid = (EntryGrid)this.getControl("mainbill");
        apGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                EntryGrid entryGrid = (EntryGrid)evt.getSource();
                ManualSettleBasePlugin.this.calCurSettleAmt(entryGrid, "summary_main", "currency", "cursettleamt");
            }
        });
        EntryGrid payGrid = (EntryGrid)this.getControl("asstbill");
        payGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                EntryGrid entryGrid = (EntryGrid)evt.getSource();
                ManualSettleBasePlugin.this.calCurSettleAmt(entryGrid, "summary_asst", "asst_currency", "asst_cursettleamt");
            }
        });
        OrgEdit orgCtrl = (OrgEdit)this.getControl("org");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List<Long> orgIdList = this.getOrgIdList();
            logger.info("ManualSettleBasePlugin\uff1a\u83b7\u5f97\u7684\u6709\u6743\u9650\u4e14\u5df2\u7ecf\u521d\u59cb\u5316\u7684\u7ec4\u7ec7" + orgIdList.size() + "\u4e2a");
            QFilter qFilter = new QFilter("id", "in", orgIdList);
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(qFilter);
            showParameter.getListFilterParameter().setQFilters(filters);
        });
        final FilterGrid mainFilterGrid = (FilterGrid)this.getControl("mainfiltergrid");
        mainFilterGrid.addBeforeF7SelectListener(new BeforeFilterF7SelectListener(){

            public void beforeF7Select(BeforeFilterF7SelectEvent arg) {
                String fieldName = arg.getFieldName();
                if ("expenseitem.name".equals(fieldName)) {
                    arg.getQfilters().add(new QFilter("enable", "=", (Object)Boolean.TRUE));
                } else if ("asstact.name".equals(fieldName)) {
                    ManualSettleBasePlugin.this.asstactSetFilter(mainFilterGrid, arg, "asstacttype");
                } else if ("itempayee.name".equals(fieldName)) {
                    ManualSettleBasePlugin.this.asstactSetFilter(mainFilterGrid, arg, "itempayeetype");
                } else if ("itempayer.name".equals(fieldName)) {
                    ManualSettleBasePlugin.this.asstactSetFilter(mainFilterGrid, arg, "itempayertype");
                }
            }
        });
        final FilterGrid asstFilterGrid = (FilterGrid)this.getControl("asstfiltergrid");
        asstFilterGrid.addBeforeF7SelectListener(new BeforeFilterF7SelectListener(){

            public void beforeF7Select(BeforeFilterF7SelectEvent arg) {
                String fieldName = arg.getFieldName();
                if ("e_expenseitem.name".equals(fieldName)) {
                    arg.getQfilters().add(new QFilter("enable", "=", (Object)Boolean.TRUE));
                } else if ("asstact.name".equals(fieldName)) {
                    ManualSettleBasePlugin.this.asstactSetFilter(asstFilterGrid, arg, "asstacttype");
                } else if ("itempayee.name".equals(fieldName)) {
                    ManualSettleBasePlugin.this.asstactSetFilter(asstFilterGrid, arg, "itempayeetype");
                } else if ("itempayer.name".equals(fieldName)) {
                    ManualSettleBasePlugin.this.asstactSetFilter(asstFilterGrid, arg, "itempayertype");
                }
            }
        });
        BasedataEdit baseDataCtrl = (BasedataEdit)this.getControl("asstactvalue");
        baseDataCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                QFilter baseDataFilter = BaseDataHelper.getBasedataFilter(showParameter.getBillFormId(), org.getLong("id"));
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(baseDataFilter);
                showParameter.getListFilterParameter().setQFilters(filters);
            }
        });
        apGrid.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                if (!"billno".equals(evt.getFieldName())) {
                    return;
                }
                ManualSettleBasePlugin.this.billHyperClick(evt.getFieldName(), evt.getRowIndex());
            }
        });
        payGrid.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                if (!"asst_billno".equals(evt.getFieldName())) {
                    return;
                }
                ManualSettleBasePlugin.this.billHyperClick(evt.getFieldName(), evt.getRowIndex());
            }
        });
    }

    private void billHyperClick(String operationKey, int index) {
        String entryEntity = "billno".equals(operationKey) ? "mainbill" : "asstbill";
        String formId = "billno".equals(operationKey) ? "mainEntity" : "asstEntity";
        String idEntity = "billno".equals(operationKey) ? "id" : "asst_id";
        String billtype = "billno".equals(operationKey) ? "billtype" : "asst_billtype";
        BillShowParameter param = new BillShowParameter();
        param.setPkId(((DynamicObject)this.getModel().getEntryEntity(entryEntity).get(index)).get(idEntity));
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String billTypeEntity = ((DynamicObject)this.getModel().getEntryEntity(entryEntity).get(index)).getString(billtype);
        if ("ap_paidbill".equals(billTypeEntity) || "ar_receivedbill".equals(billTypeEntity)) {
            param.setFormId(((DynamicObject)this.getModel().getEntryEntity(entryEntity).get(index)).getString(billtype));
        } else {
            param.setFormId(this.getPageCache().get(formId));
        }
        this.getView().showForm((FormShowParameter)param);
    }

    protected void asstactSetFilter(FilterGrid filterGrid, BeforeFilterF7SelectEvent arg, String typeName) {
        String entity = null;
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        List filterRows = filterCondition.getFilterRow();
        for (SimpleFilterRow filterRow : filterRows) {
            if (!typeName.equals(filterRow.getFieldName())) continue;
            List filterValue = filterRow.getValue();
            entity = (String)((FilterValue)filterValue.get(0)).getValue();
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (entity != null && org != null) {
            QFilter baseDataFilter = BaseDataHelper.getBasedataFilter(entity, org.getLong("id"));
            arg.getQfilters().add(baseDataFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object dataScope;
        Object totalDisplay;
        ArrayList<Long> ids;
        List parseArray;
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarpanel", "gridpanel", "viewcurrent"});
        Container queryPanel = (Container)this.getControl("querypanel");
        queryPanel.setCollapse(false);
        List<Long> orgIdList = this.getOrgIdList();
        if (orgIdList.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (!orgIdList.contains(orgId)) {
                orgId = orgIdList.get(0);
            }
            this.getModel().setValue("org", (Object)orgId);
            this.getPageCache().put("orgId", String.valueOf(orgId));
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object apcustomParam = formShowParameter.getCustomParam("finapbills");
        Object arcustomParam = formShowParameter.getCustomParam("finarbills");
        if (!ObjectUtils.isEmpty((Object)apcustomParam)) {
            parseArray = JSON.parseArray((String)apcustomParam.toString(), String.class);
            ids = new ArrayList<Long>(parseArray.size());
            for (String idStr : parseArray) {
                ids.add(Long.parseLong(idStr));
            }
            DynamicObjectCollection finapbills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,org,asstact,currency,settlestatus,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if (!ObjectUtils.isEmpty((Object)finapbills) && finapbills.size() > 0) {
                this.getModel().setValue("org", (Object)((DynamicObject)finapbills.get(0)).getLong("org"));
                this.getPageCache().put("orgId", String.valueOf(((DynamicObject)finapbills.get(0)).getLong("org")));
            }
        }
        if (!ObjectUtils.isEmpty((Object)arcustomParam)) {
            parseArray = JSON.parseArray((String)arcustomParam.toString(), String.class);
            ids = new ArrayList(parseArray.size());
            for (String idStr : parseArray) {
                ids.add(Long.parseLong(idStr));
            }
            DynamicObjectCollection finarbills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,org,asstact,currency,settlestatus,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if (!ObjectUtils.isEmpty((Object)finarbills) && finarbills.size() > 0) {
                this.getModel().setValue("org", (Object)((DynamicObject)finarbills.get(0)).getLong("org"));
                this.getPageCache().put("orgId", String.valueOf(((DynamicObject)finarbills.get(0)).getLong("org")));
            }
        }
        if ("entry".equals(totalDisplay = formShowParameter.getCustomParam("totaldisplay"))) {
            this.getModel().setValue("pagedisplay", (Object)"entry");
        }
        if ("prebill".equals(dataScope = formShowParameter.getCustomParam("datascope"))) {
            this.getPageCache().put("datascope", (String)dataScope);
        }
        this.cacheEntityNum();
        this.getPageCache().put("createnewdata", "true");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterSchemeHandler handler = new FilterSchemeHandler(this.getView());
        handler.beforeBindData();
        this.cacheEntityNum();
        this.initFilterGrid("mainfiltergrid", this.getPageCache().get("mainEntity"), true);
        if (this.isLoadAsstInfo()) {
            this.initFilterGrid("asstfiltergrid", this.getPageCache().get("asstEntity"), false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultFilterValue();
        this.lockSettleDate();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnquery": {
                this.reload();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)"settle", (CharSequence)evt.getItemKey())) {
            this.settle();
        } else if (StringUtils.equals((CharSequence)"resettle", (CharSequence)evt.getItemKey())) {
            this.openReSettlePage();
        } else if (StringUtils.equals((CharSequence)"clearing", (CharSequence)evt.getItemKey())) {
            this.clearing();
        } else if (StringUtils.equals((CharSequence)"refresh", (CharSequence)evt.getItemKey())) {
            this.reload();
        } else if (StringUtils.equals((CharSequence)"viewhistory", (CharSequence)evt.getItemKey())) {
            ListShowParameter listShowParameter = CommonSettleServiceHelper.getViewHistorySettleRecordParam(this.getSettleRecordEntity(), this.getPageCache().get("org"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if (StringUtils.equals((CharSequence)"viewcurrent", (CharSequence)evt.getItemKey())) {
            ListShowParameter listShowParameter = CommonSettleServiceHelper.getViewCurrentSettleRecordParam(this.getSettleRecordEntity(), this.getPageCache().get("org"), this.getPageCache().get("settleseq"));
            if (listShowParameter != null) {
                this.getView().showForm((FormShowParameter)listShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u672a\u751f\u6210\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"ManualSettleBasePlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }

    private void clearing() {
        EntryGrid mainGrid = (EntryGrid)this.getControl("mainbill");
        int[] mainSelectRows = mainGrid.getSelectRows();
        if (mainSelectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6e05\u7406\u7684\u5355\u636e\u3002", (String)"ManualSettleBasePlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManualSettleBasePlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        HashMap<String, HashSet<Long>> selectBillIdsByBillKey = new HashMap<String, HashSet<Long>>(1);
        for (int mainSelectRow : mainSelectRows) {
            DynamicObject mainRow = this.getModel().getEntryRowEntity("mainbill", mainSelectRow);
            Long pk = mainRow.getLong("id");
            String mainBillKey = mainRow.getString("billtype");
            HashSet<Long> ids = (HashSet<Long>)selectBillIdsByBillKey.get(mainBillKey);
            if (ObjectUtils.isEmpty((Object)ids)) {
                ids = new HashSet<Long>(mainSelectRows.length);
                ids.add(pk);
            } else {
                ids.add(pk);
            }
            selectBillIdsByBillKey.put(mainBillKey, ids);
        }
        if (selectBillIdsByBillKey.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u5355\u636e\u7c7b\u578b\u7684\u5355\u636e\u8fdb\u884c\u6e05\u7406\u3002", (String)"ManualSettleBasePlugin_28", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        Object object = selectBillIdsByBillKey.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry selectBills = (Map.Entry)object.next();
            String mainBillKey = (String)selectBills.getKey();
            Set selectIds = (Set)selectBills.getValue();
            String liquidateBillKey = "ap_finapbill".equals(mainBillKey) || "cas_paybill".equals(mainBillKey) || "ap_paidbill".equals(mainBillKey) ? "ap_liquidation" : "ar_liquidation";
            String mainEntity = this.getPageCache().get("mainEntity");
            if ("cas_paybill".equals(mainEntity)) {
                TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(selectIds.stream().map(String::valueOf).collect(Collectors.toList()));
            } else if ("cas_recbill".equals(mainEntity)) {
                TxSettleServiceHelper.validateRecBillIsExistUnfinishedTx(selectIds.stream().map(String::valueOf).collect(Collectors.toList()));
            }
            HashMap<String, String> customParam = new HashMap<String, String>(1);
            customParam.put("orgId", org.getString("id"));
            BOTPNewHelper.pushAndShow(mainBillKey, liquidateBillKey, selectIds, customParam, this.getView());
        }
    }

    @Deprecated
    protected void pushAndShow(String sourceEntity, String targetEntity, String ruleId, List<ListSelectedRow> selectedRows, Long orgId) {
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        args.setRuleId(ruleId);
        args.setHasRight(true);
        args.setSelectedRows(selectedRows);
        args.setAppId("ar");
        args.addCustomParam("bos_max_push_rows", ArApHelper.getMaxPushRows());
        args.addCustomParam("bos_support_bigdata_aysn", "true");
        args.addCustomParam("botp_requiredatamutex", "true");
        args.addCustomParam("ishasright", "true");
        args.addCustomParam("specialdataperm_currentappid", "ar");
        args.addCustomParam("skipbillnovalidatorabstractcoderule", "false");
        args.addCustomParam("botp_outformula", "false");
        args.addCustomParam("botp_isstrict", "false");
        args.addCustomParam("skipbillnovalidator", "false");
        args.addCustomParam("isstrict", "false");
        args.addCustomParam("ignoreassignperson", "false");
        args.addCustomParam("orgId", orgId.toString());
        IFormView parentView = this.getView();
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        if (result.isSuccess() && result.getCachePageIds().size() + result.getTargetBillIds().size() != 0) {
            if (result.getCachePageIds().size() + result.getTargetBillIds().size() == 1) {
                Push.showTargetBill((IFormView)parentView, (PushArgs)args, (ConvertOperationResult)result, (boolean)false);
                this.getView().sendFormAction(parentView);
            } else {
                Push.showMultiTargetBills((IFormView)parentView, (PushArgs)args, (ConvertOperationResult)result, (boolean)false);
                this.getView().sendFormAction(parentView);
            }
        } else {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        Object oldValue = changeData[0].getOldValue();
        String name = e.getProperty().getName();
        if ("pagedisplay".equals(name)) {
            this.fillMainGrid();
            if (this.isLoadAsstInfo()) {
                this.fillAsstGrid();
            }
            this.getView().setVisible(Boolean.FALSE, AMOUNT_SUMMARYS);
        } else if ("cursettleamt".equals(name)) {
            BigDecimal curSettleAmt = (BigDecimal)newValue;
            EntryGrid entryGrid = (EntryGrid)this.getControl("mainbill");
            DynamicObject focusRow = this.getModel().getEntryRowEntity("mainbill", rowIndex);
            BigDecimal unSettleAmt = focusRow.getBigDecimal("enableamt");
            if (curSettleAmt.abs().compareTo(unSettleAmt.abs()) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672a\u7ed3\u7b97\u91d1\u989d\u3002", (String)"ManualSettleBasePlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("mainbill", "cursettleamt", oldValue, rowIndex);
                return;
            }
            if (curSettleAmt.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"ManualSettleBasePlugin_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("mainbill", "cursettleamt", oldValue, rowIndex);
                return;
            }
            if (curSettleAmt.multiply(unSettleAmt).compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0d\u80fd\u6539\u53d8\u3002", (String)"ManualSettleBasePlugin_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("mainbill", "cursettleamt", oldValue, rowIndex);
                return;
            }
            this.calCurSettleAmt(entryGrid, "summary_main", "currency", "cursettleamt");
            BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate", rowIndex);
            DynamicObject basecurrency = focusRow.getDynamicObject("basecurrency");
            int baseAmtPrecision = basecurrency.getInt("amtprecision");
            String quotation = focusRow.getString("quotation");
            BigDecimal cursettlelocamt = CommonSettleServiceHelper.getLocamtByQuotation(quotation, curSettleAmt, exchangeRate, baseAmtPrecision);
            this.setEntryField("mainbill", "cursettlelocamt", cursettlelocamt, rowIndex);
        } else if ("asst_cursettleamt".equals(name)) {
            BigDecimal curSettleAmt = (BigDecimal)newValue;
            EntryGrid entryGrid = (EntryGrid)this.getControl("asstbill");
            DynamicObject focusRow = this.getModel().getEntryRowEntity("asstbill", rowIndex);
            BigDecimal unSettleAmt = focusRow.getBigDecimal("asst_unsettleamt");
            if (curSettleAmt.abs().compareTo(unSettleAmt.abs()) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672a\u7ed3\u7b97\u91d1\u989d\u3002", (String)"ManualSettleBasePlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("asstbill", "asst_cursettleamt", oldValue, rowIndex);
                return;
            }
            if (curSettleAmt.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"ManualSettleBasePlugin_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("asstbill", "asst_cursettleamt", oldValue, rowIndex);
                return;
            }
            if (curSettleAmt.multiply(unSettleAmt).compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0d\u80fd\u6539\u53d8\u3002", (String)"ManualSettleBasePlugin_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.setEntryField("asstbill", "asst_cursettleamt", oldValue, rowIndex);
                return;
            }
            this.calCurSettleAmt(entryGrid, "summary_asst", "asst_currency", "asst_cursettleamt");
            BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("asst_exchangerate", rowIndex);
            DynamicObject asst_basecurrency = focusRow.getDynamicObject("asst_basecurrency");
            int asstBaseAmtPrecision = asst_basecurrency.getInt("amtprecision");
            String asstQuotation = focusRow.getString("asst_quotation");
            BigDecimal asst_cursettlelocamt = CommonSettleServiceHelper.getLocamtByQuotation(asstQuotation, curSettleAmt, exchangeRate, asstBaseAmtPrecision);
            this.setEntryField("asstbill", "asst_cursettlelocamt", asst_cursettlelocamt, rowIndex);
        } else if ("settlerelation".equals(name)) {
            this.cacheEntityNum();
            this.getView().updateView();
            this.setDefaultFilterValue();
            this.getModel().deleteEntryData("mainbill");
            this.getModel().deleteEntryData("asstbill");
        } else if ("org".equals(name)) {
            this.getModel().deleteEntryData("mainbill");
            this.getModel().deleteEntryData("asstbill");
            if (newValue != null) {
                DynamicObject org = (DynamicObject)newValue;
                this.getPageCache().put("orgId", org.getPkValue().toString());
                this.setDefaultFilterValue();
            }
            this.lockSettleDate();
        } else if ("exchangerate".equals(name)) {
            BigDecimal exchangeRate = (BigDecimal)newValue;
            BigDecimal curSettleAmt = (BigDecimal)this.getModel().getValue("cursettleamt", rowIndex);
            DynamicObject focusRow = this.getModel().getEntryRowEntity("mainbill", rowIndex);
            String quotation = focusRow.getString("quotation");
            DynamicObject basecurrency = focusRow.getDynamicObject("basecurrency");
            int baseAmtPrecision = basecurrency.getInt("amtprecision");
            BigDecimal cursettlelocamt = CommonSettleServiceHelper.getLocamtByQuotation(quotation, curSettleAmt, exchangeRate, baseAmtPrecision);
            this.setEntryField("mainbill", "cursettlelocamt", cursettlelocamt, rowIndex);
        } else if ("asst_exchangerate".equals(name)) {
            BigDecimal exchangeRate = (BigDecimal)newValue;
            BigDecimal curSettleAmt = (BigDecimal)this.getModel().getValue("asst_cursettleamt", rowIndex);
            DynamicObject focusRow = this.getModel().getEntryRowEntity("asstbill", rowIndex);
            String quotation = focusRow.getString("asst_quotation");
            DynamicObject asst_basecurrency = focusRow.getDynamicObject("asst_basecurrency");
            int asstBaseAmtPrecision = asst_basecurrency.getInt("amtprecision");
            BigDecimal asstcursettlelocamt = CommonSettleServiceHelper.getLocamtByQuotation(quotation, curSettleAmt, exchangeRate, asstBaseAmtPrecision);
            this.setEntryField("asstbill", "asst_cursettlelocamt", asstcursettlelocamt, rowIndex);
        } else if ("cursettlelocamt".equals(name)) {
            BigDecimal cursettleLocAmt = (BigDecimal)newValue;
            BigDecimal curSettleAmt = (BigDecimal)this.getModel().getValue("cursettleamt", rowIndex);
            if (curSettleAmt.compareTo(BigDecimal.ZERO) != 0) {
                this.setEntryField("mainbill", "exchangerate", cursettleLocAmt.divide(curSettleAmt, 10, RoundingMode.HALF_UP), rowIndex);
            }
        } else if ("asst_cursettlelocamt".equals(name)) {
            BigDecimal cursettleLocAmt = (BigDecimal)newValue;
            BigDecimal curSettleAmt = (BigDecimal)this.getModel().getValue("asst_cursettleamt", rowIndex);
            if (curSettleAmt.compareTo(BigDecimal.ZERO) != 0) {
                this.setEntryField("asstbill", "asst_exchangerate", cursettleLocAmt.divide(curSettleAmt, 10, RoundingMode.HALF_UP), rowIndex);
            }
        } else if ("schemes".equals(name)) {
            FilterSchemeHandler handler = new FilterSchemeHandler(this.getView());
            handler.propertyChanged(e);
        }
    }

    public void lockSettleDate() {
        IDataModel m = this.getModel();
        boolean isAr = m.getDataEntityType().getName().equals("ar_handsettle");
        InitHelper init = null;
        DynamicObject org = (DynamicObject)m.getValue("org");
        if (org != null) {
            init = isAr ? new InitHelper(org.getLong("id"), "ar_init") : new InitHelper(org.getLong("id"), "ap_init");
            Date currentDate = init.getCurrentDate();
            if (ObjectUtils.isEmpty((Object)currentDate)) {
                currentDate = init.getStartDate();
            }
            DateTimeEdit settledate = (DateTimeEdit)this.getControl("settledate");
            settledate.setMinDate(currentDate);
        }
    }

    private void initFilterGrid(String controlName, String entityNumber, boolean isMian) {
        Label nameLabel;
        FilterGrid filterGrid = (FilterGrid)this.getControl(controlName);
        filterGrid.getFilterGridState().getFilterCondition().getFilterRow().clear();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (entityType == null) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u9875\u9762\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"ManualSettleBasePlugin_6", (String)"fi-arapcommon", (Object[])new Object[0])});
        }
        filterGrid.setEntityNumber(entityType.getName());
        filterGrid.getEntityNumber();
        if (isMian) {
            nameLabel = (Label)this.getControl("mainnamelabel");
            filterGrid.setFilterFieldKeys(this.getMainProvider().getFilterFieldKeys());
        } else {
            nameLabel = (Label)this.getControl("asstnamelabel");
            if (!entityNumber.equals("ar_liquidation") && !entityNumber.equals("ap_liquidation")) {
                filterGrid.setFilterFieldKeys(this.getAsstProvider().getFilterFieldKeys());
            }
        }
        nameLabel.setText(entityType.getDisplayName().toString());
    }

    protected void fillAsstGrid() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("asstbill");
        LocaleString amtColumnName = this.getAsstProvider().getAmtColumnName();
        grid.setColumnProperty("asst_amount", "header", (Object)amtColumnName);
        grid.setColumnProperty("asst_e_amount", "header", (Object)amtColumnName);
        ManualSettleExtColumnHelper.visibleAllExtColumns(this.getView(), false);
        IManualSettleBillProvider provider = this.getAsstProvider();
        Map<String, SettleExtDataListKeyVO> extMap = provider.getExtListInfo(this.isTotalDisplay(), false);
        extMap.forEach((k, v) -> {
            grid.setColumnProperty(k, "header", (Object)new LocaleString(ResManager.loadKDString((String)v.getSettleBillKeyName(), (String)"ManualSettleBasePlugin_7", (String)"fi-arapcommon", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.TRUE, new String[]{k});
        });
        this.getView().setVisible(Boolean.FALSE, new String[]{"asst_material", "asst_expenseitem", "asst_planduedate"});
        if (!this.isTotalDisplay()) {
            boolean asstIsMaterial = false;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            String settleRelation = (String)this.getModel().getValue("settlerelation");
            if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation)) {
                int asstSettleParam;
                if (org != null && (asstSettleParam = ArApHelper.getApSettleParam(org.getLong("id"))) == 1) {
                    asstIsMaterial = true;
                }
            } else if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
                int asstSettleParam;
                if (org != null && (asstSettleParam = ArApHelper.getArSettleParam(org.getLong("id"))) == 1) {
                    asstIsMaterial = true;
                }
            } else {
                int settleEntryParam = this.getSettleEntryParam();
                if (settleEntryParam == 1) {
                    asstIsMaterial = true;
                }
            }
            if (asstIsMaterial) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"asst_material", "asst_expenseitem"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"asst_planduedate"});
            }
        }
        this.getModel().deleteEntryData("asstbill");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = this.getAsstSetter();
        this.fillAsstVSData(vs);
        model.batchCreateNewEntryRow("asstbill", vs);
        model.endInit();
        this.getView().updateView("asstbill");
    }

    protected void fillAsstVSData(TableValueSetter vs) {
        QFilter gridFilter = this.getFilterGridValue("asstfiltergrid");
        IManualSettleBillProvider asstBillProvider = this.getAsstProvider();
        try {
            List<Object[]> asstRows = asstBillProvider.getBillDataRows(this.isTotalDisplay(), gridFilter);
            if (asstRows != null && asstRows.size() > 0) {
                for (Object[] row : asstRows) {
                    vs.addRow(row);
                }
            }
        }
        catch (ManaulSettleQueryException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    protected void fillMainGrid() {
        this.getModel().deleteEntryData("mainbill");
        EntryGrid grid = (EntryGrid)this.getView().getControl("mainbill");
        LocaleString amtColumnName = this.getMainProvider().getAmtColumnName();
        grid.setColumnProperty("pricetaxtotal", "header", (Object)amtColumnName);
        grid.setColumnProperty("e_pricetaxtotal", "header", (Object)amtColumnName);
        ManualSettleExtColumnHelper.visibleAllExtColumns(this.getView(), true);
        IManualSettleBillProvider provider = this.getMainProvider();
        Map<String, SettleExtDataListKeyVO> extMap = provider.getExtListInfo(this.isTotalDisplay(), true);
        extMap.forEach((k, v) -> {
            grid.setColumnProperty(k, "header", (Object)new LocaleString(ResManager.loadKDString((String)v.getSettleBillKeyName(), (String)"ManualSettleBasePlugin_7", (String)"fi-arapcommon", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.TRUE, new String[]{k});
        });
        this.getView().setVisible(Boolean.FALSE, new String[]{"material", "expenseitem", "planduedate"});
        if (!this.isTotalDisplay()) {
            boolean isMaterial = false;
            int settleEntryParam = this.getSettleEntryParam();
            if (settleEntryParam == 1) {
                isMaterial = true;
            }
            if (isMaterial) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"material", "expenseitem"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"planduedate"});
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = this.getMainSetter();
        this.fillMainVSData(vs);
        model.batchCreateNewEntryRow("mainbill", vs);
        model.endInit();
        this.getView().updateView("mainbill");
    }

    protected void fillMainVSData(TableValueSetter vs) {
        QFilter gridFilter = this.getFilterGridValue("mainfiltergrid");
        IManualSettleBillProvider mainBillProvider = this.getMainProvider();
        try {
            List<Object[]> mainRows = mainBillProvider.getBillDataRows(this.isTotalDisplay(), gridFilter);
            if (mainRows != null && mainRows.size() > 0) {
                for (Object[] row : mainRows) {
                    vs.addRow(row);
                }
            }
        }
        catch (ManaulSettleQueryException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    protected QFilter getFilterGridValue(String key) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(key);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)filterGrid.getEntityNumber());
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.setTimeService((ITimeService)this.getView().getService(ITimeService.class));
        filterBuilder.setUserService((IUserService)this.getView().getService(IUserService.class));
        filterBuilder.buildFilter(false);
        QFilter filter = filterBuilder.getQFilter();
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void settle() {
        String formId;
        String entityName;
        String mainAppId;
        LicenseCheckResult checkResult;
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("dhc".equalsIgnoreCase(appId) && !(checkResult = ArApLicenseServiceHelper.check(mainAppId = "ar_handsettle".equals(entityName = FormMetadataCache.getFormConfig((String)(formId = this.getView().getFormShowParameter().getFormId())).getEntityTypeId()) ? "/BBRH+122=39" : "+HKZHSKFXOX", entityName)).getHasLicense().booleanValue()) {
            this.getView().showErrorNotification(checkResult.getMsg());
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManualSettleBasePlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        if (!this.orgIsfinishinit(org.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u672a\u8fdb\u884c\u201c\u7ed3\u675f\u521d\u59cb\u5316\u201d\u3002", (String)"ManualSettleBasePlugin_8", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        if (!BaseDataHelper.checkCurrentUserPermission(org.getLong("id"), this.getModel().getDataEntityType().getName().contains("ar") ? "ar" : "ap", this.getModel().getDataEntityType().getName(), PERMISSION_SETTLE)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u624b\u5de5\u7ed3\u7b97\u7684\u201c\u7ed3\u7b97\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ManualSettleBasePlugin_9", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        if (!this.verify()) {
            return;
        }
        EntryGrid mainGrid = (EntryGrid)this.getControl("mainbill");
        int[] mainSelectRows = mainGrid.getSelectRows();
        EntryGrid asstGrid = (EntryGrid)this.getControl("asstbill");
        int[] asstSelectRows = asstGrid.getSelectRows();
        HashSet<Long> mainBillIds = new HashSet<Long>(mainSelectRows.length);
        DynamicObject[] mainRows = new DynamicObject[mainSelectRows.length];
        for (int i = 0; i < mainSelectRows.length; ++i) {
            DynamicObject mainRow;
            mainRows[i] = mainRow = this.getModel().getEntryRowEntity("mainbill", mainSelectRows[i]);
            mainBillIds.add(mainRow.getLong("id"));
        }
        HashSet<Long> asstBillIds = new HashSet<Long>(asstSelectRows.length);
        DynamicObject[] asstRows = new DynamicObject[asstSelectRows.length];
        for (int i = 0; i < asstSelectRows.length; ++i) {
            DynamicObject asstRow;
            asstRows[i] = asstRow = this.getModel().getEntryRowEntity("asstbill", asstSelectRows[i]);
            asstBillIds.add(asstRow.getLong("asst_id"));
        }
        Date createTime = new Date(System.currentTimeMillis() - 1000L);
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"manualsettle");){
            try {
                Object newValue = this.getModel().getValue("settledate");
                ManualSettleParam param = new ManualSettleParam();
                if (!ObjectUtils.isEmpty((Object)newValue)) {
                    param.setSettleDate((Date)newValue);
                }
                param.setOrgPk(org.getPkValue());
                param.setSingleSettle(this.isSingleSettle);
                param.setTotal(this.isTotalDisplay());
                boolean settleSelfFirst = (Boolean)this.getModel().getValue("settleselffirst");
                param.setSettleSelfFirst(settleSelfFirst);
                param.setSettleEntryParam(this.getSettleEntryParam());
                Object matchCondition = this.getModel().getValue("matchcondition");
                param.setDiffCurrencySettle("diffcurrency".equals(matchCondition));
                IManualSettleService manualService = this.getService();
                String mainEntity = this.getPageCache().get("mainEntity");
                if ("cas_paybill".equals(mainEntity)) {
                    TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(mainBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                } else if ("cas_recbill".equals(mainEntity)) {
                    TxSettleServiceHelper.validateRecBillIsExistUnfinishedTx(mainBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                }
                String asstEntity = this.getPageCache().get("asstEntity");
                if ("cas_paybill".equals(asstEntity)) {
                    TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(asstBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                } else if ("cas_recbill".equals(asstEntity)) {
                    TxSettleServiceHelper.validateRecBillIsExistUnfinishedTx(asstBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                }
                this.addSettleLockCtrl(mainRows, asstRows);
                manualService.manualSettle(mainRows, asstRows, param);
            }
            catch (Throwable e2) {
                try {
                    tx.markRollback();
                    this.getView().showErrorNotification(e2.getMessage());
                }
                catch (Throwable throwable2) {
                    try {
                        CommonSettleServiceHelper.settleReleaseMutexCtrl();
                        throw throwable2;
                    }
                    catch (Throwable e2) {
                        throwable = e2;
                        throw e2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
                CommonSettleServiceHelper.settleReleaseMutexCtrl();
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
            CommonSettleServiceHelper.settleReleaseMutexCtrl();
        }
        HashSet<Long> billIds = new HashSet<Long>(mainSelectRows.length);
        billIds.addAll(mainBillIds);
        billIds.addAll(asstBillIds);
        Set<Long> settleSeqs = CommonSettleServiceHelper.getSettleSeqs(billIds, createTime);
        if (EmptyUtils.isNotEmpty(settleSeqs)) {
            this.getPageCache().put("settleseq", SerializationUtils.toJsonString(settleSeqs));
        }
        this.fillMainGrid();
        if (this.isLoadAsstInfo()) {
            this.fillAsstGrid();
        }
        this.getView().setVisible(Boolean.FALSE, AMOUNT_SUMMARYS);
        this.getView().setVisible(Boolean.TRUE, new String[]{"viewcurrent"});
        DataSet settlerecord = QueryServiceHelper.queryDataSet((String)"settlerecord", (String)"ap_settlerecord", (String)"count(1)", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get("org"))), new QFilter("settleseq", "in", settleSeqs), new QFilter("createtime", ">=", (Object)createTime)}, null);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u5b8c\u6210\uff0c\u5171\u751f\u6210%s\u6761\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"ManualSettleBasePlugin_10", (String)"fi-arapcommon", (Object[])new Object[]{settlerecord.next().getInteger("count(1)")}));
    }

    protected boolean verify() {
        BigDecimal curSettleAmt;
        int i;
        EntryGrid mainGrid = (EntryGrid)this.getControl("mainbill");
        int[] mainSelectRows = mainGrid.getSelectRows();
        EntryGrid asstGrid = (EntryGrid)this.getControl("asstbill");
        int[] asstSelectRows = asstGrid.getSelectRows();
        Object matchCondition = this.getModel().getValue("matchcondition");
        if (mainSelectRows.length == 0 || asstSelectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e3b\u65b9\u548c\u8f85\u65b9\u9700\u8981\u6267\u884c\u7ed3\u7b97\u7684\u6570\u636e\u3002", (String)"ManualSettleBasePlugin_11", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        if (mainSelectRows.length == 0 && asstSelectRows.length != 0 || mainSelectRows.length != 0 && asstSelectRows.length == 0) {
            this.isSingleSettle = false;
        }
        String tempMainAsst = null;
        long tempCurrencyId = 0L;
        BigDecimal tempSettleAmt = BigDecimal.ZERO;
        Map<String, List<DynamicObject>> mainSelectRowAsstList = SettleHelper.getAsstTypeToAssListMap(this.getModel(), true, mainSelectRows);
        boolean mainMatch = SettleHelper.isAsstMatch(this.getModel(), true, mainSelectRows, mainSelectRowAsstList);
        Date MaxDate = (Date)this.getModel().getValue("settledate");
        boolean hasBoookDateField = this.getMainGridFields().contains("bookdate");
        for (int i2 = 0; i2 < mainSelectRows.length; ++i2) {
            DynamicObject mainRow = this.getModel().getEntryRowEntity("mainbill", mainSelectRows[i2]);
            boolean isMaxDate = this.compareSettleDate(MaxDate, mainRow, hasBoookDateField, "bizdate", "bookdate");
            if (!isMaxDate && MaxDate != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u7ed3\u7b97\u53cc\u65b9\u5355\u636e\u8bb0\u8d26\u65e5\u671f\u6216\u4e1a\u52a1\u65e5\u671f\u3002", (String)"ManualSettleBasePlugin_12", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            String asstActName = mainRow.get("asstact") != null ? mainRow.getString("asstact.name") : mainRow.getString("asstactname");
            DynamicObject currency = mainRow.getDynamicObject("currency");
            BigDecimal settleAmt = mainRow.getBigDecimal("cursettleamt");
            long currencyId = currency.getLong("id");
            if (i2 == 0) {
                tempMainAsst = asstActName;
                tempCurrencyId = currencyId;
                tempSettleAmt = settleAmt;
                continue;
            }
            if (!mainMatch) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u65b9\u7684\u5f80\u6765\u6237\u5e94\u76f8\u540c\u3002", (String)"ManualSettleBasePlugin_13", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if (tempCurrencyId != currencyId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u65b9\u7684\u5e01\u79cd\u5e94\u76f8\u540c\u3002", (String)"ManualSettleBasePlugin_14", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if ((tempSettleAmt.compareTo(BigDecimal.ZERO) <= 0 || settleAmt.compareTo(BigDecimal.ZERO) >= 0) && (tempSettleAmt.compareTo(BigDecimal.ZERO) >= 0 || settleAmt.compareTo(BigDecimal.ZERO) <= 0)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u65b9\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u5e94\u76f8\u540c\u3002", (String)"ManualSettleBasePlugin_15", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        String tempAsst = null;
        long tempAsstCurrencyId = 0L;
        Map<String, List<DynamicObject>> asstSelectRowAsstList = SettleHelper.getAsstTypeToAssListMap(this.getModel(), false, asstSelectRows);
        boolean asstMatch = SettleHelper.isAsstMatch(this.getModel(), false, asstSelectRows, asstSelectRowAsstList);
        for (int i3 = 0; i3 < asstSelectRows.length; ++i3) {
            DynamicObject asstRow = this.getModel().getEntryRowEntity("asstbill", asstSelectRows[i3]);
            boolean isMaxDate = this.compareSettleDate(MaxDate, asstRow, hasBoookDateField, "asst_bizdate", "asst_bookdate");
            if (!isMaxDate && MaxDate != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u7ed3\u7b97\u53cc\u65b9\u5355\u636e\u8bb0\u8d26\u65e5\u671f\u6216\u4e1a\u52a1\u65e5\u671f\u3002", (String)"ManualSettleBasePlugin_12", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            String asstActName = asstRow.get("asst_asstact") != null ? asstRow.getString("asst_asstact.name") : asstRow.getString("asst_asstactname");
            DynamicObject currency = asstRow.getDynamicObject("asst_currency");
            BigDecimal settleAmt = asstRow.getBigDecimal("asst_cursettleamt");
            long currencyId = currency.getLong("id");
            if (i3 == 0) {
                tempAsst = asstActName;
                tempAsstCurrencyId = currencyId;
                tempSettleAmt = settleAmt;
                continue;
            }
            if (!asstMatch) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f85\u65b9\u7684\u5f80\u6765\u6237\u5e94\u76f8\u540c\u3002", (String)"ManualSettleBasePlugin_16", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if (tempAsstCurrencyId != currencyId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u76f8\u540c\u7684\u4e3b\u65b9\u548c\u8f85\u65b9\u5355\u636e\u3002", (String)"ManualSettleBasePlugin_17", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if ((tempSettleAmt.compareTo(BigDecimal.ZERO) <= 0 || settleAmt.compareTo(BigDecimal.ZERO) >= 0) && (tempSettleAmt.compareTo(BigDecimal.ZERO) >= 0 || settleAmt.compareTo(BigDecimal.ZERO) <= 0)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f85\u65b9\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u5e94\u76f8\u540c\u3002", (String)"ManualSettleBasePlugin_18", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        if (!this.isSingleSettle) {
            boolean match = SettleHelper.isAsstMatch(this.getModel(), mainSelectRows, mainSelectRowAsstList, asstSelectRows, asstSelectRowAsstList);
            if ("asstandcur".equals(matchCondition) && (!match || tempCurrencyId != tempAsstCurrencyId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f80\u6765\u6237\u548c\u5e01\u79cd\u76f8\u540c\u7684\u4e3b\u65b9\u548c\u8f85\u65b9\u5355\u636e\u3002", (String)"ManualSettleBasePlugin_19", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if (tempCurrencyId != tempAsstCurrencyId && "bycurrency".equals(matchCondition)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u76f8\u540c\u7684\u4e3b\u65b9\u548c\u8f85\u65b9\u5355\u636e\u3002", (String)"ManualSettleBasePlugin_20", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if (tempCurrencyId == tempAsstCurrencyId && "diffcurrency".equals(matchCondition)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e3b\u65b9\u548c\u8f85\u65b9\u5355\u636e\u5e01\u79cd\u76f8\u540c\uff0c\u4e0d\u652f\u6301\u5f02\u5e01\u79cd\u7ed3\u7b97\u3002", (String)"ManualSettleBasePlugin_21", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
        }
        BigDecimal mainSettleAmt = BigDecimal.ZERO;
        BigDecimal asstSettleAmt = BigDecimal.ZERO;
        for (i = 0; i < mainSelectRows.length; ++i) {
            curSettleAmt = (BigDecimal)this.getModel().getValue("cursettleamt", mainSelectRows[i]);
            mainSettleAmt = mainSettleAmt.add(curSettleAmt);
        }
        for (i = 0; i < asstSelectRows.length; ++i) {
            curSettleAmt = (BigDecimal)this.getModel().getValue("asst_cursettleamt", asstSelectRows[i]);
            asstSettleAmt = asstSettleAmt.add(curSettleAmt);
        }
        if (this.isSingleSettle) {
            if ("diffcurrency".equals(matchCondition)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u65b9\u548c\u8f85\u65b9\u6570\u636e\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"ManualSettleBasePlugin_22", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if (mainSettleAmt.compareTo(BigDecimal.ZERO) != 0 || asstSettleAmt.compareTo(BigDecimal.ZERO) != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u5355\u65b9\u7ed3\u7b97\uff0c\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u5e94\u4e3a0\u3002", (String)"ManualSettleBasePlugin_23", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
        } else {
            String settleRelation = (String)this.getModel().getValue("settlerelation");
            if (this.getSettleRelationsOfValidate().contains(settleRelation) && mainSettleAmt.signum() != asstSettleAmt.signum()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91d1\u989d\u65b9\u5411\u76f8\u540c\u7684\u4e3b\u65b9\u548c\u8f85\u65b9\u5355\u636e\u3002", (String)"ManualSettleBasePlugin_24", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if (!"diffcurrency".equals(matchCondition) && mainSettleAmt.abs().compareTo(asstSettleAmt.abs()) != 0) {
                boolean manualSettleNextHideRes = this.getManualSettleNextHide();
                String operationConfirm = this.getView().getPageCache().get("operationConfirm");
                if (!manualSettleNextHideRes && EmptyUtils.isEmpty(operationConfirm)) {
                    String title = ResManager.loadKDString((String)"\u7ed3\u7b97\u53cc\u65b9\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u5c06\u6309\u6240\u52fe\u9009\u5355\u636e\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u8f83\u5c0f\u4e00\u65b9\u503c\u8fdb\u884c\u7ed3\u7b97\uff0c\u591a\u9009\u5355\u636e\u65f6\u6309\u65e5\u671f\u4ece\u5c0f\u5230\u5927\u4f9d\u6b21\u7ed3\u7b97\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ManualSettleBasePlugin_25", (String)"fi-arapcommon", (Object[])new Object[0]);
                    OperationConfirmHelper operationConfirmHelper = new OperationConfirmHelper(this.getView(), (IFormPlugin)this);
                    operationConfirmHelper.openOperationConfirm(title, new ArrayList<String>(1), true);
                    return false;
                }
                this.getPageCache().remove("operationConfirm");
            }
        }
        return BizExtendHelper.invokeBeforeSettleCallback(this.getView());
    }

    private boolean compareSettleDate(Date MaxDate, DynamicObject mainRow, boolean hasBoookDateField, String bizDateFiled, String bookDateFiled) {
        if (EmptyUtils.isNotEmpty(MaxDate)) {
            Date bookDate;
            Date bizDate = mainRow.getDate(bizDateFiled);
            if (DateUtils.getDiffDaysIgnoreTime(bizDate, MaxDate) >= 0) {
                return true;
            }
            if (hasBoookDateField && (bookDate = mainRow.getDate(bookDateFiled)) != null && DateUtils.getDiffDaysIgnoreTime(bookDate, MaxDate) >= 0) {
                return true;
            }
        }
        return false;
    }

    private boolean getManualSettleNextHide() {
        String cacheKey;
        long userId = RequestContext.get().getCurrUserId();
        String manualSettleNextHide = UserConfigServiceHelper.getSetting((long)userId, (String)(cacheKey = this.isAr() ? "ar_manualSettleNextHide" : "ap_manualSettleNextHide"));
        return "1".equals(manualSettleNextHide);
    }

    private boolean isAr() {
        String formId = this.getView().getFormShowParameter().getFormId();
        return "ar_handsettle".equals(formId);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("operationConfirm".equals(actionId) && e.getReturnData() != null) {
            this.getView().getPageCache().put("operationConfirm", "ok");
            long userId = RequestContext.get().getCurrUserId();
            Map returnData = (Map)e.getReturnData();
            boolean nexthide = (Boolean)returnData.get("nexthide");
            String cacheKey = this.isAr() ? "ar_manualSettleNextHide" : "ap_manualSettleNextHide";
            boolean manualSettleNextHideRes = UserConfigServiceHelper.setSetting((long)userId, (String)cacheKey, (String)(nexthide ? "1" : "0"));
            if (manualSettleNextHideRes) {
                this.settle();
            }
        }
    }

    protected void calCurSettleAmt(EntryGrid entryGrid, String summaryKey, String currencyKey, String curSettleAmtKey) {
        int[] selectRowIndexs = entryGrid.getSelectRows();
        if (selectRowIndexs.length > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{summaryKey});
            BigDecimal totalAmt = BigDecimal.ZERO;
            for (int i = 0; i < selectRowIndexs.length; ++i) {
                DynamicObject row = this.getModel().getEntryRowEntity(entryGrid.getEntryKey(), selectRowIndexs[i]);
                DynamicObject currency = row.getDynamicObject(currencyKey);
                totalAmt = totalAmt.add(row.getBigDecimal(curSettleAmtKey));
                totalAmt = totalAmt.setScale(currency.getInt("amtprecision"), 4);
                Label summary = (Label)this.getControl(summaryKey);
                summary.setText(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\uff1a%1$s%2$s\u3002", (String)"ManualSettleBasePlugin_26", (String)"fi-arapcommon", (Object[])new Object[0]), currency.getString("sign"), totalAmt.toPlainString()));
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{summaryKey});
        }
    }

    protected boolean isTotalDisplay() {
        String pageDisplay = (String)this.getModel().getValue("pagedisplay");
        boolean isTotalDisplay = "total".equals(pageDisplay);
        return isTotalDisplay;
    }

    protected void reload() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ManualSettleBasePlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        if (!this.orgIsfinishinit(org.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u672a\u8fdb\u884c\u201c\u7ed3\u675f\u521d\u59cb\u5316\u201d\u3002", (String)"ManualSettleBasePlugin_8", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("org", org.getPkValue().toString());
        Container queryPanel = (Container)this.getControl("querypanel");
        queryPanel.setCollapse(true);
        this.getView().setVisible(Boolean.TRUE, new String[]{"toolbarpanel", "gridpanel"});
        Container mainBillPanel = (Container)this.getControl("adv_mainbill");
        mainBillPanel.setCollapse(false);
        Container asstBillPanel = (Container)this.getControl("adv_asstbill");
        asstBillPanel.setCollapse(false);
        this.fillMainGrid();
        if (this.isLoadAsstInfo()) {
            this.fillAsstGrid();
        }
        this.getView().setVisible(Boolean.FALSE, AMOUNT_SUMMARYS);
    }

    private List<String> getSettleRelationsOfValidate() {
        ArrayList<String> settleRelations = new ArrayList<String>(7);
        settleRelations.add(SettleRelationEnum.APPAYSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.APARSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.ARAPSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.RECPAYSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.PAYRECSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.RECSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.BADDEBTRECOVERY.getValue());
        return settleRelations;
    }

    protected void cacheEntityNum() {
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ap_finapbill");
            this.getPageCache().put("asstEntity", "cas_paybill");
        } else if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ar_finarbill");
            this.getPageCache().put("asstEntity", "cas_recbill");
        } else if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ap_finapbill");
            this.getPageCache().put("asstEntity", "ar_finarbill");
        } else if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ar_finarbill");
            this.getPageCache().put("asstEntity", "ap_finapbill");
        } else if (SettleRelationEnum.BADDEBTRECOVERY.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ar_baddebtlossbill");
            this.getPageCache().put("asstEntity", "cas_recbill");
        } else if (SettleRelationEnum.RECPAYSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_recbill");
            this.getPageCache().put("asstEntity", "cas_paybill");
        } else if (SettleRelationEnum.PAYRECSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_paybill");
            this.getPageCache().put("asstEntity", "cas_recbill");
        } else if (SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ap_finapbill");
            this.getPageCache().put("asstEntity", "cas_recbill");
        } else if (SettleRelationEnum.ARPAYSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ar_finarbill");
            this.getPageCache().put("asstEntity", "cas_paybill");
        } else if (SettleRelationEnum.APSELF.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ap_finapbill");
            this.getPageCache().put("asstEntity", "ap_finapbill");
        } else if (SettleRelationEnum.PAYSELF.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_paybill");
            this.getPageCache().put("asstEntity", "cas_paybill");
        } else if (SettleRelationEnum.ARSELF.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "ar_finarbill");
            this.getPageCache().put("asstEntity", "ar_finarbill");
        } else if (SettleRelationEnum.RECSELF.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_recbill");
            this.getPageCache().put("asstEntity", "cas_recbill");
        } else if (SettleRelationEnum.RECCLEARINGSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_recbill");
            this.getPageCache().put("asstEntity", "ar_liquidation");
        } else if (SettleRelationEnum.PAYCLEARINGSETTLE.getValue().equals(settleRelation)) {
            this.getPageCache().put("mainEntity", "cas_paybill");
            this.getPageCache().put("asstEntity", "ap_liquidation");
        }
    }

    protected void setDefaultFilterValue() {
        FilterGrid mainFilterGrid = (FilterGrid)this.getControl("mainfiltergrid");
        FilterCondition mainFilter = this.getMainProvider().getDefaultFilter();
        mainFilterGrid.SetValue(mainFilter);
        if (this.isLoadAsstInfo()) {
            FilterGrid asstFilterGrid = (FilterGrid)this.getControl("asstfiltergrid");
            FilterCondition asstFilter = this.getAsstProvider().getDefaultFilter();
            asstFilterGrid.SetValue(asstFilter);
        }
    }

    protected abstract List<Long> getOrgIdList();

    protected abstract String getSettleRecordEntity();

    protected abstract IManualSettleService getService();

    protected TableValueSetter getMainSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<String> mainGridFields = this.getMainGridFields();
        for (String fieldkey : mainGridFields) {
            vs.addField(fieldkey, new Object[0]);
        }
        return vs;
    }

    protected TableValueSetter getAsstSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<String> asstGridFields = this.getAsstGridFields();
        for (String fieldkey : asstGridFields) {
            vs.addField(fieldkey, new Object[0]);
        }
        return vs;
    }

    protected List<String> getMainGridFields() {
        if (this.mainListFields == null) {
            this.mainListFields = new ArrayList<String>(64);
            EntryGrid mainGrid = (EntryGrid)this.getControl("mainbill");
            List fieldEdits = mainGrid.getFieldEdits();
            for (FieldEdit field : fieldEdits) {
                this.mainListFields.add(field.getKey());
            }
        }
        return this.mainListFields;
    }

    protected List<String> getAsstGridFields() {
        if (this.asstListFields == null) {
            this.asstListFields = new ArrayList<String>(64);
            EntryGrid mainGrid = (EntryGrid)this.getControl("asstbill");
            List fieldEdits = mainGrid.getFieldEdits();
            for (FieldEdit field : fieldEdits) {
                this.asstListFields.add(field.getKey());
            }
        }
        return this.asstListFields;
    }

    protected IManualSettleBillProvider getMainProvider() {
        if (this.mainProvider == null) {
            ManualProviderParam param = this.getManualProviderParam();
            param.setMain(true);
            return ManualSettleBillProviderFactory.getMainBillProvider(param);
        }
        return this.mainProvider;
    }

    protected IManualSettleBillProvider getAsstProvider() {
        if (this.asstProvider == null) {
            ManualProviderParam param = this.getManualProviderParam();
            param.setMain(false);
            return ManualSettleBillProviderFactory.getAsstBillProvider(param);
        }
        return this.asstProvider;
    }

    protected int getSettleEntryParam() {
        String settleEntryParam = (String)this.getModel().getValue("settleparam");
        return Integer.parseInt(settleEntryParam);
    }

    protected boolean getSubmitSettleParam() {
        DynamicObject org;
        boolean flag = false;
        String submitSettle = this.getPageCache().get("submitsettle");
        if (!ObjectUtils.isEmpty((Object)submitSettle)) {
            flag = Boolean.parseBoolean(submitSettle);
        }
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation)) {
            DynamicObject org2 = (DynamicObject)this.getModel().getValue("org");
            if (org2 != null) {
                flag = SystemParameterHelper.getAPBooleanParam(org2.getLong("id"), "ap_016");
            }
        } else if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation) && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            flag = SystemParameterHelper.getARBooleanParam(org.getLong("id"), "ar_016");
        }
        return flag;
    }

    protected ManualProviderParam getManualProviderParam() {
        int asstSettleParam;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject asstact = (DynamicObject)this.getModel().getValue("asstactvalue");
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        ManualProviderParam param = new ManualProviderParam();
        param.setOrgPk(org == null ? org : org.getPkValue());
        param.setSettleRelation(settleRelation);
        param.setFields(this.getMainGridFields());
        param.setSettleEntryParam(this.getSettleEntryParam());
        if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) && org != null) {
            asstSettleParam = ArApHelper.getApSettleParam(org.getLong("id"));
            param.setAsstSettleEntryParam(asstSettleParam);
        }
        if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation) && org != null) {
            asstSettleParam = ArApHelper.getArSettleParam(org.getLong("id"));
            param.setAsstSettleEntryParam(asstSettleParam);
        }
        param.setAsstact(asstact);
        param.setSubmitSettle(this.getSubmitSettleParam());
        param.setTotalDisplay(this.isTotalDisplay());
        String datascope = this.getPageCache().get("datascope");
        if ("prebill".equals(datascope)) {
            param.setOnlyShowPre(true);
        }
        return param;
    }

    private void setEntryField(String entryKey, String entryFieldKey, Object value, int focusRowIndex) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRowIndexs = entryGrid.getSelectRows();
        this.getModel().beginInit();
        this.getModel().setValue(entryFieldKey, value, focusRowIndex);
        this.getModel().endInit();
        this.getView().updateView(entryKey, focusRowIndex);
        entryGrid.selectRows(selectRowIndexs, focusRowIndex);
    }

    private boolean orgIsfinishinit(long orgId) {
        String entityName = this.getModel().getDataEntityType().getName().contains("ar") ? "ar_init" : "ap_init";
        DynamicObject initOrg = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,org", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)Boolean.TRUE), new QFilter("org", "=", (Object)orgId)});
        return initOrg != null;
    }

    protected void addSettleLockCtrl(DynamicObject[] mainRows, DynamicObject[] asstRows) {
        if (mainRows == null || asstRows == null || mainRows.length == 0 || asstRows.length == 0) {
            return;
        }
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject main : mainRows) {
            mainBillIdSet.add(main.getLong("id"));
        }
        HashSet<Long> asstBillIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asst : asstRows) {
            asstBillIdSet.add(asst.getLong("asst_id"));
        }
        String mainEntity = this.getPageCache().get("mainEntity");
        String asstEntity = this.getPageCache().get("asstEntity");
        if (ObjectUtils.isEmpty((Object)mainEntity) || ObjectUtils.isEmpty((Object)asstEntity)) {
            return;
        }
        CommonSettleServiceHelper.settleAddMutexCtrl(mainBillIdSet, mainEntity, asstBillIdSet, asstEntity, false);
    }

    protected boolean isLoadAsstInfo() {
        return !"ar_liquidation".equals(this.getPageCache().get("asstEntity")) && !"ap_liquidation".equals(this.getPageCache().get("asstEntity"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (Arrays.asList(schemeOpKeys).contains(opKey)) {
            FilterSchemeCallBack callBack = new FilterSchemeCallBack();
            FilterSchemeHandler handler = new FilterSchemeHandler(opKey, callBack, this.getView());
            handler.afterDoOperation();
        }
    }

    public void openReSettlePage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("ap_resettle");
        this.getView().showForm(parameter);
    }

    class FilterSchemeCallBack
    implements IFilterSchemeCallBack {
        FilterSchemeCallBack() {
        }

        @Override
        public void onAdd() {
            ManualSettleBasePlugin.this.setDefaultFilterValue();
            IDataModel model = ManualSettleBasePlugin.this.getModel();
            model.setValue("schemes", null);
            model.setValue("schemename", null);
        }

        @Override
        public String onSave() {
            IDataModel model = ManualSettleBasePlugin.this.getModel();
            DynamicObject manualSettleData = model.getDataEntity();
            HashMap<String, Object> schemeMap = new HashMap<String, Object>(8);
            schemeMap.put("org", manualSettleData.getLong("org.id"));
            String settleRelation = manualSettleData.getString("settlerelation");
            schemeMap.put("settlerelation", settleRelation);
            long asstactValueId = manualSettleData.getLong("asstactvalue.id");
            schemeMap.put("asstactvalue", asstactValueId == 0L ? null : Long.valueOf(asstactValueId));
            IFormView view = ManualSettleBasePlugin.this.getView();
            FilterGrid filterGrid = (FilterGrid)view.getControl("mainfiltergrid");
            FilterGrid.FilterGridState mainFilterGridState = filterGrid.getFilterGridState();
            FilterCondition mainFilter = mainFilterGridState.getFilterCondition();
            String mainFilterStr = SerializationUtils.toJsonString((Object)mainFilter);
            schemeMap.put("mainfilter", mainFilterStr);
            if (!"recclearing".equals(settleRelation) && !"payclearing".equals(settleRelation)) {
                filterGrid = (FilterGrid)view.getControl("asstfiltergrid");
                FilterGrid.FilterGridState asstFilterGridState = filterGrid.getFilterGridState();
                FilterCondition asstFilter = asstFilterGridState.getFilterCondition();
                String asstFilterStr = SerializationUtils.toJsonString((Object)asstFilter);
                schemeMap.put("asstfilter", asstFilterStr);
            }
            return SerializationUtils.toJsonString(schemeMap);
        }

        @Override
        public void onDelete() {
            ManualSettleBasePlugin.this.setDefaultFilterValue();
        }
    }
}

