/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

@Deprecated
public class ManualSettlePluginHelper {
    public static List<String> getFilterFieldKeys(String entityNumber) {
        List<Object> keys = new ArrayList();
        if ("ap_finapbill".equals(entityNumber)) {
            keys = ManualSettlePluginHelper.getApFieldKeys();
        } else if ("cas_paybill".equals(entityNumber)) {
            keys = ManualSettlePluginHelper.getPayFieldKeys();
        } else if ("ar_finarbill".equals(entityNumber)) {
            keys = ManualSettlePluginHelper.getArFieldKeys();
        } else if ("cas_recbill".equals(entityNumber)) {
            keys = ManualSettlePluginHelper.getRecFieldKeys();
        } else if ("ar_baddebtlossbill".equals(entityNumber)) {
            keys = ManualSettlePluginHelper.getLossFieldKeys();
        }
        return keys;
    }

    private static List<String> getLossFieldKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("billno");
        keys.add("asstacttype");
        keys.add("asstact.name");
        keys.add("org.name");
        keys.add("currency.name");
        keys.add("bizdate");
        keys.add("baddebtcause");
        keys.add("baddebtamt");
        keys.add("remark");
        keys.add("e_material.name");
        keys.add("e_expenseitem.name");
        keys.add("e_unsettleamt");
        return keys;
    }

    public static FilterCondition getDefaultFilter(String entityNumber, String orgId) {
        FilterCondition fc = new FilterCondition();
        if ("ap_finapbill".equals(entityNumber)) {
            fc = ManualSettlePluginHelper.getApDefaultFilter(orgId, "ap_init");
        } else if ("cas_paybill".equals(entityNumber)) {
            fc = ManualSettlePluginHelper.getPayDefaultFilter(orgId);
        } else if ("ar_finarbill".equals(entityNumber) || "ar_baddebtlossbill".equals(entityNumber)) {
            fc = ManualSettlePluginHelper.getApDefaultFilter(orgId, "ar_init");
            List filterRows = fc.getFilterRow();
            for (SimpleFilterRow row : filterRows) {
                if (!"asstacttype".equals(row.getFieldName())) continue;
                ArrayList<FilterValue> asstActTypeValues = new ArrayList<FilterValue>();
                FilterValue asstActTypeValue = new FilterValue();
                asstActTypeValue.setValue((Object)"bd_customer");
                asstActTypeValues.add(asstActTypeValue);
                row.setValue(asstActTypeValues);
                break;
            }
        } else if ("cas_recbill".equals(entityNumber)) {
            fc = ManualSettlePluginHelper.getRecDefaultFilter(orgId);
        }
        return fc;
    }

    private static List<String> getApFieldKeys() {
        ArrayList<String> keys = new ArrayList<String>(64);
        keys.add("billno");
        keys.add("asstacttype");
        keys.add("asstact.name");
        keys.add("payorg.name");
        keys.add("currency.name");
        keys.add("bizdate");
        keys.add("remark");
        keys.add("duedate");
        keys.add("purmode");
        keys.add("paycond.name");
        keys.add("settlementtype.name");
        keys.add("purorg.name");
        keys.add("purdept.name");
        keys.add("purchaser.name");
        keys.add("pricetaxtotal");
        keys.add("material.name");
        keys.add("expenseitem.name");
        keys.add("corebillno");
        keys.add("unsettleamt");
        return keys;
    }

    private static List<String> getArFieldKeys() {
        ArrayList<String> keys = new ArrayList<String>(64);
        keys.add("billno");
        keys.add("asstacttype");
        keys.add("asstact.name");
        keys.add("recorg.name");
        keys.add("currency.name");
        keys.add("bizdate");
        keys.add("remark");
        keys.add("duedate");
        keys.add("paymode");
        keys.add("paycond.name");
        keys.add("settlementtype.name");
        keys.add("salesorg.name");
        keys.add("salesgroup.name");
        keys.add("salesman.name");
        keys.add("recamount");
        keys.add("e_material.name");
        keys.add("e_expenseitem.name");
        keys.add("e_corebillno");
        keys.add("e_unsettleamt");
        return keys;
    }

    private static List<String> getPayFieldKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("billno");
        keys.add("org.name");
        keys.add("payeetype");
        keys.add("payeename");
        keys.add("currency.name");
        keys.add("bizdate");
        keys.add("description");
        keys.add("actpayamt");
        keys.add("e_material.name");
        keys.add("e_expenseitem.name");
        keys.add("e_corebillno");
        keys.add("e_unsettledamt");
        return keys;
    }

    private static List<String> getRecFieldKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("billno");
        keys.add("org.name");
        keys.add("payertype");
        keys.add("payername");
        keys.add("currency.name");
        keys.add("bizdate");
        keys.add("txt_description");
        keys.add("actrecamt");
        keys.add("e_material.name");
        keys.add("e_expenseitem.name");
        keys.add("e_corebillno");
        keys.add("e_unsettledamt");
        return keys;
    }

    public static TableValueSetter getMainBillSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField("billno", new Object[0]);
        vs.addField("bizdate", new Object[0]);
        vs.addField("billtype", new Object[0]);
        vs.addField("asstacttype", new Object[0]);
        vs.addField("asstactname", new Object[0]);
        vs.addField("paymenttype", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("exchangerate", new Object[0]);
        vs.addField("pricetaxtotal", new Object[0]);
        vs.addField("entryid", new Object[0]);
        vs.addField("material", new Object[0]);
        vs.addField("expenseitem", new Object[0]);
        vs.addField("e_pricetaxtotal", new Object[0]);
        vs.addField("unsettleamt", new Object[0]);
        vs.addField("enableamt", new Object[0]);
        vs.addField("cursettleamt", new Object[0]);
        return vs;
    }

    public static TableValueSetter getPayBillSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("pay_id", new Object[0]);
        vs.addField("pay_billtype", new Object[0]);
        vs.addField("pay_billno", new Object[0]);
        vs.addField("pay_bizdate", new Object[0]);
        vs.addField("pay_asstacttype", new Object[0]);
        vs.addField("pay_asstactname", new Object[0]);
        vs.addField("paymenttype", new Object[0]);
        vs.addField("pay_currency", new Object[0]);
        vs.addField("pay_exchangerate", new Object[0]);
        vs.addField("actpayamt", new Object[0]);
        vs.addField("pay_entryid", new Object[0]);
        vs.addField("e_material", new Object[0]);
        vs.addField("e_expenseitem", new Object[0]);
        vs.addField("e_payableamt", new Object[0]);
        vs.addField("pay_unsettleamt", new Object[0]);
        vs.addField("pay_cursettleamt", new Object[0]);
        return vs;
    }

    public static FilterCondition getApDefaultFilter(String orgId, String initEntity) {
        DynamicObject currency;
        FilterCondition fc = new FilterCondition();
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>();
        SimpleFilterRow bizDateRow = new SimpleFilterRow();
        bizDateRow.setCompareType("63");
        bizDateRow.setFieldName("bizdate");
        bizDateRow.setLogic("0");
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>();
        FilterValue dateValue = new FilterValue();
        dateValue.setValue((Object)"");
        dateValues.add(dateValue);
        bizDateRow.setValue(dateValues);
        rows.add(bizDateRow);
        fc.setFilterRow(rows);
        SimpleFilterRow asstActTypeRow = new SimpleFilterRow();
        asstActTypeRow.setCompareType("105");
        asstActTypeRow.setFieldName("asstacttype");
        asstActTypeRow.setLogic("0");
        ArrayList<FilterValue> asstActTypeValues = new ArrayList<FilterValue>();
        FilterValue asstActTypeValue = new FilterValue();
        asstActTypeValue.setValue((Object)"bd_supplier");
        asstActTypeValues.add(asstActTypeValue);
        asstActTypeRow.setValue(asstActTypeValues);
        rows.add(asstActTypeRow);
        SimpleFilterRow asstActRow = new SimpleFilterRow();
        asstActRow.setCompareType("800");
        asstActRow.setFieldName("asstact.name");
        asstActRow.setLogic("0");
        rows.add(asstActRow);
        if (!StringUtils.isEmpty((String)orgId) && (currency = ManualSettlePluginHelper.getStandardCurrency(Long.parseLong(orgId), initEntity)) != null) {
            SimpleFilterRow currencyRow = new SimpleFilterRow();
            currencyRow.setCompareType("67");
            currencyRow.setFieldName("currency.name");
            currencyRow.setLogic("0");
            ArrayList<FilterValue> currencyValues = new ArrayList<FilterValue>();
            FilterValue currencyValue = new FilterValue();
            currencyValue.setValue((Object)currency.getString("name"));
            currencyValues.add(currencyValue);
            currencyRow.setValue(currencyValues);
            rows.add(currencyRow);
        }
        return fc;
    }

    private static FilterCondition getPayDefaultFilter(String orgId) {
        DynamicObject currency;
        FilterCondition fc = new FilterCondition();
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>();
        SimpleFilterRow bizDateRow = new SimpleFilterRow();
        bizDateRow.setCompareType("63");
        bizDateRow.setFieldName("bizdate");
        bizDateRow.setLogic("0");
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>();
        FilterValue dateValue = new FilterValue();
        dateValue.setValue((Object)"");
        dateValues.add(dateValue);
        bizDateRow.setValue(dateValues);
        rows.add(bizDateRow);
        fc.setFilterRow(rows);
        SimpleFilterRow asstActTypeRow = new SimpleFilterRow();
        asstActTypeRow.setCompareType("105");
        asstActTypeRow.setFieldName("payeetype");
        asstActTypeRow.setLogic("0");
        ArrayList<FilterValue> asstActTypeValues = new ArrayList<FilterValue>();
        FilterValue asstActTypeValue = new FilterValue();
        asstActTypeValue.setValue((Object)"bd_supplier");
        asstActTypeValues.add(asstActTypeValue);
        asstActTypeRow.setValue(asstActTypeValues);
        rows.add(asstActTypeRow);
        SimpleFilterRow asstActRow = new SimpleFilterRow();
        asstActRow.setCompareType("67");
        asstActRow.setFieldName("payeename");
        asstActRow.setLogic("0");
        rows.add(asstActRow);
        if (!StringUtils.isEmpty((String)orgId) && (currency = ManualSettlePluginHelper.getStandardCurrency(Long.parseLong(orgId), "cas_cashmgtinit")) != null) {
            SimpleFilterRow currencyRow = new SimpleFilterRow();
            currencyRow.setCompareType("67");
            currencyRow.setFieldName("currency.name");
            currencyRow.setLogic("0");
            ArrayList<FilterValue> currencyValues = new ArrayList<FilterValue>();
            FilterValue currencyValue = new FilterValue();
            currencyValue.setValue((Object)currency.getString("name"));
            currencyValues.add(currencyValue);
            currencyRow.setValue(currencyValues);
            rows.add(currencyRow);
        }
        return fc;
    }

    private static FilterCondition getRecDefaultFilter(String orgId) {
        DynamicObject currency;
        FilterCondition fc = new FilterCondition();
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>();
        SimpleFilterRow bizDateRow = new SimpleFilterRow();
        bizDateRow.setCompareType("63");
        bizDateRow.setFieldName("bizdate");
        bizDateRow.setLogic("0");
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>();
        FilterValue dateValue = new FilterValue();
        dateValue.setValue((Object)"");
        dateValues.add(dateValue);
        bizDateRow.setValue(dateValues);
        rows.add(bizDateRow);
        fc.setFilterRow(rows);
        SimpleFilterRow asstActTypeRow = new SimpleFilterRow();
        asstActTypeRow.setCompareType("105");
        asstActTypeRow.setFieldName("payertype");
        asstActTypeRow.setLogic("0");
        ArrayList<FilterValue> asstActTypeValues = new ArrayList<FilterValue>();
        FilterValue asstActTypeValue = new FilterValue();
        asstActTypeValue.setValue((Object)"bd_customer");
        asstActTypeValues.add(asstActTypeValue);
        asstActTypeRow.setValue(asstActTypeValues);
        rows.add(asstActTypeRow);
        SimpleFilterRow asstActRow = new SimpleFilterRow();
        asstActRow.setCompareType("67");
        asstActRow.setFieldName("payername");
        asstActRow.setLogic("0");
        rows.add(asstActRow);
        if (!StringUtils.isEmpty((String)orgId) && (currency = ManualSettlePluginHelper.getStandardCurrency(Long.parseLong(orgId), "cas_cashmgtinit")) != null) {
            SimpleFilterRow currencyRow = new SimpleFilterRow();
            currencyRow.setCompareType("67");
            currencyRow.setFieldName("currency.name");
            currencyRow.setLogic("0");
            ArrayList<FilterValue> currencyValues = new ArrayList<FilterValue>();
            FilterValue currencyValue = new FilterValue();
            currencyValue.setValue((Object)currency.getString("name"));
            currencyValues.add(currencyValue);
            currencyRow.setValue(currencyValues);
            rows.add(currencyRow);
        }
        return fc;
    }

    public static String getPaySelector() {
        String selector = "id,billno,bizdate,billtype,payeetype,payeename,paymenttype,currency,basecurrency,exchangerate,actpayamt,'cas_paybill' as entityname,entry.id,entry.e_material,entry.e_expenseitem,entry.e_payableamt,entry.e_unsettledamt,entry.e_paymenttype";
        return selector;
    }

    public static QFilter getPayFilter(QFilter filter, DynamicObject org) {
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter statusWithNoCommit = new QFilter("billstatus", "=", (Object)"D").and(new QFilter("iscommitbe", "=", (Object)Boolean.FALSE));
        QFilter statusWithCommit = new QFilter("billstatus", "=", (Object)"D").and(new QFilter("iscommitbe", "=", (Object)Boolean.TRUE)).and(new QFilter("bankpaystatus", "=", (Object)"TS"));
        filter = orgFilter.and(statusWithNoCommit.or(statusWithCommit)).and(filter).and("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE);
        return filter;
    }

    public static String getPaidSelector() {
        String selector = "id,billno,bizdate,payeetype,payeename,paymenttype,currency,basecurrency,exchangerate,actpayamt,'ap_paidbill' as entityname,entry.id,entry.e_material,entry.e_expenseitem,entry.e_actamt,entry.e_unsettledamt";
        return selector;
    }

    public static QFilter getPaidFilter(QFilter filter, DynamicObject org) {
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        String property = (filter = filter == null ? orgFilter : orgFilter.and(filter)).getProperty();
        if ("description".equals(property)) {
            filter.setProperty("usage");
        } else {
            List filterNest = filter.getNests(true);
            for (QFilter.QFilterNest nest : filterNest) {
                QFilter filterInner = nest.getFilter();
                String innerProperty = filterInner.getProperty();
                if (!"description".equals(innerProperty)) continue;
                filterInner.setProperty("usage");
                break;
            }
        }
        filter = filter.and("paymenttype.ispartpayment", "=", (Object)Boolean.TRUE);
        return filter;
    }

    public static String getRecSelector() {
        String selector = "id,billno,bizdate,biztype,payertype,payername,receivingtype,currency,basecurrency,exchangerate,actrecamt,'cas_recbill' as entityname,entry.id,entry.e_material,entry.e_expenseitem,entry.e_receivableamt,entry.e_unsettledamt,entry.e_receivingtype";
        return selector;
    }

    public static String getRecedSelector() {
        String selector = "id,billno,bizdate,currency,basecurrency,asstacttype,asstact,rectype,exchangerate,recamount,'ar_receivedbill' as entityname,entry.id,entry.e_material,entry.e_amount,entry.e_unsettledamt,entry.e_settledamt";
        return selector;
    }

    public static QFilter getRecFilter(QFilter filter, DynamicObject org) {
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        filter = orgFilter.and("billstatus", "=", (Object)"D").and(filter).and("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE);
        return filter;
    }

    public static QFilter getRecedFilter(QFilter filter, DynamicObject org) {
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter recedFilter = orgFilter.and("billstatus", "=", (Object)"C").and("rectype.ispartreceivable", "=", (Object)Boolean.TRUE);
        if (filter != null) {
            recedFilter.and(filter.copy());
        }
        List filterNest = recedFilter.getNests(true);
        for (QFilter.QFilterNest nest : filterNest) {
            QFilter filterInner = nest.getFilter();
            String innerProperty = filterInner.getProperty();
            if ("txt_description".equals(innerProperty)) {
                filterInner.setProperty("description");
                continue;
            }
            if (!"payertype".equals(innerProperty)) continue;
            filterInner.setProperty("asstacttype");
        }
        return recedFilter;
    }

    public static TableValueSetter getAsstBillSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("asst_id", new Object[0]);
        vs.addField("asst_billno", new Object[0]);
        vs.addField("asst_bizdate", new Object[0]);
        vs.addField("asst_billtype", new Object[0]);
        vs.addField("asst_asstacttype", new Object[0]);
        vs.addField("asst_asstactname", new Object[0]);
        vs.addField("pay_paymenttype", new Object[0]);
        vs.addField("asst_currency", new Object[0]);
        vs.addField("asst_exchangerate", new Object[0]);
        vs.addField("asst_amount", new Object[0]);
        vs.addField("asst_entryid", new Object[0]);
        vs.addField("asst_material", new Object[0]);
        vs.addField("asst_expenseitem", new Object[0]);
        vs.addField("asst_e_amount", new Object[0]);
        vs.addField("asst_unsettleamt", new Object[0]);
        vs.addField("asst_enableamt", new Object[0]);
        vs.addField("asst_cursettleamt", new Object[0]);
        return vs;
    }

    private static DynamicObject getStandardCurrency(long orgId, String initEntity) {
        DynamicObject init = BusinessDataServiceHelper.loadSingleFromCache((String)initEntity, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        if (init == null || init.get("standardcurrency") == null) {
            return null;
        }
        return init.getDynamicObject("standardcurrency");
    }
}

