/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.arapcommon.form.handler.Handler;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitMappingServiceHelper;
import kd.fi.arapcommon.util.StringUtils;

public class PlanSplitSchemeEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"d_entrytoolbars"});
        this.addClickListeners(new String[]{"field", "fieldvalue"});
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("org");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("isfinishinit", "=", (Object)Boolean.TRUE);
            qFilter.and(new QFilter("settlemodel", "=", (Object)"2"));
            DynamicObject[] inits = BusinessDataServiceHelper.load((String)(this.isAr() ? "ar_init" : "ap_init"), (String)"id,org", (QFilter[])qFilter.toArray());
            HashSet<Long> orgIds = new HashSet<Long>(inits.length);
            for (DynamicObject init : inits) {
                orgIds.add(init.getLong("org.id"));
            }
            QFilter orgFilter = new QFilter("id", "in", orgIds);
            showParameter.getListFilterParameter().setFilter(orgFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setComboEditFields();
    }

    public void afterLoadData(EventObject e) {
        this.setComboEditFields();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setComboEditFields();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int currentIndex = changeData[0].getRowIndex();
        IDataModel model = this.getModel();
        if ("detailkey".equals(key)) {
            Map<String, String> dimensionMapping = PlanSplitMappingServiceHelper.getDimensionMapping(this.isAr());
            String planKey = dimensionMapping.get(newValue.toString());
            this.getModel().setValue("plankey", (Object)planKey, currentIndex);
        }
        if ("field".equals(key) || "condition".equals(key)) {
            model.setValue("fieldvalue", (Object)"", currentIndex);
            model.setValue("clargevalue", (Object)"", currentIndex);
            model.setValue("clargevalue_tag", (Object)"", currentIndex);
        }
        if ("fieldvalue".equals(key)) {
            model.setValue("clargevalue_tag", newValue, currentIndex);
        }
        if ("plankey".equals(key)) {
            String planKey = (String)this.getModel().getValue("plankey", currentIndex);
            String detailKey = (String)this.getModel().getValue("detailkey", currentIndex);
            if (!StringUtils.isEmpty(planKey) && !StringUtils.isEmpty(detailKey)) {
                String billEntity = this.isAr() ? "ar_finarbill" : "ap_finapbill";
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
                IDataEntityProperty planKeyType = dataEntityType.findProperty(planKey);
                IDataEntityProperty detailKeyType = dataEntityType.findProperty(detailKey);
                if ("e_sourcebillentryid".equals(detailKey) || "e_sourcebillid".equals(detailKey)) {
                    if (!"java.lang.Long".equals(planKeyType.getPropertyType().getName())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c6\u5206\u6620\u5c04\u7ef4\u5ea6\u8ba1\u5212\u884c\u5b57\u6bb5\u7c7b\u578b\u9700\u8981\u4e0e\u7269\u6599\u884c\u5b57\u6bb5\u7c7b\u578b\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanSplitSchemeEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                        this.getModel().setValue("plankey", oldValue, currentIndex);
                    }
                } else if (!planKeyType.getClass().equals(detailKeyType.getClass())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c6\u5206\u6620\u5c04\u7ef4\u5ea6\u8ba1\u5212\u884c\u5b57\u6bb5\u7c7b\u578b\u9700\u8981\u4e0e\u7269\u6599\u884c\u5b57\u6bb5\u7c7b\u578b\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanSplitSchemeEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    this.getModel().setValue("plankey", oldValue, currentIndex);
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        Handler.handle("fieldvalue", key, this::clickFieldValue);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        Handler.handle("set_mapping", itemKey, this::showSplitMappingView);
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        if ("save".equals(operateKey)) {
            this.getView().updateView();
            if (event.getOperationResult().isSuccess()) {
                this.getView().invokeOperation("enable");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection rows;
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        String actionId = event.getActionId();
        if ("listCloseCallBack".equals(actionId) && returnData instanceof ListSelectedRowCollection && (!(rows = (ListSelectedRowCollection)returnData).isEmpty() || rows.isClearFlag())) {
            ArrayList<String> primaryKeys = new ArrayList<String>(rows.size());
            ArrayList<String> names = new ArrayList<String>(rows.size());
            for (ListSelectedRow row : rows) {
                primaryKeys.add(String.valueOf(row.getPrimaryKeyValue()));
                String name = row.getName();
                if (StringUtils.isEmpty(name)) {
                    names.add(row.getNumber());
                    continue;
                }
                names.add(name);
            }
            this.getModel().beginInit();
            int currentIndex = this.getModel().getEntryCurrentRowIndex("c_entry");
            String nameValues = String.join((CharSequence)",", names);
            if (nameValues.length() > 2000) {
                nameValues = nameValues.substring(0, 2000);
            }
            this.getModel().setValue("fieldvalue", (Object)nameValues, currentIndex);
            String primaryValues = String.join((CharSequence)",", primaryKeys);
            this.getModel().setValue("clargevalue_tag", (Object)primaryValues, currentIndex);
            if (primaryValues.length() > 255) {
                this.getModel().setValue("clargevalue", (Object)primaryValues.substring(0, 255), currentIndex);
            } else {
                this.getModel().setValue("clargevalue", (Object)primaryValues, currentIndex);
            }
            this.getModel().endInit();
            this.getView().updateView("c_entry");
        }
    }

    private void clickFieldValue() {
        int currentIndex;
        IDataModel model = this.getModel();
        String field = (String)model.getValue("field", currentIndex = model.getEntryCurrentRowIndex("c_entry"));
        if (StringUtils.isNotEmpty(field)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getFinEntityName());
            IDataEntityProperty fieldType = mainType.findProperty(field);
            if (fieldType instanceof BasedataProp) {
                String condition = (String)model.getValue("condition", currentIndex);
                BasedataProp prop = (BasedataProp)fieldType;
                String baseEntity = prop.getBaseEntityId();
                ListShowParameter showListForm = "in".equals(condition) || "notin".equals(condition) ? ShowFormHelper.createShowListForm((String)baseEntity, (boolean)true) : ShowFormHelper.createShowListForm((String)baseEntity, (boolean)false);
                if (fieldType instanceof OrgProp) {
                    OrgProp orgProp = (OrgProp)fieldType;
                    QFilter bizOrgFilter = orgProp.getBizOrgFilter();
                    showListForm.getListFilterParameter().setFilter(bizOrgFilter);
                    Map showFormCustomParams = orgProp.getShowFormCustomParams();
                    showListForm.setCustomParams(showFormCustomParams);
                }
                if (fieldType instanceof ItemClassProp) {
                    DynamicObjectCollection cEntry = this.getModel().getEntryEntity("c_entry");
                    String billFormId = "";
                    for (DynamicObject entry : cEntry) {
                        if (!"asstacttype".equals(entry.get("field"))) continue;
                        billFormId = entry.getString("fieldvalue");
                        break;
                    }
                    if (!"".equals(billFormId)) {
                        showListForm.setBillFormId(billFormId);
                        if ("bos_user".equals(billFormId)) {
                            showListForm.setFormId("bos_usertreelistf7");
                        }
                    }
                }
                showListForm.setShowApproved(true);
                showListForm.setShowUsed(true);
                showListForm.setHasRight(true);
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
                if (MetadataServiceHelper.getDataEntityType((String)baseEntity).findProperty("status") != null) {
                    qFilters.add(new QFilter("status", "=", (Object)"C"));
                }
                if (MetadataServiceHelper.getDataEntityType((String)baseEntity).findProperty("enable") != null) {
                    qFilters.add(new QFilter("enable", "=", (Object)"1"));
                }
                showListForm.setListFilterParameter(new ListFilterParameter(qFilters, null));
                showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "listCloseCallBack"));
                try {
                    this.getView().showForm((FormShowParameter)showListForm);
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(e.getMessage());
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b57\u6bb5\u3002", (String)"PlanSplitSchemeEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private void showSplitMappingView() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(this.getPlanSplitMappingName());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        DynamicObject planSplitMapping = PlanSplitMappingServiceHelper.getPlanSplitMapping(this.getPlanSplitMappingName());
        customParams.put("pk", planSplitMapping.getPkValue());
        formShowParameter.setCustomParams(customParams);
        this.getView().showForm(formShowParameter);
    }

    private void setComboEditFields() {
        ComboEdit fields = (ComboEdit)this.getControl("field");
        ArrayList itemFields = new ArrayList(64);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getFinEntityName());
        Map allFields = entityType.getAllFields();
        allFields.forEach((key, value) -> {
            FilterField field;
            if (entityType.getProperty(key) != null && (value instanceof BasedataProp || value instanceof TextProp || value instanceof ComboProp || value instanceof BooleanProp) && !"splitscheme".equals((field = ((IFieldHandle)value).createFilterField(entityType, key)).getFieldName())) {
                LocaleString caption = field.getCaption();
                String fullFieldName = field.getFullFieldName();
                ComboItem item = new ComboItem(caption, fullFieldName);
                itemFields.add(item);
            }
        });
        fields.setComboItems(itemFields);
        Map allEntities = entityType.getAllEntities();
        ComboEdit detailKeyFields = (ComboEdit)this.getControl("detailkey");
        EntityType detailEntityType = (EntityType)allEntities.get(this.getDetailEntryName());
        Map detailFields = detailEntityType.getFields();
        ArrayList detailItems = new ArrayList(detailFields.size());
        detailFields.forEach((key, value) -> {
            FilterField field = ((IFieldHandle)value).createFilterField(entityType, key);
            LocaleString caption = field.getCaption();
            String fieldName = field.getFieldName();
            ComboItem item = new ComboItem(caption, fieldName);
            detailItems.add(item);
        });
        detailKeyFields.setComboItems(detailItems);
        ComboEdit planKeyFields = (ComboEdit)this.getControl("plankey");
        EntityType planEntityType = (EntityType)allEntities.get(this.getPlanEntryName());
        Map planFields = planEntityType.getFields();
        ArrayList planItems = new ArrayList(planFields.size());
        planFields.forEach((key, value) -> {
            FilterField field = ((IFieldHandle)value).createFilterField(entityType, key);
            LocaleString caption = field.getCaption();
            String fieldName = field.getFieldName();
            ComboItem item = new ComboItem(caption, fieldName);
            planItems.add(item);
        });
        planKeyFields.setComboItems(planItems);
    }

    private String getFinEntityName() {
        return this.isAr() ? "ar_finarbill" : "ap_finapbill";
    }

    private String getDetailEntryName() {
        return this.isAr() ? "entry" : "detailentry";
    }

    private String getPlanEntryName() {
        return "planentity";
    }

    private String getPlanSplitMappingName() {
        return this.isAr() ? "ar_plansplit_mapping" : "ap_plansplit_mapping";
    }

    private boolean isAr() {
        return "ar_plansplit_scheme".equals(this.getModel().getDataEntityType().getName());
    }
}

