/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.form.AbstractSettleSchemeRulePlugin;
import kd.fi.arapcommon.helper.RPASettleSchemeDefaultValueHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.StdConfig;

public class RPASettleSchemeRulePlugin
extends AbstractSettleSchemeRulePlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Map customParams = showParam.getCustomParams();
        String oper = (String)customParams.get("oper");
        Object settleModelParam = customParams.get("settleModel");
        if (settleModelParam instanceof Integer) {
            int settleModel = (Integer)settleModelParam;
            this.setSettleModel(settleModel);
        }
        if (!ObjectUtils.isEmpty(customParams.get("orgId"))) {
            String orgId = String.valueOf(customParams.get("orgId"));
            this.setOrgId(Long.valueOf(orgId));
        }
        super.afterCreateNewData(e);
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        this.initMainBillField(settleRelation);
        this.initAsstBillField(settleRelation);
        if ("modify".equals(oper)) {
            this.getModel().setValue("asstactmatch", customParams.get("asstactmatch"));
            this.getModel().setValue("currencymatch", customParams.get("currencymatch"));
            this.getModel().setValue("mainbill", customParams.get("mainbill"));
            String mainEntityKey = (String)this.getModel().getValue("mainbill");
            String asstEntityKey = (String)this.getModel().getValue("asstbill");
            String mainfilterExpression = (String)this.getModel().getValue("mainfilter_tag");
            String asstfilterExpression = (String)this.getModel().getValue("asstfilter_tag");
            mainfilterExpression = this.modifyExpressionBySettleModel(mainEntityKey, mainfilterExpression, true);
            asstfilterExpression = this.modifyExpressionBySettleModel(asstEntityKey, asstfilterExpression, false);
            this.setFilterGrid(mainEntityKey, mainfilterExpression, "mainfiltergrid", settleRelation);
            this.setFilterGrid(asstEntityKey, asstfilterExpression, "asstfiltergrid");
            int size = this.getModel().getEntryEntity("entryentity").size();
            for (int i = 0; i < size; ++i) {
                String relation = (String)this.getModel().getValue("matchrelation", i);
                if ("1".equals(relation) || "2".equals(relation)) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"splitsign"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"splitsign"});
            }
        } else {
            List<String> relationList = SettleRelationEnum.getEntityByRelation(settleRelation);
            String mainEntityKey = relationList.get(0);
            String asstEntityKey = relationList.get(1);
            this.getModel().setValue("mainbill", (Object)mainEntityKey);
            this.getModel().setValue("asstbill", (Object)asstEntityKey);
            String mainDateKey = (String)this.getModel().getValue("maindatesrc");
            int settleModel = this.getSettleModel();
            FilterCondition mainFilterCondition = RPASettleSchemeDefaultValueHelper.getDefaultFilterCondition(settleRelation, mainEntityKey, mainDateKey, true, settleModel);
            String asstDateKey = (String)this.getModel().getValue("asstdatesrc");
            FilterCondition asstFilterCondition = RPASettleSchemeDefaultValueHelper.getDefaultFilterCondition(settleRelation, asstEntityKey, asstDateKey, false, settleModel);
            this.setFilterGrid(mainEntityKey, mainFilterCondition, "mainfiltergrid");
            this.setFilterGrid(asstEntityKey, asstFilterCondition, "asstfiltergrid");
            this.setEntryValue(RPASettleSchemeDefaultValueHelper.getDefaultEntryMap(settleRelation, mainEntityKey, asstEntityKey));
        }
        this.setEntryEnable();
    }

    private String modifyExpressionBySettleModel(String entityKey, String expression, boolean isMain) {
        String mKey;
        boolean isMaterial;
        boolean bl = isMaterial = this.getSettleModel() == 1;
        if (!isMain) {
            String settleRelation = (String)this.getModel().getValue("settlerelation");
            int asstSettleModel = this.getAsstSettleModel(settleRelation);
            boolean bl2 = isMaterial = asstSettleModel == 1;
        }
        if ("ap_finapbill".equals(entityKey)) {
            mKey = this.getApEntryUnLockKey(true);
            String pKey = this.getApEntryUnLockKey(false);
            if (isMaterial && expression.contains(pKey)) {
                expression = expression.replaceAll(pKey, mKey);
            }
            if (!isMaterial && expression.contains(mKey)) {
                expression = expression.replaceAll(mKey, pKey);
            }
        } else if ("ar_finarbill".equals(entityKey)) {
            mKey = this.getArEntryUnLockKey(true);
            String pKey = this.getArEntryUnLockKey(false);
            if (isMaterial && expression.contains(pKey)) {
                expression = expression.replaceAll(pKey, mKey);
            }
            if (!isMaterial && expression.contains(mKey)) {
                expression = expression.replaceAll(mKey, pKey);
            }
        }
        return expression;
    }

    protected String getApEntryUnLockKey(boolean isMaterial) {
        return isMaterial ? "unlockamt" : "unplanlockamt";
    }

    protected String getArEntryUnLockKey(boolean isMaterial) {
        return isMaterial ? "e_unlockamt" : "unplanlockamt";
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        int currentIndex = changeData[0].getRowIndex();
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        switch (propertyName) {
            case "settlerelation": {
                this.getModel().deleteEntryData("entryentity");
                this.getModel().setValue("mainbill", (Object)"");
                this.getModel().setValue("asstbill", (Object)"");
                if (StringUtils.isEmpty((CharSequence)settleRelation)) break;
                if (!SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) && !SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation)) {
                    this.getModel().setValue("asstactmatch", (Object)"0");
                }
                List<String> entitys = SettleRelationEnum.getEntityByRelation(settleRelation);
                String mainEntityKey = entitys.get(0);
                this.initMainBillField(settleRelation);
                this.getModel().setValue("mainbill", (Object)mainEntityKey);
                this.initFieldColumn(mainEntityKey, "mainfield");
                this.initDateSrc(mainEntityKey, "maindatesrc");
                if (SettleRelationEnum.APLIQUIDATIONSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARLIQUIDATIONSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECCLEARINGSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.PAYCLEARINGSETTLE.getValue().equals(settleRelation)) {
                    return;
                }
                this.setEntryValue(RPASettleSchemeDefaultValueHelper.getDefaultEntryMap(settleRelation, mainEntityKey, entitys.get(1)));
                this.setEntryEnable();
                this.initAsstBillField(settleRelation);
                String asstEntityKey = entitys.get(1);
                this.getModel().setValue("asstbill", (Object)asstEntityKey);
                this.initFieldColumn(asstEntityKey, "asstfield");
                this.initDateSrc(asstEntityKey, "asstdatesrc");
                break;
            }
            case "mainbill": {
                String mainEntityKey = (String)this.getModel().getValue("mainbill");
                if (StringUtils.isEmpty((CharSequence)mainEntityKey)) {
                    return;
                }
                this.getModel().deleteEntryData("entryentity");
                this.initMainOrAsstBillEnable(mainEntityKey, "mainbill");
                this.initFieldColumn(mainEntityKey, "mainfield");
                this.initDateSrc(mainEntityKey, "maindatesrc");
                String mainDateKey = (String)this.getModel().getValue("maindatesrc");
                FilterCondition filterCondition = RPASettleSchemeDefaultValueHelper.getDefaultFilterCondition(settleRelation, mainEntityKey, mainDateKey, true, this.getSettleModel());
                this.setFilterGrid(mainEntityKey, filterCondition, "mainfiltergrid");
                if (this.getModel().getEntryRowCount("entryentity") != 0) break;
                this.setEntryValue(RPASettleSchemeDefaultValueHelper.getDefaultEntryMap(settleRelation, mainEntityKey, (String)this.getModel().getValue("asstbill")));
                this.setEntryEnable();
                break;
            }
            case "asstbill": {
                String asstEntityKey = (String)this.getModel().getValue("asstbill");
                if (StringUtils.isEmpty((CharSequence)asstEntityKey)) {
                    return;
                }
                this.getModel().deleteEntryData("entryentity");
                this.initMainOrAsstBillEnable(asstEntityKey, "asstbill");
                this.initFieldColumn(asstEntityKey, "asstfield");
                this.initDateSrc(asstEntityKey, "asstdatesrc");
                String asstDateKey = (String)this.getModel().getValue("asstdatesrc");
                int asstSettleModel = this.getAsstSettleModel(settleRelation);
                FilterCondition asstFilterCondition = RPASettleSchemeDefaultValueHelper.getDefaultFilterCondition(settleRelation, asstEntityKey, asstDateKey, false, asstSettleModel);
                this.setFilterGrid(asstEntityKey, asstFilterCondition, "asstfiltergrid");
                if (this.getModel().getEntryRowCount("entryentity") != 0) break;
                this.setEntryValue(RPASettleSchemeDefaultValueHelper.getDefaultEntryMap(settleRelation, (String)this.getModel().getValue("mainbill"), asstEntityKey));
                this.setEntryEnable();
                break;
            }
            case "matchrelation": {
                String relation = (String)this.getModel().getValue("matchrelation");
                if ("1".equals(relation) || "2".equals(relation)) {
                    this.getView().setEnable(Boolean.TRUE, currentIndex, new String[]{"splitsign"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, currentIndex, new String[]{"splitsign"});
                break;
            }
            case "maindatesrc": {
                this.changeGridByDate("mainfiltergrid", changeData);
                break;
            }
            case "asstdatesrc": {
                this.changeGridByDate("asstfiltergrid", changeData);
            }
        }
    }

    private void initMainBillField(String settleRelation) {
        List<String> entities = SettleRelationEnum.getEntityByRelation(settleRelation);
        if (entities.isEmpty()) {
            return;
        }
        MainEntityType entityType = this.getModel().getDataEntityType();
        ComboProp property = (ComboProp)entityType.getProperty("mainbill");
        List comboItems = property.getComboItems();
        Map<String, ValueMapItem> keyMap = comboItems.stream().collect(Collectors.toMap(ValueMapItem::getValue, v -> v));
        ComboEdit fields = (ComboEdit)this.getControl("mainbill");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        String mainBillKey = entities.get(0);
        ComboItem item = new ComboItem(keyMap.get(mainBillKey).getName(), mainBillKey);
        items.add(item);
        if (SettleRelationEnum.RECCLEARINGSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECSELF.getValue().equals(settleRelation)) {
            items.add(new ComboItem(keyMap.get("ar_receivedbill").getName(), "ar_receivedbill"));
        }
        if (SettleRelationEnum.PAYCLEARINGSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.PAYRECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.PAYSELF.getValue().equals(settleRelation)) {
            items.add(new ComboItem(keyMap.get("ap_paidbill").getName(), "ap_paidbill"));
        }
        fields.setComboItems(items);
    }

    private void initAsstBillField(String settleRelation) {
        List<String> entities = SettleRelationEnum.getEntityByRelation(settleRelation);
        if (entities.isEmpty()) {
            return;
        }
        MainEntityType entityType = this.getModel().getDataEntityType();
        ComboProp property = (ComboProp)entityType.getProperty("asstbill");
        List comboItems = property.getComboItems();
        Map<String, ValueMapItem> keyMap = comboItems.stream().collect(Collectors.toMap(ValueMapItem::getValue, v -> v));
        ComboEdit fields = (ComboEdit)this.getControl("asstbill");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        String asstBillKey = entities.get(1);
        ComboItem item = new ComboItem(keyMap.get(asstBillKey).getName(), asstBillKey);
        items.add(item);
        if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.PAYSELF.getValue().equals(settleRelation) || SettleRelationEnum.RECPAYSETTLE.getValue().equals(settleRelation)) {
            items.add(new ComboItem(keyMap.get("ap_paidbill").getName(), "ap_paidbill"));
        }
        if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.PAYRECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECSELF.getValue().equals(settleRelation)) {
            items.add(new ComboItem(keyMap.get("ar_receivedbill").getName(), "ar_receivedbill"));
        }
        fields.setComboItems(items);
    }

    private void setEntryEnable() {
        for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
            Boolean isPreference = (Boolean)this.getModel().getValue("preference", i) == false;
            this.getView().setEnable(isPreference, i, new String[]{"mainfield"});
            this.getView().setEnable(isPreference, i, new String[]{"asstfield"});
            this.getView().setEnable(isPreference, i, new String[]{"matchrelation"});
            this.getView().setEnable(isPreference, i, new String[]{"isnullmatch"});
            this.getView().setEnable(isPreference, i, new String[]{"splitsign"});
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if ("entryentity".equals(e.getEntryProp().getName())) {
            int[] rowIndexs;
            for (int rowIndex : rowIndexs = e.getRowIndexs()) {
                if (rowIndex >= 2) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0d\u8981\u5220\u9664\u9884\u7f6e\u6570\u636e\u3002", (String)"RPASettleSchemeRulePlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    private void changeGridByDate(String gridKey, ChangeData[] changeData) {
        String newStr = (String)changeData[0].getNewValue();
        String oldStr = (String)changeData[0].getOldValue();
        FilterCondition filterCondition = this.getFilterCondition(gridKey);
        List filterRows = filterCondition.getFilterRow();
        newStr = newStr.substring(newStr.indexOf(46) + 1);
        oldStr = oldStr.substring(oldStr.indexOf(46) + 1);
        for (SimpleFilterRow filterRow : filterRows) {
            String fieldName = filterRow.getFieldName();
            if (!fieldName.equals(oldStr)) continue;
            filterRow.setFieldName(newStr);
            break;
        }
        this.setFilterCondition(filterCondition, gridKey);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if ("entryentity".equals(e.getEntryProp().getName())) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"splitsign"});
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            String mainExpression = this.getExpress("mainfiltergrid");
            String asstExpression = this.getExpress("asstfiltergrid");
            String mainEntityKey = (String)this.getModel().getValue("mainbill");
            String asstEntityKey = (String)this.getModel().getValue("asstbill");
            if (this.verifyExpression(mainExpression, mainEntityKey)) {
                return;
            }
            if (this.verifyExpression(asstExpression, asstEntityKey)) {
                return;
            }
            if (this.verifyDefaultCondition(true)) {
                return;
            }
            String settleRelation = (String)this.getModel().getValue("settlerelation");
            boolean validate = this.isValidate(settleRelation);
            if (validate && this.verifyDefaultCondition(false)) {
                return;
            }
            if (validate && this.verifyMatchRule()) {
                return;
            }
            this.getModel().setValue("mainfilter_tag", (Object)mainExpression);
            this.getModel().setValue("asstfilter_tag", (Object)asstExpression);
        }
        super.click(evt);
    }

    private boolean isValidate(String settleRelation) {
        return !SettleRelationEnum.ARLIQUIDATIONSETTLE.getValue().equals(settleRelation) && !SettleRelationEnum.APLIQUIDATIONSETTLE.getValue().equals(settleRelation) && !SettleRelationEnum.PAYCLEARINGSETTLE.getValue().equals(settleRelation) && !SettleRelationEnum.RECCLEARINGSETTLE.getValue().equals(settleRelation);
    }

    private boolean verifyMatchRule() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            Object relation = this.getModel().getValue("matchrelation", i);
            Object splitSign = this.getModel().getValue("splitsign", i);
            if ("0".equals(relation) || !ObjectUtils.isEmpty((Object)splitSign)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u5339\u914d\u5173\u7cfb\u4e0d\u662f\u201d=\u201c\u65f6\uff0c\u62c6\u5206\u7b26\u4e3a\u5fc5\u586b\u9879\u3002", (String)"RPASettleSchemeRulePlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean verifyDefaultCondition(boolean isMain) {
        String isValidateRPASettleRule = StdConfig.get("isValidateRPASettleRule");
        if ("false".equals(isValidateRPASettleRule)) {
            return false;
        }
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        String entityKey = (String)this.getModel().getValue(isMain ? "mainbill" : "asstbill");
        String dateKey = (String)this.getModel().getValue(isMain ? "maindatesrc" : "asstdatesrc");
        if (dateKey.contains(".")) {
            dateKey = dateKey.substring(dateKey.indexOf(46) + 1);
        }
        int settleModel = this.getSettleModel();
        if (!isMain) {
            settleModel = this.getAsstSettleModel(settleRelation);
        }
        List defaultFilterRow = RPASettleSchemeDefaultValueHelper.getDefaultFilterCondition(settleRelation, entityKey, dateKey, isMain, settleModel).getFilterRow();
        FilterGrid filtergrid = (FilterGrid)this.getView().getControl(isMain ? "mainfiltergrid" : "asstfiltergrid");
        List filterRow = filtergrid.getFilterGridState().getFilterCondition().getFilterRow();
        if (filterRow.size() < 4 || this.isDiffRow((SimpleFilterRow)defaultFilterRow.get(3), (SimpleFilterRow)filterRow.get(3), true)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u5355\u636e\u914d\u7f6e\u7684\u57fa\u672c\u6761\u4ef6\u4e2d\uff0c\u53ea\u6709\u5355\u636e\u7684\u65e5\u671f\u8303\u56f4\u53ef\u4fee\u6539\uff0c\u5176\u4ed6\u9ed8\u8ba4\u6761\u4ef6\u5747\u4e0d\u5141\u8bb8\u4fee\u6539\u6216\u5220\u9664\u3002", (String)"RPASettleSchemeRulePlugin_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            return true;
        }
        for (int i = 0; i < defaultFilterRow.size() - 1; ++i) {
            if (!this.isDiffRow((SimpleFilterRow)defaultFilterRow.get(i), (SimpleFilterRow)filterRow.get(i), false)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u5355\u636e\u914d\u7f6e\u7684\u57fa\u672c\u6761\u4ef6\u4e2d\uff0c\u53ea\u6709\u5355\u636e\u7684\u65e5\u671f\u8303\u56f4\u53ef\u4fee\u6539\uff0c\u5176\u4ed6\u9ed8\u8ba4\u6761\u4ef6\u5747\u4e0d\u5141\u8bb8\u4fee\u6539\u6216\u5220\u9664\u3002", (String)"RPASettleSchemeRulePlugin_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isDiffRow(SimpleFilterRow row, SimpleFilterRow row2, boolean isDateType) {
        boolean isValueEquals;
        if (row == null || row2 == null) {
            return true;
        }
        boolean isLogicEquals = "0".equals(row2.getLogic());
        boolean isNameEquals = row.getFieldName().equals(row2.getFieldName());
        if (isDateType) {
            return !isNameEquals || !isLogicEquals;
        }
        boolean isCompareTypeEquals = row.getCompareType().equals(row2.getCompareType());
        Set valueSet = row.getValue().stream().map(FilterValue::getValue).collect(Collectors.toSet());
        List value2 = row2.getValue();
        boolean bl = isValueEquals = value2.size() == valueSet.size();
        if (isValueEquals) {
            for (FilterValue filterValue : value2) {
                if (valueSet.contains(filterValue.getValue())) continue;
                isValueEquals = false;
                break;
            }
        }
        return !isNameEquals || !isCompareTypeEquals || !isValueEquals || !isLogicEquals;
    }

    private boolean verifyExpression(String expression, String entityKey) {
        CRFormula formulaObj = this.deserialize(expression);
        try {
            String tranExpr = this.tranFormula(formulaObj, entityKey);
            formulaObj.setExprTran(tranExpr);
        }
        catch (Exception exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"RPASettleSchemeRulePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
            return true;
        }
        return false;
    }

    protected CRFormula deserialize(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return new CRCondition();
        }
        return (CRFormula)SerializationUtils.fromJsonString((String)json, CRCondition.class);
    }

    protected String tranFormula(CRFormula formulaObj, String entityKey) {
        String tranExpr = null;
        if (StringUtils.isNotBlank((CharSequence)entityKey)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
            FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
            if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
                FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
                String[] scripts = filterBuilder.buildFilterScript();
                ArrayList<String> descs = new ArrayList<String>(2);
                if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                    descs.add(scripts[1]);
                }
                tranExpr = StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)" \u4e14 ", (String)"RPASettleSchemeRulePlugin_1", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            }
        }
        return tranExpr;
    }

    @Override
    protected Map<String, Object> getData() {
        Map<String, Object> data = super.getData();
        data.put("mainbill", this.getModel().getValue("mainbill"));
        data.put("asstbill", this.getModel().getValue("asstbill"));
        data.put("currencymatch", this.getModel().getValue("currencymatch"));
        data.put("asstactmatch", this.getModel().getValue("asstactmatch"));
        return data;
    }

    @Override
    protected Map<String, Object> getEntryMap(DynamicObject entry) {
        Map<String, Object> entryMap = super.getEntryMap(entry);
        entryMap.put("splitsign", entry.get("splitsign"));
        entryMap.put("preference", entry.get("preference"));
        return entryMap;
    }

    public void setFilterGrid(String entityName, FilterCondition filterCondition, String filtertag) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filtertag);
        filterGrid.getFilterGridState().getFilterCondition().getFilterRow().clear();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        filterGrid.setEntityNumber(entityType.getName());
        this.getView().updateView(filtertag);
        filterGrid.SetValue(filterCondition);
    }

    public void setFilterCondition(FilterCondition filterCondition, String filtertag) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filtertag);
        filterGrid.SetValue(filterCondition);
    }

    private void setFilterGrid(String entityName, String expression, String filtertag, String settleRelation) {
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filtertag);
        filterGrid.getFilterGridState().getFilterCondition().getFilterRow().clear();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        filterGrid.setEntityNumber(entityType.getName());
        this.getView().updateView(filtertag);
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)expression, CRCondition.class);
            FilterCondition filterCondition = conditionObj.getFilterCondition();
            if (filterCondition != null) {
                String fieldName;
                if ("recclearing".equals(settleRelation) && "e_unsettledamt".equals(fieldName = ((SimpleFilterRow)filterCondition.getFilterRow().get(1)).getFieldName())) {
                    ((SimpleFilterRow)filterCondition.getFilterRow().get(1)).setCompareType("21");
                }
                filterGrid.SetValue(filterCondition);
            }
        } else {
            filterGrid.SetValue(new FilterCondition());
        }
    }

    public void setFilterGrid(String entityName, String expression, String filtertag) {
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filtertag);
        filterGrid.getFilterGridState().getFilterCondition().getFilterRow().clear();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        filterGrid.setEntityNumber(entityType.getName());
        this.getView().updateView(filtertag);
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)expression, CRCondition.class);
            FilterCondition filterCondition = conditionObj.getFilterCondition();
            if (filterCondition != null) {
                filterGrid.SetValue(filterCondition);
            }
        } else {
            filterGrid.SetValue(new FilterCondition());
        }
    }

    FilterCondition getFilterCondition(String filtertag) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filtertag);
        return filterGrid.getFilterGridState().getFilterCondition();
    }

    String getExpress(String filtertag) {
        CRCondition conditionObj = new CRCondition();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filtertag);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        conditionObj.setFilterCondition(filterGridState.getFilterCondition());
        return SerializationUtils.toJsonString((Object)conditionObj);
    }

    int getSettleModel() {
        IPageCache pageCache = this.getView().getPageCache();
        String settleModel = pageCache.get("settleModel");
        if (settleModel != null) {
            return Integer.parseInt(settleModel);
        }
        return 1;
    }

    void setSettleModel(int settleModel) {
        this.getView().getPageCache().put("settleModel", String.valueOf(settleModel));
    }

    Long getOrgId() {
        IPageCache pageCache = this.getView().getPageCache();
        String orgId = pageCache.get("orgId");
        if (orgId != null) {
            return Long.valueOf(orgId);
        }
        return null;
    }

    void setOrgId(Long orgId) {
        this.getView().getPageCache().put("orgId", String.valueOf(orgId));
    }

    private int getAsstSettleModel(String settleRelation) {
        int settleModel = this.getSettleModel();
        Long orgId = this.getOrgId();
        if (orgId != null) {
            if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
                Object value = SystemParameterHelper.getARAppParameter(orgId, "ar_003");
                settleModel = value == null ? 1 : Integer.parseInt(value.toString());
            } else if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation)) {
                Object value = SystemParameterHelper.getAPAppParameter(orgId, "ap_003");
                settleModel = value == null ? 1 : Integer.parseInt(value.toString());
            }
        }
        return settleModel;
    }
}

