/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.InvoiceBizTypeEnum;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.helper.BizPartnerHelper;

public class RecPaycoordinPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(RecPaycoordinPlugin.class);
    private static final String bizId = "83bfebc8000002ac";

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey(this.getTgtMainType().getName())) {
            DynamicObject targetEntity = entity.getDataEntity();
            targetEntity.set("relationpay", (Object)Boolean.TRUE);
            DynamicObject source = BusinessDataServiceHelper.loadSingle((Object)targetEntity.get("sourcebillid"), (String)this.getSrcMainType().getName());
            DynamicObject orgObject = BizPartnerHelper.getinternalOrg(source.getDynamicObject("asstact"));
            if (ObjectUtils.isEmpty((Object)orgObject)) continue;
            Long tarOrgId = orgObject.getLong("id");
            targetEntity.set("org", (Object)orgObject);
            DynamicObject custsupper = null;
            if (this.getSrcMainType().getName().equals("ap_finapbill")) {
                if (ObjectUtils.isEmpty((Object)targetEntity.get("recorg")) && orgObject.getBoolean("fisbankroll")) {
                    targetEntity.set("recorg", (Object)orgObject);
                }
                if (ObjectUtils.isEmpty((Object)targetEntity.get("salesorg")) && orgObject.getBoolean("fissale")) {
                    targetEntity.set("salesorg", (Object)orgObject);
                }
                custsupper = targetEntity.getDynamicObject("billtype").getPkValue().equals(BillTypeConsts.ARFIN_OTR) ? BizPartnerHelper.getbizPartnerorder((Long)source.getDynamicObject("org").getPkValue(), tarOrgId, "iscustomer") : BizPartnerHelper.getbizPartner((Long)source.getDynamicObject("org").getPkValue(), tarOrgId, "iscustomer");
            } else {
                if (ObjectUtils.isEmpty((Object)targetEntity.get("payorg")) && orgObject.getBoolean("fisbankroll")) {
                    targetEntity.set("payorg", (Object)orgObject);
                }
                if (ObjectUtils.isEmpty((Object)targetEntity.get("purorg")) && orgObject.getBoolean("fispurchase")) {
                    targetEntity.set("purorg", (Object)orgObject);
                }
                if ((custsupper = targetEntity.getDynamicObject("billtypeid").getPkValue().equals(BillTypeConsts.APFIN_OTR) ? BizPartnerHelper.getbizPartnerorder((Long)source.getDynamicObject("org").getPkValue(), tarOrgId, "issupplier") : BizPartnerHelper.getbizPartner((Long)source.getDynamicObject("org").getPkValue(), tarOrgId, "issupplier")) != null) {
                    targetEntity.set("asstactname", (Object)custsupper.getString("name"));
                }
            }
            if (custsupper != null) {
                targetEntity.set("asstacttype", (Object)custsupper.getDataEntityType().getName());
                targetEntity.set("asstact", (Object)custsupper);
            }
            if (!"ap_finapbill".equals(this.getTgtMainType().getName()) || targetEntity.get("paymentcurrency") != null) continue;
            DynamicObject asstact = targetEntity.getDynamicObject("asstact");
            String asstactType = asstact.getDataEntityType().getName();
            if (!"bd_supplier".equals(asstactType)) {
                targetEntity.set("paymentcurrency", (Object)targetEntity.getDynamicObject("currency"));
                continue;
            }
            Object asstactPk = asstact.getPkValue();
            DynamicObject asstactFieldValue = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"paymentcurrency", (QFilter[])new QFilter[]{new QFilter("id", "=", asstactPk)});
            DynamicObject paymentCurrency = asstactFieldValue.getDynamicObject("paymentcurrency");
            if (ObjectUtils.isEmpty((Object)paymentCurrency)) {
                targetEntity.set("paymentcurrency", (Object)targetEntity.getDynamicObject("currency"));
                continue;
            }
            targetEntity.set("paymentcurrency", (Object)paymentCurrency);
        }
        boolean trgIsAr = "ap_finapbill".equals(this.getTgtMainType().getName());
        List<Object> srcIds = new ArrayList(16);
        if (trgIsAr) {
            AsstactHelper.setAccountBankField(entitys, "", "asstacttype", "asstact", "payeebanknum", "bebank");
            srcIds = Arrays.stream(entitys).map(v -> Long.valueOf(v.getDataEntity().getString("sourcebillid"))).collect(Collectors.toList());
        } else {
            srcIds = Arrays.stream(entitys).map(v -> v.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList());
        }
        List<Long> orgIds = Arrays.stream(entitys).map(v -> v.getDataEntity().getLong("org.id")).collect(Collectors.toList());
        HashMap<Long, Long> srcBillBaseCurrencyMap = new HashMap<Long, Long>(16);
        Map<Long, Long> trgOrgBaseCurrencyMap = this.getTrgOrgBaseCurrency(trgIsAr, orgIds);
        DynamicObjectCollection srcBills = trgIsAr ? QueryServiceHelper.query((String)"ap_finapbill", (String)"id,basecurrency", (QFilter[])new QFilter[]{new QFilter("id", "in", srcIds)}) : QueryServiceHelper.query((String)"ar_finarbill", (String)"id,basecurrency", (QFilter[])new QFilter[]{new QFilter("id", "in", srcIds)});
        for (DynamicObject srcBill : srcBills) {
            srcBillBaseCurrencyMap.put(srcBill.getLong("id"), srcBill.getLong("basecurrency"));
        }
        for (ExtendedDataEntity entity : entitys) {
            Long srcBillId;
            Long srcBaseCurrencyId;
            DynamicObject bill = entity.getDataEntity();
            Long orgId = bill.getLong("org.id");
            Long orgBaseCurrencyId = trgOrgBaseCurrencyMap.get(orgId);
            if (orgBaseCurrencyId == null || orgBaseCurrencyId.equals(srcBaseCurrencyId = (Long)srcBillBaseCurrencyMap.get(srcBillId = Long.valueOf(trgIsAr ? Long.parseLong(bill.getString("sourcebillid")) : bill.getLong("sourcebillid"))))) continue;
            bill.set("exchangerate", (Object)BigDecimal.ZERO);
        }
        if ("ap_finapbill".equals(this.getTgtMainType().getName())) {
            this.setCoreBillInfo(entitys);
            List<DynamicObject> finApBills = Stream.of(entitys).map(ExtendedDataEntity::getDataEntity).filter(v -> "bd_supplier".equals(v.getString("asstactType"))).collect(Collectors.toList());
            this.setTaxdeduction(finApBills);
        }
    }

    public Map<Long, Long> getTrgOrgBaseCurrency(boolean isAr, List<Long> orgIds) {
        HashMap<Long, Long> orgIdToCurrency = new HashMap<Long, Long>(16);
        QFilter qFilter = new QFilter("org", "in", orgIds);
        if (isAr) {
            DynamicObject[] inits;
            for (DynamicObject initInfo : inits = BusinessDataServiceHelper.load((String)"ar_init", (String)(this.getSelectors() + ", policytype.type"), (QFilter[])new QFilter[]{qFilter})) {
                Long orgId = initInfo.getLong("org.id");
                String policytype = initInfo.getString("policytype.type");
                if ("master".equals(policytype)) {
                    orgIdToCurrency.put(orgId, initInfo.getDynamicObject("standardcurrency").getLong("id"));
                    continue;
                }
                orgIdToCurrency.putIfAbsent(orgId, initInfo.getDynamicObject("standardcurrency").getLong("id"));
            }
        } else {
            DynamicObject[] inits;
            for (DynamicObject initInfo : inits = BusinessDataServiceHelper.load((String)"ap_init", (String)this.getSelectors(), (QFilter[])new QFilter[]{qFilter})) {
                orgIdToCurrency.put(initInfo.getLong("org.id"), initInfo.getDynamicObject("standardcurrency").getLong("id"));
            }
        }
        return orgIdToCurrency;
    }

    private String getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("org");
        selectors.add("standardcurrency");
        selectors.add("exratetable");
        selectors.add("isfinishinit");
        selectors.add("startdate");
        return String.join((CharSequence)",", selectors);
    }

    private void setCoreBillInfo(ExtendedDataEntity[] entitys) {
        HashSet<Long> srcArEntryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject apBill = entity.getDataEntity();
            DynamicObjectCollection entry = apBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                Long coreBillId = row.getLong("corebillid");
                if (coreBillId != 0L) continue;
                Long srcEntryId = Long.valueOf(row.getString("e_sourcebillentryid"));
                srcArEntryIds.add(srcEntryId);
            }
        }
        if (srcArEntryIds.size() == 0) {
            return;
        }
        DynamicObjectCollection srcArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"entry.id,entry.corebillid,entry.corebillentryid,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", srcArEntryIds)});
        if (srcArBills.size() == 0) {
            return;
        }
        Map<Long, DynamicObject> srcEntryIdToEntry = srcArBills.stream().collect(Collectors.toMap(v -> v.getLong("entry.id"), v -> v));
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject apBill = entity.getDataEntity();
            DynamicObjectCollection entry = apBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                Long srcEntryId;
                DynamicObject srcEntry;
                Long coreBillId = row.getLong("corebillid");
                if (coreBillId != 0L || (srcEntry = srcEntryIdToEntry.get(srcEntryId = Long.valueOf(row.getString("e_sourcebillentryid")))) == null) continue;
                row.set("corebillid", (Object)srcEntry.getLong("entry.corebillid"));
                row.set("corebillentryid", (Object)srcEntry.getLong("entry.corebillentryid"));
                row.set("corebilltype", (Object)srcEntry.getString("entry.e_corebilltype"));
                row.set("corebillno", (Object)srcEntry.getString("entry.e_corebillno"));
                row.set("corebillentryseq", (Object)srcEntry.getInt("entry.e_corebillentryseq"));
            }
        }
    }

    private void setTaxdeduction(List<DynamicObject> finApBills) {
        List asstactPks = finApBills.stream().map(v -> v.getLong("asstact.id")).collect(Collectors.toList());
        Map asstacts = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"invoicecategory", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactPks)});
        Set invoiceCategoryIdSet = asstacts.values().stream().map(t -> t.getLong("invoicecategory.id")).collect(Collectors.toSet());
        Map invoiceBizTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicebiztype", (String)"number,id,mulinvoicetype", (QFilter[])new QFilter[]{new QFilter("mulinvoicetype.fbasedataid", "in", invoiceCategoryIdSet).and("mulbiz.fbasedataid", "=", (Object)bizId)});
        HashMap<Object, DynamicObject> invoiceTypeMap = new HashMap<Object, DynamicObject>(8);
        Map specInvoiceTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicebiztype", (String)"number,id,mulinvoicetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1533341968170710016L).and("mulbiz.fbasedataid", "=", (Object)bizId)});
        for (Map.Entry asstactEntry : asstacts.entrySet()) {
            DynamicObject asst = (DynamicObject)asstactEntry.getValue();
            Long invoiceTypeId = asst.getLong("invoicecategory.id");
            if (invoiceTypeId == null || invoiceTypeId == 0L) continue;
            for (Map.Entry bizTypeIdEntry : invoiceBizTypeMap.entrySet()) {
                DynamicObject invoiceBizType = (DynamicObject)bizTypeIdEntry.getValue();
                DynamicObjectCollection mulInvoiceTypes = invoiceBizType.getDynamicObjectCollection("mulinvoicetype");
                Set invoiceTypeIds = mulInvoiceTypes.stream().map(t -> t.get("FBasedataId.id")).collect(Collectors.toSet());
                if (!invoiceTypeIds.contains(invoiceTypeId)) continue;
                invoiceTypeMap.put(asst.get("id"), invoiceBizType);
            }
        }
        for (DynamicObject finBill : finApBills) {
            DynamicObject asstact = finBill.getDynamicObject("asstact");
            Long asstactId = asstact.getLong("id");
            DynamicObject invoiceBizType = finBill.getDynamicObject("invoicebiztype");
            if (invoiceBizType == null) {
                Object invoiceBizTypeId = invoiceTypeMap.get(asstactId);
                if (invoiceBizTypeId == null) {
                    finBill.set("invoicebiztype", specInvoiceTypeMap.get(1533341968170710016L));
                } else {
                    finBill.set("invoicebiztype", invoiceBizTypeId);
                }
            }
            String taxPayerType = finBill.getString("org.taxpayertype");
            long invBizType = finBill.getLong("invoicebiztype.id");
            if (StringUtils.isEmpty((CharSequence)taxPayerType)) {
                if (invBizType == 0L || InvoiceBizTypeEnum.SP00002_S.getValue() == invBizType) {
                    finBill.set("istaxdeduction", (Object)Boolean.TRUE);
                    continue;
                }
                finBill.set("istaxdeduction", (Object)Boolean.FALSE);
                continue;
            }
            if ("1".equals(taxPayerType) && (InvoiceBizTypeEnum.SP00002_S.getValue() == invBizType || invBizType == 0L)) {
                finBill.set("istaxdeduction", (Object)Boolean.TRUE);
                continue;
            }
            finBill.set("istaxdeduction", (Object)Boolean.FALSE);
        }
    }

    private void setBankCount4Asst(DynamicObject targetEntity) {
        DynamicObject asstact = targetEntity.getDynamicObject("asstact");
        if (ObjectUtils.isEmpty((Object)asstact)) {
            return;
        }
        Object asstactPk = asstact.getPkValue();
        boolean isSupplier = "bd_supplier".equals(asstact.getDataEntityType().getName());
        DynamicObject asstactFieldValue = null;
        asstactFieldValue = isSupplier ? BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"entry_bank.bankaccount, entry_bank.bank,entry_bank.isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "=", asstactPk)}) : BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (String)"entry_bank.bankaccount, entry_bank.bank,entry_bank.isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "=", asstactPk)});
        DynamicObjectCollection entryBanks = asstactFieldValue.getDynamicObjectCollection("entry_bank");
        DynamicObject defaultBank = null;
        if (!ObjectUtils.isEmpty((Object)entryBanks)) {
            if (entryBanks.size() == 1) {
                defaultBank = (DynamicObject)entryBanks.get(0);
            } else {
                for (int i = 0; i < entryBanks.size(); ++i) {
                    if (((DynamicObject)entryBanks.get(i)).getBoolean("isdefault_bank")) {
                        defaultBank = (DynamicObject)entryBanks.get(i);
                        break;
                    }
                    if (i != 0) continue;
                    defaultBank = (DynamicObject)entryBanks.get(0);
                }
            }
        }
        if (defaultBank != null) {
            String acctBank = defaultBank.getString("bankaccount");
            DynamicObject bank = defaultBank.getDynamicObject("bank");
            if (!ObjectUtils.isEmpty((Object)acctBank)) {
                targetEntity.set("payeebanknum", (Object)acctBank);
            }
            if (!ObjectUtils.isEmpty((Object)bank)) {
                targetEntity.set("bebank", (Object)bank);
            }
        }
    }
}

