/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.service.log.LogUtil;

public class SettleRecordBaseList
extends AbstractListPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setShortCuts();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck(this.getView(), args, "SZJK-PRE-0057");
        }
        this.refuseOperate(args);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = e.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] billNos = selectedRows.stream().map(selectedRow -> selectedRow.getBillNo()).toArray();
            LogUtil.addOpLog("ap_settlerecord", billNos.length > 0 ? billNos[0] : null, operateKey, "billnos\uff1a" + JSONObject.toJSONString((Object)billNos) + "execute non-standard operations\uff1a" + operateKey, true);
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts")) {
            String key;
            switch (key = e.getEventArgs()) {
                case "[17,16,69]": {
                    ListShowParameter listShowParameter = new ListShowParameter();
                    listShowParameter.setBillFormId("ap_settle_ext_setting");
                    listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)listShowParameter);
                }
            }
        }
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"ctrl+shift+e");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    private void refuseOperate(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        ArrayList<String> operateKeys = new ArrayList<String>(5);
        operateKeys.add("submit");
        operateKeys.add("unsubmit");
        operateKeys.add("audit");
        operateKeys.add("unaudit");
        operateKeys.add("delete");
        if (operateKeys.contains(operateKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u4e0d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c", (String)"SettleRecordEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }
}

