/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.EventObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CheckResult;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class SysParamPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"ar002_condition", "ar0041_condition", "ar0042_condition", "ap002_condition", "ap0041_condition", "ap0042_condition"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "ar002_condition": {
                this.showConditionForm("botp_condition", "ar_finarbill", "ar002_condition", "ar002_conditionvalue");
                break;
            }
            case "ap002_condition": {
                this.showConditionForm("botp_condition", "ap_finapbill", "ap002_condition", "ap002_conditionvalue");
                break;
            }
            case "ar0041_condition": 
            case "ar0042_condition": {
                this.showConditionForm("ap_condition", "ar_busbill", key, key + "value");
                break;
            }
            case "ap0041_condition": 
            case "ap0042_condition": {
                this.showConditionForm("ap_condition", "ap_busbill", key, key + "value");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String conditionJson;
        String conditionValKey = "ar0042_conditionvalue";
        if (this.getView().getEntityId().contains("ar_parameter") && ObjectUtils.isEmpty((Object)(conditionJson = (String)this.getModel().getValue(conditionValKey))) && !ObjectUtils.isEmpty((Object)(conditionJson = BusWoffHelper.getDefaultConditionValue(conditionValKey)))) {
            this.fillCondition(conditionJson, "ar_busbill", "ar0042_condition", conditionValKey);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("true".equals(StdConfig.get("isHiddenArInvoice"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"costadjustsetting11134", "ar_001"});
        }
        if (this.getView().getEntityId().contains("ar_parameter") && "true".equals(StdConfig.get("busPaysecurityUseTolerance"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ar_035", "ar_036"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String effectCondition;
        super.propertyChanged(e);
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        String key = e.getProperty().getName();
        if (("ar002_condition".equals(key) || "ar0041_condition".equals(key) || "ar0042_condition".equals(key) || "ap002_condition".equals(key) || "ap0041_condition".equals(key) || "ap0042_condition".equals(key)) && StringUtils.isEmpty((CharSequence)(effectCondition = (String)this.getModel().getValue(key)))) {
            this.getModel().setValue(key + "value", null);
        }
        if ("ap_003".equals(key) || "ar_003".equals(key)) {
            boolean newCustomerUseNewSettle = SettleVersionServiceHelper.isNewCustomerUseNewSettle();
            if (newCustomerUseNewSettle) {
                if (!"2".equals(newValue)) {
                    this.getModel().setValue(key, (Object)"2");
                }
            } else if (EmptyUtils.isEmpty(newValue)) {
                this.getModel().setValue(key, oldValue);
            }
        }
        if (("ap_004".equals(key) || "ar_004".equals(key)) && EmptyUtils.isEmpty(newValue)) {
            this.getModel().setValue(key, oldValue);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        this.handleCondition(actionId, returnData);
    }

    private void handleCondition(String actionId, String returnData) {
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String billEntityName = null;
        switch (actionId) {
            case "ar002_condition": {
                billEntityName = "ar_finarbill";
                break;
            }
            case "ap002_condition": {
                billEntityName = "ap_finapbill";
                break;
            }
            case "ar0041_condition": 
            case "ar0042_condition": {
                billEntityName = "ar_busbill";
                break;
            }
            case "ap0041_condition": 
            case "ap0042_condition": {
                billEntityName = "ap_busbill";
            }
        }
        if (billEntityName == null) {
            return;
        }
        this.fillCondition(returnData, billEntityName, actionId, actionId + "value");
    }

    private void fillCondition(String conditionJson, String entityNumber, String sourceCtrlKey, String sourceCtrlVal) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        CheckResult checkResult = new CheckResult();
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
        condition.check(dataEntityType, null, checkResult);
        if (!checkResult.isPass()) {
            this.getView().showErrorNotification(checkResult.getMessages().toString());
            return;
        }
        String exprDesc = condition.getExprDesc();
        if (StringUtils.isEmpty((CharSequence)exprDesc)) {
            this.getModel().setValue(sourceCtrlVal, null);
        } else {
            this.getModel().setValue(sourceCtrlVal, (Object)conditionJson);
        }
        this.getModel().setValue(sourceCtrlKey, (Object)exprDesc);
    }

    private void showConditionForm(String formId, String entityNumber, String sourceCtrlKey, String sourceCtrlVal) {
        String conditionJson = (String)this.getModel().getValue(sourceCtrlVal);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, null);
        String fieldNodes = SerializationUtils.toJsonString((Object)srcBillNode);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", "false");
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

